package m05bSeguroEJB;

import javax.ejb.CreateException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.RemoveException;

import m05bBD.m05bSeguro;


/**
 * This class is the Bean Implementation for the Entity EJB <tt>M05SeguroEB</tt>.
 *
 * @see     m05.exe.Seguro
 * @see     m05.exe.M05SeguroEB
 * @see     m05.exe.M05SeguroEBPK
 * @see     m05.exe.M05SeguroEBHome
 */
abstract public class m05SeguroBean implements EntityBean {
  
  private EntityContext ctx;

 

  /** 
   * This is the primary key.
   * It is the clave, which is the primary key 
   * in table <tt>m0528t00</tt>.
   */

  /**
   * Returns the Seguro information of this E-EJB.
   */    
  public m05bSeguro getSeguro(){
    m05bSeguro seguro = new m05bSeguro();
    
    seguro.setSeg_codigo(getSeg_codigo());
    seguro.setSeg_cia(getSeg_cia());
    seguro.setSeg_direccion(getSeg_direccion());
    seguro.setSeg_telefono(getSeg_telefono());
    seguro.setSeg_poliza(getSeg_poliza());
    seguro.setSeg_modalidad(getSeg_modalidad());
    
    return seguro;	
  }    

  /**
   * Sets the Seguro information of this E-EJB.
   * @exception P2GException 
   *              If the given Seguro <tt>seg_codigo</tt> field 
   *              does not match the primary key that is in the E-EJB.
   */   
  public void setSeguro(m05bSeguro seguro)
    throws Exception{
   
    //the primary key is never modified!!
    if (getSeg_codigo() != seguro.getSeg_codigo())
      throw new CreateException ("Cannot modify a different seguro");
      
    setSeg_cia(seguro.getSeg_cia());
    setSeg_direccion(seguro.getSeg_direccion());
    setSeg_telefono(seguro.getSeg_telefono());
    setSeg_poliza(seguro.getSeg_poliza());
    setSeg_modalidad(seguro.getSeg_modalidad());
    //setSeg_alta(new Timestamp(seguro.getSeg_alta().getTime()));

  }   	
  
  abstract public String getSeg_codigo();
  abstract public void setSeg_codigo(String n);
  
  abstract public String getSeg_cia();
  abstract public void setSeg_cia(String n);

  abstract public String getSeg_direccion();
  abstract public void setSeg_direccion(String n);
  
  abstract public String getSeg_telefono();
  abstract public void setSeg_telefono(String n);

  
  abstract public String getSeg_poliza();
  abstract public void setSeg_poliza(String n);

  abstract public String getSeg_modalidad();
  abstract public void setSeg_modalidad(String n);



  public void ejbActivate() {
  }

  public void ejbPassivate() {
  }

  public void setEntityContext(EntityContext ctx) {
    this.ctx = ctx;
  }

  public void unsetEntityContext() {
    this.ctx = null;
  }

  public void ejbLoad() {
  }
  
  public void ejbStore() {
  }

  public void ejbRemove()
    throws RemoveException
  {
  }

  /**
   * This function initializes the Seguro 
   * information of this E-EJB.
   * It assigns a new primary key to the Seguro.
   */ 
  public m05SeguroPK ejbCreate(m05bSeguro seguro) 
    throws CreateException
  {
    try {
      setSeg_codigo(getSeg_codigo());
    } catch (Exception e) {
      throw new CreateException (e.getMessage());
    }    
    setSeg_cia(seguro.getSeg_cia());
    setSeg_direccion(seguro.getSeg_direccion());
    setSeg_telefono(seguro.getSeg_telefono());
    setSeg_poliza(seguro.getSeg_poliza());
    setSeg_modalidad(seguro.getSeg_modalidad());
    return null;      	
  }

  public void ejbPostCreate(m05bSeguro seguro) 
  {
  }

 
}
