package m05bRevisionesEJB;

import javax.ejb.CreateException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.RemoveException;

import m05bBD.m05bRevisiones;



/**
 * This class is the Bean Implementation for the Entity EJB <tt>M05RevisionesEB</tt>.
 *
 * @see     m05.exe.Revisiones
 * @see     m05.exe.M05RevisionesEB
 * @see     m05.exe.M05RevisionesEBPK
 * @see     m05.exe.M05RevisionesEBHome

 */
abstract public class m05RevisionesBean implements EntityBean {
  
  private EntityContext ctx;

 

  /** 
   * This is the primary key.
   * It is the clave, which is the primary key 
   * in table <tt>m0527t00</tt>.
   */

  /**
   * Returns the Revisiones information of this E-EJB.
   */    
  public m05bRevisiones getRevisiones(){
    m05bRevisiones revision = new m05bRevisiones();

    revision.setRev_codigo(getRev_codigo());
    revision.setRev_matricula(getRev_matricula());
    revision.setRev_impreso(getRev_impreso());
    revision.setRev_estado(getRev_estado());
    revision.setRev_resultado(getRev_resultado());
    revision.setRev_anomalia(getRev_anomalia());
    revision.setRev_fecinspec(getRev_fecinspec());
    revision.setRev_fecrep(getRev_fecrep());
    revision.setRev_fecprox(getRev_fecprox());
    
    return revision;	
  }    

  /**
   * Sets the Revisiones information of this E-EJB.
   * @exception P2GException 
   *              If the given Revisiones <tt>tas_codigo</tt> field 
   *              does not match the primary key that is in the E-EJB.
   */   
  public void setRevisiones(m05bRevisiones revision)
    throws Exception{
   
    //the primary key is never modified!!
    if (getRev_codigo() != revision.getRev_codigo() )
      throw new CreateException ("Cannot modify a different revision");
      
    setRev_matricula(revision.getRev_matricula());
    setRev_codigo (revision.getRev_codigo());
    setRev_impreso(revision.getRev_impreso());
    setRev_estado(revision.getRev_estado());
    setRev_resultado(revision.getRev_resultado());
    setRev_anomalia(revision.getRev_anomalia());
    setRev_fecrep(revision.getRev_fecrep());
    setRev_fecinspec(revision.getRev_fecinspec());
    setRev_fecprox(revision.getRev_fecprox());

    
  }   	

  
  abstract public String getRev_matricula();
  abstract public void setRev_matricula(String n);

  abstract public String getRev_codigo();
  abstract public void setRev_codigo(String n);

  abstract public String getRev_impreso();
  abstract public void setRev_impreso(String n);
  
  abstract public String getRev_resultado();
  abstract public void setRev_resultado(String n);
  
  abstract public String getRev_fecprox();
  abstract public void setRev_fecprox(String n);

  abstract public String getRev_fecinspec();
  abstract public void setRev_fecinspec(String n);

  abstract public String getRev_fecrep();
  abstract public void setRev_fecrep(String n);

  abstract public String getRev_estado();
  abstract public void setRev_estado(String n);

  abstract public String getRev_anomalia();
  abstract public void setRev_anomalia(String n);


  public void ejbActivate() {
  }

  public void ejbPassivate() {
  }

  public void setEntityContext(EntityContext ctx) {
    this.ctx = ctx;
  }

  public void unsetEntityContext() {
    this.ctx = null;
  }

  public void ejbLoad() {
  }
  
  public void ejbStore() {
  }

  public void ejbRemove() throws RemoveException{}

  /**
   * This function initializes the Revisiones 
   * information of this E-EJB.
   * It assigns a new primary key to the Revisiones.
   */ 
  public m05RevisionesPK ejbCreate(m05bRevisiones revision) 
    throws CreateException
  {
    try {
    setRev_codigo(revision.getRev_codigo());
    } catch (Exception e) {
      throw new CreateException (e.getMessage());
    }    
    setRev_matricula(revision.getRev_matricula());
    setRev_fecinspec(revision.getRev_fecinspec());
    setRev_impreso(revision.getRev_impreso());
    setRev_anomalia(revision.getRev_anomalia());
    setRev_resultado(revision.getRev_resultado());
    setRev_estado(revision.getRev_estado());
    setRev_fecprox(revision.getRev_fecprox());
    setRev_fecrep(revision.getRev_fecrep());
    return null;
  }

  public void ejbPostCreate(m05bRevisiones revision)  {
  }

 
}
