package m05bRevisionEJB;

import javax.ejb.CreateException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.RemoveException;

import m05bBD.m05bRevision;


/**
 * This class is the Bean Implementation for the Entity EJB <tt>M05RevisionEB</tt>.
 *
 * @see     m05.exe.Revision
 * @see     m05.exe.M05RevisionEB
 * @see     m05.exe.M05RevisionEBPK
 * @see     m05.exe.M05RevisionEBHome

 */
abstract public class m05RevisionBean implements EntityBean {

  private EntityContext ctx;

 
  /**
   * This is the primary key.
   * It is the clave, which is the primary key
   * in table <tt>m0535t00</tt>.
   */

  /**
   * Returns the Revision information of this E-EJB.
   */
  public m05bRevision getRevision(){
    m05bRevision revision = new m05bRevision();

    revision.setRevi_matricula(getRevi_matricula());
    revision.setRevi_importe(getRevi_importe());
    revision.setRevi_orden(getRevi_orden());
    revision.setRevi_descrip(getRevi_descrip());
    revision.setRevi_cod(getRevi_cod());
    revision.setRevi_fecha(getRevi_fecha());
    revision.setRevi_fecprox(getRevi_fecprox());
    revision.setRevi_realiza(getRevi_realiza());
    revision.setRevi_kmpre(getRevi_kmpre());
    revision.setRevi_kmre(getRevi_kmre());

    return revision;
  }

  /**
   * Sets the Revision information of this E-EJB.
   * @exception P2GException
   *              If the given Revision <tt>revi_cod</tt> field
   *              does not match the primary key that is in the E-EJB.
   */
  public void setRevision(m05bRevision revision)
    throws Exception{

    //the primary key is never modified!!
    if (getRevi_cod() != revision.getRevi_cod())
      throw new CreateException ("Cannot modify a different revision");

    setRevi_matricula(revision.getRevi_matricula());
    setRevi_importe(revision.getRevi_importe());
    setRevi_orden(revision.getRevi_orden());
    setRevi_descrip(revision.getRevi_descrip());
    setRevi_realiza(revision.getRevi_realiza());
    setRevi_fecha(revision.getRevi_fecha());
    setRevi_fecprox(revision.getRevi_fecprox());
    setRevi_kmpre(revision.getRevi_kmpre());
    setRevi_kmre(revision.getRevi_kmre());


  }


  abstract public String getRevi_matricula();
  abstract public void setRevi_matricula(String n);

  abstract public String getRevi_importe();
  abstract public void setRevi_importe(String n);

  abstract public String getRevi_cod();
  abstract public void setRevi_cod(String n);

  abstract public String getRevi_fecha();
  abstract public void setRevi_fecha(String n);

  abstract public String getRevi_fecprox();
  abstract public void setRevi_fecprox(String n);

  abstract public String getRevi_orden();
  abstract public void setRevi_orden(String n);

  abstract public String getRevi_descrip();
  abstract public void setRevi_descrip(String n);

  abstract public String getRevi_realiza();
  abstract public void setRevi_realiza(String n);

  abstract public String getRevi_kmre();
  abstract public void setRevi_kmre(String n);

  abstract public String getRevi_kmpre();
  abstract public void setRevi_kmpre(String n);


  public void ejbActivate() {
  }

  public void ejbPassivate() {
  }

  public void setEntityContext(EntityContext ctx) {
    this.ctx = ctx;
  }

  public void unsetEntityContext() {
    this.ctx = null;
  }

  public void ejbLoad() {
  }

  public void ejbStore() {
  }

  public void ejbRemove() throws RemoveException{}

  /**
   * This function initializes the Revisiones
   * information of this E-EJB.
   * It assigns a new primary key to the Revisiones.
   */
  public m05RevisionPK ejbCreate(m05bRevision revision)
    throws CreateException
  {
    try {
    setRevi_cod(revision.getRevi_cod());
    } catch (Exception e) {
      throw new CreateException (e.getMessage());
    }

    setRevi_importe(revision.getRevi_importe());
    setRevi_descrip(revision.getRevi_descrip());
    setRevi_matricula(revision.getRevi_matricula());
    setRevi_realiza(revision.getRevi_realiza());
    setRevi_orden(revision.getRevi_orden());
    setRevi_fecha(revision.getRevi_fecha());
    setRevi_fecprox(revision.getRevi_fecprox());
    setRevi_kmpre(revision.getRevi_kmpre());
    setRevi_kmre(revision.getRevi_kmre());
    return null;
  }

  public void ejbPostCreate(m05bRevision revision)  {
  }


}
