package m05bResponsableEJB;

import javax.ejb.CreateException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.RemoveException;

import m05bBD.m05bResponsable;


/**
 * This class is the Bean Implementation for the Entity EJB <tt>M05ResponsableEB</tt>.
 *
 * @see     m05.exe.Responsable
 * @see     m05.exe.M05ResponsableEB
 * @see     m05.exe.M05ResponsableEBPK
 * @see     m05.exe.M05ResponsableEBHome
 * @author <a href="mailto:paco.gomez@terra.com">Paco Gomez</a>.
 *         Professional J2EE Programming with BEA WebLogic Server, 
 *         by Gomez & Zadrozny, Copyright &#169; 2000. 
 */
abstract public class m05ResponsableBean implements EntityBean {
  
  private EntityContext ctx;

  

  /** 
   * This is the primary key.
   * It is the clave, which is the primary key 
   * in table <tt>m0526t00</tt>.
   */
  
  /**
   * Returns the Responsable information of this E-EJB.
   */    
  public m05bResponsable getResponsable(){
    m05bResponsable responsable = new m05bResponsable();
    responsable.setRes_codigo(getRes_codigo());
    responsable.setRes_cargo(getRes_cargo());
    responsable.setRes_nombre(getRes_nombre());
    responsable.setRes_cargoEu(getRes_cargoEu());
    
    return responsable;	
  }    

  /**
   * Sets the Responsable information of this E-EJB.
   * @exception P2GException 
   *              If the given Responsable <tt>res_cargo</tt> field 
   *              does not match the primary key that is in the E-EJB.
   */   
  public void setResponsable(m05bResponsable responsable)
    throws Exception{
   
    //the primary key is never modified!!
    if (getRes_codigo() != responsable.getRes_codigo())
      throw new CreateException ("Cannot modify a different responsable");
    setRes_cargo(responsable.getRes_cargo());
    setRes_cargoEu(responsable.getRes_cargoEu());
    setRes_nombre(responsable.getRes_nombre());
  }   	
  
  abstract public String getRes_codigo();
  abstract public void setRes_codigo(String n);
  
  abstract public String getRes_cargo();
  abstract public void setRes_cargo(String n);
  abstract public String getRes_cargoEu();
  abstract public void setRes_cargoEu(String n);
  abstract public String getRes_nombre();
  abstract public void setRes_nombre(String n);

  public void ejbActivate() {
  }

  public void ejbPassivate() {
  }

  public void setEntityContext(EntityContext ctx) {
    this.ctx = ctx;
  }

  public void unsetEntityContext() {
    this.ctx = null;
  }

  public void ejbLoad() {
  }
  
  public void ejbStore() {
  }

  public void ejbRemove()
    throws RemoveException
  {
  }

  /**
   * This function initializes the Responsable 
   * information of this E-EJB.
   * It assigns a new primary key to the Responsable.
   */ 
  public m05ResponsablePK ejbCreate(m05bResponsable responsable) 
    throws CreateException
  {
    try {
      setRes_codigo(getRes_codigo());
    } catch (Exception e) {
      throw new CreateException (e.getMessage());
    }  
    setRes_cargo(responsable.getRes_cargo());
    setRes_cargoEu(responsable.getRes_cargoEu());
    setRes_nombre(responsable.getRes_nombre());
    return null;      	
  }

  public void ejbPostCreate(m05bResponsable responsable) 
  {
  }

 
}
