package m05bReparacionEJB;

import javax.ejb.CreateException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.RemoveException;

import m05bBD.m05bReparacion;

/**
 * This class is the Bean Implementation for the Entity EJB
 * <tt>M05ReparacionEB</tt>.
 * 
 * @see m05.exe.Reparacion
 * @see m05.exe.M05ReparacionEB
 * @see m05.exe.M05ReparacionEBPK
 * @see m05.exe.M05ReparacionEBHome
 */
abstract public class m05ReparacionBean implements EntityBean {

	private EntityContext ctx;

	/**
	 * This is the primary key. It is the clave, which is the primary key in
	 * table <tt>m0525t00</tt>.
	 */
	/*
	 * public String rep_codigo = "";
	 * 
	 * public String rep_observacion = ""; public String rep_descripcion = "";
	 */

	/**
	 * Returns the Reparacion information of this E-EJB.
	 */
	public m05bReparacion getReparacion() {
		m05bReparacion reparacion = new m05bReparacion();

		reparacion.setRep_codigo(getRep_codigo());
		reparacion.setRep_descripcion(getRep_descripcion());
		reparacion.setRep_observacion(getRep_observacion());

		/* Iker */
		reparacion.setRep_descripcionEu(getRep_descripcionEu());
		reparacion.setRep_observacionEu(getRep_observacionEu());

		return reparacion;
	}

	/**
	 * Sets the Reparacion information of this E-EJB.
	 * 
	 * @exception P2GException
	 *                If the given Reparacion <tt>rep_codigo</tt> field does not
	 *                match the primary key that is in the E-EJB.
	 */
	public void setReparacion(m05bReparacion reparacion) throws Exception {

		// the primary key is never modified!!
		if (getRep_codigo() != reparacion.getRep_codigo())
			throw new CreateException("Cannot modify a different reparacion");

		setRep_observacion(reparacion.getRep_observacion());
		setRep_descripcion(reparacion.getRep_descripcion());

		setRep_observacionEu(reparacion.getRep_observacionEu());
		setRep_descripcionEu(reparacion.getRep_descripcionEu());

	}

	abstract public String getRep_codigo();

	abstract public void setRep_codigo(String n);

	abstract public String getRep_observacion();

	abstract public void setRep_observacion(String n);

	abstract public String getRep_descripcion();

	abstract public void setRep_descripcion(String n);

	abstract public String getRep_observacionEu();

	abstract public void setRep_observacionEu(String n);

	abstract public String getRep_descripcionEu();

	abstract public void setRep_descripcionEu(String n);

	public void ejbActivate() {
	}

	public void ejbPassivate() {
	}

	public void setEntityContext(EntityContext ctx) {
		this.ctx = ctx;
	}

	public void unsetEntityContext() {
		this.ctx = null;
	}

	public void ejbLoad() {
	}

	public void ejbStore() {
	}

	public void ejbRemove() throws RemoveException {
	}

	/**
	 * This function initializes the Reparacion information of this E-EJB. It
	 * assigns a new primary key to the Reparacion.
	 * 
	 * @see #getNewOrderNum()
	 */
	public m05ReparacionPK ejbCreate(m05bReparacion reparacion)
			throws CreateException {
		try {
			setRep_codigo(getRep_codigo());
		} catch (Exception e) {
			throw new CreateException(e.getMessage());
		}
		setRep_observacion(reparacion.getRep_observacion());
		setRep_descripcion(reparacion.getRep_descripcion());
		setRep_observacionEu(reparacion.getRep_observacionEu());
		setRep_descripcionEu(reparacion.getRep_descripcionEu());
		return null;
	}

	public void ejbPostCreate(m05bReparacion reparacion) {
	}

}