package m05bRentingEJB;

import javax.ejb.CreateException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.RemoveException;

import m05bBD.m05bRenting;

/**
 * This class is the Bean Implementation for the Entity EJB <tt>M05RentingEB</tt>.
 *
 * @see     m05.exe.Renting
 * @see     m05.exe.M05RentingEB
 * @see     m05.exe.M05RentingEBPK
 * @see     m05.exe.M05RentingEBHome
 */
abstract public class m05RentingBean implements EntityBean {

  private EntityContext ctx;



  /**
   * This is the primary key.
   * It is the clave, which is the primary key
   * in table <tt>m0541t00</tt>.
   */

  /**
   * Returns the Reparacion information of this E-EJB.
   */
  public m05bRenting getRenting(){
    m05bRenting renting = new m05bRenting();

    renting.setRen_importe(getRen_importe());
    renting.setRen_fecha(getRen_fecha());
    renting.setRen_matricula(getRen_matricula());
    renting.setRen_codigo(getRen_codigo());

    return renting;
  }

  /**
   * Sets the Renting information of this E-EJB.
   * @exception P2GException
   *              If the given Renting <tt>ren_matricula</tt> field
   *              does not match the primary key that is in the E-EJB.
   */
  public void setRenting(m05bRenting renting)
    throws Exception{

    //the primary key is never modified!!
    if (getRen_codigo() != renting.getRen_codigo())
      throw new CreateException ("Cannot modify a different renting");

    setRen_fecha(renting.getRen_fecha());
    setRen_matricula(renting.getRen_matricula());
    setRen_importe(renting.getRen_importe());
    setRen_codigo (renting.getRen_codigo());

  }

  abstract public String getRen_importe();
  abstract public void setRen_importe(String n);

  abstract public String getRen_codigo();
  abstract public void setRen_codigo(String n);

  abstract public String getRen_fecha();
  abstract public void setRen_fecha(String n);

  abstract public String getRen_matricula();
  abstract public void setRen_matricula(String n);

  public void ejbActivate() {
  }

  public void ejbPassivate() {
  }

  public void setEntityContext(EntityContext ctx) {
    this.ctx = ctx;
  }

  public void unsetEntityContext() {
    this.ctx = null;
  }

  public void ejbLoad() {
  }

  public void ejbStore() {
  }

  public void ejbRemove()
    throws RemoveException
  {
  }

  /**
   * This function initializes the Renting
   * information of this E-EJB.
   * It assigns a new primary key to the Renting.
   * @see #getNewOrderNum()
   */
  public m05RentingPK ejbCreate(m05bRenting renting)
    throws CreateException
  {
    try {
      setRen_codigo(getRen_codigo());
    } catch (Exception e) {
      throw new CreateException (e.getMessage());
    }

    setRen_fecha(renting.getRen_fecha());
    setRen_matricula(renting.getRen_matricula());
    setRen_importe(renting.getRen_importe());


    return null;
  }

  public void ejbPostCreate(m05bRenting renting)
  {
  }
}