package m05bReformasEJB;

import javax.ejb.CreateException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.RemoveException;

import m05bBD.m05bReformas;

/**
 * This class is the Bean Implementation for the Entity EJB <tt>M05ReformasEB</tt>.
 *
 * @see     m05.exe.Reformas
 * @see     m05.exe.M05ReformasEB
 * @see     m05.exe.M05ReformasEBPK
 * @see     m05.exe.M05ReformasEBHome
 */
abstract public class m05ReformasBean implements EntityBean {

  private EntityContext ctx;

  

  /**
   * This is the primary key.
   * It is the clave, which is the primary key
   * in table <tt>m0537t00</tt>.
   */

  /**
   * Returns the Reparacion information of this E-EJB.
   */
  public m05bReformas getReformas(){
    m05bReformas reformas = new m05bReformas();

    reformas.setRef_codigo(getRef_codigo());
    reformas.setRef_fecha(getRef_fecha());
    reformas.setRef_marca(getRef_marca());
    reformas.setRef_matric(getRef_matricula());
    reformas.setRef_numero(getRef_numero());
    reformas.setRef_taller(getRef_taller());
    reformas.setRef_tipref(getRef_tipref());
    reformas.setRef_observ(getRef_observacion());


    return reformas;
  }

  /**
   * Sets the Reformas information of this E-EJB.
   * @exception P2GException
   *              If the given Reformas <tt>ref_codigo</tt> field
   *              does not match the primary key that is in the E-EJB.
   */
  public void setReformas(m05bReformas reformas)
    throws Exception{

    //the primary key is never modified!!
    if (getRef_codigo() != reformas.getRef_codigo())
      throw new CreateException ("Cannot modify a different reparacion");

    setRef_fecha(reformas.getRef_fecha());
    setRef_matricula(reformas.getRef_matric());
    setRef_tipref(reformas.getRef_tipref());
    setRef_marca(reformas.getRef_marca());
    setRef_numero(reformas.getRef_numero());
    setRef_taller(reformas.getRef_taller());
    setRef_observacion(reformas.getRef_observ());


  }

  abstract public String getRef_codigo();
  abstract public void setRef_codigo(String n);

  abstract public String getRef_fecha();
  abstract public void setRef_fecha(String n);

  abstract public String getRef_matricula();
  abstract public void setRef_matricula(String n);

  abstract public String getRef_tipref();
  abstract public void setRef_tipref(String n);

  abstract public String getRef_marca();
  abstract public void setRef_marca(String n);

  abstract public String getRef_numero();
  abstract public void setRef_numero(String n);

  abstract public String getRef_taller();
  abstract public void setRef_taller(String n);

  abstract public String getRef_observacion();
  abstract public void setRef_observacion(String n);

  public void ejbActivate() {
  }

  public void ejbPassivate() {
  }

  public void setEntityContext(EntityContext ctx) {
    this.ctx = ctx;
  }

  public void unsetEntityContext() {
    this.ctx = null;
  }

  public void ejbLoad() {
  }

  public void ejbStore() {
  }

  public void ejbRemove()
    throws RemoveException
  {
  }

  /**
   * This function initializes the Reformas
   * information of this E-EJB.
   * It assigns a new primary key to the Reformas.
   * @see #getNewOrderNum()
   */
  public m05ReformasPK ejbCreate(m05bReformas reformas)
    throws CreateException
  {
    try {
      setRef_codigo(getRef_codigo());
    } catch (Exception e) {
      throw new CreateException (e.getMessage());
    }

    setRef_fecha(reformas.getRef_fecha());
    setRef_matricula(reformas.getRef_matric());
    setRef_tipref(reformas.getRef_tipref());
    setRef_marca(reformas.getRef_marca());
    setRef_numero(reformas.getRef_numero());
    setRef_taller(reformas.getRef_taller());
    setRef_observacion(reformas.getRef_observ());

    return null;
  }

  public void ejbPostCreate(m05bReformas reformas)
  {
  }


}