package m05bPolizaEJB;

import javax.ejb.CreateException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.RemoveException;

import m05bBD.m05bPoliza;

/**
 * This class is the Bean Implementation for the Entity EJB <tt>M05PolizaEB</tt>.
 *
 * @see     m05.exe.Poliza
 * @see     m05.exe.M05PolizaEB
 * @see     m05.exe.M05PolizaEBPK
 * @see     m05.exe.M05PolizaEBHome
 */

abstract public class m05PolizaBean implements EntityBean {

  private EntityContext ctx;

 
  /**
   * This is the primary key.
   * It is the clave, which is the primary key
   * in table <tt>m0513t00</tt>.
   */

  /**
   * Returns the Poliza information of this E-EJB.
   */
  public m05bPoliza getPoliza(){
    m05bPoliza poliza = new m05bPoliza();

    poliza.setPol_codigo(getPol_codigo());
    poliza.setPol_matricula(getPol_matricula());
    poliza.setPol_poliza(getPol_poliza());
    poliza.setPol_cia(getPol_cia());
    poliza.setPol_modal(getPol_modal());
    poliza.setPol_fbaja(getPol_fbaja());
    poliza.setPol_falta(getPol_falta());
    poliza.setPol_fcaduc(getPol_fcaduc());
    poliza.setPol_fsolic(getPol_fsolic());
    poliza.setPol_importe(getPol_importe());
    poliza.setPol_fimpreso(getPol_fimpreso());
    poliza.setPol_estado(getPol_estado());
    poliza.setPol_impreso(getPol_impreso());
    poliza.setPol_fimpreso(getPol_fimpreso());
    poliza.setPol_estado(getPol_estado());
    poliza.setPol_polizav(getPol_polizav());


    return poliza;
  }

  /**
   * Sets the Reformas information of this E-EJB.
   * @exception P2GException
   *              If the given Reformas <tt>ref_codigo</tt> field
   *              does not match the primary key that is in the E-EJB.
   */
  public void setPoliza(m05bPoliza poliza)
    throws Exception{

    //the primary key is never modified!!
    if (getPol_codigo() != poliza.getPol_codigo())
      throw new CreateException ("Cannot modify a different reparacion");

    setPol_fbaja(poliza.getPol_fbaja());
    setPol_matricula(poliza.getPol_matricula());
    setPol_falta(poliza.getPol_falta());
    setPol_poliza(poliza.getPol_poliza());
    setPol_polizav(poliza.getPol_polizav());
    setPol_cia(poliza.getPol_cia());
    setPol_modal(poliza.getPol_modal());
    setPol_fcaduc(poliza.getPol_fcaduc());
    setPol_fsolic(poliza.getPol_fsolic());
    setPol_importe(poliza.getPol_importe());
    setPol_estado(poliza.getPol_estado());
    setPol_impreso(poliza.getPol_impreso());
    setPol_fimpreso(poliza.getPol_fimpreso());
    setPol_estado(poliza.getPol_estado());



  }

  abstract public String getPol_codigo();
  abstract public void setPol_codigo(String n);

  abstract public String getPol_fbaja();
  abstract public void setPol_fbaja(String n);

  abstract public String getPol_matricula();
  abstract public void setPol_matricula(String n);

  abstract public String getPol_falta();
  abstract public void setPol_falta(String n);

  abstract public String getPol_poliza();
  abstract public void setPol_poliza(String n);

  abstract public String getPol_cia();
  abstract public void setPol_cia(String n);

  abstract public String getPol_modal();
  abstract public void setPol_modal(String n);

  abstract public String getPol_fcaduc();
  abstract public void setPol_fcaduc(String n);

  abstract public String getPol_fsolic();
  abstract public void setPol_fsolic(String n);

  abstract public String getPol_importe();
  abstract public void setPol_importe(String n);

  abstract public String getPol_estado();
  abstract public void setPol_estado(String n);

  abstract public String getPol_impreso();
  abstract public void setPol_impreso(String n);

  abstract public String getPol_fimpreso();
  abstract public void setPol_fimpreso(String n);

  abstract public String getPol_polizav();
  abstract public void setPol_polizav(String n);

  public void ejbActivate() {
  }

  public void ejbPassivate() {
  }

  public void setEntityContext(EntityContext ctx) {
    this.ctx = ctx;
  }

  public void unsetEntityContext() {
    this.ctx = null;
  }

  public void ejbLoad() {
  }

  public void ejbStore() {
  }

  public void ejbRemove()
    throws RemoveException
  {
  }

  /**
   * This function initializes the Poliza
   * information of this E-EJB.
   * It assigns a new primary key to the Poliza.
   * @see #getNewOrderNum()
   */
  public m05PolizaPK ejbCreate(m05bPoliza poliza)
    throws CreateException
  {
    try {
      setPol_codigo(getPol_codigo());
    } catch (Exception e) {
      throw new CreateException (e.getMessage());
    }

    setPol_fbaja(poliza.getPol_fbaja());
    setPol_matricula(poliza.getPol_matricula());
    setPol_falta(poliza.getPol_falta());
    setPol_poliza(poliza.getPol_poliza());
    setPol_cia(poliza.getPol_cia());
    setPol_modal(poliza.getPol_modal());
    setPol_fcaduc(poliza.getPol_fcaduc());
    setPol_fsolic(poliza.getPol_fsolic());
    setPol_importe(poliza.getPol_importe());
    setPol_estado(poliza.getPol_estado());
    setPol_impreso(poliza.getPol_impreso());
    setPol_fimpreso(poliza.getPol_fimpreso());
    setPol_polizav(poliza.getPol_polizav());
    return null;
  }

  public void ejbPostCreate(m05bPoliza poliza)
  {
  }


}