package m05bPiezaEJB;

import javax.ejb.CreateException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.RemoveException;

import m05bBD.m05bPieza;


/**
 * This class is the Bean Implementation for the Entity EJB <tt>M05PiezaEB</tt>.
 *
 * @see     m05.exe.Pieza
 * @see     m05.exe.M05PiezaEB
 * @see     m05.exe.M05PiezaEBPK
 * @see     m05.exe.M05PiezaEBHome
 * @author <a href="mailto:paco.gomez@terra.com">Paco Gomez</a>.
 *         Professional J2EE Programming with BEA WebLogic Server, 
 *         by Gomez & Zadrozny, Copyright &#169; 2000. 
 */
abstract public class m05PiezaBean implements EntityBean {
  
  private EntityContext ctx;

 

  /** 
   * This is the primary key.
   * It is the clave, which is the primary key 
   * in table <tt>m0502t00</tt>.
   */

  
  /**
   * Returns the Pieza information of this E-EJB.
   */    
  public m05bPieza getPieza(){
    m05bPieza pieza = new m05bPieza();
    
    pieza.setPie_codigo(getPie_codigo());
    pieza.setPie_pieza(getPie_pieza());
    pieza.setPie_precio(getPie_precio());
    /*Iker Euskera*/
    pieza.setPie_piezaEu(getPie_piezaEu());
    return pieza;	
  }    

  /**
   * Sets the Pieza information of this E-EJB.
   * @exception P2GException 
   *              If the given Pieza <tt>pie_codigo</tt> field 
   *              does not match the primary key that is in the E-EJB.
   */   
  public void setPieza(m05bPieza pieza)
    throws Exception{
   
    //the primary key is never modified!!
    if (getPie_codigo() != pieza.getPie_codigo())
      throw new CreateException ("Cannot modify a different pieza");
      
    setPie_pieza(pieza.getPie_pieza());
    setPie_precio(pieza.getPie_precio());
    /*Iker Euskera*/
    setPie_piezaEu(pieza.getPie_piezaEu());
  }   	
  
  abstract public String getPie_codigo();
  abstract public void setPie_codigo(String n);
  
  abstract public String getPie_pieza();
  abstract public void setPie_pieza(String n);
  
  abstract public String getPie_piezaEu();
  abstract public void setPie_piezaEu(String n);
  abstract public double getPie_precio();
  abstract public void setPie_precio(double n);

  public void ejbActivate() {
  }

  public void ejbPassivate() {
  }

  public void setEntityContext(EntityContext ctx) {
    this.ctx = ctx;
  }

  public void unsetEntityContext() {
    this.ctx = null;
  }

  public void ejbLoad() {
  }
  
  public void ejbStore() {
  }

  public void ejbRemove()
    throws RemoveException
  {
  }

  /**
   * This function initializes the Pieza 
   * information of this E-EJB.
   * It assigns a new primary key to the Pieza.
   */ 
  public m05PiezaPK ejbCreate(m05bPieza pieza) 
    throws CreateException
  {
    try {
      setPie_codigo(getPie_codigo());
    } catch (Exception e) {
      throw new CreateException (e.getMessage());
    }    
    setPie_pieza(pieza.getPie_pieza());
    
    setPie_precio(pieza.getPie_precio());
    /*Iker: euskera*/
    setPie_piezaEu(pieza.getPie_piezaEu());
    return null;      	
  }

  public void ejbPostCreate(m05bPieza pieza) 
  {
  }

 
}
