package m05bPersonalEJB;
import javax.ejb.CreateException;
import javax.ejb.EntityBean;
import javax.ejb.EntityContext;
import javax.ejb.RemoveException;

import m05bBD.m05bPersonal;

/**
 * This class is the Bean Implementation for the Entity EJB <tt>M05PersonalEB</tt>.
 *
 * @see     m05.exe.Personal
 * @see     m05.exe.M05PersonalEB
 * @see     m05.exe.M05PersonalEBPK
 * @see     m05.exe.M05PersonalEBHome
 */
abstract public class m05PersonalBean implements EntityBean {
  private EntityContext ctx;

  

  /** 
   * This is the primary key.
   * It is the clave, which is the primary key 
   * in table <tt>m0521t00</tt>.
   */

  /**
   * Returns the Personal information of this E-EJB.
   */
  public m05bPersonal getPersonal(){
    m05bPersonal personal = new m05bPersonal();
    personal.setPer_dni(getPer_dni());
    personal.setPer_nombre(getPer_nombre());
    personal.setPer_direc(getPer_direc());
    personal.setPer_telef(getPer_telef());
    personal.setPer_cod_car(getPer_cod_car());
    personal.setPer_coddpto(getPer_coddpto());
    personal.setPer_codrango(getPer_codrango());
    personal.setPer_actualizable(getPer_actualizable());
    personal.setPer_tipoper(getPer_tipoper());
    personal.setPer_codprovincia(getPer_codprovincia());
    personal.setPer_codmunicipio(getPer_codmunicipio());
    personal.setPer_codpostal(getPer_codpostal());        
    return personal;

  } 
  /**
   * Sets the Personal information of this E-EJB.
   * @exception P2GException 
   *              If the given Personal <tt>per_dni</tt> field 
   *              does not match the primary key that is in the E-EJB.
   */
  public void setPersonal(m05bPersonal personal) throws Exception{
    //the primary key is never modified!!
    if (getPer_dni() != personal.getPer_dni())
      throw new CreateException ("Cannot modify a different personal");
         setPer_dni(personal.getPer_dni());
         setPer_nombre(getPer_nombre());
    	 setPer_direc(getPer_direc());
         setPer_telef(getPer_telef());
         setPer_cod_car(getPer_cod_car());
         setPer_coddpto(getPer_coddpto());
         setPer_codrango(getPer_codrango());
         setPer_actualizable(getPer_actualizable());
         setPer_tipoper(getPer_tipoper());
         setPer_codprovincia(getPer_codprovincia());
         setPer_codmunicipio(getPer_codmunicipio());         
         setPer_codpostal(getPer_codpostal());         
  }
  
  abstract public String getPer_dni();
  abstract public void setPer_dni(String n);
  abstract public String getPer_nombre();
  abstract public void setPer_nombre(String n);
  abstract public String getPer_direc();
  abstract public void setPer_direc(String n);

  abstract public String getPer_telef();
  abstract public void setPer_telef(String n);
  abstract public String getPer_cod_car();
  abstract public void setPer_cod_car(String n);
  
  abstract public String getPer_coddpto();
  abstract public void setPer_coddpto(String n);
  abstract public String getPer_codrango();
  abstract public void setPer_codrango(String n);
  abstract public String getPer_actualizable();
  abstract public void setPer_actualizable(String n);
  abstract public String getPer_tipoper();
  abstract public void setPer_tipoper(String n);
  abstract public String getPer_codprovincia();
  abstract public void setPer_codprovincia(String n);
  abstract public String getPer_codmunicipio();
  abstract public void setPer_codmunicipio(String n);  
  abstract public String getPer_codpostal();
  abstract public void setPer_codpostal(String n);  

  public void ejbActivate() {   }

  public void ejbPassivate() {  }

  public void setEntityContext(EntityContext ctx) {
    this.ctx = ctx;
  }

  public void unsetEntityContext() {
    this.ctx = null;
  }

  public void ejbLoad() {  }
 
  public void ejbStore() {  }

  public void ejbRemove()  throws RemoveException  {   }

  /**
   * This function initializes the Personal 
   * information of this E-EJB.
   * It assigns a new primary key to the Personal.
   */ 
  public m05PersonalPK ejbCreate(m05bPersonal personal)  throws CreateException
  {
    try {
      setPer_dni(getPer_dni());
    } catch (Exception e) {
      throw new CreateException (e.getMessage());
    }    
    setPer_nombre(personal.getPer_nombre());
    setPer_direc(personal.getPer_direc());
    setPer_telef(personal.getPer_telef());
    setPer_cod_car(personal.getPer_cod_car());
    setPer_coddpto(personal.getPer_coddpto());
    setPer_codrango(personal.getPer_codrango());
    setPer_actualizable(personal.getPer_actualizable());
    setPer_tipoper(personal.getPer_tipoper());
    setPer_codprovincia(personal.getPer_codprovincia());
    setPer_codmunicipio(personal.getPer_codmunicipio());    
    setPer_codpostal(personal.getPer_codpostal());    
    return null; 
  }
  public void ejbPostCreate(m05bPersonal personal)  {   }

}