package vehiculosServlet;

import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.ResourceBundle;

import javax.servlet.http.HttpSession;

import m05bClasses.m05bComun;
import m05bClasses.m05bConexion;
import m05bClasses.m05bConstantes;
import m05bClasses.m05bFileLog;

/**
 * Inserte aqu la descripcin del tipo. Fecha de creacin: (11/11/04)
 */
public class m05bModificarKmActualesServlet extends
		javax.servlet.http.HttpServlet {
	   m05bFileLog miLog = new m05bFileLog();
	/**
	 * Process incoming HTTP POST requests
	 * 
	 * @param request
	 *            Object that encapsulates the request to the servlet
	 * @param response
	 *            Object that encapsulates the response from the servlet
	 */
	public void doPost(javax.servlet.http.HttpServletRequest request,
			javax.servlet.http.HttpServletResponse response)
			throws javax.servlet.ServletException, java.io.IOException {

		performTask(request, response);

	}

	/**
	 * Returns the servlet info string.
	 */
	public String getServletInfo() {

		return super.getServletInfo();

	}

	/**
	 * Initializes the servlet.
	 */
	public void init() {
		// insert code to initialize the servlet here

	}

	/**
	 * Process incoming requests for information
	 * 
	 * @param request
	 *            Object that encapsulates the request to the servlet
	 * @param response
	 *            Object that encapsulates the response from the servlet
	 */
	public void performTask(javax.servlet.http.HttpServletRequest request,
			javax.servlet.http.HttpServletResponse response) {

		String sMatricula, sKmActuales = "", sfcambio = "";
		java.util.Date fcambio = null;

		java.sql.Connection conn = null;
		PreparedStatement pstmt = null;
		m05bComun miComun = new m05bComun();

		try {
			// Actualizar tabla de vehiculos con los Km a una fecha
			sMatricula = request.getParameter("Matricula").toUpperCase();
			sKmActuales = request.getParameter("KmActuales");
			sKmActuales = miComun.ImportesABasedatos(sKmActuales);
			HttpSession session = request.getSession(true);
			ResourceBundle res = (ResourceBundle) session
					.getAttribute("resTit");

			Locale idiomaLocal = (Locale) session.getAttribute("Local");
			String idiomaSes = ((idiomaLocal.getLanguage() == null) ? "es"
					: idiomaLocal.getLanguage());
			String campoTexto = "", campoTexto2 = "", campoTexto3 = "C";
			String formatoFecha = "dd/MM/yyyy";
			if (!idiomaSes.equals("es")) {
				campoTexto = "E";
				campoTexto2 = "E_";
				campoTexto3 = "E";
				formatoFecha = "yyyy/MM/dd";
			}
			SimpleDateFormat dateFormater = new SimpleDateFormat(formatoFecha);
			sfcambio = request.getParameter("FCambio");
			if (!(sfcambio.equals("")))
				fcambio = dateFormater.parse(sfcambio);
			try {
				// Comprobar que la tarjeta este dada de baja
				m05bConexion miConex = new m05bConexion();
				conn = miConex.getConnection();
				pstmt = conn.prepareStatement("update "
						+ m05bConstantes.TAB_VEHICULOS + " set "
						+ m05bConstantes.COL_34_KMACTUALES + " = ? " + " ,"
						+ m05bConstantes.COL_34_FKMACT + " = ? " + "where "
						+ m05bConstantes.COL_34_MATRICULA + " = ?");
				pstmt.setString(1, sKmActuales);
				pstmt.setTimestamp(2, new Timestamp(fcambio.getTime()));
				pstmt.setString(3, sMatricula);
				pstmt.executeUpdate();
				response.sendRedirect("m05bModifKmActualesJsp.jsp?Mensaje="
						+ m05bConstantes.MSG_OK);
			} catch (Exception ex) {
				response.sendRedirect("m05bError.jsp");
			} finally {
				if (pstmt != null)
					pstmt.close();
				if (conn != null)
					conn.close();
			}
		} catch (Throwable theException) {
			// uncomment the following line when unexpected exceptions
			// are occuring to aid in debugging the problem.
			miLog.addTraza(theException);
			try {
				response.sendRedirect("m05bError.jsp");
			} catch (IOException e) {
				// TODO Auto-generated catch block
				miLog.addTraza(e);
			}
		}
	}
}