package vehiculosServlet;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Locale;
import java.util.ResourceBundle;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import m05bClasses.m05bComun;
import m05bClasses.m05bConexion;
import m05bClasses.m05bConstantes;
import m05bClasses.m05bFileLog;

import org.apache.fop.apps.Driver;
import org.apache.fop.apps.FOPException;
import org.xml.sax.InputSource;

public class m05bImpVehiculosRangoServlet extends
		javax.servlet.http.HttpServlet {
	java.sql.Connection conn = null;
	String sLinea;
	String sFoFileDir = "/datos/m05b/tmp/";
	File foFileDir;
	File tmpFoFile;
	FileOutputStream tmpFoFileStream;
	m05bComun miComun = new m05bComun();
	m05bFileLog miLog = new m05bFileLog();

	String sSituacion = "";
	String sSituacionBD = "";
	String sGRango = "";
	String sRango = "";
	String sCodCentro = "";
	String sAgrupado = "";
	String sOrdenado = "";
	String sDesDpto = "";
	String sCodDpto = "";
	public static final String FO_REQUEST_PARAM = "fo";

	// Logger log = null;

	public void doPost(javax.servlet.http.HttpServletRequest request,
			javax.servlet.http.HttpServletResponse response)
			throws javax.servlet.ServletException, java.io.IOException {
		try {
			doGet(request, response);
		} catch (Exception e) {
			miLog.addTraza(e);
		}
	}

	public void doGet(HttpServletRequest request, HttpServletResponse response)
			throws ServletException {
		performTask(request, response);
	}

	private void fncAbrirFicheroTemporal() throws java.io.IOException {
		foFileDir = new File(sFoFileDir);
		tmpFoFile = File.createTempFile("m05b", "Fo", foFileDir);
		tmpFoFileStream = new FileOutputStream(tmpFoFile);

	}

	private void fncImprimirFinPagina() throws java.io.IOException {
		sLinea = "	    </fo:table-body>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "       </fo:table>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "      </fo:flow>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "   </fo:page-sequence>\n";
		tmpFoFileStream.write(sLinea.getBytes());

	}

	private void fncImprimirComienzoPagina(ResourceBundle res,String idioma) throws java.io.IOException,
			javax.naming.NamingException {
		sLinea = "<fo:page-sequence master-reference=\"general\">\n";
		tmpFoFileStream.write(sLinea.getBytes());

		// REGION BEFORE
		sLinea = "		<fo:static-content flow-name=\"xsl-region-before\" >\n";
		tmpFoFileStream.write(sLinea.getBytes());
		// -------------- CABECERA DEL LISTADO --------------
		// Cabecera 1
		sLinea = "      <fo:block text-align=\"end\">\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "      </fo:block>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "      <fo:block   font-weight=\"bold\" padding-top=\"10pt\">\n "
				+ res.getString("infVehRang.titulo") + "</fo:block> \n";
		tmpFoFileStream.write(sLinea.getBytes());

		if (sAgrupado.equals("1")) {
			sLinea = "     <fo:block font-weight=\"bold\" padding-top=\"10pt\">\n<![CDATA[ "
					+ res.getString("infVehRang.texto1")
					+ sDesDpto
					+ " ( "
					+ sCodDpto
					+ " )"
					+ "]]></fo:block> \n";
			tmpFoFileStream.write(sLinea.getBytes());
		}
		sLinea = "      <fo:block font-weight=\"bold\" padding-top=\"10pt\">\n<![CDATA[ "
				+ res.getString("infVehRang.texto2") + sRango + "]]></fo:block>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		if (!(sSituacionBD.equals(""))) {
			sLinea = "      <fo:block font-weight=\"bold\" padding-top=\"10pt\">\n <![CDATA["
					+ res.getString("infVehRang.texto3") + sSituacionBD + "]]></fo:block>\n";
			tmpFoFileStream.write(sLinea.getBytes());
		}

		sLinea = " 		</fo:static-content>\n";
		tmpFoFileStream.write(sLinea.getBytes());

		// PIE DE PAGINA Pie
		sLinea = "		<fo:static-content flow-name=\"xsl-region-after\">\n";
		tmpFoFileStream.write(sLinea.getBytes());
		// PIE DE PAGINA Pie
		sLinea = "      <fo:block >\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "       <fo:table>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    <fo:table-column column-width=\"150mm\"/>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    <fo:table-column column-width=\"110mm\"/>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    <fo:table-body font-family=\"Helvetica\" font-size=\"6pt\">\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    <fo:table-row>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    <fo:table-cell >\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "      <fo:block text-align=\"left\">"
				+ miComun.getDetFechaActual(idioma)
				+ "</fo:block>";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    </fo:table-cell>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    <fo:table-cell >\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "      <fo:block text-align=\"right\">";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = res.getString("pagina")+" <fo:page-number/> \n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "</fo:block>";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    </fo:table-cell>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    </fo:table-row>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    </fo:table-body>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "       </fo:table>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "      </fo:block>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = " 		</fo:static-content>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		// BODY
		sLinea = "	<fo:flow flow-name=\"xsl-region-body\">\n";
		tmpFoFileStream.write(sLinea.getBytes());
		Context ctx = new InitialContext(System.getProperties());
		// -------------- DETALLE DEL LISTADO --------------
		sLinea = "        <fo:table space-after.optimum=\"12pt\">\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    <fo:table-column column-width=\"20mm\"/>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    <fo:table-column column-width=\"30mm\"/>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    <fo:table-column column-width=\"40mm\"/>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    <fo:table-column column-width=\"20mm\"/>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    <fo:table-column column-width=\"15mm\"/>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    <fo:table-column column-width=\"20mm\"/>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    <fo:table-column column-width=\"15mm\"/>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    <fo:table-column column-width=\"100mm\"/>\n";
		tmpFoFileStream.write(sLinea.getBytes());

		sLinea = "	    <fo:table-body font-family=\"Helvetica\" font-size=\"8pt\">\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    <fo:table-row>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		// Matricula
		sLinea = "	    <fo:table-cell padding-top=\"2mm\">\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "      <fo:block font-weight=\"bold\" text-align=\"center\">\n "+ res.getString("infVehRang.col1")
				+ "</fo:block>";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    </fo:table-cell>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		// Marca
		sLinea = "	    <fo:table-cell padding-top=\"2mm\">\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "      <fo:block font-weight=\"bold\"  text-align=\"center\">\n "+ res.getString("infVehRang.col2")+"</fo:block>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    </fo:table-cell>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		// Modelo
		sLinea = "	    <fo:table-cell padding-top=\"2mm\">\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "      <fo:block font-weight=\"bold\"  text-align=\"center\">\n "+ res.getString("infVehRang.col3")+"</fo:block>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    </fo:table-cell>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		// F.Matriculacion
		sLinea = "	    <fo:table-cell padding-top=\"2mm\">\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "      <fo:block font-weight=\"bold\"  text-align=\"center\">\n "+ res.getString("infVehRang.col4")+"</fo:block>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    </fo:table-cell>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		// Km
		sLinea = "	    <fo:table-cell padding-top=\"2mm\">\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "      <fo:block font-weight=\"bold\"  text-align=\"center\">\n "+ res.getString("infVehRang.col5")+"</fo:block>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    </fo:table-cell>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		// situacion
		sLinea = "	    <fo:table-cell padding-top=\"2mm\" >\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "      <fo:block font-weight=\"bold\"  text-align=\"center\">\n "+ res.getString("infVehRang.col6")+"</fo:block>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    </fo:table-cell>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		// Centro
		sLinea = "	    <fo:table-cell padding-top=\"2mm\" >\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "      <fo:block font-weight=\"bold\"  text-align=\"center\">\n "+ res.getString("infVehRang.col7")+"</fo:block>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    </fo:table-cell>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		// Descipcion
		sLinea = "	    <fo:table-cell padding-top=\"2mm\" >\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "      <fo:block font-weight=\"bold\"  text-align=\"center\">\n "+ res.getString("infVehRang.col8")+"</fo:block>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    </fo:table-cell>\n";
		tmpFoFileStream.write(sLinea.getBytes());

		sLinea = "	    </fo:table-row>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    <fo:table-row >\n";
		tmpFoFileStream.write(sLinea.getBytes());

	}

	private void imprimirTotal(int intCont, boolean bolGeneral,ResourceBundle res)
			throws java.io.IOException, javax.naming.NamingException {
		sLinea = "	    <fo:table-row>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		// vacas
		for (int i = 0; i < 7; i++) {
			sLinea = "	    <fo:table-cell>\n<fo:block>\n</fo:block>\n</fo:table-cell>\n";
			tmpFoFileStream.write(sLinea.getBytes());
		}
		// Contador
		sLinea = "	    <fo:table-cell>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		if (bolGeneral)
			sLinea = "      <fo:block font-weight=\"bold\" text-align=\"right\"  padding-top=\"26pt\">\n "
					+ res.getString("infListTasas.texto4") + intCont + "</fo:block>\n";
		else
			sLinea = "      <fo:block font-weight=\"bold\" text-align=\"right\"  padding-top=\"26pt\">\n "
					+res.getString("infVehRang.texto4")+ intCont + "</fo:block>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    </fo:table-cell>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    </fo:table-row>\n";
		tmpFoFileStream.write(sLinea.getBytes());
	}

	public void performTask(javax.servlet.http.HttpServletRequest request,
			javax.servlet.http.HttpServletResponse response)
			throws ServletException {
		java.sql.Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		m05bComun miComun = new m05bComun();

		try {
			HttpSession session = request.getSession(true);
			ResourceBundle res = (ResourceBundle) session
					.getAttribute("resTit");

			Locale idiomaLocal = (Locale) session.getAttribute("Local");
			String idiomaSes = ((idiomaLocal.getLanguage() == null) ? "es"
					: idiomaLocal.getLanguage());
			String campoTexto = "", campoTexto2 = "", campoTexto3 = "C";
			String formatoFecha="dd/MM/yyyy";
			if (!idiomaSes.equals("es")) {
				campoTexto = "E";
				campoTexto2 = "E_";
				campoTexto3 = "E";
				formatoFecha = "yyyy/MM/dd";
			}

			m05bConexion miConex = new m05bConexion();
			conn = miConex.getConnection();

			// Obtencin de informacin de BD
			// Vehculo
			// Recogemos la situacion
			sSituacion = request.getParameter("Situacion");
			sSituacionBD = sSituacion;
			if ((sSituacion == null) || (sSituacion.equals(""))) {
				sSituacion = "";
			} else {
				sSituacion = miComun.ListaCaracteres(sSituacion);
			}
			// Recogemos el Grupo Rango
			sGRango = request.getParameter("GRango");
			if ((sGRango == null) || (sGRango.equals(""))) {
				sGRango = "";
			}
			// Recogemos el Rango
			sRango = request.getParameter("Rango");
			if ((sRango == null) || (sRango.equals(""))) {
				sRango = "";
			}
			// Recogemos el Centro
			sCodCentro = request.getParameter("CodCentro");
			if (sCodCentro == null) {
				sCodCentro = "";
			}
			// Recogemos Agrupado
			sAgrupado = request.getParameter("Agrupado");
			miLog.addTraza("Bego", "m05bImpVehiculosRangoServlet :",
					"Agrupado: " + sAgrupado, m05bConstantes.LOG_NIVEL_BAJO);

			if (sAgrupado == null) {
				sAgrupado = "";
			}
			// Recogemos Ordenado por:
			sOrdenado = request.getParameter("Ordenado");
			if (sOrdenado == null) {
				sOrdenado = "";
			}

			sDesDpto = "";
			sCodDpto = "";
			String matricula = "";
			String sMatricula = "";
			String sMarca = "";
			String sModelo = "";
			String sFMatricula = "";
			String sKilometros = "";
			String sCentro = "";
			String sDescripcion = "";
			String sDpto = "";
			String sDesDptoAnt = "";
			String sRangoAnt = "";
			double dNumero = 0.0;
			String sSentencia = " SELECT  DISTINCT DECODE ("
					+campoTexto2+ m05bConstantes.COL_06_DESCDPTO + ",'','Parque Movil',"
					+campoTexto2+ m05bConstantes.COL_06_DESCDPTO + "),"
					+ m05bConstantes.COL_34_RANGO + ",TO_CHAR("
					+ m05bConstantes.COL_34_FBAJA + ",'"+formatoFecha+"'),"
					+ m05bConstantes.COL_34_MATRICULA + ",M."
					+ m05bConstantes.COL_99_DESCRIPCION + ","
					+ m05bConstantes.COL_17_DESCRIP + ",TO_CHAR("
					+ m05bConstantes.COL_34_FMATRIC + ",'"+formatoFecha+"'),"
					+ m05bConstantes.COL_34_KMACTUALES + ","
					+ m05bConstantes.COL_34_SITUACION + ","
					+ m05bConstantes.COL_05_CODIGO + ","
					+ m05bConstantes.COL_05_DESC + ", "
					+ m05bConstantes.COL_34_FADQUIS + ","
					+ m05bConstantes.COL_34_REGADQUIS + ",NVL(S."
					+ campoTexto+m05bConstantes.COL_99_DESCRIPCION + ",S."
					+m05bConstantes.COL_99_DESCRIPCION + "),"
					+ m05bConstantes.COL_34_CODDPTO + " FROM "
					+ m05bConstantes.TAB_DEPARTAMENTOS + ","
					+ m05bConstantes.TAB_VEHICULOS + ","
					+ m05bConstantes.TAB_MODELOS + ","
					+ m05bConstantes.TAB_DESCRIPCIONES + "  M,"
					+ m05bConstantes.TAB_DESCRIPCIONES + "  S,"
					+ m05bConstantes.TAB_CENTROS + ","
					+ m05bConstantes.TAB_TARJETAS + " WHERE "
					+ m05bConstantes.COL_31_MATRICULA + "(+) ="
					+ m05bConstantes.COL_34_MATRICULA + " AND "
					+ m05bConstantes.COL_34_MODELO + "="
					+ m05bConstantes.COL_17_CODMOD + " AND M."
					+ m05bConstantes.COL_99_CODTABLA + "="
					+ m05bConstantes.DESC_MARCAS + " AND "
					+ m05bConstantes.COL_34_MARCA + "= M."
					+ m05bConstantes.COL_99_CODDESC + " AND S."
					+ m05bConstantes.COL_99_CODTABLA + "="
					+ m05bConstantes.DESC_SITUACIONES + " AND "
					+ m05bConstantes.COL_34_SITUACION + "= S."
					+ m05bConstantes.COL_99_CODDESC + " AND "
					+ m05bConstantes.COL_06_CODDPTO + "="
					+ m05bConstantes.COL_34_CODDPTO + " AND "
					+ m05bConstantes.COL_31_CENTRO + "="
					+ m05bConstantes.COL_05_CODIGO + "(+) AND "
					+ m05bConstantes.COL_31_SITUACION + "(+) ='"
					+ m05bConstantes.TAR_ALTA + "' ";

			if (!(sSituacion.equals(""))) {
				sSentencia = sSentencia + " AND "
						+ m05bConstantes.COL_34_SITUACION + " in ("
						+ sSituacion + ")";
			}
			if (!(sCodCentro.equals(""))) {
				sSentencia = sSentencia + " AND "
						+ m05bConstantes.COL_05_CODIGO + " = '" + sCodCentro
						+ "'";
			}
			if (!(sRango.equals(""))) {
				sSentencia = sSentencia + " AND " + m05bConstantes.COL_34_RANGO
						+ " = '" + sRango + "'";
			} else if (!(sGRango.equals(""))) {
				String sSentenciaGrupo = " SELECT "
						+ m05bConstantes.COL_36_RANGOS + " FROM "
						+ m05bConstantes.TAB_GRUPOS + " WHERE "
						+ m05bConstantes.COL_36_CODIGO + " = '" + sGRango + "'";
				pstmt = conn.prepareStatement(sSentenciaGrupo);
				rs = pstmt.executeQuery();
				if (rs.next()) {
					sGRango = rs.getString(1) == null ? "" : rs.getString(1);
					sGRango = miComun.ListaCaracteres(sGRango);
					sSentencia = sSentencia + " AND "
							+ m05bConstantes.COL_34_RANGO + " in ( " + sGRango
							+ ")";

				}
			}
			// Agrupado
			if (sAgrupado.equals("1")) {
				sSentencia = sSentencia + " ORDER BY 1,2";
			} else {
				sSentencia = sSentencia + " ORDER BY 2";
			}
			// Orden
			String sOrden = "1";
			if (sOrdenado.equals("1")) {
				sOrden = "7";
			} else if (sOrdenado.equals("2")) {
				sOrden = "4";
			} else if (sOrdenado.equals("3")) {
				sOrden = "10";
			} else if (sOrdenado.equals("4")) {
				sOrden = "8";
			}

			sSentencia = sSentencia + " ," + sOrden;
			miLog.addTraza("Bego", "m05bImpVehiculosRangoServletInicio :",
					"sSentencia: " + sSentencia, m05bConstantes.LOG_NIVEL_BAJO);
			pstmt = conn.prepareStatement(sSentencia);
			rs = pstmt.executeQuery();

			fncAbrirFicheroTemporal();

			sLinea = "<?xml version=\"1.0\" encoding=\"windows-1252\"?>\n";
			tmpFoFileStream.write(sLinea.getBytes());

			sLinea = "<fo:root xmlns:fo=\"http://www.w3.org/1999/XSL/Format\">\n";
			tmpFoFileStream.write(sLinea.getBytes());
			// LAYOUT DEL LISTADO
			sLinea = "<fo:layout-master-set>\n";
			tmpFoFileStream.write(sLinea.getBytes());
			sLinea = "	<fo:simple-page-master master-name=\"general\"  page-height=\"21cm\" page-width=\"29.5cm\" margin-top=\"2cm\" margin-bottom=\"2cm\" margin-left=\"2cm\" margin-right=\"2cm\">\n";
			tmpFoFileStream.write(sLinea.getBytes());
			sLinea = "		<fo:region-before extent=\"3cm\"/>\n";
			tmpFoFileStream.write(sLinea.getBytes());
			sLinea = "		<fo:region-body  margin-top=\"3.8cm\" margin-bottom=\"1.5cm\" />\n";
			tmpFoFileStream.write(sLinea.getBytes());
			sLinea = "		<fo:region-after  extent=\"1cm\"/>\n";
			tmpFoFileStream.write(sLinea.getBytes());
			sLinea = "		<fo:region-start extent=\"0cm\"/>\n";
			tmpFoFileStream.write(sLinea.getBytes());
			sLinea = "		<fo:region-end extent=\"0cm\"/>\n";
			tmpFoFileStream.write(sLinea.getBytes());

			sLinea = "	</fo:simple-page-master>\n";
			tmpFoFileStream.write(sLinea.getBytes());

			sLinea = "</fo:layout-master-set>\n";
			tmpFoFileStream.write(sLinea.getBytes());

			int cont = 0;
			String dNumeroS = "";
			// Agurtzane Mar12: contador en listados
			int intCont = 0, intContParcial = 0;
			boolean bolReset = false, bolFin = false;
			// Fin Agurtzane Mar12: contador en listados
			while (rs.next()) {
				// Agurtzane Mar12: contador en listados
				intCont++;
				intContParcial++;
				// Fin Agurtzane Mar12: contador en listados
				sDesDpto = rs.getString(1) == null ? "" : rs.getString(1);
				sCodDpto = rs.getString(15) == null ? "" : rs.getString(15);
				sRango = rs.getString(2) == null ? "" : rs.getString(2);
				sMatricula = rs.getString(4) == null ? "" : rs.getString(4);
				sMarca = rs.getString(5) == null ? "" : rs.getString(5);
				sModelo = rs.getString(6) == null ? "" : rs.getString(6);
				sFMatricula = rs.getString(7) == null ? "" : rs.getString(7);
				// sKilometros = rs.getString(8)==null ? "":rs.getString(8);
				dNumeroS = (rs.getString(8) == null) ? "0" : rs.getString(8);
				sKilometros = miComun.formatearDblMiles(new Double(dNumeroS)
						.doubleValue());
				sKilometros = sKilometros.equals("0") ? "" : sKilometros;
				sKilometros = sKilometros.replaceAll(",", ".");
				sSituacion = rs.getString(14) == null ? "" : rs.getString(14);
				sCentro = rs.getString(10) == null ? "" : rs.getString(10);
				sDescripcion = rs.getString(11) == null ? "" : rs.getString(11);

				if (((!(sDesDpto.equals(sDesDptoAnt))) && (sAgrupado
						.equals("1")))
						|| ((!(sRango.equals(sRangoAnt))))
						|| (cont == 20)) {
					if ((((!(sDesDpto.equals(sDesDptoAnt))))
							&& (sDesDptoAnt != "") && (sAgrupado.equals("1")))
							|| (((!(sRango.equals(sRangoAnt)))) && (sRangoAnt != ""))
							|| (cont == 20)) {
						// Agurtzane Mar12: contador en listados
						bolReset = false;
						bolFin = false;
						if (cont == 20) {
							bolFin = true;
							if (((!(sDesDpto.equals(sDesDptoAnt))) && (sAgrupado
									.equals("1")))
									|| (!(sRango.equals(sRangoAnt)))) {
								bolReset = true;
							}
						} else
							bolReset = true;
						if (bolReset) {
							imprimirTotal(intContParcial, false,res);
							intContParcial = 0;
						}
						// Fin Agurtzane Mar12: contador en listados

						fncImprimirFinPagina();
					}
					fncImprimirComienzoPagina(res,campoTexto3);
					cont = 0;
					if (!bolFin)
						intContParcial = 0;// Agurtzane Mar12: contador en
											// listados
				} else {
					cont = cont + 1;
					sLinea = "	    <fo:table-row >\n";
					tmpFoFileStream.write(sLinea.getBytes());
				}
				sDesDptoAnt = sDesDpto;
				sRangoAnt = sRango;
				// Matricula
				sLinea = "	    <fo:table-cell padding-top=\"0.2mm\" border-width=\"0.1mm\" border-style=\"solid\">\n";
				tmpFoFileStream.write(sLinea.getBytes());
				sLinea = "      <fo:block  text-align=\"center\">\n <![CDATA["
						+ sMatricula + "]]></fo:block>";
				tmpFoFileStream.write(sLinea.getBytes());
				sLinea = "	    </fo:table-cell>\n";
				tmpFoFileStream.write(sLinea.getBytes());
				// Marca
				sLinea = "	    <fo:table-cell padding-top=\"0.2mm\" border-width=\"0.1mm\" border-style=\"solid\">\n";
				tmpFoFileStream.write(sLinea.getBytes());
				sLinea = "      <fo:block  text-align=\"center\">\n<![CDATA[ " + sMarca
						+ "]]></fo:block>\n";
				tmpFoFileStream.write(sLinea.getBytes());
				sLinea = "	    </fo:table-cell>\n";
				tmpFoFileStream.write(sLinea.getBytes());
				// Modelo
				sLinea = "	    <fo:table-cell padding-top=\"0.2mm\" border-width=\"0.1mm\" border-style=\"solid\">\n";
				tmpFoFileStream.write(sLinea.getBytes());
				sLinea = "      <fo:block  text-align=\"center\">\n<![CDATA[" + sModelo
						+ "]]></fo:block>\n";
				tmpFoFileStream.write(sLinea.getBytes());
				sLinea = "	    </fo:table-cell>\n";
				tmpFoFileStream.write(sLinea.getBytes());
				// F.Matricula
				sLinea = "	    <fo:table-cell padding-top=\"0.2mm\" border-width=\"0.1mm\" border-style=\"solid\">\n";
				tmpFoFileStream.write(sLinea.getBytes());
				sLinea = "      <fo:block  text-align=\"center\">\n<![CDATA["
						+ sFMatricula + "]]></fo:block>\n";
				tmpFoFileStream.write(sLinea.getBytes());
				sLinea = "	    </fo:table-cell>\n";
				tmpFoFileStream.write(sLinea.getBytes());
				// Km
				sLinea = "	    <fo:table-cell padding-top=\"0.2mm\" border-width=\"0.1mm\" border-style=\"solid\">\n";
				tmpFoFileStream.write(sLinea.getBytes());
				sLinea = "      <fo:block  text-align=\"center\">\n<![CDATA["
						+ sKilometros + "]]></fo:block>\n";
				tmpFoFileStream.write(sLinea.getBytes());
				sLinea = "	    </fo:table-cell>\n";
				tmpFoFileStream.write(sLinea.getBytes());
				// situacion
				sLinea = "	    <fo:table-cell padding-top=\"0.2mm\" border-width=\"0.1mm\" border-style=\"solid\">\n";
				tmpFoFileStream.write(sLinea.getBytes());
				sLinea = "      <fo:block  text-align=\"center\">\n<![CDATA["
						+ sSituacion + "]]></fo:block>\n";
				tmpFoFileStream.write(sLinea.getBytes());
				sLinea = "	    </fo:table-cell>\n";
				tmpFoFileStream.write(sLinea.getBytes());
				// Centro
				sLinea = "	    <fo:table-cell padding-top=\"0.2mm\" border-width=\"0.1mm\" border-style=\"solid\">\n";
				tmpFoFileStream.write(sLinea.getBytes());
				sLinea = "      <fo:block  text-align=\"center\">\n<![CDATA[" + sCentro
						+ "]]></fo:block>\n";
				tmpFoFileStream.write(sLinea.getBytes());
				sLinea = "	    </fo:table-cell>\n";
				tmpFoFileStream.write(sLinea.getBytes());
				// descripcion
				sLinea = "	    <fo:table-cell padding-top=\"0.2mm\" border-width=\"0.1mm\" border-style=\"solid\">\n";
				tmpFoFileStream.write(sLinea.getBytes());
				sLinea = "      <fo:block  text-align=\"center\">\n<![CDATA["
						+ sDescripcion + "]]></fo:block>\n";
				tmpFoFileStream.write(sLinea.getBytes());
				sLinea = "	    </fo:table-cell>\n";
				tmpFoFileStream.write(sLinea.getBytes());
				sLinea = "	    </fo:table-row>\n";
				tmpFoFileStream.write(sLinea.getBytes());
			}

			// Agurtzane Mar12: contador en listados
			intContParcial++;
			imprimirTotal(intContParcial, false,res);
			imprimirTotal(intCont, true,res);
			// Fin Agurtzane Mar12: contador en listados

			fncImprimirFinPagina();
			rs.close();
			sLinea = "</fo:root>\n";
			tmpFoFileStream.write(sLinea.getBytes());
			tmpFoFileStream.close();

			// FileInputStream file = new FileInputStream(sFoFileDir +
			// tmpFoFile.getName());
			generarPDFdesdeFO(sFoFileDir + tmpFoFile.getName(), sFoFileDir,
					response);

			// renderFO(new InputSource(file), response);

			// tmpFoFile.delete();

			// response.flushBuffer();

		} catch (Exception ex) {
			try {
				response.sendRedirect("m05bError.jsp");
			} catch (IOException e) {
				// TODO Auto-generated catch block
				miLog.addTraza(e);
			}
		} finally {
			try {
				if (rs != null)
					rs.close();
				if (pstmt != null)
					pstmt.close();
				if (conn != null)
					conn.close();
			} catch (SQLException e2) {
				try {
					response.sendRedirect("m05bError.jsp");
				} catch (IOException e) {
					// TODO Auto-generated catch block
					miLog.addTraza(e);
				}
			}
		}
	}

	/**
	 * renders an FO inputsource into a PDF file which is rendered directly to
	 * the response object's OutputStream
	 */
	public void renderFO(InputSource foFile, HttpServletResponse response)
			throws ServletException {
		try {
			ByteArrayOutputStream out = new ByteArrayOutputStream();

			response.reset();
			OutputStream oOut = response.getOutputStream();
			BufferedOutputStream bOut = new BufferedOutputStream(oOut);
			Driver driver = new Driver(foFile, out);
			driver.setRenderer(Driver.RENDER_PDF);
			driver.run();

			response.setContentLength(out.size());
			response.setContentType("application/pdf");

			bOut.write(out.toByteArray());
			out.close();
			bOut.flush();
			bOut.close();
			// response.flushBuffer();
		} catch (Exception ex) {
			throw new ServletException(ex);
		}
	}

	public void generarPDFdesdeFO(String ficheroFO, String rutaPDF,
			HttpServletResponse response) throws FOPException {
		try {

			Driver driver = new Driver();

			driver.setRenderer(Driver.RENDER_PDF);

			// Si no existe el directrio lo crea
			File f = new File(rutaPDF);

			if (!f.exists()) {

				f.mkdir();

			}
			// Cargar los datos del .FO
			FileInputStream file = new FileInputStream(ficheroFO);

			BufferedInputStream bfile = new BufferedInputStream(file);

			driver.setInputSource(new InputSource(bfile));

			// Crear un temporal que va a ser el .pdf
			String sPdfFileDir = rutaPDF;
			File pdfFileDir = new File(sPdfFileDir);
			File tmpPdfFile = File.createTempFile("m05b", ".pdf", pdfFileDir);

			FileOutputStream fileout = new FileOutputStream(tmpPdfFile);

			BufferedOutputStream bfileout = new BufferedOutputStream(fileout);

			driver.setOutputStream(bfileout);

			driver.run();

			bfile.close();

			bfileout.close();
			// Longitus del Fichero PDF.
			Long longitud = new Long(tmpPdfFile.length());
			String sLongitud = "" + longitud;
			int iLongitud = Integer.parseInt(sLongitud);

			response.setContentLength((int) iLongitud);
			response.setContentType("application/pdf");

			byte[] fileBytes = new byte[longitud.intValue()];
			FileInputStream fisficheroPdf = new FileInputStream(tmpPdfFile);
			fisficheroPdf.read(fileBytes);
			ServletOutputStream os = response.getOutputStream();
			((OutputStream) os).write(fileBytes);
			((OutputStream) os).flush();
			((OutputStream) os).close();

			// BORRAR EL FICHERO FO

			File fichero = new File(ficheroFO);

			boolean borrado = fichero.delete();
			boolean borrado2 = tmpPdfFile.delete();

		} catch (Exception e) {
		}

	}
}