package vehiculosServlet;

import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.StringTokenizer;

import m05bClasses.m05bConexion;
import m05bClasses.m05bConstantes;
import m05bClasses.m05bFileLog;


/**
 * Inserte aqu la descripcin del tipo.
 * Fecha de creacin: (21/04/05)
 */
public class m05bGrabarUbicacionServlet extends javax.servlet.http.HttpServlet {m05bFileLog miLog = new m05bFileLog();
/**
 * Process incoming HTTP POST requests
 *
 * @param request Object that encapsulates the request to the servlet
 * @param response Object that encapsulates the response from the servlet
 */
	java.sql.Connection conn=null;
    
    
public void doPost(javax.servlet.http.HttpServletRequest request, javax.servlet.http.HttpServletResponse response) throws javax.servlet.ServletException, java.io.IOException {

	performTask(request, response);

}
/**
 * Returns the servlet info string.
 */
public String getServletInfo() {

	return super.getServletInfo();

}
/**
 * Initializes the servlet.
 */
public void init() {
	// insert code to initialize the servlet here
}

/**
 * Actualiza la ubicacion del vehculo.
 */
public void grabarUbicacion(String matricula, String ubicacion) throws java.lang.Exception {

       String sql;
	   PreparedStatement pstmt = null;
		
       try {
				sql = "update " + m05bConstantes.TAB_VEHICULOS +
						" set " + m05bConstantes.COL_34_APARCADO + " = '" + ubicacion + "'" +
						" where "+ m05bConstantes.COL_34_MATRICULA +" = '" + matricula + "'" ;
				pstmt = conn.prepareStatement(sql);
				pstmt.executeUpdate();
				
				// Se actualiza adems la tabla temporal
				sql = "update " + m05bConstantes.TAB_COCHESLIBRES +
						" set " + m05bConstantes.COL_96_UBICACION + " = '" + ubicacion + "'" +
						" where "+ m05bConstantes.COL_96_MATRICULA +" = '" + matricula + "'" ;
				pstmt = conn.prepareStatement(sql);
				pstmt.executeUpdate();
					
	   } catch (Exception ex) {
	   	   		//System.out.println("m05b - Grabar Ubicacion: EXCEPTION: " + ex.toString() );
	  			throw new Exception(ex);
	   } 	finally{
				if (pstmt != null)
					pstmt.close();
	   }
}  // Fin funcion grabarUbicacion

/**
 * Process incoming requests for information
 *
 * @param request Object that encapsulates the request to the servlet
 * @param response Object that encapsulates the response from the servlet
 */
public void performTask(javax.servlet.http.HttpServletRequest request, javax.servlet.http.HttpServletResponse response) {

       String sRegistro, sMatricula="", sUbicacion="", sql, sLista, sValor, sURL="", sTipo="";
       String sRango="", sFecDesde="", sFecHasta="",sHorDesde="", sHorHasta=""; 
	   PreparedStatement pstmt = null, pstmtInsert = null;;
	   ResultSet rs = null;
	   try  {  	
		   	m05bConexion miConex = new m05bConexion();
			conn = miConex.getConnection();
			conn.setAutoCommit(false);  // Al final si todo ha ido bien se hace commit
	
		   	sLista = request.getParameter("listaBD");
	            
            sValor = request.getParameter("Valor")== null?"":request.getParameter("Valor");
            
            sRango = request.getParameter("Rango")== null?"":request.getParameter("Rango");
            sFecDesde = request.getParameter("Desde");
            sFecHasta = request.getParameter("Hasta");
            sHorDesde = request.getParameter("HoraDesde");
            sHorHasta = request.getParameter("HoraHasta");
            
            sTipo = request.getParameter("Tipo")== null?"":request.getParameter("Tipo");
            
			String delimReg= "@", delimUbic="#";
			StringTokenizer stReg = new StringTokenizer(sLista,delimReg);
			while (stReg.hasMoreTokens()) {
			         sRegistro=stReg.nextToken();
					 sUbicacion="";
					 StringTokenizer stUbic = new StringTokenizer(sRegistro,delimUbic);
					 if (stUbic.hasMoreTokens()) {
				         sMatricula=stUbic.nextToken();
						 sUbicacion=stUbic.nextToken();
						 if (sUbicacion.equals("null"))  
						 	 sUbicacion="";
					 	grabarUbicacion(sMatricula, sUbicacion);
			         }  // Fin if
			}  // Fin while
			//Si todo ha ido bien se actualizan los cambios en la BD
		    conn.commit();

		    
		    if (sValor.equals("Hoy") ) 
				sURL="m05bCochesLibresHoyJsp.jsp?Tipo=" +  sTipo + "&Rango=" +  sRango +"&Mensaje=true";
			else 
				sURL="m05bCochesLibresJsp.jsp?Mensaje=true";
				/*sURL="m05bCochesLibresJsp.jsp?Rango=" +  sRango +  "&Desde=" + sFecDesde ;
				sURL+="&Hasta=" + sFecHasta + "&HoraDesde=" + sHorDesde + "&HoraHasta=" + sHorHasta;
				sURL+="&Mensaje=true";*/
			response.sendRedirect(sURL);
		} 	catch (Exception SQLException) {
					try {
			  			conn.rollback();  // Ha habido problemas, se deshacen todos los cambios
			  		} catch (SQLException e1){
			  			miLog.addTraza(e1);
			  		}
					miLog.addTraza(SQLException);
					try {
						response.sendRedirect("m05bError.jsp");
					} catch (IOException e) {
						// TODO Auto-generated catch block
						miLog.addTraza(e);
					}
		}	catch(Throwable theException) {
					// uncomment the following line when unexpected exceptions
					// are occuring to aid in debugging the problem.
					miLog.addTraza(theException);
					try {
						response.sendRedirect("m05bError.jsp");
					} catch (IOException e) {
						// TODO Auto-generated catch block
						miLog.addTraza(e);
					}
		} 	finally {
					if (conn != null) {
						try {
				  			conn.close();
				  		} catch (SQLException e2){
				  			try {
								response.sendRedirect("m05bError.jsp");
							} catch (IOException e) {
								// TODO Auto-generated catch block
								miLog.addTraza(e);
							}
				  		}
				  	} // Fin if
		}  // Fin finally
	
}  // Fin performTask
	
}// Fin m05bGrabarUbicacionServlet