package vehiculosServlet;

import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Locale;

import javax.servlet.http.HttpSession;

import m05bClasses.m05bComun;
import m05bClasses.m05bConexion;
import m05bClasses.m05bConstantes;
import m05bClasses.m05bFileLog;
import m05bClasses.m05bGenerarClave;



/**
 * Inserte aqu la descripcin del tipo.
 * Fecha de creacin: (14/09/05)
 */
public class m05bCambiarCuentaKmServlet extends javax.servlet.http.HttpServlet {m05bFileLog miLog = new m05bFileLog();

/**
 * Process incoming HTTP POST requests
 *
 * @param request Object that encapsulates the request to the servlet
 * @param response Object that encapsulates the response from the servlet
 */    

	String matricula, kmCambio,kmModif, kmAct, fechaCambio;
	java.sql.Connection conn=null;
	

public void doPost(javax.servlet.http.HttpServletRequest request, javax.servlet.http.HttpServletResponse response) throws javax.servlet.ServletException, java.io.IOException {

	performTask(request, response);

}
/**
 * Returns the servlet info string.
 */
public String getServletInfo() {

	return super.getServletInfo();

}
/**
 * Initializes the servlet.
 */
public void init() {
	// insert code to initialize the servlet here
}

/**
 * Initializes the servlet.
 */
public void actualizarMatricula(String tabla, String km, String matric, String fecha,String idioma) throws java.lang.Exception  {
	   
	   // Pone como matricula actual la nueva matricula
	String formatoFecha="dd/MM/yyyy";
	if (!idioma.equals("es")) {
		
		formatoFecha = "yyyy/MM/dd";
	}
	   String sql;
	   PreparedStatement pstmt = null;
	   
	   try
	   {   
		   sql = " update " + tabla  +
		 		 " set " + km + " = " + km + "" + " - (" + kmAct + " - "+kmModif + 
		 		 " ) where " + matric + " = '" + matricula + "'" +
		 		 " and " + fecha + " < to_date('" + fechaCambio + "','"+formatoFecha+"') and " + km + " is not null";
			miLog.addTraza(m05bConstantes.LOG_NO_USER , "CambiarCuentaKmServlet", "sUpdateAsignacion1: "+sql , m05bConstantes.LOG_NIVEL_BAJO);
			
	       pstmt = conn.prepareStatement(sql);
		   pstmt.executeUpdate();
	   } catch (Exception ex) {
			try {
	  			conn.rollback();  // Ha habido problemas, se deshacen todos los cambios
	  			throw new Exception(ex);
	  		} catch (SQLException e1){
	  			System.err.println("Exception: OutletMaintenanceS.service: " + e1);
	  		}
	   } finally{
	   	    try {
				if (pstmt != null)
					pstmt.close();
			} catch (SQLException e2) {
				System.err.println("Exception: OutletMaintenanceS.service: " + e2);
	  		}
	   }
}




public void grabarHistorico(int id, String persona, String kmCambio,String idioma) throws java.lang.Exception  {
	
	   // Graba un registro histrico a partir de los datos del vehiculo al que se ha cambiado la matricula

	   String sql;
	   java.sql.Statement pstmt = null;
	   PreparedStatement pstmtInsert = null;
	   ResultSet rs = null;

   	   String marca = "", rango = "", kmact = "", expte = "", color = "", serie = "", cv = "", poliza = "";
	   String vcontab = "", precio = "", vidautil = "", amoanual = "", amoacum = "", impbaja = "";
	   String situacion = "", coddpto = "", desdpto = "", regadquis = "", motbaja = "";
	   String destino = "", kmrevis = "", mesrevis = "", autaparc = "", rotul = "", aparcado = "";
	   String infadic1 = "", infadic2 = "", matricant = "", modelo = "", notas = "";
	   String fkmact = "", fgarantia = "", falta = "", fmatric = "", fbaja = "", fadquis = "", fcambio = "", ffin = "";
	   String formatoFecha = "dd/MM/yyyy";
		if (!idioma.equals("es")) {
		
			formatoFecha = "yyyy/MM/dd";
		}
	   SimpleDateFormat formatterDate = new SimpleDateFormat (formatoFecha);
	   m05bComun miComun = new m05bComun();


	   try
	   {   
		// Obtener los datos del vehiculo correspondiente a esa matrcula
			   sql = "select " + m05bConstantes.COL_34_MATRIC_ANT + ", " + m05bConstantes.COL_34_MARCA +
					", " + m05bConstantes.COL_34_RANGO + ", " + m05bConstantes.COL_34_MODELO + ", " + m05bConstantes.COL_34_KMACTUALES +
					", " + m05bConstantes.COL_34_FKMACT + ", " + m05bConstantes.COL_34_FGARANTIA + ", " + m05bConstantes.COL_34_EXPDTE +
					", " + m05bConstantes.COL_34_COLOR + ", " + m05bConstantes.COL_34_NSERIE + ", " + m05bConstantes.COL_34_FALTA +
					", " + m05bConstantes.COL_34_FMATRIC + ", " + m05bConstantes.COL_34_FBAJA + ", " + m05bConstantes.COL_34_CV +
					", " + m05bConstantes.COL_34_POLIZA + ", " + m05bConstantes.COL_34_VCONTAB + ", " + m05bConstantes.COL_34_PRECIO +
					", " + m05bConstantes.COL_34_VIDAUTIL + ", " + m05bConstantes.COL_34_AMOANUAL + ", " + m05bConstantes.COL_34_AMOACUM +
					", " + m05bConstantes.COL_34_IMPBAJA + ", " + m05bConstantes.COL_34_SITUACION + ", " + m05bConstantes.COL_34_CODDPTO +
					", " + m05bConstantes.COL_34_DESDPTO + ", " + m05bConstantes.COL_34_FADQUIS + ", " + m05bConstantes.COL_34_REGADQUIS +
					", " + m05bConstantes.COL_34_MOTIVBAJA + ", " + m05bConstantes.COL_34_DESTINO + ", " + m05bConstantes.COL_34_KMREVIS +
					", " + m05bConstantes.COL_34_MESREVIS + ", " + m05bConstantes.COL_34_AUTORI_APAR + ", " + m05bConstantes.COL_34_ROTULADO +
					", " + m05bConstantes.COL_34_APARCADO + ", " + m05bConstantes.COL_34_INF1 + ", " + m05bConstantes.COL_34_INF2 +
					" from " + m05bConstantes.TAB_VEHICULOS  +
				    " where " +  m05bConstantes.COL_34_MATRICULA + " = '" + matricula + "'" ;
				  miLog.addTraza(m05bConstantes.LOG_NO_USER , "CambiarCuentaKmServlet", "sSelect: " + sql, m05bConstantes.LOG_NIVEL_BAJO);

		       	pstmt = conn.createStatement();
		   		pstmt.execute(sql);
		   		rs = pstmt.getResultSet();
		   		if (rs.next()){
	       	    			matricant = rs.getString(1)==null?"":rs.getString(1);
	       	    			marca = rs.getString(2);
	       	    			rango = rs.getString(3);
	       	    			modelo = rs.getString(4);
	       	    			kmact = rs.getString(5);
	       	    			if (rs.getDate(6) != null)
	       	    				fkmact = formatterDate.format(rs.getDate(6));
	       	    			if (rs.getDate(7) != null)
	       	    				fgarantia = formatterDate.format(rs.getDate(7));
	       	    			expte = rs.getString(8);
	       	    			color = rs.getString(9);
	       	    			serie = rs.getString(10);
	       	    			if (rs.getDate(11) != null)
	       	    				falta = formatterDate.format(rs.getDate(11));
	       	    			if (rs.getDate(12) != null)
	       	    				fmatric = formatterDate.format(rs.getDate(12));
	       	    			if (rs.getDate(13) != null)
		       	    			fbaja = formatterDate.format(rs.getDate(13));
	       	    			cv = rs.getString(14);
        					//cv=miComun.ImportesABasedatos(cv);
	       	    			poliza = rs.getString(15);
	       	    			vcontab = rs.getString(16);
	       	    			precio = rs.getString(17);
	       	    			vidautil = rs.getString(18);
							amoanual = rs.getString(19);
							amoacum = rs.getString(20);
							impbaja = rs.getString(21);
							situacion = rs.getString(22);
							coddpto = rs.getString(23);
							desdpto = rs.getString(24);
							if (rs.getDate(25) != null)
								fadquis = formatterDate.format(rs.getDate(25));
							regadquis = rs.getString(26);
							motbaja = rs.getString(27);
	   	  						destino = rs.getString(28);
					   	    kmrevis = rs.getString(29);
	   						mesrevis = rs.getString(30);
	   						autaparc = rs.getString(31);
	   						rotul = rs.getString(32);
	   						aparcado = rs.getString(33)==null?"":rs.getString(33);
	   						infadic1 = rs.getString(34);
	   						infadic2 = rs.getString(35);
	   						notas = "CAMBIO CUENTAKM REALIZADO POR " + persona + " - KM ANTES: " + kmact + " - KM DESPUES: " + kmCambio;
	           }
	    } catch (Exception ex) {
			   try {
					conn.rollback();  // Ha habido problemas, se deshacen todos los cambios
					throw new Exception(ex);
			   } catch (SQLException e1){
					System.err.println("Exception: OutletMaintenanceS.service: " + e1);
			   }
		}
		
		try 
		{
		// Ejecutar la insercin de los datos obtenidos
			   sql = " insert into " + m05bConstantes.TAB_HIST_VEHICULOS  + " (" +
			    	  m05bConstantes.COL_44_ID + ", " + m05bConstantes.COL_44_MATRICULA + ", " + m05bConstantes.COL_44_MARCA +
	 				  ", " + m05bConstantes.COL_44_RANGO + ", " + m05bConstantes.COL_44_KMACTUALES + 
					  ", " + m05bConstantes.COL_44_FKMACT + ", " + m05bConstantes.COL_44_FGARANTIA + ", " + m05bConstantes.COL_44_EXPDTE +
					  ", " + m05bConstantes.COL_44_COLOR + ", " + m05bConstantes.COL_44_NSERIE + ", " + m05bConstantes.COL_44_FALTA +
					  ", " + m05bConstantes.COL_44_FMATRIC + ", " + m05bConstantes.COL_44_FBAJA + ", " + m05bConstantes.COL_44_CV +
					  ", " + m05bConstantes.COL_44_POLIZA + ", " + m05bConstantes.COL_44_VCONTAB + ", " + m05bConstantes.COL_44_PRECIO +
					  ", " + m05bConstantes.COL_44_VIDAUTIL + ", " + m05bConstantes.COL_44_AMOANUAL + ", " + m05bConstantes.COL_44_AMOACUM +
					  ", " + m05bConstantes.COL_44_IMPBAJA + ", " + m05bConstantes.COL_44_SITUACION + ", " + m05bConstantes.COL_44_CODDPTO +
					  ", " + m05bConstantes.COL_44_DESDPTO + ", " + m05bConstantes.COL_44_FCAMBIO + ", " + m05bConstantes.COL_44_FFIN +
					  ", " + m05bConstantes.COL_44_FADQUIS + ", " + m05bConstantes.COL_44_REGADQUIS + ", " + m05bConstantes.COL_44_MOTIVBAJA + 
				      ", " + m05bConstantes.COL_44_DESTINO + ", " + m05bConstantes.COL_44_KMREVIS + ", " + m05bConstantes.COL_44_MESREVIS + 
				      ", " + m05bConstantes.COL_44_AUTORI_APAR + ", " + m05bConstantes.COL_44_ROTULADO + ", " + m05bConstantes.COL_44_APARCADO + 
				      ", " + m05bConstantes.COL_44_INF1 + ", " + m05bConstantes.COL_44_INF2 + ", " + m05bConstantes.COL_44_MATRIC_ANT + 
	  			      ", " + m05bConstantes.COL_44_MODELO + ", " + m05bConstantes.COL_44_NOTA + ") " +
				   	  " values (" + id + ", '" + matricula + "', '" + marca + "', '" + rango + "', " + kmact + 
					  ", to_date('" + fkmact + "','"+formatoFecha+"'), to_date('" + fgarantia + "','"+formatoFecha+"'), '" + expte + 
					  "', '" + color + "', '" + serie + "', to_date('" + falta + "','"+formatoFecha+"'), to_date('" + fmatric + 
					  "','"+formatoFecha+"'), to_date('" + fbaja + "','"+formatoFecha+"'), '" + cv + "', '" + poliza + "', " + vcontab + 
				      ", " + precio + ", '" + vidautil + "', " + amoanual + ", " + amoacum + ", " + impbaja + 
				      ", '" + situacion + "', '" + coddpto + "', '" + desdpto + "', sysdate, null, to_date('" + fadquis + "','"+formatoFecha+"'), '" + regadquis + "', '" + motbaja + 
					  "', " + destino + ", " + kmrevis + ", " + mesrevis + ", '" + autaparc + "', '" + rotul + "', '" + aparcado + 
					  "', '" + infadic1 + "', '" + infadic2 + "', '" + matricant + "', '" + modelo + "', '" + notas + "' )";

				  miLog.addTraza(m05bConstantes.LOG_NO_USER , "CambiarCuentaKmServlet", "sInsert: " + sql, m05bConstantes.LOG_NIVEL_BAJO);
			    
			    pstmtInsert = conn.prepareStatement(sql);
				pstmtInsert.executeUpdate();
				if (pstmtInsert != null)
					pstmtInsert.close();
	   } catch (Exception ex) {
			try {
	  			conn.rollback();  // Ha habido problemas, se deshacen todos los cambios
	  			throw new Exception(ex);
	  		} catch (SQLException e1){
	  			System.err.println("Exception: OutletMaintenanceS.service: " + e1);
	  		}
	   }
		try 
		{
		// Ejecutar la insercin de los datos obtenidos
			   sql = " update " + m05bConstantes.TAB_VEHICULOS  +
		 		 " set " + m05bConstantes.COL_34_KMACTUALES + " = ("   + kmAct + " - "+ kmModif  + "),"+
		 		 m05bConstantes.COL_34_FKMACT + " = to_date('" + fechaCambio + "','"+formatoFecha+"')" +
		 		 " where " + m05bConstantes.COL_34_MATRICULA + " = '" + matricula + "'" +
		 		 " and " +m05bConstantes.COL_34_FKMACT + " <= to_date('" + fechaCambio + "','"+formatoFecha+"')";

				 miLog.addTraza(m05bConstantes.LOG_NO_USER , "CambiarCuentaKmServlet", "sInsert: " + sql, m05bConstantes.LOG_NIVEL_BAJO);
			    
			    pstmtInsert = conn.prepareStatement(sql);
				pstmtInsert.executeUpdate();
				if (pstmtInsert != null)
					pstmtInsert.close();
	   } catch (Exception ex) {
			try {
	  			conn.rollback();  // Ha habido problemas, se deshacen todos los cambios
	  			throw new Exception(ex);
	  		} catch (SQLException e1){
	  			System.err.println("Exception: OutletMaintenanceS.service: " + e1);
	  		}
	   }	   
	   finally{
	   	    try {
	   	    	if (rs !=  null)
	   	    		rs.close();
				if (pstmt != null)
					pstmt.close();
				if (pstmtInsert != null)
					pstmtInsert.close();
			} catch (SQLException e2) {
				System.err.println("Exception: OutletMaintenanceS.service: " + e2);
	  		}
	   }
}


/**
 * Process incoming requests for information
 *
 * @param request Object that encapsulates the request to the servlet
 * @param response Object that encapsulates the response from the servlet
 */
public void performTask(javax.servlet.http.HttpServletRequest request, javax.servlet.http.HttpServletResponse response) {


       String sql, persona;
	   int id;
		// Conexion
		try {
			try {
				   m05bConexion miConex = new m05bConexion();
				   conn = miConex.getConnection();
				   conn.setAutoCommit(false);  // Al final si todo ha ido bien se hace commit
   		
				   HttpSession session = request.getSession(true);
				   Locale idiomaLocal = (Locale) session.getAttribute("Local");
					String idiomaSes = ((idiomaLocal.getLanguage() == null) ? "es"
							: idiomaLocal.getLanguage());
			       m05bComun comun =  new m05bComun();
				   matricula = request.getParameter("Matricula");
				   kmModif = request.getParameter("KmModif");
			       if ( (kmModif.equals("")) ||  (kmModif == null ) )
			       	kmModif="0";
			       else
			       	kmModif=comun.ImportesABasedatos(kmModif);
				   kmAct = request.getParameter("KmAct");
			       if ( (kmAct.equals("")) ||  (kmAct == null ) )
			    	   kmAct="0";
			       else
			    	   kmAct=comun.ImportesABasedatos(kmAct);	
			       kmCambio="0";
				   fechaCambio = request.getParameter("FCambio");
				   persona = (String) session.getAttribute("persona");
	       		

				// Actualizar tablas que contienen el campo matricula
					actualizarMatricula( m05bConstantes.TAB_ASIGNACION, m05bConstantes.COL_01_KMSALIDA, m05bConstantes.COL_01_MATRICULA, m05bConstantes.COL_01_FDESDE,idiomaSes );
					miLog.addTraza(m05bConstantes.LOG_NO_USER , "CambiarCuentaKmServlet", "sUpdateAsignacion1: " , m05bConstantes.LOG_NIVEL_BAJO);
						
					actualizarMatricula( m05bConstantes.TAB_ASIGNACION, m05bConstantes.COL_01_KMLLEGADA, m05bConstantes.COL_01_MATRICULA, m05bConstantes.COL_01_FDEVOL,idiomaSes );
					miLog.addTraza(m05bConstantes.LOG_NO_USER , "CambiarCuentaKmServlet", "sUpdateAsignacion2: " , m05bConstantes.LOG_NIVEL_BAJO);
					
					actualizarMatricula( m05bConstantes.TAB_GASTOS, m05bConstantes.COL_09_KMGASTO, m05bConstantes.COL_09_MATRICULA, m05bConstantes.COL_09_FECHA,idiomaSes);
					miLog.addTraza(m05bConstantes.LOG_NO_USER , "CambiarCuentaKmServlet", "sUpdateGastos: " , m05bConstantes.LOG_NIVEL_BAJO);
					
					actualizarMatricula( m05bConstantes.TAB_OPEBANCOS, m05bConstantes.COL_18_KM, m05bConstantes.COL_18_MATRICULA, m05bConstantes.COL_18_FECHA ,idiomaSes);
					miLog.addTraza(m05bConstantes.LOG_NO_USER , "CambiarCuentaKmServlet", "sUpdateOpeBanco: " , m05bConstantes.LOG_NIVEL_BAJO);
					
					actualizarMatricula( m05bConstantes.TAB_ORDENESTRAB, m05bConstantes.COL_20_KM_ENTRADA, m05bConstantes.COL_20_MATRICULA, m05bConstantes.COL_20_FENTRADA,idiomaSes );
					miLog.addTraza(m05bConstantes.LOG_NO_USER , "CambiarCuentaKmServlet", "sUpdateOrdenesTrab1: " , m05bConstantes.LOG_NIVEL_BAJO);
					
					actualizarMatricula( m05bConstantes.TAB_ORDENESTRAB, m05bConstantes.COL_20_KM_SALIDA, m05bConstantes.COL_20_MATRICULA, m05bConstantes.COL_20_FSALIDA ,idiomaSes);
					miLog.addTraza(m05bConstantes.LOG_NO_USER , "CambiarCuentaKmServlet", "sUpdateOrdenesTrab2: " , m05bConstantes.LOG_NIVEL_BAJO);
					
					actualizarMatricula( m05bConstantes.TAB_REVISIONES, m05bConstantes.COL_35_KMRE, m05bConstantes.COL_35_MATRICULA, m05bConstantes.COL_35_FECHA ,idiomaSes);
					miLog.addTraza(m05bConstantes.LOG_NO_USER , "CambiarCuentaKmServlet", "sUpdateRevisiones1: " , m05bConstantes.LOG_NIVEL_BAJO);
					
					actualizarMatricula( m05bConstantes.TAB_REVISIONES, m05bConstantes.COL_35_KMPRE, m05bConstantes.COL_35_MATRICULA, m05bConstantes.COL_35_FECHA,idiomaSes );
					miLog.addTraza(m05bConstantes.LOG_NO_USER , "CambiarCuentaKmServlet", "sUpdateRevisiones2: " , m05bConstantes.LOG_NIVEL_BAJO);
					
					actualizarMatricula( m05bConstantes.TAB_VEHICULOS, m05bConstantes.COL_34_KMACTUALES, m05bConstantes.COL_34_MATRICULA, m05bConstantes.COL_34_FKMACT ,idiomaSes);
					miLog.addTraza(m05bConstantes.LOG_NO_USER , "CambiarCuentaKmServlet", "sUpdateVehiculo: " , m05bConstantes.LOG_NIVEL_BAJO);
					
					
					
				//Grabar historico vehiculos (incluir usuario que realiza el cambio y fecha del cambio)
						// Obtener el siguiente ID que se va a grabar en la tabla historico de vehiculos
					//id=getNewID().longValue();
					m05bGenerarClave miID = new m05bGenerarClave();
					id = miID.getNextId(m05bConstantes.TAB_HIST_VEHICULOS,m05bConstantes.COL_44_ID);
					grabarHistorico(id, persona, kmModif,idiomaSes);
						
				//Si todo ha ido bien se actualizan los cambios en la BD
				    conn.commit();
						
					response.sendRedirect("m05bCambioCuentaKmJsp.jsp?Mensaje=" + m05bConstantes.MSG_OK);

			} catch (Exception SQLException) {
				miLog.addTraza(SQLException);	
				try {
		  			conn.rollback();  // Ha habido problemas, se deshacen todos los cambios
		  		} catch (SQLException e2){
		  			throw new Exception(SQLException);
		  		}
		  		response.sendRedirect("m05bError.jsp");
			} 	finally{
					if (conn != null)
						conn.close();
			}  
	} catch(Throwable theException)	{
		// uncomment the following line when unexpected exceptions
		// are occuring to aid in debugging the problem.
		miLog.addTraza(theException);
		try {
			response.sendRedirect("m05bError.jsp");
		} catch (IOException e) {
			// TODO Auto-generated catch block
			miLog.addTraza(e);
		}
	}
}
}
