package utiliServlet;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.Locale;

import m05bClasses.m05bConstantesPaginas;
import n05bModelosVistas.m05bAmortizacion;
import n05bModelosVistas.m05bAmortizacionBase;
import n05bModelosVistas.m05bAsignacion;
import n05bModelosVistas.m05bCombustible;
import n05bModelosVistas.m05bImprimible;
import n05bModelosVistas.m05bKilometrajes;
import n05bModelosVistas.m05bOption;
import n05bModelosVistas.m05bOrdenTrabajo;
import n05bModelosVistas.m05bPersonaEstadisticas;
import n05bModelosVistas.m05bSancion;
import n05bModelosVistas.m05bTasasMunicipio;
import n05bModelosVistas.m05bVehiculoV;

import org.apache.log4j.Logger;

public class m05bJson {
	private static Logger logger = Logger.getLogger(m05bExcel.class);
	private String idioma;

	public m05bJson(String idioma) {
		this.idioma = idioma;
	}

	/**
	 * 
	 * @param datos
	 */
	public StringBuffer createJsonAltas(ArrayList<m05bVehiculoV> datos) {
		
		return toJson((ArrayList) datos, m05bVehiculoV.ORDENEXCELALTAS);
	}
	/**
	 * 
	 * @param datos
	 */
	public StringBuffer createJsonBajas(ArrayList<m05bVehiculoV> datos)
	 {
		String template = m05bConstantesPaginas.EXCELBAJAS;

		return toJson((ArrayList) datos, m05bVehiculoV.ORDENEXCELBAJAS);
	}
	/**
	 * 
	 * @param datos
	 */

	public StringBuffer createJsonAsignacionesPorVeh(ArrayList<m05bAsignacion> datos) {
		String template = m05bConstantesPaginas.EXCELASIGNACIONESPORVEH;

		return toJson((ArrayList) datos, m05bAsignacion.ORDENINFORMEASIGNACIONESPORVEH);

	}
	/**
	 * 
	 * @param datos
	 */
	public StringBuffer createJsonAsignacionesFechas(ArrayList<m05bAsignacion> datos) {

		return toJson((ArrayList) datos, m05bAsignacion.ORDENINFORMEASIGNACIONESFECHAS);

	}

	/**
	 * 
	 * @param datos
	 */
	public StringBuffer createJsonAsignacionesPersonas(
			ArrayList<m05bPersonaEstadisticas> datos) {

		return toJson((ArrayList) datos,
				m05bPersonaEstadisticas.ORDENINFORMEASIGNACIONPERSONAS);
	}

	/**
	 * 
	 * @param datos
	 */
	public StringBuffer createJsonAsignacionesVivas(ArrayList<m05bAsignacion> datos) {

		return toJson((ArrayList) datos, m05bAsignacion.ORDENINFORMEASIGNACIONESVIVAS);
	}
	/**
	 * 
	 * @param datos
	 */
	public StringBuffer createJsonCoches(ArrayList<m05bVehiculoV> datos) {

		return toJson((ArrayList) datos, m05bVehiculoV.ORDENLISTADO);
	}

	/**
	 * 
	 * @param datos
	 */
	public StringBuffer createJsonConductores(ArrayList<m05bAsignacion> datos) {

		return toJson((ArrayList) datos, m05bAsignacion.ORDENCONDUCTORES);
	}

	/**
	 * 
	 * @param datos
	 */
	public StringBuffer createJsonCTKAmortizacion(ArrayList<m05bAmortizacion> datos) {

		return toJson((ArrayList) datos, m05bAmortizacion.ORDENAMORTIZACION);

	}

	/**
	 * 
	 * @param datos
	 */
	public StringBuffer createJsonCTKAmortizacionBase(
			ArrayList<m05bAmortizacionBase> datos) {

		return toJson((ArrayList) datos, m05bAmortizacionBase.ORDENAMORTIZACIONBASE);

	}

	/**
	 * 
	 * @param datos
	 */
	public StringBuffer createJsonListadoGeneral(ArrayList<m05bAmortizacionBase> datos) {

		return toJson((ArrayList) datos, m05bVehiculoV.ORDENLISTADO);
	}

	/**
	 * 
	 * @param datos
	 */
	public StringBuffer createJsonOrdenes(ArrayList<m05bOrdenTrabajo> datos) {

		return toJson((ArrayList) datos, m05bOrdenTrabajo.ORDENDELAORDEN);
	}

	/**
	 * 
	 * @param datos
	 */
	public StringBuffer createJsonOrdenesDetalle(ArrayList<m05bOrdenTrabajo> datos) {

		return toJson((ArrayList) datos, m05bOrdenTrabajo.ORDENDETALLES);
	}

	/**
	 * 
	 * @param datos
	 */
	public StringBuffer createJsonOrdenesFechas(ArrayList<m05bOrdenTrabajo> datos) {

		return toJson((ArrayList) datos, m05bOrdenTrabajo.ORDENFECHAS);
	}

	/**
	 * 
	 * @param datos
	 */
	public StringBuffer createJsonOrdenesFechasAgrup(ArrayList<m05bOrdenTrabajo> datos) {

		return toJson((ArrayList) datos, m05bOrdenTrabajo.ORDENFECHASAGRUP);
	}

	/**
	 * 
	 * @param datos
	 */
	public StringBuffer createJsonOrdenesRangoAgrup(ArrayList<m05bOrdenTrabajo> datos) {

		return toJson((ArrayList) datos, m05bOrdenTrabajo.ORDENFECHASRANGOAGRUP);
	}

	/**
	 * 
	 * @param datos
	 */
	public StringBuffer createJsonCtkCombustibleResumen(ArrayList<m05bCombustible> datos) {

		return toJson((ArrayList) datos, m05bCombustible.ORDENRESUMEN);
	}

	/**
	 * 
	 * @param datos
	 */
	public StringBuffer createJsonCtkCombustible(ArrayList<m05bCombustible> datos) {

		return toJson((ArrayList) datos, m05bCombustible.ORDENCOMBUSTIBLE);
	}

	/**
	 * 
	 * @param datos
	 */
	public StringBuffer createJsonCTKKilometros(ArrayList<m05bKilometrajes> datos) {

		return toJson((ArrayList) datos, m05bKilometrajes.ORDENKMRECORRIDOS);
	}

	/**
	 * 
	 * @param datos
	 */
	public StringBuffer createJsonCTKKilometrosBase(ArrayList<m05bKilometrajes> datos) {

		return toJson((ArrayList) datos, m05bKilometrajes.ORDENBASE);
	}
	/**
	 * 
	 * @param datos
	 */
	public StringBuffer createJsonCTKVehiculosBase(ArrayList<m05bKilometrajes> datos) {

		return toJson((ArrayList) datos, m05bKilometrajes.ORDENVEHICULOSALTA);
	}

	/**
	 * 
	 * @param datos
	 */
	public StringBuffer createJsonCTKVehiculos(ArrayList<m05bKilometrajes> datos) {

		return toJson((ArrayList) datos, m05bKilometrajes.ORDENNUMERO);
	}
	/**
	 * 
	 * @param datos
	 */
	public StringBuffer createJsonTasas(ArrayList<m05bTasasMunicipio> datos) {

		return toJson((ArrayList) datos, m05bTasasMunicipio.ORDEN);
	}
	/**
	 * 
	 * @param datos
	 */
	public StringBuffer createJsonSanciones(ArrayList<m05bSancion> datos) {

		return toJson((ArrayList) datos, m05bSancion.ORDENBASE);
	}

	/**
	 * 
	 * @param datos
	 */
	public StringBuffer createJsonCTKVehiculosNUM(ArrayList<m05bKilometrajes> datos) {

		return toJson((ArrayList) datos, m05bKilometrajes.ORDENNUMERO);
	}

	private StringBuffer  toJson(ArrayList<m05bImprimible> datos, int[] orden) {
		Iterator iter = datos.iterator();
		m05bImprimible elemento;
		StringBuffer str = new StringBuffer();

		// "employees": [
		// { "firstName":"John" , "lastName":"Doe" },
		// { "firstName":"Anna" , "lastName":"Smith" },
		// { "firstName":"Peter" , "lastName":"Jones" }
		// ]
		// }
		str.append("{\"salida\":[");

		int count = 0;
		m05bOption current;
		while (iter.hasNext()) {
			elemento = (m05bImprimible) iter.next();
			if (count != 0)
				str.append(",");
			str.append("{");
			for (int i = 0; i < orden.length; i++) {
				if (i != 0) {
					str.append(",");
				}
				str.append("\"");
				str.append(i);
				str.append("\":\"");
				str.append(format(elemento.get(orden[i])));
				str.append("\"");
		
			}
			str.append("}");
			count++;
		}
		str.append("]}");
		return str;

	}
	private StringBuffer format(Object elem){
		StringBuffer str= new StringBuffer();
		DecimalFormatSymbols simbolos = DecimalFormatSymbols.getInstance(Locale.ITALY);
		if(elem ==null)
			str.append(" ");
		else{
			if(elem instanceof Date){
				DateFormat df;
				if(this.idioma.equals("ES"))
					df= new SimpleDateFormat("dd/MM/yyyy");
				else
					df= new SimpleDateFormat("yyyy/MM/dd");
				str.append(df.format((Date) elem));
			}
			else if(elem instanceof Integer){
				DecimalFormat df2 = new DecimalFormat( "#,##0",simbolos );
				str.append(df2.format( elem));
			}
			else if(elem instanceof Double){
				DecimalFormat df2 = new DecimalFormat( "#,###,###,##0.00",simbolos );
				str.append(df2.format( elem));
			}
			else{
				str.append(elem);
			}
		}
		return str;
		
	}

}
