package utiliServlet;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.OutputKeys;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;

import m05bClasses.m05bFileLog;
import n05bModelosVistas.m05bImprimible;
import n05bModelosVistas.m05bOption;

import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class m05bInformesXML {
	private static Logger logger;
	   m05bFileLog miLog = new m05bFileLog();
	public m05bInformesXML() {
		logger = Logger.getLogger(this.getClass());
	}

	/**
	 * Crea un XML String , pasando de un ArrayList de asignaciones a texto
	 * 
	 * @param datos
	 * @return
	 */
	public Document informeAltasXML(ArrayList<m05bImprimible> datos, int anio,String idioma) {
		try {
			DocumentBuilderFactory docFactory = DocumentBuilderFactory
					.newInstance();
			DocumentBuilder docBuilder = docFactory.newDocumentBuilder();

			// root elements
			Document doc = docBuilder.newDocument();

			Element rootElement = doc.createElement("datos");
			doc.appendChild(rootElement);

			Element anioel = doc.createElement("anio");
			anioel.appendChild(doc.createTextNode("" + anio));
			rootElement.appendChild(anioel);
			Element vehiculos = doc.createElement("lineas");
			rootElement.appendChild(vehiculos);
			Iterator iter = datos.iterator();
			m05bImprimible elemento;

			while (iter.hasNext()) {
				elemento = (m05bImprimible) iter.next();
				vehiculos.appendChild(elemento.toXMl(doc,idioma));

			}

			return doc;// nodeToString(rootElement);
		} catch (Exception e) {
			miLog.addTraza(e);
			logger.error(e.getMessage());
			StackTraceElement[] stackTraceElements = Thread.currentThread()
					.getStackTrace();
			for (StackTraceElement stackTrace : stackTraceElements) {
				logger.error(stackTrace.getClassName() + "  "
						+ stackTrace.getMethodName() + " "
						+ stackTrace.getLineNumber());
			}
		}
		return null;
	}

	/**
	 * Crea un XML String , pasando de un ArrayList de asignaciones a texto
	 * 
	 * @param datos
	 * @return
	 */
	public Document informeAsignacionesXML(ArrayList<m05bImprimible> datos,String idioma) {
		try {
			DocumentBuilderFactory docFactory = DocumentBuilderFactory
					.newInstance();
			DocumentBuilder docBuilder = docFactory.newDocumentBuilder();

			// root elements
			Document doc = docBuilder.newDocument();

			Element rootElement = doc.createElement("datos");
			doc.appendChild(rootElement);

			Element asignaciones = doc.createElement("lineas");
			rootElement.appendChild(asignaciones);
			Iterator iter = datos.iterator();
			m05bImprimible elemento;

			while (iter.hasNext()) {
				elemento = (m05bImprimible) iter.next();
				asignaciones.appendChild(elemento.toXMl(doc,idioma));

			}

			return doc;
		} catch (Exception e) {
e.printStackTrace();
			StackTraceElement[] stackTraceElements = Thread.currentThread()
					.getStackTrace();
			for (StackTraceElement stackTrace : stackTraceElements) {
				logger.error(stackTrace.getClassName() + "  "
						+ stackTrace.getMethodName() + " "
						+ stackTrace.getLineNumber());
			}
		}
		return null;
	}

	/**
	 * Aade las cabecerar correctas al XML y pasa de Node a String
	 * 
	 * @param node
	 * @return
	 */
	private String nodeToString(Node node) {
		StringWriter sw = new StringWriter();
		try {
			Transformer t = TransformerFactory.newInstance().newTransformer();
			t.setOutputProperty(OutputKeys.ENCODING, "ISO-8859-1");

			t.setOutputProperty(OutputKeys.OMIT_XML_DECLARATION, "no");
			t.setOutputProperty(OutputKeys.INDENT, "yes");
			t.transform(new DOMSource(node), new StreamResult(sw));
		} catch (TransformerException te) {

			StackTraceElement[] stackTraceElements = Thread.currentThread()
					.getStackTrace();
			for (StackTraceElement stackTrace : stackTraceElements) {
				logger.error(stackTrace.getClassName() + "  "
						+ stackTrace.getMethodName() + " "
						+ stackTrace.getLineNumber());
			}
			//System.out.println("nodeToString Transformer Exception");
		}
		return sw.toString();
	}

	public void setOptionList(Document doc, ArrayList<m05bOption> lista,
			String nombre) {
		if (lista!=null && lista.size() > 0) {
			Element rootElement = doc.createElement(nombre);

			Element elemento;
			for (m05bOption opt : lista) {
				elemento = doc.createElement("elemento");

				elemento.appendChild(doc.createTextNode(opt.getText()));
				rootElement.appendChild(elemento);
			}
			doc.getElementsByTagName("datos").item(0).appendChild(rootElement);
		}
	}

	public void setFecha(Document doc, String fechaDesde, String fechaHasta,
			String nombre) {
		if ((fechaDesde != null &&fechaDesde.length()>0)||
				(fechaHasta != null&&fechaHasta.length()>0)) {
			Element rootElement = doc.createElement(nombre);
			Element elemento;
			if (fechaDesde != null &&fechaDesde.length()>0) {
				elemento = doc.createElement("desde");

				elemento.appendChild(doc.createTextNode(fechaDesde));
				rootElement.appendChild(elemento);
			}
			if ((fechaHasta != null&&fechaHasta.length()>0)) {
				elemento = doc.createElement("hasta");

				elemento.appendChild(doc.createTextNode(fechaHasta));
				rootElement.appendChild(elemento);
			}

			doc.getElementsByTagName("datos").item(0).appendChild(rootElement);
		}
	}
	public void setTipo(Document doc, String tipo,String nombre){
		Element rootElement = doc.createElement(nombre);
		Element elemento;
		
			elemento = doc.createElement("desde");

			elemento.appendChild(doc.createTextNode(tipo));
			rootElement.appendChild(elemento);
			doc.getElementsByTagName("datos").item(0).appendChild(rootElement);
	}
}
