package utiliServlet;

import java.io.FileInputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;

import m05bClasses.m05bConstantesPaginas;
import n05bModelosVistas.m05bAmortizacion;
import n05bModelosVistas.m05bAmortizacionBase;
import n05bModelosVistas.m05bAsignacion;
import n05bModelosVistas.m05bCombustible;
import n05bModelosVistas.m05bImprimible;
import n05bModelosVistas.m05bKilometrajes;
import n05bModelosVistas.m05bOption;
import n05bModelosVistas.m05bOrdenTrabajo;
import n05bModelosVistas.m05bPersonaEstadisticas;
import n05bModelosVistas.m05bSancion;
import n05bModelosVistas.m05bTasasMunicipio;
import n05bModelosVistas.m05bVehiculoV;

import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.CellRangeAddress;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;

public class m05bExcel {
	private static Logger logger = Logger.getLogger(m05bExcel.class);
	private String idioma;

	public m05bExcel(String idioma) {
		this.idioma = idioma;
	}

	/**
	 * Crear un EXCEL utilizando el XSL de Template y el XML datos enel
	 * OutputStream salida
	 * 
	 * 
	 * @param datos
	 * @param salida
	 * @param lang
	 * @throws Exception
	 */

	public void createFileAltas(ArrayList<m05bVehiculoV> datos, int anio,
			OutputStream salida) throws Exception {
		String template = m05bConstantesPaginas.EXCELALTAS;
		if (idioma == null || idioma.length() == 0 || idioma.equals("ES"))
			template = template.replaceAll("IDIOMAX", "es");
		else
			template = template.replaceAll("IDIOMAX", "eu");
		createFile(template, (short) 4, 0, (ArrayList) datos,
				m05bVehiculoV.ORDENEXCELALTAS, anio + "", null, salida);
	}

	/**
	 * Crear un EXCEL utilizando el XSL de Template y el XML datos enel
	 * OutputStream salida
	 * 
	 * 
	 * @param datos
	 * @param salida
	 * @param lang
	 * @throws Exception
	 */
	public void createFileBajas(ArrayList<m05bVehiculoV> datos, int anio,
			OutputStream salida) throws Exception {
		String template = m05bConstantesPaginas.EXCELBAJAS;
		if (idioma == null || idioma.length() == 0 || idioma.equals("ES"))
			template = template.replaceAll("IDIOMAX", "es");
		else
			template = template.replaceAll("IDIOMAX", "eu");
		createFile(template, (short) 4, 0, (ArrayList) datos,
				m05bVehiculoV.ORDENEXCELBAJAS, anio + "", null, salida);
	}

	/**
	 * Crear un EXCEL utilizando el XSL de Template y el XML datos enel
	 * OutputStream salida
	 * 
	 * 
	 * @param datos
	 * @param salida
	 * @param lang
	 * @throws Exception
	 */
	public void createFileAsignacionesPorVeh(ArrayList<m05bAsignacion> datos,
			ArrayList<String> parametros, OutputStream salida) throws Exception {
		String template = m05bConstantesPaginas.EXCELASIGNACIONESPORVEH;
		if (idioma == null || idioma.length() == 0 || idioma.equals("ES"))
			template = template.replaceAll("IDIOMAX", "es");
		else
			template = template.replaceAll("IDIOMAX", "eu");
		createFile(template, (short) 4, 0, (ArrayList) datos,
				m05bAsignacion.ORDENINFORMEASIGNACIONESPORVEH, "", parametros,
				salida);

	}

	/**
	 * Crear un EXCEL utilizando el XSL de Template y el XML datos enel
	 * OutputStream salida
	 * 
	 * 
	 * @param datos
	 * @param salida
	 * @param lang
	 * @throws Exception
	 */
	public void createFileAsignacionesFechas(ArrayList<m05bAsignacion> datos,
			String fechaDesde, String fechaHasta, OutputStream salida)
			throws Exception {
		String template = m05bConstantesPaginas.EXCELASIGNACIONESFECHAS;
		if (idioma == null || idioma.length() == 0 || idioma.equals("ES"))
			template = template.replaceAll("IDIOMAX", "es");
		else
			template = template.replaceAll("IDIOMAX", "eu");
		createFile(template, (short) 4, 0, (ArrayList) datos,
				m05bAsignacion.ORDENINFORMEASIGNACIONESFECHAS, fechaDesde + "-"
						+ fechaHasta, null, salida);

	}

	/**
	 * Crear un EXCEL utilizando el XSL de Template y el XML datos enel
	 * OutputStream salida
	 * 
	 * 
	 * @param datos
	 * @param salida
	 * @param lang
	 * @throws Exception
	 */
	public void createFileAsignacionesPersonas(
			ArrayList<m05bPersonaEstadisticas> datos, String anio,
			OutputStream salida) throws Exception {
		String template = m05bConstantesPaginas.EXCELASIGNACIONESPERSONAS;
		if (idioma == null || idioma.length() == 0 || idioma.equals("ES"))
			template = template.replaceAll("IDIOMAX", "es");
		else
			template = template.replaceAll("IDIOMAX", "eu");
		createFile(template, (short) 4, 0, (ArrayList) datos,
				m05bPersonaEstadisticas.ORDENINFORMEASIGNACIONPERSONAS, anio,
				null, salida);
	}

	/**
	 * Crear un EXCEL utilizando el XSL de Template y el XML datos enel
	 * OutputStream salida
	 * 
	 * 
	 * @param datos
	 * @param salida
	 * @throws Exception
	 */
	public void createFileAsignacionesVivas(ArrayList<m05bAsignacion> datos,ArrayList<String> params,
			OutputStream salida) throws Exception {
		String template = m05bConstantesPaginas.EXCELASIGNACIONESVIVAS;
		if (idioma == null || idioma.length() == 0 || idioma.equals("ES"))
			template = template.replaceAll("IDIOMAX", "es");
		else
			template = template.replaceAll("IDIOMAX", "eu");
		createFile(template, (short) 4, 0, (ArrayList) datos,
				m05bAsignacion.ORDENINFORMEASIGNACIONESVIVAS, "", params, salida);
	}

	/**
	 * Crear un EXCEL utilizando el XSL de Template y el XML datos de coches por
	 * tipo OutputStream salida
	 * 
	 * 
	 * @param datos
	 * @param salida
	 * @throws Exception
	 */
	public void createFileCoches(ArrayList<m05bVehiculoV> datos,ArrayList<String> params,
			OutputStream salida) throws Exception {
		String template = m05bConstantesPaginas.EXCELCOCHES;
		if (idioma == null || idioma.length() == 0 || idioma.equals("ES"))
			template = template.replaceAll("IDIOMAX", "es");
		else
			template = template.replaceAll("IDIOMAX", "eu");
		createFile(template, (short) 4, 0, (ArrayList) datos,
				m05bVehiculoV.ORDENLISTADO, "", params, salida);
	}

	/**
	 * 
	 * 
	 * @param datos
	 * @param salida
	 * @throws Exception
	 */
	public void createFileConductores(ArrayList<m05bAsignacion> datos,ArrayList<String>parametros,
			OutputStream salida) throws Exception {
		String template = m05bConstantesPaginas.EXCELCONDUCTORES;
		if (idioma == null || idioma.length() == 0 || idioma.equals("ES"))
			template = template.replaceAll("IDIOMAX", "es");
		else
			template = template.replaceAll("IDIOMAX", "eu");
		createFile(template, (short) 4, 0, (ArrayList) datos,
				m05bAsignacion.ORDENCONDUCTORES, "", parametros, salida);
	}

	/**
	 * Crea el Excel de amortizacion
	 * 
	 * @param datos
	 * @param fechainit
	 * @param fechafin
	 * @param salida
	 * @throws Exception
	 */
	public void createFileCTKAmortizacion(ArrayList<m05bAmortizacion> datos,
			ArrayList<String>parametros, OutputStream salida)
			throws Exception {
		String template = m05bConstantesPaginas.EXCELCTKAMORTIZACION;
		if (idioma == null || idioma.length() == 0 || idioma.equals("ES"))
			template = template.replaceAll("IDIOMAX", "es");
		else
			template = template.replaceAll("IDIOMAX", "eu");
		createFile(template, (short) 4, 0, (ArrayList) datos,
				m05bAmortizacion.ORDENAMORTIZACION, "",parametros, salida);

	}

	/**
	 * Crea el Excel de amortizacion
	 * 
	 * @param datos
	 * @param fechainit
	 * @param fechafin
	 * @param salida
	 * @throws Exception
	 */
	public void createFileCTKAmortizacionBase(
			ArrayList<m05bAmortizacionBase> datos, ArrayList<String> parametros, OutputStream salida) throws Exception {
		String template = m05bConstantesPaginas.EXCELCTKAMORTIZACIONBASE;
		if (idioma == null || idioma.length() == 0 || idioma.equals("ES"))
			template = template.replaceAll("IDIOMAX", "es");
		else
			template = template.replaceAll("IDIOMAX", "eu");
		createFile(template, (short) 4, 0, (ArrayList) datos,
				m05bAmortizacionBase.ORDENAMORTIZACIONBASE, "", parametros, salida);

	}

	/**
	 * Crea el excel de Listado general
	 * 
	 * @param datos
	 * @param salida
	 * @throws Exception
	 */
	public void createFileListadoGeneral(ArrayList<m05bAmortizacionBase> datos,
			OutputStream salida) throws Exception {
		String template = m05bConstantesPaginas.EXCELLISTADOGENERAL;
		if (idioma == null || idioma.length() == 0 || idioma.equals("ES"))
			template = template.replaceAll("IDIOMAX", "es");
		else
			template = template.replaceAll("IDIOMAX", "eu");
		createFile(template, (short) 4, 0, (ArrayList) datos,
				m05bVehiculoV.ORDENLISTADO, "", null, salida);
	}

	/**
	 * Crea el excel de Listado general
	 * 
	 * @param datos
	 * @param salida
	 * @throws Exception
	 */
	public void createFileOrdenes(ArrayList<m05bOrdenTrabajo> datos,ArrayList<String> parametros,
			OutputStream salida) throws Exception {
		String template = m05bConstantesPaginas.EXCELLISTADOORDENES;
		if (idioma == null || idioma.length() == 0 || idioma.equals("ES"))
			template = template.replaceAll("IDIOMAX", "es");
		else
			template = template.replaceAll("IDIOMAX", "eu");
		createFile(template, (short) 4, 0, (ArrayList) datos,
				m05bOrdenTrabajo.ORDENDELAORDEN, "", parametros, salida);
	}

	/**
	 * Crea el excel de Listado general
	 * 
	 * @param datos
	 * @param salida
	 * @throws Exception
	 */
	public void createFileOrdenesDetalle(ArrayList<m05bOrdenTrabajo> datos,ArrayList<String> parametros,
			OutputStream salida) throws Exception {
		String template = m05bConstantesPaginas.EXCELLISTADOORDENESDETALLE;
		if (idioma == null || idioma.length() == 0 || idioma.equals("ES"))
			template = template.replaceAll("IDIOMAX", "es");
		else
			template = template.replaceAll("IDIOMAX", "eu");
		createFile(template, (short) 4, 0, (ArrayList) datos,
				m05bOrdenTrabajo.ORDENDETALLES, "", parametros, salida);
	}

	/**
	 * Crea el excel de Listado general
	 * 
	 * @param datos
	 * @param salida
	 * @throws Exception
	 */
	public void createFileOrdenesFechas(ArrayList<m05bOrdenTrabajo> datos,
			OutputStream salida) throws Exception {
		String template = m05bConstantesPaginas.EXCELLISTADOORDENESFECHAS;
		if (idioma == null || idioma.length() == 0 || idioma.equals("ES"))
			template = template.replaceAll("IDIOMAX", "es");
		else
			template = template.replaceAll("IDIOMAX", "eu");
		createFile(template, (short) 4, 0, (ArrayList) datos,
				m05bOrdenTrabajo.ORDENFECHAS, "", null, salida);
	}

	/**
	 * Crea el excel de Listado general
	 * 
	 * @param datos
	 * @param salida
	 * @throws Exception
	 */
	public void createFileOrdenesFechasAgrup(ArrayList<m05bOrdenTrabajo> datos,ArrayList<String> parametros,
			OutputStream salida) throws Exception {
		String template = m05bConstantesPaginas.EXCELLISTADOORDENESFECHASAGRUP;
		if (idioma == null || idioma.length() == 0 || idioma.equals("ES"))
			template = template.replaceAll("IDIOMAX", "es");
		else
			template = template.replaceAll("IDIOMAX", "eu");
		createFile(template, (short) 4, 0, (ArrayList) datos,
				m05bOrdenTrabajo.ORDENFECHASAGRUP, "", parametros, salida);
	}

	/**
	 * Crea el excel de Listado general agrupado por
	 * departamento,matricula,rango
	 * 
	 * @param datos
	 * @param salida
	 * @throws Exception
	 */
	public void createFileOrdenesRangoAgrup(ArrayList<m05bOrdenTrabajo> datos,ArrayList<String> parametros,
			OutputStream salida) throws Exception {
		String template = m05bConstantesPaginas.EXCELLISTADOORDENESRANGOAGRUP;
		if (idioma == null || idioma.length() == 0 || idioma.equals("ES"))
			template = template.replaceAll("IDIOMAX", "es");
		else
			template = template.replaceAll("IDIOMAX", "eu");
		createFile(template, (short) 4, 0, (ArrayList) datos,
				m05bOrdenTrabajo.ORDENFECHASRANGOAGRUP, "", parametros, salida);
	}

	/**
	 * Crea el excel de Listado general agrupado por
	 * departamento,matricula,rango
	 * 
	 * @param datos
	 * @param salida
	 * @throws Exception
	 */
	public void createFileCtkCombustibleResumen(
			ArrayList<m05bCombustible> datos,ArrayList<String> parametros, OutputStream salida)
			throws Exception {
		String template = m05bConstantesPaginas.EXCELCTKCOMBUSTIBLERESUMEN;
		if (idioma == null || idioma.length() == 0 || idioma.equals("ES"))
			template = template.replaceAll("IDIOMAX", "es");
		else
			template = template.replaceAll("IDIOMAX", "eu");
		createFile(template, (short) 4, 0, (ArrayList) datos,
				m05bCombustible.ORDENRESUMEN, "", parametros, salida);
	}

	/**
	 * Crea el excel de Listado general agrupado por
	 * departamento,matricula,rango
	 * 
	 * @param datos
	 * @param salida
	 * @throws Exception
	 */
	public void createFileCtkCombustible(ArrayList<m05bCombustible> datos,ArrayList<String> parametros,
			OutputStream salida) throws Exception {
		String template = m05bConstantesPaginas.EXCELCTKCOMBUSTIBLELISTA;
		if (idioma == null || idioma.length() == 0 || idioma.equals("ES"))
			template = template.replaceAll("IDIOMAX", "es");
		else
			template = template.replaceAll("IDIOMAX", "eu");
		createFile(template, (short) 4, 0, (ArrayList) datos,
				m05bCombustible.ORDENCOMBUSTIBLE, "", parametros, salida);
	}

	/**
	 * 
	 * @param datos
	 * @param salida
	 * @throws Exception
	 */
	public void createFileCTKKilometros(ArrayList<m05bKilometrajes> datos,ArrayList<String> parametros,
			OutputStream salida) throws Exception {
		String template = m05bConstantesPaginas.EXCELCTKKILOMETRAJERESUMEN;
		if (idioma == null || idioma.length() == 0 || idioma.equals("ES"))
			template = template.replaceAll("IDIOMAX", "es");
		else
			template = template.replaceAll("IDIOMAX", "eu");
		createFile(template, (short) 4, 0, (ArrayList) datos,
				m05bKilometrajes.ORDENKMRECORRIDOS, "", parametros, salida);
	}

	/**
	 * 
	 * @param datos
	 * @param salida
	 * @throws Exception
	 */
	public void createFileCTKKilometrosBase(ArrayList<m05bKilometrajes> datos,ArrayList<String> parametros,
			OutputStream salida) throws Exception {
		String template = m05bConstantesPaginas.EXCELCTKKILOMETRAJELISTA;
		if (idioma == null || idioma.length() == 0 || idioma.equals("ES"))
			template = template.replaceAll("IDIOMAX", "es");
		else
			template = template.replaceAll("IDIOMAX", "eu");
		createFile(template, (short) 4, 0, (ArrayList) datos,
				m05bKilometrajes.ORDENBASE, "", parametros, salida);
	}

	public void createFileCTKVehiculosBase(ArrayList<m05bKilometrajes> datos,ArrayList<String> parametros,
			OutputStream salida) throws Exception {
		String template = m05bConstantesPaginas.EXCELCTKVEHICULOSLISTA;
		if (idioma == null || idioma.length() == 0 || idioma.equals("ES"))
			template = template.replaceAll("IDIOMAX", "es");
		else
			template = template.replaceAll("IDIOMAX", "eu");
		createFile(template, (short) 4, 0, (ArrayList) datos,
				m05bKilometrajes.ORDENVEHICULOSALTA, "", parametros, salida);
	}

	/**
	 * 
	 * @param datos
	 * @param salida
	 * @throws Exception
	 */
	public void createFileCTKVehiculos(ArrayList<m05bKilometrajes> datos,ArrayList<String> parametros,
			OutputStream salida) throws Exception {
		String template = m05bConstantesPaginas.EXCELCTKVEHICULOSRESUMEN;
		if (idioma == null || idioma.length() == 0 || idioma.equals("ES"))
			template = template.replaceAll("IDIOMAX", "es");
		else
			template = template.replaceAll("IDIOMAX", "eu");
		createFile(template, (short) 4, 0, (ArrayList) datos,
				m05bKilometrajes.ORDENNUMERO, "", parametros, salida);
	}

	/**
	 * 
	 * @param datos
	 * @param salida
	 * @throws Exception
	 */
	public void createFileCTKVehiculosNUM(ArrayList<m05bKilometrajes> datos,ArrayList<String> parametros,
			OutputStream salida) throws Exception {
		String template = m05bConstantesPaginas.EXCELCTKVEHICULOSNUMRESUMEN;
		if (idioma == null || idioma.length() == 0 || idioma.equals("ES"))
			template = template.replaceAll("IDIOMAX", "es");
		else
			template = template.replaceAll("IDIOMAX", "eu");
		createFile(template, (short) 4, 0, (ArrayList) datos,
				m05bKilometrajes.ORDENNUMERO, "", parametros, salida);
	}
	
	/**
	 * 
	 * @param datos
	 * @param salida
	 * @throws Exception
	 */
	public void createFileTasas(ArrayList<m05bTasasMunicipio> datos,ArrayList<String> parametros,
			OutputStream salida) throws Exception {
		String template = m05bConstantesPaginas.EXCELTASAS;
		if (idioma == null || idioma.length() == 0 || idioma.equals("ES"))
			template = template.replaceAll("IDIOMAX", "es");
		else
			template = template.replaceAll("IDIOMAX", "eu");
		createFile(template, (short) 4, 0, (ArrayList) datos,
				m05bTasasMunicipio.ORDEN, "", parametros, salida);
	}

	/**
	 * 
	 * @param datos
	 * @param salida
	 * @throws Exception
	 */
	public void createFileSanciones(ArrayList<m05bSancion> datos,ArrayList<String> parametros,
			OutputStream salida) throws Exception {
		String template = m05bConstantesPaginas.EXCELSANCIONES;
		if (idioma == null || idioma.length() == 0 || idioma.equals("ES"))
			template = template.replaceAll("IDIOMAX", "es");
		else
			template = template.replaceAll("IDIOMAX", "eu");
		createFile(template, (short) 4, 0, (ArrayList) datos,
				m05bSancion.ORDENBASE, "", parametros, salida);
	}
	/**
	 * Crear un EXCEL utilizando el XSL de Template y el XML datos enel
	 * OutputStream salida
	 * 
	 * @param template
	 * @param datos
	 * @param salida
	 * @param lang
	 * @throws Exception
	 */
	private void createFile(String template, short rownum, int colnum,
			ArrayList<m05bImprimible> datos, int[] orden, String anio,
			ArrayList<String> parametros, OutputStream salida) throws Exception {
		logger.info("Escribiendo en la plantilla " + template);
		// create a destination file
		try {

			FileInputStream in = new FileInputStream(template);

			// create a new workbook object; note that the workbook
			// and the file are two separate things until the very
			// end, when the workbook is written to the file.
			HSSFWorkbook wb = new HSSFWorkbook(in);
			// create a new worksheet

			// create a row object reference for later use
			HSSFRow r = null;
			// create a cell object reference
			HSSFCell c = null;

			HSSFCellStyle grisa = wb.createCellStyle();
			grisa.setFillForegroundColor(HSSFColor.GREY_25_PERCENT.index);
			grisa.setFillPattern(HSSFCellStyle.SOLID_FOREGROUND);

			HSSFCellStyle zuria = wb.createCellStyle();
			zuria.setFillForegroundColor(HSSFColor.WHITE.index);
			zuria.setFillPattern(HSSFCellStyle.SOLID_FOREGROUND);

			HSSFFont font = wb.createFont();
			font.setBoldweight(HSSFFont.BOLDWEIGHT_BOLD);

			font.setColor(HSSFColor.WHITE.index);

			HSSFCellStyle bold = wb.createCellStyle();
			bold.setFillForegroundColor(HSSFColor.BLACK.index);
			bold.setFillPattern(HSSFCellStyle.SOLID_FOREGROUND);

			bold.setFont(font);

			int rowc = 1, columnc = 0;

			Iterator iter = datos.iterator();
			HSSFSheet ws;
			int counts = rownum;
			HSSFSheet indice = wb.getSheetAt(0);
			r = indice.getRow(1);
			c = r.getCell(0);
			c.setCellValue(c.getStringCellValue() + " " + anio);

			counts = 2;
			//Creamos el estilo 
			HSSFFont fuente = wb.createFont();
			// cabecera tablas
			fuente.setBoldweight(HSSFFont.BOLDWEIGHT_BOLD);
			fuente.setColor(HSSFColor.BLACK.index);
			fuente.setFontHeightInPoints((short) 8);
			HSSFCellStyle cabecera = wb.createCellStyle();
			cabecera.setFillForegroundColor(HSSFColor.WHITE.index);
			cabecera.setFillPattern(HSSFCellStyle.SOLID_FOREGROUND);
			cabecera.setAlignment(HSSFCellStyle.ALIGN_LEFT);
			cabecera.setVerticalAlignment(HSSFCellStyle.VERTICAL_CENTER);
//			cabecera.setBorderRight(HSSFCellStyle.BORDER_THIN);
//			cabecera.setRightBorderColor(HSSFColor.GREY_50_PERCENT.index);
//			cabecera.setBorderLeft(HSSFCellStyle.BORDER_THIN);
//			cabecera.setLeftBorderColor(HSSFColor.GREY_50_PERCENT.index);
//			cabecera.setBorderTop(HSSFCellStyle.BORDER_THIN);
//			cabecera.setTopBorderColor(HSSFColor.GREY_50_PERCENT.index);
//			cabecera.setBorderBottom(HSSFCellStyle.BORDER_THIN);
//			cabecera.setBottomBorderColor(HSSFColor.GREY_50_PERCENT.index);

			cabecera.setFont(fuente);
			cabecera.setWrapText(true);
			Row sourceRow = indice.getRow(3);
			int numeroCeldas=sourceRow.getLastCellNum()-1;
		
		
			
			//Aade los parmetros de entrada een el informe despus del ttulo
			if (parametros != null&&parametros.size()>0) {
				if(parametros.size()>1)
					copyRow(indice, 3, 3 + parametros.size());
				for (String param : parametros) {
					r = indice.createRow(counts);
					indice.addMergedRegion(new CellRangeAddress(counts, counts, 0, numeroCeldas));
					c = r.createCell(0);
					c.setCellStyle(cabecera);
					c.setCellValue(param);
					counts++;
				}
				if(parametros.size()>1)
					counts += 2;
				else
					counts ++;
			} else
				counts = rownum;

			m05bImprimible elemento;
			Object campo;
			while (iter.hasNext()) {
				elemento = (m05bImprimible) iter.next();
				r = indice.createRow(counts);
				for (int i = 0; i < orden.length; i++) {
					c = r.createCell(i);
					campo = elemento.get(orden[i]);
					if (campo instanceof Integer)
						c.setCellValue((Integer) campo);
					else if (campo instanceof Double)
						c.setCellValue((Double) campo);
					else if (campo instanceof Date)
						c.setCellValue((Date) campo);
					else if (campo instanceof String)
						c.setCellValue((String) campo);
				}
				counts++;
			}
			wb.write(salida);
			salida.close();
		} catch (Exception e) {
			StackTraceElement[] stackTraceElements = Thread.currentThread()
					.getStackTrace();
			for (StackTraceElement stackTrace : stackTraceElements) {
				logger.error(stackTrace.getClassName() + "  "
						+ stackTrace.getMethodName() + " "
						+ stackTrace.getLineNumber());
			}
			throw (e);
		}
	}

	private static void copyRow(Sheet worksheet, int sourceRowNum,
			int destinationRowNum) {
		// Get the source / new row
		Row newRow = worksheet.getRow(destinationRowNum);
		Row sourceRow = worksheet.getRow(sourceRowNum);

		// If the row exist in destination, push down all rows by 1 else create
		// a new row
		if (newRow != null) {
			worksheet
					.shiftRows(destinationRowNum, worksheet.getLastRowNum(), 1);
		} else {
			newRow = worksheet.createRow(destinationRowNum);
		}

		// Loop through source columns to add to new row
		for (int i = 0; i < sourceRow.getLastCellNum(); i++) {
			// Grab a copy of the old/new cell
			Cell oldCell = sourceRow.getCell(i);
			Cell newCell = newRow.createCell(i);

			// If the old cell is null jump to next cell
			if (oldCell == null) {
				newCell = null;
				continue;
			}

			// Use old cell style
			newCell.setCellStyle(oldCell.getCellStyle());

			// If there is a cell comment, copy
			if (newCell.getCellComment() != null) {
				newCell.setCellComment(oldCell.getCellComment());
			}

			// If there is a cell hyperlink, copy
			if (oldCell.getHyperlink() != null) {
				newCell.setHyperlink(oldCell.getHyperlink());
			}

			// Set the cell data type
			newCell.setCellType(oldCell.getCellType());

			// Set the cell data value
			switch (oldCell.getCellType()) {
			case Cell.CELL_TYPE_BLANK:
				break;
			case Cell.CELL_TYPE_BOOLEAN:
				newCell.setCellValue(oldCell.getBooleanCellValue());
				break;
			case Cell.CELL_TYPE_ERROR:
				newCell.setCellErrorValue(oldCell.getErrorCellValue());
				break;
			case Cell.CELL_TYPE_FORMULA:
				newCell.setCellFormula(oldCell.getCellFormula());
				break;
			case Cell.CELL_TYPE_NUMERIC:
				newCell.setCellValue(oldCell.getNumericCellValue());
				break;
			case Cell.CELL_TYPE_STRING:
				newCell.setCellValue(oldCell.getRichStringCellValue());
				break;
			}
		}
	}

	public String setOptionList(ArrayList<m05bOption> lista, String nombre) {
		StringBuffer str = new StringBuffer();
		if (lista!=null && lista.size() > 0) {
			boolean first = true;
			str.append(nombre + ":");

			for (m05bOption opt : lista) {
				if (!first)
					str.append(",");
				first=false;
				str.append(opt.getText());
			}

		}
		return str.toString();
	}

	public String setFecha(String fechaDesde, String fechaHasta, String nombre) {
		StringBuffer str = new StringBuffer();
		if ((fechaDesde != null && fechaDesde.length() > 0)
				|| (fechaHasta != null && fechaHasta.length() > 0)) {
			str.append(nombre + ": ");
			if (fechaDesde != null && fechaDesde.length() > 0) {
			
				str.append(fechaDesde);

			}
			if ((fechaHasta != null && fechaHasta.length() > 0)) {
				str.append(" - ");
				str.append(fechaHasta);
			}

		}
		return str.toString();
	}

}
