package utiliServlet;

import java.io.IOException;

import javax.servlet.RequestDispatcher;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import m05bClasses.m05bFileLog;


/**
 *  Esta clase representa una clase base para la implementacin de servlets
 *  para la gestin de las pantallas de la aplicacin.
 *  Incluye una serie de mtodos comunes a todos los servlets de manejo
 *  de pantallas.
 */
public class m05bCServlet extends HttpServlet {
	m05bFileLog miLog = new m05bFileLog();
    public static final String  ACTUALIZAR                  = "A",
                                CREAR                       = "C",
                                ELIMINAR                    = "E",
                                CREAR_NUEVO                 = "N",
                                RECUPERAR                   = "R",
                                BUSCAR                      = "B",
                                VISUALIZAR_AYUDA            = "VA",
                                VISUALIZAR_AYUDA_ESPECIFICA = "VAE",
                                IMPRIMIR                    = "I",
                                SOLICITUD_ALTA              = "SA",
                                BORRAR                      = "B",
								OBTENER_CORRELATIVO 		= "OC",
								RECUPERAR_EXPEDIENTES 		= "RE",
								MOSTRAR 					= "MO",
								BORRAR_EXPEDIENTE 			= "BE",
								ACTUALIZAR_PANTALLA_EXPEDIENTE = "APE",
								EXPEDIENTES_ACTUALIZADOS    = "EA",
								OBTENER_POBLACION   		= "OP",
    							VOLVER                      = "V";

    
    // Contexto del servlet
    private ServletContext servCtx;
    
    //Control de sesion
    protected static final String sessionFlag = "QWght1YUhJ_T2Tfr-3TTjuJ4Jk55mnP6_v7pl8kj9y0ssY0_wwYG";
    protected static final String nameSessionFlag    = "__NAMESESSIONFLAG__";
    
    
    /**
     *  Inicializa variables globales.
     *  @param  config  variables globales a inicializar.
     *  @throws ServletException
     */
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        servCtx = config.getServletContext();
    }
    
    /**
     *  Representa la operacin de peticin HTTP get
     *  @param  request     Peticin del cliente
     *  @param  response    Respuesta al cliente
     *  @throws ServletException
     *  @throws IOException
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, IOException
    {}
    
    /**
     *  Representa la operacin de peticin HTTP post
     *  @param  request     Peticin del cliente
     *  @param  response    Respuesta al cliente
     *  @throws ServletException
     *  @throws IOException
     */
    public void doPost(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, IOException
    {}
    
    /**
     *  verifica que la sesion es correcta
     *  @param  request     Peticin del cliente
     *  @param  response    Respuesta al cliente
     *  @return si hay o no error
     *  @throws ServletException
     *  @throws IOException
     */
    protected boolean verificarSesion(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        HttpSession session = req.getSession();
        if (session==null) {
            //System.out.println(this.getClass().getName() + "No se recibe la sesion");
            return true;
        }
        else {
            String auxiliar = (String)session.getAttribute(nameSessionFlag);
            
            if (auxiliar==null) {
                //System.out.println(this.getClass().getName() + "No hay nameSessionFlag");
                return true;
            }
            else if (!auxiliar.equals(sessionFlag)) {
                //System.out.println(this.getClass().getName() + "No hay SessionFlag");
                return true;
            }
        }
        return false;
    }
    
    /**
     *  marca la sesion
     *  @param  request     Peticin del cliente
     *  @param  response    Respuesta al cliente
     *  @throws ServletException
     *  @throws IOException
     */
    protected void marcarSesion(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        HttpSession session = req.getSession(true);
        // DEPRECATED PARA Weblogic 5.1
        //        session.putValue(nameSessionFlag, sessionFlag);
        session.setAttribute(nameSessionFlag, sessionFlag);
    }
    
    /**
     *  Trata los errores de seguridad que pudiesen haber surgido en el servlet envindolos
     *  a una pgina de errores.
     *  @param  request     Peticion del cliente
     *  @param  response    Respuesta al cliente
     *  @param  e           Excepcin que se va a tratar.
     */
    protected void manejarErrorSesion(HttpServletRequest request, HttpServletResponse response) {
        try {
            //response.sendRedirect(r76bCPaginas.JSP_PAGINA_ERROR_SESSION);
        	response.sendRedirect("m05bError.jsp");
        }
        catch (Exception ex) {
            miLog.addTraza(ex);
        }
    }
    
    public String getServletInfo() {
        return "Informacion utiliServlet.m05bCServlet";
    }
    
    /**
     *  Trata los errores que pudiesen haber surgido en el servlet envindolos
     *  a una pgina de errores.
     *  @param  request     Peticion del cliente
     *  @param  response    Respuesta al cliente
     *  @param  e           Excepcin que se va a tratar.
     */
    /*protected void manejarErrores(HttpServletRequest request, HttpServletResponse response, Exception e) {
        try {
            // Pasamos la excepcin a una pgina jsp
            request.setAttribute(r76bCWebMessages.EXCEPCION, e);
            r76bCContenedor lista = new r76bCContenedor();
            lista.codigo = r76bCContenedor.RESULTADO_ERROR;
            
            if (getObjetoSesion(r76bCWebMessages.PERFIL, request, response)!=null){
            	lista.vendorMessage = ((r76bEExcepcionBase)e).getMessageAsHTML((r76bCPerfilUsuario)getObjetoSesion(r76bCWebMessages.PERFIL, request, response));
            	setObjetoSesion(r76bCWebMessages.CONTENEDOR, lista, request, response);
            }
            r76bCLog.send(0,this.getClass().getName(), "Excepcion: " + e);
            r76bCLog.send(0,this.getClass().getName(), "Cargando pagina de error: " + r76bCPaginas.PAGINA_MENSAJES2);
            
            response.sendRedirect(r76bCPaginas.PAGINA_MENSAJES);
            
            
        }
        catch (Exception ex) {
            miLog.addTraza(ex);
        }
    }*/
    
    /**
     *  Realiza una redireccin a una pgina pasada como parmetro
     *  @param  req     Peticin del cliente
     *  @param  res     Respuesta al cliente
     *  @param  page    Nombre de pgina a la que queremos redireccionar.
     */
    public void forward(HttpServletRequest req, HttpServletResponse res, String page) {
        try {
            //System.out.println(this.getClass().getName() + "Cargando pagina: " + page);
            //getServletConfig ().getServletContext().getRequestDispatcher(page).forward(req, res);
            RequestDispatcher rd = servCtx.getRequestDispatcher(page);
            rd.forward(req, res);
        }
        catch (Exception ex) {
            //manejarErrores(req, res, ex);
        }
    }
    
    /**
     *  Introduce un objeto en la sesin.
     *  @param  clave   nombre del objeto para referenciarlo en la sesin.
     *  @param  objeto  objeto que queremos introducir en la sesin.
     *  @param  request Peticin del cliente.
     *  @param  response Respuesta al cliente.
     */
    protected void setObjetoSesion(String clave, Object objeto, HttpServletRequest request,
    HttpServletResponse response) {
        try {
            HttpSession session = request.getSession();
            // DEPRECATED PARA Weblogic 5.1
            //            session.putValue(clave, objeto);
            session.setAttribute(clave, objeto);
        }
        catch (Exception e) {
            //manejarErrores(request, response, e);
        }
    }
    
    /**
     *  Obtiene de la sesin un determinado objeto.
     *  @param  clave   nombre con el que referenciamos al objeto de la sesin
     *                  que queremos obtener.
     *  @param  request Peticin del cliente.
     *  @param  response  Respuesta al cliente.
     */
    protected Object getObjetoSesion(String clave, HttpServletRequest request,
    HttpServletResponse response) {
        Object obj = null;
        try {
            HttpSession session = request.getSession();
            // DEPRECATED PARA Weblogic 5.1
            //            obj = session.getValue(clave);
            obj = session.getAttribute(clave);
        }
        catch (Exception e) {
            //manejarErrores(request, response, e);
        }
        return obj;
    }
    
    /**
     *  Trata los errores de seguridad que pudiesen haber surgido en el servlet envindolos
     *  a una pgina de errores.
     *  @param  request     Peticion del cliente
     *  @param  response    Respuesta al cliente
     *  @param  e           Excepcin que se va a tratar.
     */
    protected void manejarErrorSeguridad(HttpServletRequest request, HttpServletResponse response) {
        try {
            //response.sendRedirect(r76bCPaginas.JSP_ERROR_SEGURIDAD);
        	response.sendRedirect("m05bError.jsp");
        }
        catch (Exception ex) {
            //System.out.println( this.getClass().getName() + "Excepcion: " + ex);
        }
    }
    
    

   
    /**
     * Metodo que indica si se tiene acceso a un determinado modulo de seguridad.
     * Wrapper sobre la aplicacion N38 del Gobierno Vasco
     */
   /* public boolean tieneAccesoModulo(String astrNombreModulo, HttpServletRequest request) {
        HttpSession session = request.getSession();
        if (r76bControlAccesoAdaptador.tieneAccesoModulo(astrNombreModulo, session))
            return true;
        else
            return false;
    }*/
    
    
    /**
     * Metodo que indica si se tiene un determinado permiso de seguridad.
     * Wrapper sobre la aplicacion N38 del Gobierno Vasco
     */
   /* public boolean tienePermiso(String astrNombrePermiso, HttpServletRequest request,HttpServletResponse response) {
        r76bCPerfilUsuario cPerfil = (r76bCPerfilUsuario)getObjetoSesion(r76bCWebMessages.PERFIL, request, response);
        
        HttpSession session = request.getSession();
        if (cPerfil.tienePermiso(astrNombrePermiso, session))
            return true;
        else
            return false;
    }*/
    
    protected void setNoCache(HttpServletResponse res) {
        res.setHeader("pragma", "no-cache");
        res.setHeader("Cache-Control", "no-cache");
        res.setHeader("Cache-Control", "max-age=3D10");
        res.setHeader("Expires", "0");
    }
}
