package tiposreformaServlet;

import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.SQLException;

import m05bClasses.m05bConexion;
import m05bClasses.m05bConstantes;
import m05bClasses.m05bFileLog;


/**
 * Inserte aqu la descripcin del tipo.
 * Fecha de creacin: (19/05/04)
 */
public class m05bGrabarTiposReformaServlet extends javax.servlet.http.HttpServlet {m05bFileLog miLog = new m05bFileLog();
/**
 * Process incoming HTTP POST requests
 *
 * @param request Object that encapsulates the request to the servlet
 * @param response Object that encapsulates the response from the servlet
 */
public void doPost(javax.servlet.http.HttpServletRequest request, javax.servlet.http.HttpServletResponse response) throws javax.servlet.ServletException, java.io.IOException {

	performTask(request, response);

}
/**
 * Returns the servlet info string.
 */
public String getServletInfo() {

	return super.getServletInfo();

}
/**
 * Initializes the servlet.
 */
public void init() {
	// insert code to initialize the servlet here

}
/**
 * Process incoming requests for information
 *
 * @param request Object that encapsulates the request to the servlet
 * @param response Object that encapsulates the response from the servlet
 */
public void performTask(javax.servlet.http.HttpServletRequest request, javax.servlet.http.HttpServletResponse response) {

       	String sCodigo;
       	String sDescripcion,sDescripcionEu;
       	String accion;
		java.sql.Connection conn=null;
		PreparedStatement pstmt = null;
		
     try

	{

		sCodigo = request.getParameter("Codigo");
		sDescripcion=request.getParameter("Descripcion").toUpperCase();
		sDescripcionEu=request.getParameter("DescripcionEu").toUpperCase();
		accion=request.getParameter("Accion");

		try{
			m05bConexion miConex = new m05bConexion();
			conn = miConex.getConnection();
			if (accion.equals(m05bConstantes.ACC_ACTUALIZAR))  {
			       pstmt = conn.prepareStatement("update	M0538T00 " +
					"set	DESC_38 = ? " +
					", EDESC_38 =?"+
					"where	COD_TIPREF_38 = ?");
				pstmt.setString(1, sDescripcion);
				pstmt.setString(2, sDescripcionEu);
				pstmt.setString(3, sCodigo);
			}
			else if (accion.equals(m05bConstantes.ACC_INSERTAR))  {
				pstmt = conn.prepareStatement(
					"insert into	M0538T00 " +
					"(COD_TIPREF_38, DESC_38,EDESC_38) " +
					" values " +
					"(? ,?,?)" );
				pstmt.setString(1, sCodigo);
				pstmt.setString(2, sDescripcion);
				pstmt.setString(3, sDescripcionEu);
			}
			else   {
				pstmt = conn.prepareStatement(
					"delete from 	M0538T00 " +
					" where COD_TIPREF_38 =  ? " );
				pstmt.setString(1, sCodigo);

			}
			pstmt.executeUpdate();
			response.sendRedirect("m05bRelTiposReformaJsp.jsp");
		} 	catch (SQLException ex1) {
				if (ex1.getErrorCode() == m05bConstantes.ERR_INTEGRIDAD)
						response.sendRedirect("m05bTiposReformaJsp.jsp?Codigo=" + sCodigo + "&Mensaje=" + m05bConstantes.MSG_INTEGRIDAD);
				else
					response.sendRedirect("m05bError.jsp");
				miLog.addTraza(ex1);
		} 	finally{
				if (pstmt != null)
					pstmt.close();
				if (conn != null)
					conn.close();
		}
	}
	catch(Throwable theException)
	{
		// uncomment the following line when unexpected exceptions
		// are occuring to aid in debugging the problem.
		miLog.addTraza(theException);
		try {
			response.sendRedirect("m05bError.jsp");
		} catch (IOException e) {
			// TODO Auto-generated catch block
			miLog.addTraza(e);
		}
	}
}
}
