package test;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

import m05bClasses.m05bConexion;
import m05bClasses.m05bFileLog;


/**
 * Fecha de creacin: (22-02-2005)
 */

public class m05bAnalizaTexto{
	
	//Todas aquellas palabras inferiores en longitud al limite se ignoran
	//Ejemplo: preposiciones, determinantes...etc
	private static int limiteCaracteres = 3;
	   m05bFileLog miLog = new m05bFileLog();
	public List buscar(	String tabla, String campo, String where, String texto){
		ArrayList palabrasValidas = new ArrayList();
		StringTokenizer st = new StringTokenizer(texto," ");
		String palabra ="";
		while ( st.hasMoreTokens() ){
			palabra= st.nextToken();
			if(palabra.length()>m05bAnalizaTexto.limiteCaracteres){
				palabrasValidas.add(palabra);
			}
		}
		//Creo la sentencia SQL
		String sql = crearSentenciaSQL(tabla, campo, where, palabrasValidas);
		
		ArrayList lista = obtenerListaDescripciones(sql);
		return lista;
	}
	
	private static String crearSentenciaSQL(String tabla, String campo, String where, ArrayList palabrasValidas){
		String sql = "SELECT " + campo + " FROM " + tabla;
		if(!where.equals("")){
			sql+= " WHERE "+where+ " AND (";
		}
		if(palabrasValidas.isEmpty())
			return sql;
		String palabra = "";
		String sqlCampo = "replace(replace(replace(replace(replace("+campo+",'','U'),'','O'),'','I'),'','E'),'','A')";
		if(where.equals(""))
			sql+= " WHERE";
		String sql2 ="";
		for(int i=0;i<palabrasValidas.size();i++){
			palabra = (String)palabrasValidas.get(i);
			palabra = palabra.toUpperCase();
			palabra = reemplazarAcentos(palabra);
			//La palabra sin acentos y en maysculas
			if(sql2.equals(""))
				sql2+= " " + sqlCampo + " LIKE '%"+palabra+"%'";
			else
				sql2+= " AND " + sqlCampo + " LIKE '%"+palabra+"%'";
		}
		sql+=sql2;
		if(!where.equals(""))
			sql+=")";
		return sql;
	}
	
	private static String reemplazarAcentos(String palabra){
		String palabraSinAcentos = palabra;
		palabraSinAcentos = palabraSinAcentos.replaceAll("","A");
		palabraSinAcentos = palabraSinAcentos.replaceAll("","E");
		palabraSinAcentos = palabraSinAcentos.replaceAll("","I");
		palabraSinAcentos = palabraSinAcentos.replaceAll("","O");
		palabraSinAcentos = palabraSinAcentos.replaceAll("","U");
		return palabraSinAcentos;
	}
	
	private static ArrayList obtenerListaDescripciones(String sql){
		ArrayList resultado = new ArrayList();
		java.sql.Connection conn=null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String descripcion = "";
		try{
			m05bConexion miConex = new m05bConexion();
			conn = miConex.getConnection();
			pstmt = conn.prepareStatement(sql);
			rs=pstmt.executeQuery();
			while(rs.next()){
				descripcion = rs.getString(1);
				resultado.add(descripcion);
			}
		}catch(Exception e){
			   m05bFileLog miLog = new m05bFileLog();
			miLog.addTraza(e);
			if(rs!=null)
				try {
					rs.close();
				} catch (SQLException e1) {
					// TODO Auto-generated catch block
					miLog.addTraza(e1);
				}
			if(pstmt!=null)
				try {
					pstmt.close();
				} catch (SQLException e2) {
					// TODO Auto-generated catch block
					miLog.addTraza(e2);
				}
			if(conn!=null)
				try {
					conn.close();
				} catch (SQLException e3) {
					// TODO Auto-generated catch block
					miLog.addTraza(e3);
				}
		}finally{
			if(rs!=null)
				try {
					rs.close();
				} catch (SQLException e1) {
					// TODO Auto-generated catch block
					m05bFileLog miLog = new m05bFileLog();
					miLog.addTraza(e1);
				}
			if(pstmt!=null)
				try {
					pstmt.close();
				} catch (SQLException e2) {
					// TODO Auto-generated catch block
					m05bFileLog miLog = new m05bFileLog();
					miLog.addTraza(e2);
				}
			if(conn!=null)
				try {
					conn.close();
				} catch (SQLException e3) {
					// TODO Auto-generated catch block
					m05bFileLog miLog = new m05bFileLog();
					miLog.addTraza(e3);
				}
		}
		return resultado;
	}
}