package tarjetasServlet;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.Clob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import javax.servlet.http.HttpSession;

import m05bClasses.m05bComun;
import m05bClasses.m05bConexion;
import m05bClasses.m05bConstantes;
import m05bClasses.m05bFileLog;
import m05bClasses.m05bGenerarClave;

/**
 * Inserte aqu la descripcin del tipo.
 * Fecha de creacin: (18/11/04)
 */
public class m05bImportarArchivosCajasServlet extends javax.servlet.http.HttpServlet {m05bFileLog miLog = new m05bFileLog();
/**
 * Process incoming HTTP POST requests
 *
 * @param request Object that encapsulates the request to the servlet
 * @param response Object that encapsulates the response from the servlet
 */    


    String mensaje="", persona="";
    long idOpeBancos = 0;
    boolean bCentros = false;

    
    m05bComun miComun = new m05bComun();
    
	// Conexion
	java.sql.Connection conn=null;
    m05bConexion miConex = new m05bConexion();


public void doPost(javax.servlet.http.HttpServletRequest request, javax.servlet.http.HttpServletResponse response) throws javax.servlet.ServletException, java.io.IOException {
	performTask(request, response);
}  // Fin funcion doPost


public String getServletInfo() {
/*  Returns the servlet info string.  */
	return super.getServletInfo();
} // Fin funcion getServletInfo


public void init() {
	// insert code to initialize the servlet here
} // Fin funcion init


public Clob fncLeerCLOB(String id) throws java.lang.Exception {
	   String sql, pathFichero = null;
	   PreparedStatement pstmt = null;
	   ResultSet rs = null;
	   boolean cargado= false;
	   java.sql.Clob lob = null;
	   byte[] inBytes;
	   int numBytes;
	   java.io.OutputStream os=null;
	   // Comprueba si ya se ha cargado ese fichero
	   try  {
			   sql = "select " + m05bConstantes.COL_43_FICHERO + 
			   	   		" from " +  m05bConstantes.TAB_CARGAGASTOSTARJETAS + 
			   		  	" where " + m05bConstantes.COL_43_ID + " = " + id ;
		       pstmt = conn.prepareStatement(sql);
			   rs=pstmt.executeQuery();
	   		   if (rs.next()){
	            	lob = rs.getClob(1);
		 	   } else {
	       					miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC,"         ------   FICHERO CLOB NO ENCONTRADO", m05bConstantes.LOG_NIVEL_BAJO);
		 	   }
	   } catch (Exception ex) {
			try {
	  			conn.rollback();  // Ha habido problemas, se deshacen todos los cambios
	  		} catch (SQLException e1){
	       		miLog.addTraza(persona, "Imp. ArchCajas Servlet","EXCEPTION-1: LEER FICHERO --> " + e1, m05bConstantes.LOG_NIVEL_BAJO);
	  		}
			miLog.addTraza(ex);
	  		throw new Exception(ex);
	   } finally{
	   	    try {
	   	    	if (rs != null)
	   	    		rs.close();
				if (pstmt != null)
					pstmt.close();
			} catch (SQLException e2) {
	       		miLog.addTraza(persona, "Imp. ArchCajas Servlet","EXCEPTION-2: LEER FICHERO --> " + e2, m05bConstantes.LOG_NIVEL_BAJO);
	  		}
	   }
	   return lob;
} // Fin funcion fncLeerCLOB


public String fncComprobarFichCargado(String primerRegistro) throws java.lang.Exception {
	   String sql, fecha="";
	   PreparedStatement pstmt = null;
	   ResultSet rs = null;
	   
	   // Comprueba si ya se ha cargado ese fichero
	   try  {
		   sql = "select to_char(" + m05bConstantes.COL_43_FECHA + ",'dd-mm-yyyy hh24:mi:ss')"+
		   	   		" from " +  m05bConstantes.TAB_CARGAGASTOSTARJETAS + 
		   		 	" where " + m05bConstantes.COL_43_PRIMERREG + " = '" + primerRegistro + "'";
		   //miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC,"Comprobar fich cargado: " + sql , m05bConstantes.LOG_NIVEL_BAJO);
	       pstmt = conn.prepareStatement(sql);
		   rs=pstmt.executeQuery();
   		   if (rs.next()){
	   	    	fecha = rs.getString(1);
	 	   } 
	   } catch (Exception ex) {
			try {
	  			conn.rollback();  // Ha habido problemas, se deshacen todos los cambios
	  		} catch (SQLException e1){
	       		miLog.addTraza(persona, "Imp. ArchCajas Servlet","EXCEPTION-1: COMPROBAR FICH CARGADO --> " + e1, m05bConstantes.LOG_NIVEL_BAJO);
	  		}
			miLog.addTraza(ex);
	  		throw new Exception(ex);
	   } finally{
	   	    try {
	   	    	if (rs != null)
	   	    		rs.close();
				if (pstmt != null)
					pstmt.close();
			} catch (SQLException e2) {
	       		miLog.addTraza(persona, "Imp. ArchCajas Servlet","EXCEPTION-2: COMPROBAR FICH CARGADO --> " + e2, m05bConstantes.LOG_NIVEL_BAJO);
	  		}
	   }
	   //miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC,"FECHA: " + fecha, m05bConstantes.LOG_NIVEL_BAJO);
	   return fecha;
} // Fin funcion fncComprobarFichCargado


public void fncBorrarKutxak() throws java.lang.Exception {
	   String sql;
	   PreparedStatement pstmt = null;

	   // Borrar el contenido de la tabla M0516T00
	   try  {
		   sql = "delete from " +  m05bConstantes.TAB_KUTXAK ;
	       pstmt = conn.prepareStatement(sql);
		   pstmt.executeUpdate();
	  } catch (Exception ex) {
			try {
	  			conn.rollback();  // Ha habido problemas, se deshacen todos los cambios
	  			throw new Exception(ex);
	  		} catch (SQLException e1){
	       		miLog.addTraza(persona, "Imp. ArchCajas Servlet","EXCEPTION-1: BORRAR KUTXAK --> " + e1, m05bConstantes.LOG_NIVEL_BAJO);
	  		}
	   } finally{
	   	    try {
				if (pstmt != null)
					pstmt.close();
			} catch (SQLException e2) {
	       		miLog.addTraza(persona, "Imp. ArchCajas Servlet","EXCEPTION-2: BORRAR KUTXAK --> " + e2, m05bConstantes.LOG_NIVEL_BAJO);
	  		}
	   }
} // Fin funcion fncBorrarKutxak

public String obtenerDatosTarjeta(String tarjeta, String centro, String fecha) throws java.lang.Exception {
	   String matricula="", matriculaTemp="",centroTarj="",centroTarjTemp="", fechaBajaTemp="",fechaAltaTemp="",sql;
	   int nFechaBajaTemp,nFechaAltaTemp,nFecha;
	   nFecha=Integer.parseInt(fecha);
	   PreparedStatement pstmt = null;
	   ResultSet rs=null;
	   // Obtiene la matrcula y el centro actual a partir de la tarjeta

	   try  {
			sql = "select " + m05bConstantes.COL_14_MATRICULA + ", " + m05bConstantes.COL_14_CTRO +", DECODE(TO_CHAR("+m05bConstantes.COL_14_FBAJA+",'YYYYMMDD'),'','00000000',TO_CHAR("+m05bConstantes.COL_14_FBAJA+",'YYYYMMDD')),TO_CHAR("+m05bConstantes.COL_14_FALTA+",'YYYYMMDD') "+
				  " from " + m05bConstantes.TAB_HIST_TARJETAS +
				  " where " + m05bConstantes.COL_14_TARJETA + " = '" + tarjeta + 
				  "' AND "+m05bConstantes.COL_14_FALTA+"<= TO_DATE('"+fecha+"','YYYYMMDD') order by " + m05bConstantes.COL_14_FALTA+" asc,3 desc";
			  //if (tarjeta.equals("5020950006341987"))
			  //{
				  //miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC,"sql: " + tarjeta, m05bConstantes.LOG_NIVEL_BAJO);							  
			  //}
		   
	       pstmt = conn.prepareStatement(sql);
		   rs=pstmt.executeQuery();
		   String Encontrado="0";
		   while ((rs.next())&& (Encontrado.equals("0"))){

	        	    matriculaTemp= rs.getString(1)==null?"null":rs.getString(1);

	        	    centroTarjTemp=rs.getString(2);
	        	    fechaBajaTemp=rs.getString(3);
	        	    fechaAltaTemp=rs.getString(4);
	        	    //if (tarjeta.equals("5020970005805188")){
	        	    	//miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC,"centroTarjTemp : " + centroTarjTemp, m05bConstantes.LOG_NIVEL_BAJO);
	        	    	//miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC,"fechaBajaTemp : " + fechaBajaTemp, m05bConstantes.LOG_NIVEL_BAJO);
	        	    //}
	        	    nFechaBajaTemp= Integer.parseInt(fechaBajaTemp);
	        	    nFechaAltaTemp= Integer.parseInt(fechaAltaTemp);
	        	    if ((nFechaBajaTemp <= nFecha) || (nFechaAltaTemp<=nFecha)){
	        	    	matricula=matriculaTemp;
	        	    	centroTarj=centroTarjTemp;
	        	    	if (nFechaAltaTemp==nFecha){
	        	    		Encontrado="1";
	        	    	}
	        	    }

	 	   }
	 	   // Comprobar que los centros asociados a tarjetas coinciden con el centro 
	 	   //	   que tiene la tarjeta asociado en la tabla M0531T00
	 	   if (!centro.equals(centroTarj))  {
	 	   	   //miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC,"CENTRO NO COINCIDENTE: " + tarjeta + " TARJETA: " + centroTarj + " - FICHERO: " + centro, m05bConstantes.LOG_NIVEL_BAJO);
			   bCentros = true;
	 	   }
	   } catch (Exception ex) {
			try {
	  			conn.rollback();  // Ha habido problemas, se deshacen todos los cambios
	  			throw new Exception(ex);
	  		} catch (SQLException e1){
	       		miLog.addTraza(persona, "Imp. ArchCajas Servlet","Exception-e1: OBTENER DATOS TARJETA --> " + e1, m05bConstantes.LOG_NIVEL_BAJO);
	  		}
			miLog.addTraza(ex);
 			throw new Exception(ex);
	   } finally{
	   	    try {
				if (rs != null)
					rs.close();
				if (pstmt != null)
					pstmt.close();
			} catch (SQLException e2) {
    	   		miLog.addTraza(persona, "Imp. ArchCajas Servlet","Exception-e2: OBTENER DATOS TARJETA --> " + e2, m05bConstantes.LOG_NIVEL_BAJO);
	  		}
	   }
	   miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC,"matricula: " + matricula, m05bConstantes.LOG_NIVEL_BAJO);	   
   	   return matricula;
} // Fin funcion obtenerDatosTarjeta


public String fncCasamientoGastos(String matricula, String concepto) throws java.lang.Exception {
	// Proceso de casamiento de gastos
		// Poner en M0518T00 valor a la columna Verificado segun contenido en tabla M0534T00
	
	   String verificado=m05bConstantes.VERIFICADO_NO;
	   String rango="";
	   String sql;
	   PreparedStatement pstmt = null;
	   ResultSet rs=null;

	   try  {
			sql = "select " + m05bConstantes.COL_34_RANGO +
				  " from " + m05bConstantes.TAB_VEHICULOS +
				  " where " + m05bConstantes.COL_34_MATRICULA + " = '" + matricula + "'";
			//miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC,"SQL CASAMIENTO GASTOS: " + sql, m05bConstantes.LOG_NIVEL_BAJO);
	       pstmt = conn.prepareStatement(sql);
		   rs=pstmt.executeQuery();
		   if (rs.next()){
	        	    rango= rs.getString(1);
   	    	        //miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC,"   ........   Rango Casamiento: " + rango , m05bConstantes.LOG_NIVEL_BAJO);
   	    	        //miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC,"   ........   Tipo Casamiento: " + concepto , m05bConstantes.LOG_NIVEL_BAJO);
					if ((concepto.substring(0,1).equals(m05bConstantes.GASTO_PEAJE) && 
						 	  	(((rango.indexOf("B"))==0) ||(rango.equals("VR")) || (rango.equals("X")) 
						 	  		|| ((rango.indexOf("C"))==0) || ((rango.indexOf("A"))==0)))) {
						 verificado=m05bConstantes.VERIFICADO_SI;
    	    	        //miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC,"   ..............   VERIFICADO", m05bConstantes.LOG_NIVEL_BAJO);
					}
	 	   }
	 	   
	   } catch (Exception ex) {
			try {
	  			conn.rollback();  // Ha habido problemas, se deshacen todos los cambios
	  			throw new Exception(ex);
	  		} catch (SQLException e1){
	       		miLog.addTraza(persona, "Imp. ArchCajas Servlet","Exception-1: CASAMIENTO GASTOS --> " + e1, m05bConstantes.LOG_NIVEL_BAJO);
	  		}
			miLog.addTraza(ex);
	   } finally{
	   	    try {
	   	    	if (rs != null)
	   	    		rs.close();
				if (pstmt != null)
					pstmt.close();
			} catch (SQLException e2) {
	       		miLog.addTraza(persona, "Imp. ArchCajas Servlet","Exception-2: CASAMIENTO GASTOS --> " + e2, m05bConstantes.LOG_NIVEL_BAJO);
	  		}
	   }
   	   return 	verificado;
} // Fin funcion fncCasamiento

public void fncCasamientoGastos18_09() throws java.lang.Exception {
	// Proceso de casamiento de gastos
		// Poner en M0518T00 valor a la columna Verificado segun contenido en tabla M0534T00
	
	   String verificado=m05bConstantes.VERIFICADO_NO;
	   String rango="";
	   String sql;
	   PreparedStatement pstmt = null;


	   try  {
			sql = "UPDATE " + m05bConstantes.TAB_OPEBANCOS+ " SET "+ m05bConstantes.COL_18_VERIFIC +"='" + m05bConstantes.VERIFICADO_SI +"' WHERE  " + m05bConstantes.COL_18_VERIFIC + "='" + m05bConstantes.VERIFICADO_NO + "'" +
				" AND " +  m05bConstantes.COL_18_MATRICULA + "||" + m05bConstantes.COL_18_TARJETA + "|| TO_CHAR(" + m05bConstantes.COL_18_FECHA + ",'YYYYmmdd')||" + m05bConstantes.COL_18_CARGO + " in (select " + 
				m05bConstantes.COL_09_MATRICULA+"||"+m05bConstantes.COL_09_TARJETA+"|| TO_CHAR("+ m05bConstantes.COL_09_FECHA+",'YYYYmmdd')||"+m05bConstantes.COL_09_CARGO+ " from " +m05bConstantes.TAB_GASTOS+","+m05bConstantes.TAB_VEHICULOS+
				"  where "+m05bConstantes.COL_09_MATRICULA+" = "+m05bConstantes.COL_34_MATRICULA +" and " + m05bConstantes.COL_34_RANGO + " like 'C%')";
			//miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC,"SQL CASAMIENTO GASTOS: " + sql, m05bConstantes.LOG_NIVEL_BAJO);
	       pstmt = conn.prepareStatement(sql);
		   pstmt.executeUpdate();
		 
		
	 	   
	   } catch (Exception ex) {
			try {
	  			conn.rollback();  // Ha habido problemas, se deshacen todos los cambios
	  			throw new Exception(ex);
	  		} catch (SQLException e1){
	       		miLog.addTraza(persona, "Imp. ArchCajas Servlet","Exception-1: CASAMIENTO GASTOS --> " + e1, m05bConstantes.LOG_NIVEL_BAJO);
	  		}
			miLog.addTraza(ex);
	   } finally{
	   	    try {
				if (pstmt != null)
					pstmt.close();
			} catch (SQLException e2) {
	       		miLog.addTraza(persona, "Imp. ArchCajas Servlet","Exception-2: CASAMIENTO GASTOS --> " + e2, m05bConstantes.LOG_NIVEL_BAJO);
	  		}
	   }
  
} // Fin funcion fncCasamiento18-09

public String fncCargarKutxak(String inputLine, long ctrldupl) throws java.lang.Exception {
	   String sql, rdo="ok";
	   PreparedStatement pstmt = null;
	   String ueconomica="", centro="", mege="", tarjeta="", tipo="", sqlConcepto="",
	   		  cif="", comercio="", descrip="", fecha="", hora="",
	   		  importe="", cargabon="", matricula="", verificado=m05bConstantes.VERIFICADO_NO;
	   
	       //miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC,"	", m05bConstantes.LOG_NIVEL_BAJO);
	       //miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC,"\n******   CARGAR KUTXAK CON: " +  inputLine, m05bConstantes.LOG_NIVEL_BAJO);
	       //miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC,"\n******   CARGAR KUTXAK CON LONG : " +  inputLine.length(), m05bConstantes.LOG_NIVEL_BAJO);
	
	// Meter en la tabla M0516T00 el contenido del fichero
	   try  {
           	   // Coger valores para actualizar la tabla KUTXAK
               ueconomica=inputLine.substring(1,2);
               centro=inputLine.substring(2,5);
               mege=inputLine.substring(5,11);
               tarjeta=inputLine.substring(11,27);
               tipo=inputLine.substring(27,28);
               //Obtenemos la descripcion de nuestra tabla 99
               sqlConcepto = "(SELECT DESCRIP_99 FROM M0599T00 WHERE COD_TAB_99 ='2' AND COD_DESC_99='"+tipo+"')";
               //concepto=inputLine.substring(28,47);
	   		   cif=inputLine.substring(47,56);
	   		   comercio=inputLine.substring(56,65);
	   		   descrip=inputLine.substring(65,95);
	   		   fecha=inputLine.substring(95,103);
	   		   hora=inputLine.substring(103,107);
	   		   importe=inputLine.substring(107,116);
	   		   importe=miComun.ImporteFicheroABasedatos(importe);
	   		   cargabon=inputLine.substring(116,117);
	   		   //miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC," -----   Matricula: " + matricula, m05bConstantes.LOG_NIVEL_BAJO);
			   //miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC," -----   fecha: " + fecha, m05bConstantes.LOG_NIVEL_BAJO);	   		   
	   		   //miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC,"CARGAR KUTXAK:   C/A - " + cargabon, m05bConstantes.LOG_NIVEL_BAJO);
	   		   // Los abonos (Tipo= A) llevaran importe con signo negativo
			   if (cargabon.equals(m05bConstantes.TAR_ABONO))  {
			   	   importe = "-" + importe;
			   }
	   		   //miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC,"CARGAR KUTXAK:   IMPORTE: " + importe, m05bConstantes.LOG_NIVEL_BAJO);
	   		   matricula=obtenerDatosTarjeta(tarjeta,centro,fecha);
	   		   if (matricula.equals("")) {
	   		   	   rdo="";
	   		   } else if (matricula.equals("null")) {
	   		   	   rdo="null";
	   		   } else {
		               // Actualizar la base de datos
		               sql = " insert into " + m05bConstantes.TAB_KUTXAK  +
		               	   	" ( " + m05bConstantes.COL_16_UCONOMICA + ",  " + m05bConstantes.COL_16_CENTRO + ",  " + m05bConstantes.COL_16_MEGE + 
		               	    ",  " + m05bConstantes.COL_16_TARJETA + ",  " + m05bConstantes.COL_16_TIPO + ",  " + m05bConstantes.COL_16_CONCEPTO + 
		               	    ",  " + m05bConstantes.COL_16_CIF + ",  " + m05bConstantes.COL_16_COMERCIO + ",  " + m05bConstantes.COL_16_DESCRIPCION + 
		               	    ",  " + m05bConstantes.COL_16_FECHA + ",  " + m05bConstantes.COL_16_HORA + ",  " + m05bConstantes.COL_16_IMPORTE + 
		               	    ",  " + m05bConstantes.COL_16_CARG_ABON + ",  " + m05bConstantes.COL_16_MATRICULA + ")" +
				 		 	" values (?, ?, ?, ?, ?,"+sqlConcepto+ ", ?, ?, ?, ?, ?,"+importe+ ", ?, ?)";
		                    //" values ( ?,?,?,?,?,?,?,?,?,?,?,?,?,? )";
		               //if (tarjeta.equals("5020950006341987")){
				       	   //miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC,"CARGAR KUTXAK: INSERT M0516T00: " + sql , m05bConstantes.LOG_NIVEL_BAJO);		            	   
		               //}
			           pstmt = conn.prepareStatement(sql);
					   pstmt.setString(1,ueconomica);
					   pstmt.setString(2,centro);			           
					   pstmt.setString(3,mege);			         
					   pstmt.setString(4,tarjeta);	
					   pstmt.setString(5,tipo);	
					   //pstmt.setString(6,sqlConcepto);	
					   pstmt.setString(6,cif);	
					   pstmt.setString(7,comercio);	
					   pstmt.setString(8,descrip);	
					   pstmt.setString(9,fecha);	
					   pstmt.setString(10,hora);	
					   //pstmt.setString(11,importe);	
					   pstmt.setString(11,cargabon);	
					   pstmt.setString(12,matricula);	
				       pstmt.executeUpdate();
				       pstmt.close();
				       
    	  		// Hacer la carga de M0516T00 a M0518T00 poniendo formato fecha-hora
					   verificado=fncCasamientoGastos(matricula,tipo);
		               sql = " insert into " + m05bConstantes.TAB_OPEBANCOS  +
		               	   	" ( " + m05bConstantes.COL_18_TARJETA + ",  " + m05bConstantes.COL_18_TIPO + ",  " + m05bConstantes.COL_18_CONCEPTO + 
		               	    ",  " + m05bConstantes.COL_18_ESTAB + ",  " + m05bConstantes.COL_18_FECHA + ",  " + m05bConstantes.COL_18_IMPORTE + 
		               	    ",  " + m05bConstantes.COL_18_VERIFIC + ",  " + m05bConstantes.COL_18_CARGO + ",  " + m05bConstantes.COL_18_MATRICULA + 
		               	    ",  " + m05bConstantes.COL_18_CONTROL + ",  " + m05bConstantes.COL_18_ESTCIF + ",  " + m05bConstantes.COL_18_CENTRO +
		               	    ",  " + m05bConstantes.COL_18_UECONO + ",  " + m05bConstantes.COL_18_NCOMERCIO +","+m05bConstantes.COL_18_KM+","+m05bConstantes.COL_18_LITROS+")" +
		            	 	" values (?, ?, " + sqlConcepto +
				 		 	",?, TO_DATE(?,'YYYYMMDD HH24MI'), " + importe + 
				 		 	", ?,?, ?, " + ctrldupl + ", ?, ?,?, ?,null,null)";
				 		 	//" values (?,?,'"+sqlConcepto+ "', ?, TO_DATE(?,'YYYYMMDD HH24MI'), "+importe+", ?, ?, ?, " + ctrldupl + ",?, ?, ?,?,null,null)";
			       	   //miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC,"CARGAR KUTXAK: INSERT M0518T00: " + sql , m05bConstantes.LOG_NIVEL_BAJO);
			           pstmt = conn.prepareStatement(sql);
					   pstmt.setString(1,tarjeta);
					   pstmt.setString(2,tipo);			           
					   //pstmt.setString(3,sqlConcepto);			         
					   pstmt.setString(3,descrip);	
					   pstmt.setString(4,fecha+" "+hora);	
					   //pstmt.setString(6,importe);	
					   pstmt.setString(5,verificado);	
					   pstmt.setString(6,cargabon);	
					   pstmt.setString(7,matricula);	
					   pstmt.setString(8,cif);	
					   pstmt.setString(9,centro);	
					   pstmt.setString(10,ueconomica);	
					   pstmt.setString(11,comercio);	
				       pstmt.executeUpdate();
				}      
	   } catch (Exception ex) {
			try {
	  			conn.rollback();  // Ha habido problemas, se deshacen todos los cambios
	  			throw new Exception(ex);
	  		} catch (SQLException e1){
	       		miLog.addTraza(persona, "Imp. ArchCajas Servlet","Exception-1: CARGAR KUTXAK --> " + e1, m05bConstantes.LOG_NIVEL_BAJO);
	  		}
			miLog.addTraza(ex);
  			throw new Exception(ex);
	   } finally{
	   	    try {
				if (pstmt != null)
					pstmt.close();
			} catch (SQLException e2) {
	       		miLog.addTraza(persona, "Imp. ArchCajas Servlet","Exception-2: CARGAR KUTXAK --> " + e2, m05bConstantes.LOG_NIVEL_BAJO);
	  		}
	   }
	   //miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC,"CARGAR KUTXAK RDO: " + rdo, m05bConstantes.LOG_NIVEL_BAJO);
	   return rdo;
} // Fin funcion fncCargarKutxak

public boolean fncComprobarDuplicados() throws java.lang.Exception {
	// Comprobar duplicados por matrcula, fecha, hora y cantidad 

	   String sql;
	   PreparedStatement pstmt = null;
	   ResultSet rs=null;
	   boolean duplic = false;
	   // Obtiene la matrcula y el centro a partir de la tarjeta

	   try  {
			sql = "select distinct(" + m05bConstantes.COL_16_MATRICULA + ") " + 
				  " from " + m05bConstantes.TAB_KUTXAK +
				  " group by " + m05bConstantes.COL_16_MATRICULA  + ", " + m05bConstantes.COL_16_FECHA +
				  ", " + m05bConstantes.COL_16_HORA + ", " + m05bConstantes.COL_16_IMPORTE +
				  " having count(" + m05bConstantes.COL_16_MATRICULA + ") > 1" ;
	      // miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC,"SELECT MATRICULAS DUPLICADAS: " + sql , m05bConstantes.LOG_NIVEL_BAJO);
	       pstmt = conn.prepareStatement(sql);
		   rs=pstmt.executeQuery();
		   if (rs.next()){
	        	    duplic=true;
	 	   }  else {
	        	    duplic=false;
	 	   }  miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC,"      _________   Duplicados: " + duplic, m05bConstantes.LOG_NIVEL_BAJO);
	   } catch (Exception ex) {
			try {
	  			conn.rollback();  // Ha habido problemas, se deshacen todos los cambios
	  			throw new Exception(ex);
	  		} catch (SQLException e1){
	       		miLog.addTraza(persona, "Imp. ArchCajas Servlet","Exception-1: COMPROBAR DUPLICADOS --> " + e1, m05bConstantes.LOG_NIVEL_BAJO);
	  		}
			miLog.addTraza(ex);
	   } finally{
	   	    try {
	   	    	if (rs != null)
	   	    		rs.close();
				if (pstmt != null)
					pstmt.close();
			} catch (SQLException e2) {
	       		miLog.addTraza(persona, "Imp. ArchCajas Servlet","Exception-2: COMPROBAR DUPLICADOS --> " + e2, m05bConstantes.LOG_NIVEL_BAJO);
	  		}
	   }
	   return duplic;
} // Fin funcion fncComprobarDuplicados


public void fncBorrarCargaGastosTarjetas(String id) throws java.lang.Exception {
	   String sql;
	   PreparedStatement pstmt = null;
	
   	// Insertar un registro en la tabla M0516T00
	   try  {
		   sql = "delete from " +  m05bConstantes.TAB_CARGAGASTOSTARJETAS +
		   			" where " + m05bConstantes.COL_43_ID + " = " + id ;
	       //miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC,"BORRAR CARGA GASTOS TARJETAS: " + sql , m05bConstantes.LOG_NIVEL_BAJO);
	       pstmt = conn.prepareStatement(sql);
		   pstmt.executeUpdate();
	   } catch (Exception ex) {
			try {
	  			conn.rollback();  // Ha habido problemas, se deshacen todos los cambios
	  			throw new Exception(ex);
	  		} catch (SQLException e1){
	       		miLog.addTraza(persona, "Imp. ArchCajas Servlet","Exception-1: BORRAR CARGA GASTOS TARJETAS --> " + e1, m05bConstantes.LOG_NIVEL_BAJO);
	  		}
			miLog.addTraza(ex);
	   } finally{
	   	    try {
				if (pstmt != null)
					pstmt.close();
			} catch (SQLException e2) {
	       		miLog.addTraza(persona, "Imp. ArchCajas Servlet","Exception-2: BORRAR CARGA GASTOS TARJETAS --> " + e2, m05bConstantes.LOG_NIVEL_BAJO);
	  		}
	   }
} // Fin funcion fncBorrarCargaGastosTarjetas

public void fncActCargaGastosTarjetas(String id, String primerReg, int numRegistros) throws java.lang.Exception {
	   String sql;
	   PreparedStatement pstmt = null;
	
   	// Insertar un registro en la tabla M0516T00
	   try  {
		   sql = "update " +  m05bConstantes.TAB_CARGAGASTOSTARJETAS +
		   			" set " + m05bConstantes.COL_43_PRIMERREG + " = '" + primerReg + "'" +
		   			", " + m05bConstantes.COL_43_NUMREG + " = '" + numRegistros + "'" +
		   			" where " + m05bConstantes.COL_43_ID + " = " + id ;
	       //miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC,"CARGA GASTOS TARJETAS: " + sql , m05bConstantes.LOG_NIVEL_BAJO);
	       pstmt = conn.prepareStatement(sql);
		   pstmt.executeUpdate();
	   } catch (Exception ex) {
			try {
	  			conn.rollback();  // Ha habido problemas, se deshacen todos los cambios
	  			throw new Exception(ex);
	  		} catch (SQLException e1){
	       		miLog.addTraza(persona, "Imp. ArchCajas Servlet","Exception-1: INSERTAR CARGA GASTOS TARJETAS --> " + e1, m05bConstantes.LOG_NIVEL_BAJO);
	  		}
			miLog.addTraza(ex);
	   } finally{
	   	    try {
				if (pstmt != null)
					pstmt.close();
			} catch (SQLException e2) {
	       		miLog.addTraza(persona, "Imp. ArchCajas Servlet","Exception-2: INSERTAR CARGA GASTOS TARJETAS --> " + e2, m05bConstantes.LOG_NIVEL_BAJO);
	  		}
	   }
} // Fin funcion fncActCargaGastosTarjetas


/**
 * Process incoming requests for information
 *
 * @param request Object that encapsulates the request to the servlet
 * @param response Object that encapsulates the response from the servlet
 */
public void performTask(javax.servlet.http.HttpServletRequest request, javax.servlet.http.HttpServletResponse response) {

       String inputLine="", sql, pathFichero="", primerReg="", id="", fecha="", rdoKutxak="";
	   BufferedReader bf=null;
	   StringBuffer sb = null;	   
	   java.sql.Clob lob = null;
	   int numRegistros=0;
	   String urlServlet="";
	   boolean bContinuar=true, bDuplicados=false;
	   
       try  {
            HttpSession session = request.getSession(true);
       	    persona = (String) session.getAttribute("persona");

       	    // Conexion
       		conn = miConex.getConnection();       	   	   
       	    conn.setAutoCommit(false);  // Al final si todo ha ido bien se hace commit    
       	    
	   	    pathFichero = request.getParameter("Fichero");
	   	    id=request.getParameter("Id");
			m05bGenerarClave miId = new m05bGenerarClave();
			idOpeBancos = miId.getNextId(m05bConstantes.TAB_OPEBANCOS, m05bConstantes.COL_18_CONTROL);
	   	    
		// Comprobar que el fichero exista en la ruta indicada  (si no esta da error al abrir)
	       	miLog.addTraza(persona, "IMPORTAR ARCHIVOS CAJAS", "INICIO", m05bConstantes.LOG_NIVEL_BAJO);
	       	miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC,"......   LEER FICHERO", m05bConstantes.LOG_NIVEL_BAJO);
            lob = fncLeerCLOB(id);
	       	miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC,"......   TRATAR FICHERO", m05bConstantes.LOG_NIVEL_BAJO);
			sb = new StringBuffer(100);
			bf = new BufferedReader(new InputStreamReader( ( (Clob)	lob).getAsciiStream()));
	       	miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC,"......   PRIMER REGISTRO", m05bConstantes.LOG_NIVEL_BAJO);
			if ( (inputLine = bf.readLine().replaceAll("", "")) != null) {
	           		// Comprobar si el fichero ya ha sido cargado anteriormente
	       			miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC,"         ------   COMPROBAR SI FICHERO CARGADO", m05bConstantes.LOG_NIVEL_BAJO);
    				primerReg=inputLine;
    				fecha=fncComprobarFichCargado(primerReg);
					if (!(fecha.equals(""))) {
						// Si ha sido cargado ...Mensaje, listado y terminar		       				
							miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC,"         ------   FECHA CARGA: " + fecha, m05bConstantes.LOG_NIVEL_BAJO);						
							fncBorrarCargaGastosTarjetas(id);
	         	    		conn.commit();
				  		//	System.out.println("SQLEXception1erCommit");
	         	    		//response.sendRedirect("m05bCargasCajasPDFJsp.jsp?Fecha="+fecha);
				  			//urlServlet="m05bCargasCajasPDFJsp.jsp";
				  			fecha=fecha.replace(' ','_');
				  			response.sendRedirect("m05bLisResulImportarJsp.jsp?Fecha="+fecha+"&Informe=1");
	         	    		bContinuar=false;
					} else  {
						// Si no ha sido cargado ...
	       					miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC,"         ------   BORRAR KUTXAK", m05bConstantes.LOG_NIVEL_BAJO);
				    	 	fncBorrarKutxak();
				    		// Tratamiento del primer registro
	       					miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC,"         ------   CARGAR KUTXAK", m05bConstantes.LOG_NIVEL_BAJO);
							rdoKutxak=fncCargarKutxak(inputLine, idOpeBancos);
							++idOpeBancos;
							if (rdoKutxak.equals("ok")) {
			         	            ++numRegistros;
			         	    } else if (rdoKutxak.equals(""))  {
			         	    	miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC,"rdoKutxak: " + rdoKutxak, m05bConstantes.LOG_NIVEL_BAJO);	   			         	    	
			         	    		miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC,"Servlet ID-1  --  " + id, m05bConstantes.LOG_NIVEL_BAJO);
			         	    	//	System.out.println("Pasa por el primer m05bTarjCajasPDFJsp.jsp");
			         	    		bContinuar=false;
			         	    		conn.rollback();
			         	    		//response.sendRedirect("m05bTarjCajasPDFJsp.jsp?Id="+id);
			         				//urlServlet="m05bTarjCajasPDFJsp.jsp_Id="+id;
						  			response.sendRedirect("m05bLisResulImportarJsp.jsp?Informe=2&Id="+id);
			         	   } else if (rdoKutxak.equals("null"))  {
			         	    		miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC,"Servlet ID-1  --  NULL  " + id, m05bConstantes.LOG_NIVEL_BAJO);
			         	    		bContinuar=false;
			         	    		conn.rollback();
			         	    		//response.sendRedirect("m05bTarjNoMatricCajasPDFJsp.jsp?Id="+id);
			         				//urlServlet="m05bTarjNoMatricCajasPDFJsp.jsp_Id="+id;
						  			response.sendRedirect("m05bLisResulImportarJsp.jsp?Informe=3&Id="+id);			         	    		
			         	    		
			         	    }
			         	    
			         	    if (bContinuar)  {
					    		// Tratamiento del resto del fichero
		       					miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC,"......   RESTO FICHERO", m05bConstantes.LOG_NIVEL_BAJO);
								while ( ((inputLine = bf.readLine()) != null) && (bContinuar) ) {
								inputLine=inputLine.replaceAll("", "");
								  if (!(inputLine.equals(""))){
									rdoKutxak=fncCargarKutxak(inputLine, idOpeBancos);
									++idOpeBancos;
									if (rdoKutxak.equals("ok")) {
					         	            ++numRegistros;
					         	    } else if (rdoKutxak.equals(""))  {
					         	    		miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC,"Servlet ID-2  --  " + id, m05bConstantes.LOG_NIVEL_BAJO);
					         	    		bContinuar=false;
					         	    		conn.rollback();
					         	    		//response.sendRedirect("m05bTarjCajasPDFJsp.jsp?Id="+id);
					         				//urlServlet="m05bTarjCajasPDFJsp.jsp_Id="+id;
								  			response.sendRedirect("m05bLisResulImportarJsp.jsp?Informe=2&Id="+id);			         	    		
					         	    							         	    		
					         	    } else if (rdoKutxak.equals("null"))  {
					         	    		miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC,"Servlet ID-2  --  NULL  " + id, m05bConstantes.LOG_NIVEL_BAJO);
					         	    		bContinuar=false;
					         	    		conn.rollback();
					         	    		//response.sendRedirect("m05bTarjNoMatricCajasPDFJsp.jsp?Id="+id);
					         				//urlServlet="m05bTarjNoMatricCajasPDFJsp.jsp_Id="+id;
								  			response.sendRedirect("m05bLisResulImportarJsp.jsp?Informe=3&Id="+id);			         	    							         	    		
					         	    		
					         	   }
								  }
		         	    		}
				         	    if (bContinuar)  {
				         	    	//inputLine.charAt(0);
			       					miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC,"         ------   ACTUALIZAR CARGA GASTOS TARJETAS", m05bConstantes.LOG_NIVEL_BAJO);
						        	fncActCargaGastosTarjetas(id,primerReg, numRegistros );
					       			miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC,"         ------   COMPROBAR DUPLICADOS", m05bConstantes.LOG_NIVEL_BAJO);
									bDuplicados=fncComprobarDuplicados();	
			       					fncCasamientoGastos18_09();
			       					conn.commit();
			       					if ((bCentros) && (bDuplicados)) {
						    			// Hay centros en fich distintos de tabla tarjetas
						    				// Con listado de duplicados
										//response.sendRedirect("m05bCentrosCajasPDFJsp.jsp?Id="+id+"&Duplic=true");
				         				//urlServlet="m05bCentrosCajasPDFJsp.jsp_Id="+id+"-Duplic=true";
				         				//miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC,"         ------   Informe=4", m05bConstantes.LOG_NIVEL_BAJO);				         				
							  			response.sendRedirect("m05bLisResulImportarJsp.jsp?Informe=4&Id="+id);		
							  			miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC,"         ------   Informe=4", m05bConstantes.LOG_NIVEL_BAJO);
			       					} else if (bCentros) {
						    			// Hay centros en fich distintos de tabla tarjetas
										//response.sendRedirect("m05bCentrosCajasPDFJsp.jsp?Id="+id+"&Duplic=false");
				         				//urlServlet="m05bCentrosCajasPDFJsp.jsp_Id="+id+"-Duplic=false";
							  			response.sendRedirect("m05bLisResulImportarJsp.jsp?Informe=5&Id="+id);			         	    		
			       					} else if (bDuplicados) {
						    			// Si existen duplicados por matr, fecha, hora y cantidad ...
										//response.sendRedirect("m05bDuplicCajasPDFJsp.jsp");
				         				//urlServlet="m05bDuplicCajasPDFJsp.jsp";
							  			response.sendRedirect("m05bLisResulImportarJsp.jsp?Informe=6");			         	    												
									} else {
				       					miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC,"PROCESO HA FINALIZADO OK", m05bConstantes.LOG_NIVEL_BAJO);
				       					//Si todo ha ido bien se actualizan los cambios en la BD
				       					response.sendRedirect("m05bImportCajasJsp.jsp?Mensaje=" + m05bConstantes.MSG_OK);
									}
						        }
					        }
					}
	        } else {
		  	  		miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC,"         ------   FICHERO VACIO", m05bConstantes.LOG_NIVEL_BAJO);
	        }

       } 	catch (java.io.FileNotFoundException fnfex) {
     			miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC,"PerformTask EXCEPTION-1: Archivo no encontrado: " + fnfex, m05bConstantes.LOG_NIVEL_BAJO);
     			try {
					response.sendRedirect("m05bError.jsp");
				} catch (IOException e) {
					// TODO Auto-generated catch block
					miLog.addTraza(e);
				}
       }	catch(java.io.IOException ioex) {
   				miLog.addTraza(persona, "Imp. ArchCajas Servlet","EXCEPTION-2: java.io.IOException: " + ioex, m05bConstantes.LOG_NIVEL_BAJO);	   	
   				try {
					response.sendRedirect("m05bError.jsp");
				} catch (IOException e) {
					// TODO Auto-generated catch block
					miLog.addTraza(e);
				}
       }	catch (Exception SQLException) {
					try {
			  			conn.rollback();  // Ha habido problemas, se deshacen todos los cambios
			  		} catch (SQLException e2){
			       		miLog.addTraza(persona, "Imp. ArchCajas Servlet","EXCEPTION-2: " + e2, m05bConstantes.LOG_NIVEL_BAJO);
			  		}
				miLog.addTraza(SQLException);
				try {
					response.sendRedirect("m05bError.jsp");
				} catch (IOException e) {
					// TODO Auto-generated catch block
					miLog.addTraza(e);
				}
	   }	catch(Throwable theException)	{
   				miLog.addTraza(persona, "Imp. ArchCajas Servlet","EXCEPTION-2: Throwable: " + theException, m05bConstantes.LOG_NIVEL_BAJO);	   	
				miLog.addTraza(theException);
				try {
					response.sendRedirect("m05bError.jsp");
				} catch (IOException e) {
					// TODO Auto-generated catch block
					miLog.addTraza(e);
				}
	  } 	finally{
	  			try{
					miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC,"DESPUES COMMIT", m05bConstantes.LOG_NIVEL_BAJO);	  	
					if (conn != null)
						conn.close();
			  		} 
	  			catch (SQLException e){
				    miLog.addTraza(persona, "Imp. ArchCajas Servlet","EXCEPTION-3: " + e, m05bConstantes.LOG_NIVEL_BAJO);
				    try {
						response.sendRedirect("m05bError.jsp");
					} catch (IOException e1) {
						// TODO Auto-generated catch block
						miLog.addTraza(e1);
					}   	
	  			}
	   }
} // Fin funcion performTask
	
}  // Fin clse m05bImportarArchivosCajasServlet