package tarjetasServlet;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Locale;
import java.util.ResourceBundle;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import m05bClasses.m05bComun;
import m05bClasses.m05bConexion;
import m05bClasses.m05bConstantes;
import m05bClasses.m05bFileLog;

import org.apache.fop.apps.Driver;
import org.apache.fop.apps.FOPException;
import org.xml.sax.InputSource;

public class m05bImpTarjetasDptoServlet extends javax.servlet.http.HttpServlet {m05bFileLog miLog = new m05bFileLog();
	// java.sql.Connection conn=null;
	String sLinea;
	String sFoFileDir = "/datos/m05b/tmp/";
	File foFileDir;
	File tmpFoFile;
	FileOutputStream tmpFoFileStream;
	m05bComun miComun = new m05bComun();
	
	String sDpto = "";
	String sDptoCorto = "";
	String sDesDpto = "";
	String sSituacion = "";
	String sCount = "";
	String sTipoLis = "";
	String sTitTipoLis = "";

	public static final String FO_REQUEST_PARAM = "fo";

	// Logger log = null;

	public void doPost(javax.servlet.http.HttpServletRequest request,
			javax.servlet.http.HttpServletResponse response)
			throws javax.servlet.ServletException, java.io.IOException {
		try {
			doGet(request, response);
		} catch (Exception e) {
			miLog.addTraza(e);
		}
	}

	public void doGet(HttpServletRequest request, HttpServletResponse response)
			throws ServletException {
		performTask(request, response);
	}

	// if(log == null)
	// {
	// Hierarchy hierarchy = Hierarchy.getDefaultHierarchy();
	// log = hierarchy.getLoggerFor("fop");
	// log.setPriority(Priority.WARN);
	// }

	private void fncAbrirFicheroTemporal() throws java.io.IOException {
		foFileDir = new File(sFoFileDir);
		tmpFoFile = File.createTempFile("m05b", "Fo", foFileDir);
		tmpFoFileStream = new FileOutputStream(tmpFoFile);

	}

	private void fncImprimirFinPagina() throws java.io.IOException {
		sLinea = "	    </fo:table-body>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "       </fo:table>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "      </fo:flow>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "   </fo:page-sequence>\n";
		tmpFoFileStream.write(sLinea.getBytes());

	}

	private void fncImprimirComienzoPagina(ResourceBundle res, String idioma)
			throws java.io.IOException, javax.naming.NamingException {
		sLinea = "<fo:page-sequence master-reference=\"general\">\n";
		tmpFoFileStream.write(sLinea.getBytes());
		// REGION BEFORE
		sLinea = "		<fo:static-content flow-name=\"xsl-region-before\" >\n";
		tmpFoFileStream.write(sLinea.getBytes());
		// -------------- CABECERA DEL LISTADO --------------
		// Cabecera 1
		sLinea = "      <fo:block text-align=\"end\">\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "      </fo:block>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "      <fo:block font-weight=\"bold\" padding-top=\"10pt\">\n "
				+ res.getString("infTarjDep.titulo") + "</fo:block>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "      <fo:block font-size=\"8pt\" font-weight=\"bold\" padding-top=\"5pt\">\n <![CDATA["
				+ res.getString("infTarjDep.texto1")
				+ sDptoCorto
				+ " "
				+ sDesDpto
				+ "]]><fo:leader leader-pattern=\"space\" leader-length=\"100pt\"/>"
				+ res.getString("infTarjDep.texto2")
				+ sCount
				+ "<fo:leader leader-pattern=\"space\" leader-length=\"120pt\"/><![CDATA["
				+ res.getString("infTarjDep.texto3")
				+ sTitTipoLis
				+ "]]></fo:block>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = " 		</fo:static-content>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		// PIE DE PAGINA Pie
		sLinea = "		<fo:static-content flow-name=\"xsl-region-after\">\n";
		tmpFoFileStream.write(sLinea.getBytes());
		// PIE DE PAGINA Pie
		sLinea = "      <fo:block >\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "       <fo:table>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    <fo:table-column column-width=\"127mm\"/>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    <fo:table-column column-width=\"125mm\"/>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    <fo:table-body font-family=\"Helvetica\" font-size=\"6pt\">\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    <fo:table-row>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    <fo:table-cell >\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "      <fo:block text-align=\"left\">"
				+ miComun.getDetFechaActual(idioma) + "</fo:block>";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    </fo:table-cell>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    <fo:table-cell >\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "      <fo:block text-align=\"right\">";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = res.getString("pagina") + " <fo:page-number/> \n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "</fo:block>";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    </fo:table-cell>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    </fo:table-row>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    </fo:table-body>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "       </fo:table>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "      </fo:block>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = " 		</fo:static-content>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		// BODY
		sLinea = "	<fo:flow flow-name=\"xsl-region-body\">\n";
		tmpFoFileStream.write(sLinea.getBytes());
		Context ctx = new InitialContext(System.getProperties());
		// -------------- DETALLE DEL LISTADO --------------
		sLinea = "        <fo:table space-after.optimum=\"12pt\">\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    <fo:table-column column-width=\"20mm\"/>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    <fo:table-column column-width=\"80mm\"/>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    <fo:table-column column-width=\"30mm\"/>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    <fo:table-column column-width=\"41mm\"/>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    <fo:table-column column-width=\"51mm\"/>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    <fo:table-column column-width=\"20mm\"/>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    <fo:table-column column-width=\"10mm\"/>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    <fo:table-body font-family=\"Helvetica\" font-size=\"8pt\">\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    <fo:table-row>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		// Matricula
		sLinea = "	    <fo:table-cell padding-top=\"1mm\">\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "      <fo:block font-weight=\"bold\"  text-align=\"center\">\n "
				+ res.getString("infTarjDep.col1") + "</fo:block>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    </fo:table-cell>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		// Centro
		sLinea = "	    <fo:table-cell padding-top=\"1mm\">\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "      <fo:block font-weight=\"bold\" text-align=\"center\">\n "
				+ res.getString("infTarjDep.col2") + "" + "</fo:block>";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    </fo:table-cell>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		// Tarjeta
		sLinea = "	    <fo:table-cell padding-top=\"1mm\">\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "      <fo:block font-weight=\"bold\"  text-align=\"center\">\n "
				+ res.getString("infTarjDep.col3") + "</fo:block>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    </fo:table-cell>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		// Marca
		sLinea = "	    <fo:table-cell padding-top=\"1mm\">\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "      <fo:block font-weight=\"bold\"  text-align=\"center\">\n "
				+ res.getString("infTarjDep.col4") + "</fo:block>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    </fo:table-cell>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		// Modelo
		sLinea = "	    <fo:table-cell padding-top=\"1mm\">\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "      <fo:block font-weight=\"bold\"  text-align=\"center\">\n "
				+ res.getString("infTarjDep.col5") + "</fo:block>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    </fo:table-cell>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		// CodigoCentro
		sLinea = "	    <fo:table-cell padding-top=\"1mm\">\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "      <fo:block font-weight=\"bold\"  text-align=\"center\">\n "
				+ res.getString("infTarjDep.col6") + "</fo:block>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    </fo:table-cell>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		// Tipo
		sLinea = "	    <fo:table-cell padding-top=\"1mm\">\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "      <fo:block font-weight=\"bold\"  text-align=\"center\">\n "
				+ res.getString("infTarjDep.col7") + "</fo:block>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    </fo:table-cell>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    </fo:table-row>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    <fo:table-row >\n";
		tmpFoFileStream.write(sLinea.getBytes());

	}

	public void performTask(javax.servlet.http.HttpServletRequest request,
			javax.servlet.http.HttpServletResponse response)
			throws ServletException {
		java.sql.Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		PreparedStatement pstmt2 = null;
		ResultSet rs2 = null;
		// m05bComun miComun = new m05bComun();

		try {
			HttpSession session = request.getSession(true);
			ResourceBundle res = (ResourceBundle) session
					.getAttribute("resTit");
			/* Iker. idioma */
			Locale idiomaLocal = (Locale) session.getAttribute("Local");
			String idiomaSes = ((idiomaLocal.getLanguage() == null) ? "es"
					: idiomaLocal.getLanguage());

			String campoTexto3 = "C";
			String campoTexto2 = "";
			String campoTexto="";
			if (!idiomaSes.equals("es")){
				campoTexto2 = "E_";
				campoTexto3 = "E";
				campoTexto = "E";
			}
				
			m05bConexion miConex = new m05bConexion();
			conn = miConex.getConnection();

			// Obtencin de informacin de BD
			// Vehculo
			sDpto = request.getParameter("CodDpto");
			if (sDpto == null) {
				sDpto = "";
			}

			sSituacion = request.getParameter("Situacion");
			if ((sSituacion == null) || (sSituacion.equals(""))) {
				sSituacion = "";
			} else {
				sSituacion = miComun.ListaCaracteres(sSituacion);
			}
			sTipoLis = request.getParameter("TipoLis");
			if (sTipoLis == null) {
				sTipoLis = "0";
			}
			if (sTipoLis.equals("0")) {
				sTitTipoLis = "Todos";
			} else {
				if (sTipoLis.equals("G")) {
					sTitTipoLis = "Gastos";
				} else {
					sTitTipoLis = "Via T";
				}
			}
			String matricula = "";
			String sCodCentro = "";
			String sMatricula = "";
			String sMarca = "";
			String sModelo = "";
			String sTarjeta = "";
			String sDesCentro = "";
			String sTerritorio = "";
			String sDesDptoAnt = "";
			String sDptoAnt = "";
			String sTipo = "";
			String sDatosCount = " SELECT COUNT(*) ";
			String sDatos = " SELECT  NVL(" + campoTexto2+m05bConstantes.COL_06_DESCDPTO + ","
					+ m05bConstantes.COL_06_DESCDPTO + "),NVL("
					+ campoTexto+ m05bConstantes.COL_05_DESC + ","
					+ m05bConstantes.COL_05_DESC + "),"
					+ m05bConstantes.COL_31_TARJETA + ","
					+ m05bConstantes.COL_31_TAG + ","
					+ m05bConstantes.COL_31_MATRICULA + ","
					+ m05bConstantes.COL_31_CENTRO + "," + "SUBSTR("
					+ m05bConstantes.COL_05_CODIGO + ",1,2),M."
					+ m05bConstantes.COL_99_DESCRIPCION + ","
					+ m05bConstantes.COL_17_DESCRIP + ","
					+ m05bConstantes.COL_34_SITUACION + ", DECODE("
					+ m05bConstantes.COL_31_CENTRO + ",'039','1','0'),"
					+ m05bConstantes.COL_31_TIPO + ","
					+ m05bConstantes.COL_06_CODDPTO;
			String sWhere = " FROM " + m05bConstantes.TAB_TARJETAS + ","
					+ m05bConstantes.TAB_CENTROS + ","
					+ m05bConstantes.TAB_VEHICULOS + ","
					+ m05bConstantes.TAB_MODELOS + ","
					+ m05bConstantes.TAB_DESCRIPCIONES + " M ,"
					+ m05bConstantes.TAB_DEPARTAMENTOS + " WHERE "
					+ m05bConstantes.COL_31_CENTRO + "="
					+ m05bConstantes.COL_05_CODIGO + " AND "
					+ m05bConstantes.COL_31_MATRICULA + " = "
					+ m05bConstantes.COL_34_MATRICULA + " AND " + " ((( "
					+ m05bConstantes.COL_31_TARJETA + " ) Like '502%') "
					+ " AND " + " ((" + m05bConstantes.COL_31_SITUACION
					+ ")='A')) and " + m05bConstantes.COL_34_MODELO + "="
					+ m05bConstantes.COL_17_CODMOD + " AND M."
					+ m05bConstantes.COL_99_CODTABLA + "(+)='7' AND "
					+ m05bConstantes.COL_34_MARCA + "= M."
					+ m05bConstantes.COL_99_CODDESC + "(+) and " + " SUBSTR("
					+ m05bConstantes.COL_06_CODDPTO + ",1,2)=SUBSTR("
					+ m05bConstantes.COL_05_CODIGO + ",1,2)"
					+ " AND COD_DPTO_06 = CODDPTO_34 ";

			if (!(sTipoLis.equals("0"))) {
				sWhere = sWhere + " AND " + m05bConstantes.COL_31_TIPO + " = '"
						+ sTipoLis + "'";
			}
			if (sSituacion.equals("0")) {
				sWhere = sWhere + " AND " + m05bConstantes.COL_34_SITUACION
						+ " in (" + sSituacion + ")";
			}
			if (!(sSituacion.equals(""))) {
				sWhere = sWhere + " AND " + m05bConstantes.COL_34_SITUACION
						+ " in (" + sSituacion + ")";
			}
			if (!(sDpto.equals(""))) {
				sWhere = sWhere + " AND " + m05bConstantes.COL_06_CODDPTO
						+ " = '" + sDpto + "'";
				sWhere = sWhere + " AND " + m05bConstantes.COL_34_CODDPTO
						+ " = '" + sDpto + "'";
			}
			String sSentenciaCount = sDatosCount + sWhere;
			if (!(sDpto.equals(""))) {
				sWhere = sWhere + " AND  SUBSTR("
						+ m05bConstantes.COL_31_CENTRO + ",1,2)=SUBSTR('"
						+ sDpto + "',1,2)";
			}
			String sSentencia = sDatos + sWhere;
			sSentencia = sSentencia + " ORDER BY " + " SUBSTR("
					+ m05bConstantes.COL_05_CODIGO + ",1,2),DECODE("
					+ m05bConstantes.COL_31_CENTRO + ",'039','1','0'),"
					+ m05bConstantes.COL_06_DESCDPTO + ","
					+ m05bConstantes.COL_31_CENTRO + " asc";
			// System.out.println("m05b - ImpTarjetasDptoServlet" + sSentencia);

			miLog.addTraza(m05bConstantes.LOG_NO_USER,
					m05bConstantes.LOG_NO_SRC, "sSentencia: " + sSentencia,
					m05bConstantes.LOG_NIVEL_BAJO);

			pstmt = conn.prepareStatement(sSentencia);
			rs = pstmt.executeQuery();

			// String foParam = request.getParameter(FO_REQUEST_PARAM);
			fncAbrirFicheroTemporal();

			sLinea = "<?xml version=\"1.0\" encoding=\"windows-1252\"?>\n";
			tmpFoFileStream.write(sLinea.getBytes());

			sLinea = "<fo:root xmlns:fo=\"http://www.w3.org/1999/XSL/Format\">\n";
			tmpFoFileStream.write(sLinea.getBytes());
			// LAYOUT DEL LISTADO
			sLinea = "<fo:layout-master-set>\n";
			tmpFoFileStream.write(sLinea.getBytes());
			sLinea = "	<fo:simple-page-master master-name=\"general\"  page-height=\"21cm\" page-width=\"29.5cm\" margin-top=\"2cm\" margin-bottom=\"2cm\" margin-left=\"2cm\" margin-right=\"2cm\">\n";
			tmpFoFileStream.write(sLinea.getBytes());
			sLinea = "		<fo:region-before extent=\"2cm\"/>\n";
			tmpFoFileStream.write(sLinea.getBytes());
			sLinea = "		<fo:region-body  margin-top=\"2.8cm\" margin-bottom=\"1.5cm\" />\n";
			tmpFoFileStream.write(sLinea.getBytes());
			sLinea = "		<fo:region-after  extent=\"1cm\"/>\n";
			tmpFoFileStream.write(sLinea.getBytes());
			sLinea = "		<fo:region-start extent=\"0cm\"/>\n";
			tmpFoFileStream.write(sLinea.getBytes());
			sLinea = "		<fo:region-end extent=\"0cm\"/>\n";
			tmpFoFileStream.write(sLinea.getBytes());

			sLinea = "	</fo:simple-page-master>\n";
			tmpFoFileStream.write(sLinea.getBytes());

			sLinea = "</fo:layout-master-set>\n";
			tmpFoFileStream.write(sLinea.getBytes());
			int cont = 0;
			while (rs.next()) {
				sTarjeta = rs.getString(3) == null ? "" : rs.getString(3);
				sMatricula = rs.getString(5) == null ? "" : rs.getString(5);
				sMarca = rs.getString(8) == null ? "" : rs.getString(8);
				sModelo = rs.getString(9) == null ? "" : rs.getString(9);
				// sSalto = rs.getString(11)==null ? "":rs.getString(11);
				sDptoCorto = rs.getString(7) == null ? "" : rs.getString(7);
				sDpto = rs.getString(7) == null ? "" : rs.getString(13);
				sDesDpto = rs.getString(1) == null ? "" : rs.getString(1);
				sDesCentro = rs.getString(2) == null ? "" : rs.getString(2);
				sCodCentro = rs.getString(6) == null ? "" : rs.getString(6);
				sTipo = rs.getString(12) == null ? "" : rs.getString(12);

				if (((!(sDpto.equals(sDptoAnt)))) || (cont == 18)) {
					if (sDptoAnt != "") {
						fncImprimirFinPagina();
					}
					sSentenciaCount = "";
					sSentenciaCount = sDatosCount + sWhere;
					sSentenciaCount = sSentenciaCount + " AND  SUBSTR("
							+ m05bConstantes.COL_31_CENTRO + ",1,2)=SUBSTR('"
							+ sDpto + "',1,2)";

					sSentenciaCount = sSentenciaCount + " AND "
							+ m05bConstantes.COL_06_CODDPTO + " = '" + sDpto
							+ "'";
					sSentenciaCount = sSentenciaCount + " AND "
							+ m05bConstantes.COL_34_CODDPTO + " = '" + sDpto
							+ "'";

					pstmt2 = conn.prepareStatement(sSentenciaCount);
					rs2 = pstmt2.executeQuery();
					if (rs2.next()) {
						sCount = rs2.getString(1) == null ? "" : rs2
								.getString(1);
					}
					if (pstmt2 != null) {
						rs2.close();
						pstmt2.close();
					}
					fncImprimirComienzoPagina(res,campoTexto3);
					cont = 0;
				} else {
					cont = cont + 1;
					sLinea = "	    <fo:table-row >\n";
					tmpFoFileStream.write(sLinea.getBytes());
				}
				sDptoAnt = sDpto;
				// Matricula
				sLinea = "	    <fo:table-cell padding-top=\"2mm\" border-width=\"0.1mm\" border-style=\"solid\">\n";
				tmpFoFileStream.write(sLinea.getBytes());
				sLinea = "      <fo:block  text-align=\"center\">\n<![CDATA["
						+ sMatricula + "]]></fo:block>\n";
				tmpFoFileStream.write(sLinea.getBytes());
				sLinea = "	    </fo:table-cell>\n";
				tmpFoFileStream.write(sLinea.getBytes());
				// Centro
				sLinea = "	    <fo:table-cell padding-top=\"2mm\" border-width=\"0.1mm\" border-style=\"solid\">\n";
				tmpFoFileStream.write(sLinea.getBytes());
				sLinea = "      <fo:block  text-align=\"center\">\n <![CDATA["
						+ sDesCentro + "]]></fo:block>";
				tmpFoFileStream.write(sLinea.getBytes());
				sLinea = "	    </fo:table-cell>\n";
				tmpFoFileStream.write(sLinea.getBytes());
				// Tarjeta
				sLinea = "	    <fo:table-cell padding-top=\"2mm\" border-width=\"0.1mm\" border-style=\"solid\">\n";
				tmpFoFileStream.write(sLinea.getBytes());
				sLinea = "      <fo:block  text-align=\"center\">\n <![CDATA["
						+ sTarjeta + "]]></fo:block>\n";
				tmpFoFileStream.write(sLinea.getBytes());
				sLinea = "	    </fo:table-cell>\n";
				tmpFoFileStream.write(sLinea.getBytes());
				// Marca
				sLinea = "	    <fo:table-cell padding-top=\"2mm\" border-width=\"0.1mm\" border-style=\"solid\">\n";
				tmpFoFileStream.write(sLinea.getBytes());
				sLinea = "      <fo:block  text-align=\"center\">\n<![CDATA[" + sMarca
						+ "]]></fo:block>\n";
				tmpFoFileStream.write(sLinea.getBytes());
				sLinea = "	    </fo:table-cell>\n";
				tmpFoFileStream.write(sLinea.getBytes());
				// Modelo
				sLinea = "	    <fo:table-cell padding-top=\"2mm\" border-width=\"0.1mm\" border-style=\"solid\">\n";
				tmpFoFileStream.write(sLinea.getBytes());
				sLinea = "      <fo:block  text-align=\"center\">\n<![CDATA[" + sModelo
						+ "]]></fo:block>\n";
				tmpFoFileStream.write(sLinea.getBytes());
				sLinea = "	    </fo:table-cell>\n";
				tmpFoFileStream.write(sLinea.getBytes());
				// CodigoCentro
				sLinea = "	    <fo:table-cell padding-top=\"2mm\" border-width=\"0.1mm\" border-style=\"solid\">\n";
				tmpFoFileStream.write(sLinea.getBytes());
				sLinea = "      <fo:block  text-align=\"center\">\n<![CDATA["
						+ sCodCentro + "]]></fo:block>\n";
				tmpFoFileStream.write(sLinea.getBytes());
				sLinea = "	    </fo:table-cell>\n";
				tmpFoFileStream.write(sLinea.getBytes());
				// Tipo
				sLinea = "	    <fo:table-cell padding-top=\"2mm\" border-width=\"0.1mm\" border-style=\"solid\">\n";
				tmpFoFileStream.write(sLinea.getBytes());
				sLinea = "      <fo:block  text-align=\"center\">\n<![CDATA[" + sTipo
						+ "]]></fo:block>\n";
				tmpFoFileStream.write(sLinea.getBytes());
				sLinea = "	    </fo:table-cell>\n";
				tmpFoFileStream.write(sLinea.getBytes());
				sLinea = "	    </fo:table-row>\n";
				tmpFoFileStream.write(sLinea.getBytes());
			}
			fncImprimirFinPagina();
			rs.close();

			sLinea = "</fo:root>\n";
			tmpFoFileStream.write(sLinea.getBytes());

			tmpFoFileStream.close();
			// renderFO(new InputSource(file), response);
			generarPDFdesdeFO(sFoFileDir + tmpFoFile.getName(), sFoFileDir,
					response);

			// tmpFoFile.delete();

			// response.flushBuffer();

		} catch (Exception ex) {
			try {
				response.sendRedirect("m05bError.jsp");
			} catch (IOException e) {
				// TODO Auto-generated catch block
				miLog.addTraza(e);
			}
		} finally {
			try {
				if (pstmt != null) {
					rs.close();
					pstmt.close();
				}
				if (pstmt2 != null) {
					rs2.close();
					pstmt2.close();
				}
				if (conn != null)
					conn.close();
			} catch (SQLException e2) {
				try {
					response.sendRedirect("m05bError.jsp");
				} catch (IOException e) {
					// TODO Auto-generated catch block
					miLog.addTraza(e);
				}
			}
		}
	}

	/**
	 * renders an FO inputsource into a PDF file which is rendered directly to
	 * the response object's OutputStream
	 */
	public void renderFO(InputSource foFile, HttpServletResponse response)
			throws ServletException {
		try {
			ByteArrayOutputStream out = new ByteArrayOutputStream();

			response.reset();
			OutputStream oOut = response.getOutputStream();
			BufferedOutputStream bOut = new BufferedOutputStream(oOut);
			Driver driver = new Driver(foFile, out);
			driver.setRenderer(Driver.RENDER_PDF);
			driver.run();

			response.setContentLength(out.size());
			response.setContentType("application/pdf");

			bOut.write(out.toByteArray());
			out.close();
			bOut.flush();
			bOut.close();
			// response.flushBuffer();
		} catch (Exception ex) {
			throw new ServletException(ex);
		}
	}

	public void generarPDFdesdeFO(String ficheroFO, String rutaPDF,
			HttpServletResponse response) throws FOPException {
		try {
			Driver driver = new Driver();

			driver.setRenderer(Driver.RENDER_PDF);

			// Si no existe el directrio lo crea
			File f = new File(rutaPDF);

			if (!f.exists()) {
				f.mkdir();
			}

			// Cargar los datos del .FO
			FileInputStream file = new FileInputStream(ficheroFO);

			BufferedInputStream bfile = new BufferedInputStream(file);

			driver.setInputSource(new InputSource(bfile));

			// Crear un temporal que va a ser el .pdf
			String sPdfFileDir = rutaPDF;
			File pdfFileDir = new File(sPdfFileDir);
			File tmpPdfFile = File.createTempFile("m05b", ".pdf", pdfFileDir);

			FileOutputStream fileout = new FileOutputStream(tmpPdfFile);

			BufferedOutputStream bfileout = new BufferedOutputStream(fileout);

			driver.setOutputStream(bfileout);

			driver.run();

			bfile.close();

			bfileout.close();
			// Longitus del Fichero PDF.
			Long longitud = new Long(tmpPdfFile.length());
			String sLongitud = "" + longitud;
			int iLongitud = Integer.parseInt(sLongitud);

			response.setContentLength((int) iLongitud);
			response.setContentType("application/pdf");

			byte[] fileBytes = new byte[longitud.intValue()];
			FileInputStream fisficheroPdf = new FileInputStream(tmpPdfFile);
			fisficheroPdf.read(fileBytes);
			ServletOutputStream os = response.getOutputStream();
			((OutputStream) os).write(fileBytes);
			((OutputStream) os).flush();
			((OutputStream) os).close();

			// BORRAR EL FICHERO FO

			File fichero = new File(ficheroFO);

			boolean borrado = fichero.delete();
			boolean borrado2 = tmpPdfFile.delete();

		} catch (Exception e) {
			// System.out.println("EXCEPCION !!! : Error pasando de FO a PDF: "
			// + e);
		}
	}
}