package tarjetasServlet;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.sql.Clob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import m05bClasses.m05bComun;
import m05bClasses.m05bConexion;
import m05bClasses.m05bConstantes;
import m05bClasses.m05bConstantesInformes;
import m05bClasses.m05bFileLog;

import org.apache.fop.apps.Driver;
import org.xml.sax.InputSource;


/**
 * Inserte aqu la descripcin del tipo.
 * Fecha de creacin: (17/10/05)
 */
    
public class m05bImpTarjNoMatricCajasServlet extends javax.servlet.http.HttpServlet    {
		java.sql.Connection conn=null;
	    public static final String FO_REQUEST_PARAM = "fo";
//      Logger log = null;
	    m05bFileLog miLog = new m05bFileLog();
   public void doPost(javax.servlet.http.HttpServletRequest request, javax.servlet.http.HttpServletResponse response) throws javax.servlet.ServletException, java.io.IOException
   {
 	   try{
		      doGet(request, response);
		    }catch (Exception e){
		      miLog.addTraza(e);
		    }
   }

   public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException
   {
      performTask(request, response);
   }


public Clob fncLeerCLOB(String id) throws java.lang.Exception {
	   String sql;
	   PreparedStatement pstmt = null;
	   ResultSet rs = null;
	   java.sql.Clob lob = null;
	   // Comprueba si ya se ha cargado ese fichero
	   try  {
			   sql = "select " + m05bConstantes.COL_43_FICHERO + 
			   	   		" from " +  m05bConstantes.TAB_CARGAGASTOSTARJETAS + 
			   		  	" where " + m05bConstantes.COL_43_ID + " = " + id ;
			   ////System.out.println("m05b - ImpTarjNoMatricCajasServlet: SQL: " + sql);
		       pstmt = conn.prepareStatement(sql);
			   rs=pstmt.executeQuery();
	   		   if (rs.next()){
	            	lob = rs.getClob(1);
		 	   } else {
	       					//System.out.println("         ------   FICHERO CLOB NO ENCONTRADO");
		 	   }
	   } catch (Exception ex) {
			try {
	  			conn.rollback();  // Ha habido problemas, se deshacen todos los cambios
	  		} catch (SQLException e1){
	  			System.err.println("m05b - Imp Arch Cajas: EXCEPTION-1: LEER FICHERO --> " + e1);
	  		}
			miLog.addTraza(ex);
	  		throw new Exception(ex);
	   } finally{
	   	    try {
	   	    	if (rs != null)
	   	    		rs.close();
				if (pstmt != null)
					pstmt.close();
			} catch (SQLException e2) {
				System.err.println("m05b - Imp Arch Cajas: EXCEPTION-2: LEER FICHERO --> " + e2);
	  		}
	   }
	   return lob;
} // Fin funcion fncLeerCLOB
	
public boolean fncComprobarHayMatric(String tarjeta) throws java.lang.Exception {
	   String matricula="", sql;
	   PreparedStatement pstmt = null;
	   ResultSet rs=null;
	   boolean rdo = false;
	   // Comprobar si la matricula existe en la aplicacion

	   try  {
			sql = "select " + m05bConstantes.COL_14_MATRICULA + ", " + m05bConstantes.COL_14_CTRO +
				  " from " + m05bConstantes.TAB_HIST_TARJETAS +
				  " where " + m05bConstantes.COL_14_TARJETA + " = '" + tarjeta + "'";
	       pstmt = conn.prepareStatement(sql);
	       //System.out.println("	m05b - Imp Arch Cajas: COMPROBAR HAY MATRIC : " + sql);
		   rs=pstmt.executeQuery();
		   if (rs.next()){
	        	    matricula= rs.getString(1);
        	    	rdo=true;
	        	    if ((matricula == null) || (matricula.equals(""))) {
	        	    	rdo=false;
	        	    }
	 	   } 
	   } catch (Exception ex) {
			try {
	  			conn.rollback();  // Ha habido problemas, se deshacen todos los cambios
	  			throw new Exception(ex);
	  		} catch (SQLException e1){
	  			System.err.println("m05b - Imp Arch Cajas: Exception: COMPROBAR TARJ EXISTE --> " + e1);
	  		}
			miLog.addTraza(ex);
 			throw new Exception(ex);
	   } finally{
	   	    try {
				if (rs != null)
					rs.close();
				if (pstmt != null)
					pstmt.close();
			} catch (SQLException e2) {
				System.err.println("m05b - Imp Arch Cajas: Exception: COMPROBAR TARJ EXISTE --> " + e2);
	  		}
	   }
   	   return rdo;
} // Fin funcion fncComprobarHayMatric
	
	
public void fncBorrarCargaGastosTarjetas(String id) throws java.lang.Exception {
	   String sql;
	   PreparedStatement pstmt = null;
	
   	// Insertar un registro en la tabla M0516T00
	   try  {
		   sql = "delete from " +  m05bConstantes.TAB_CARGAGASTOSTARJETAS +
		   			" where " + m05bConstantes.COL_43_ID + " = " + id ;
	       //System.out.println("m05b - Imp Arch Cajas: BORRAR CARGA GASTOS TARJETAS: " + sql );
	       pstmt = conn.prepareStatement(sql);
		   pstmt.executeUpdate();
	   } catch (Exception ex) {
			try {
	  			conn.rollback();  // Ha habido problemas, se deshacen todos los cambios
	  			throw new Exception(ex);
	  		} catch (SQLException e1){
	  			System.err.println("m05b - Imp Arch Cajas: EXCEPTION-1: BORRAR CARGA GASTOS TARJETAS --> " + e1);
	  		}
			miLog.addTraza(ex);
	   } finally{
	   	    try {
				if (pstmt != null)
					pstmt.close();
			} catch (SQLException e2) {
				System.err.println("m05b - Imp Arch Cajas: EXCEPTION-2: BORRAR CARGA GASTOS TARJETAS --> " + e2);
	  		}
	   }
} // Fin funcion fncBorrarCargaGastosTarjetas
	

   public void performTask(javax.servlet.http.HttpServletRequest request, javax.servlet.http.HttpServletResponse response) throws ServletException {
      String sTarjeta="", sTarjetaAnt="", sFecha="", sHora="", sConcepto = "", sCIF= "", sEstablecimiento="", sImporte="", sCargabon="";
      String sSentencia, id="", inputLine="";
      java.sql.Clob lob = null;
	  BufferedReader bf=null;
	  StringBuffer sb = null;
     
      try {  
      	 HttpSession session = request.getSession(true);
      	 
		 m05bConexion miConex = new m05bConexion();
		 conn = miConex.getConnection();
		 
		 m05bComun miComun = new m05bComun();

	     //System.out.println("m05b - IMPORTAR ARCHIVOS CAJAS - tarjetas sin matricula");
	     //System.out.println("......   LEER FICHERO");

   	     id=request.getParameter("Id");
	     //System.out.println("......   ID =  " + id);
   	     
         lob = fncLeerCLOB(id);
       	 //System.out.println("......   TRATAR FICHERO");
		 sb = new StringBuffer(100);
		 bf = new BufferedReader(new InputStreamReader( ( (Clob)	lob).getAsciiStream()));

         //String foParam = request.getParameter(FO_REQUEST_PARAM);
         String sFoFileDir = "/datos/m05b/tmp/";
         File foFileDir = new File(sFoFileDir);
         File tmpFoFile = File.createTempFile("m05b", "Fo", foFileDir);

         FileOutputStream tmpFoFileStream = new FileOutputStream(tmpFoFile);

         String sLinea;
         sLinea = "<?xml version=\"1.0\" encoding=\"windows-1252\"?>\n";
         tmpFoFileStream.write(sLinea.getBytes());
         
         sLinea = "<fo:root xmlns:fo=\"http://www.w3.org/1999/XSL/Format\">\n";
         tmpFoFileStream.write(sLinea.getBytes());
		 // LAYOUT DEL LISTADO 
	         sLinea = "<fo:layout-master-set>\n";
	         tmpFoFileStream.write(sLinea.getBytes());
		           sLinea = "	<fo:simple-page-master master-name=\"general\"  page-height=\"21cm\" page-width=\"29.5cm\" margin-top=\"2cm\" margin-bottom=\"2cm\" margin-left=\"2.5cm\" margin-right=\"2.5cm\">\n";
			       tmpFoFileStream.write(sLinea.getBytes());
			         sLinea = "		<fo:region-before extent=\"2cm\"/>\n";
			         tmpFoFileStream.write(sLinea.getBytes());
			         sLinea = "		<fo:region-body  margin-top=\"2cm\" margin-bottom=\"2cm\" />\n";
			         tmpFoFileStream.write(sLinea.getBytes());
			         sLinea = "		<fo:region-after  extent=\"1cm\"/>\n";
			         tmpFoFileStream.write(sLinea.getBytes());
			         sLinea = "		<fo:region-start extent=\"0cm\"/>\n";
			         tmpFoFileStream.write(sLinea.getBytes());
			         sLinea = "		<fo:region-end extent=\"0cm\"/>\n";
			         tmpFoFileStream.write(sLinea.getBytes());
			         
		            sLinea = "	</fo:simple-page-master>\n";
		          tmpFoFileStream.write(sLinea.getBytes());
	         sLinea = "</fo:layout-master-set>\n";
	         tmpFoFileStream.write(sLinea.getBytes());

		 // PAGE-SEQUENCE DEL LISTADO 
	         sLinea = "<fo:page-sequence master-reference=\"general\">\n";
	         tmpFoFileStream.write(sLinea.getBytes());
	         
	     //System.out.println("......   REGION BEFORE");

//REGION BEFORE
        	sLinea = "		<fo:static-content flow-name=\"xsl-region-before\" >\n";
        	tmpFoFileStream.write(sLinea.getBytes());
		           // --------------    CABECERA DEL LISTADO    --------------
                        //Cabecera 1
		            /*sLinea = "      <fo:block text-align=\"end\">\n";
		            tmpFoFileStream.write(sLinea.getBytes());
			            sLinea = "p. <fo:page-number/>\n";
			            tmpFoFileStream.write(sLinea.getBytes());
		            sLinea = "      </fo:block>\n";
		            tmpFoFileStream.write(sLinea.getBytes());*/
                    sLinea = "      <fo:block font-weight=\"bold\" padding-top=\"10pt\">\n " + "TARJETAS SIN MATRICULA" + "</fo:block>\n";
			        tmpFoFileStream.write(sLinea.getBytes());
        	sLinea = " 		</fo:static-content>\n"; 
        	tmpFoFileStream.write(sLinea.getBytes());

	     //System.out.println("......   PIE PAGINA");


            //PIE DE PAGINA Pie
        	sLinea = "		<fo:static-content flow-name=\"xsl-region-after\">\n";
        	tmpFoFileStream.write(sLinea.getBytes());
            
            //PIE DE PAGINA Pie
					sLinea = "      <fo:block >\n";
		            tmpFoFileStream.write(sLinea.getBytes());
		            	sLinea= "       <fo:table>\n";
		            	tmpFoFileStream.write(sLinea.getBytes());
		            		sLinea = "	    <fo:table-column column-width=\"80mm\"/>\n";
			            	tmpFoFileStream.write(sLinea.getBytes());
		            		sLinea = "	    <fo:table-column column-width=\"120mm\"/>\n";
			            	tmpFoFileStream.write(sLinea.getBytes());
		            		sLinea = "	    <fo:table-body font-family=\"Helvetica\" font-size=\"6pt\">\n";
			            	tmpFoFileStream.write(sLinea.getBytes());
			            		sLinea = "	    <fo:table-row>\n";
			            		tmpFoFileStream.write(sLinea.getBytes());
			            			sLinea = "	    <fo:table-cell >\n";
			            			tmpFoFileStream.write(sLinea.getBytes());
							            sLinea = "      <fo:block text-align=\"left\">" + miComun.getDetFechaActual(m05bConstantesInformes.IDIOMA_C)+ "</fo:block>";
							            tmpFoFileStream.write(sLinea.getBytes());
			            			sLinea = "	    </fo:table-cell>\n";
			            			tmpFoFileStream.write(sLinea.getBytes());
			            			sLinea = "	    <fo:table-cell >\n";
			            			tmpFoFileStream.write(sLinea.getBytes());
			            			    sLinea = "      <fo:block text-align=\"right\">" ; 
                       		            tmpFoFileStream.write(sLinea.getBytes());
		                                sLinea = "Pgina <fo:page-number/> \n";
                        	            tmpFoFileStream.write(sLinea.getBytes());
							            sLinea=  "</fo:block>";
							            tmpFoFileStream.write(sLinea.getBytes());
			            			sLinea = "	    </fo:table-cell>\n";
			            			tmpFoFileStream.write(sLinea.getBytes());
			            		sLinea = "	    </fo:table-row>\n";
			            		tmpFoFileStream.write(sLinea.getBytes());
		            		sLinea = "	    </fo:table-body>\n";
			            	tmpFoFileStream.write(sLinea.getBytes());			            								            		
			            sLinea= "       </fo:table>\n";
		            	tmpFoFileStream.write(sLinea.getBytes());
		            sLinea = "      </fo:block>\n";
		            tmpFoFileStream.write(sLinea.getBytes());
        	sLinea = " 		</fo:static-content>\n"; 
        	tmpFoFileStream.write(sLinea.getBytes());


	     //System.out.println("......   BODY");

			//BODY
		         sLinea = "	<fo:flow flow-name=\"xsl-region-body\">\n";
		         tmpFoFileStream.write(sLinea.getBytes());
		         Context ctx =  new InitialContext(System.getProperties());
      	         // --------------    DETALLE DEL LISTADO    --------------
		           		sLinea= "        <fo:table space-after.optimum=\"12pt\">\n";
		            	tmpFoFileStream.write(sLinea.getBytes());
		            		sLinea = "	    <fo:table-column column-width=\"40mm\"/>\n";
			            	tmpFoFileStream.write(sLinea.getBytes());
		            		sLinea = "	    <fo:table-column column-width=\"20mm\"/>\n";
			            	tmpFoFileStream.write(sLinea.getBytes());
		            		sLinea = "	    <fo:table-column column-width=\"20mm\"/>\n";
			            	tmpFoFileStream.write(sLinea.getBytes());
		            		sLinea = "	    <fo:table-column column-width=\"45mm\"/>\n";
			            	tmpFoFileStream.write(sLinea.getBytes());
		            		sLinea = "	    <fo:table-column column-width=\"20mm\"/>\n";
			            	tmpFoFileStream.write(sLinea.getBytes());
		            		sLinea = "	    <fo:table-column column-width=\"45mm\"/>\n";
			            	tmpFoFileStream.write(sLinea.getBytes());
		            		sLinea = "	    <fo:table-column column-width=\"20mm\"/>\n";
			            	tmpFoFileStream.write(sLinea.getBytes());
		            		sLinea = "	    <fo:table-column column-width=\"20mm\"/>\n";
			            	tmpFoFileStream.write(sLinea.getBytes());
		                    /*sLinea = "	    <fo:table-header font-family=\"Helvetica\" font-size=\"7pt\" >\n";
			                tmpFoFileStream.write(sLinea.getBytes());
			                sLinea = "	    </fo:table-header>\n";
			                tmpFoFileStream.write(sLinea.getBytes());*/
			            		
			            		///DETALLE
		            		sLinea = "	    <fo:table-body font-family=\"Helvetica\" font-size=\"8pt\">\n";
			            	tmpFoFileStream.write(sLinea.getBytes());
   		                        sLinea = "	    <fo:table-row >\n";
			            		tmpFoFileStream.write(sLinea.getBytes());
			            			// Tarjeta 
			            			sLinea = "	    <fo:table-cell padding-top=\"0.2mm\" border-width=\"0.1mm\" border-style=\"solid\">\n";
			            			tmpFoFileStream.write(sLinea.getBytes());
								        sLinea = "      <fo:block text-align=\"center\" font-weight=\"bold\">\n Tarjeta </fo:block>";
				 			            tmpFoFileStream.write(sLinea.getBytes());
			            			sLinea = "	    </fo:table-cell>\n";
			            			tmpFoFileStream.write(sLinea.getBytes());
			            			// Fecha
			            			sLinea = "	    <fo:table-cell padding-top=\"0.2mm\" border-width=\"0.1mm\" border-style=\"solid\">\n";
			            			tmpFoFileStream.write(sLinea.getBytes());
								        sLinea = "      <fo:block  text-align=\"center\" font-weight=\"bold\">\n Fecha </fo:block>\n";
								        tmpFoFileStream.write(sLinea.getBytes());
			            			sLinea = "	    </fo:table-cell>\n";
			            			tmpFoFileStream.write(sLinea.getBytes());
			            			// Hora
			            			sLinea = "	    <fo:table-cell padding-top=\"0.2mm\" border-width=\"0.1mm\" border-style=\"solid\">\n";
			            			tmpFoFileStream.write(sLinea.getBytes());
								        sLinea = "      <fo:block  text-align=\"center\" font-weight=\"bold\">\n Hora </fo:block>\n";
								        tmpFoFileStream.write(sLinea.getBytes());
			            			sLinea = "	    </fo:table-cell>\n";
			            			tmpFoFileStream.write(sLinea.getBytes());
			            			// Concepto
			            			sLinea = "	    <fo:table-cell padding-top=\"0.2mm\" border-width=\"0.1mm\" border-style=\"solid\">\n";
			            			tmpFoFileStream.write(sLinea.getBytes());
							            sLinea = "      <fo:block  text-align=\"center\" font-weight=\"bold\">\n Concepto </fo:block>\n";
							            tmpFoFileStream.write(sLinea.getBytes());
			            			sLinea = "	    </fo:table-cell>\n";
			            			tmpFoFileStream.write(sLinea.getBytes());
			            			// CIF
			            			sLinea = "	    <fo:table-cell padding-top=\"0.2mm\" border-width=\"0.1mm\" border-style=\"solid\">\n";
			            			tmpFoFileStream.write(sLinea.getBytes());
							            sLinea = "      <fo:block  text-align=\"center\" font-weight=\"bold\">\n CIF </fo:block>\n";
							            tmpFoFileStream.write(sLinea.getBytes());
			            			sLinea = "	    </fo:table-cell>\n";
			            			tmpFoFileStream.write(sLinea.getBytes());
			            			// Establecimiento 
			            			sLinea = "	    <fo:table-cell padding-top=\"0.2mm\" border-width=\"0.1mm\" border-style=\"solid\">\n";
			            			tmpFoFileStream.write(sLinea.getBytes());
								        sLinea = "      <fo:block  text-align=\"center\" font-weight=\"bold\">\n Establecimiento </fo:block>";
				 			            tmpFoFileStream.write(sLinea.getBytes());
			            			sLinea = "	    </fo:table-cell>\n";
			            			tmpFoFileStream.write(sLinea.getBytes());
			            			// Importe
			            			sLinea = "	    <fo:table-cell padding-top=\"0.2mm\" border-width=\"0.1mm\" border-style=\"solid\">\n";
			            			tmpFoFileStream.write(sLinea.getBytes());
								        sLinea = "      <fo:block  text-align=\"center\" font-weight=\"bold\">\n Importe </fo:block>\n";
								        tmpFoFileStream.write(sLinea.getBytes());
			            			sLinea = "	    </fo:table-cell>\n";
			            			tmpFoFileStream.write(sLinea.getBytes());
			            			// Cargo/Abono
			            			sLinea = "	    <fo:table-cell padding-top=\"0.2mm\" border-width=\"0.1mm\" border-style=\"solid\">\n";
			            			tmpFoFileStream.write(sLinea.getBytes());
							            sLinea = "      <fo:block  text-align=\"center\" font-weight=\"bold\">\n Cargo/Abono </fo:block>\n";
							            tmpFoFileStream.write(sLinea.getBytes());
			            			sLinea = "	    </fo:table-cell>\n";
			            			tmpFoFileStream.write(sLinea.getBytes());
			            		sLinea = "	    </fo:table-row>\n";
			            		tmpFoFileStream.write(sLinea.getBytes());
			            	
			            	int cont=0;
	     					//System.out.println("......   PRIMER REGISTRO: " + inputLine);
		 					while ( (inputLine = bf.readLine()) != null) {
			   		    	    sTarjeta = inputLine.substring(11,27);
			   		    	    if ((fncComprobarHayMatric(sTarjeta))==false) {
				   		    	    sFecha = inputLine.substring(101,103)+"/"+inputLine.substring(99,101)+"/"+inputLine.substring(95,99);
			       	    			sHora = inputLine.substring(103,105)+ ":" +inputLine.substring(105,107) ;
									sConcepto = inputLine.substring(28,47);
									sCIF = inputLine.substring(47,56);
			       	    			sEstablecimiento = inputLine.substring(65,95);
			       	    			sCargabon = inputLine.substring(116,117);
			       	    			sImporte = inputLine.substring(107,116);
			       	    			while (sImporte.length() > 0)  {
			       	    				//Quitar ceros a la izda
			       	    				if (sImporte.substring(0,1).equals("0"))  {
			       	    					sImporte=sImporte.substring(1,sImporte.length());
			       	    				}  else {
			       	    					break;
			       	    				}
			       	    			}
								   if (sCargabon.equals(m05bConstantes.TAR_ABONO))  {
								   	   sImporte = "-" + sImporte;
								   }
	   		                        sLinea = "	    <fo:table-row >\n";
				            		tmpFoFileStream.write(sLinea.getBytes());
				            			// Tarjeta 
				            		if (!(sTarjeta.equals(sTarjetaAnt)))  {
				            			sLinea = "	    <fo:table-cell padding-top=\"0.2mm\" border-width=\"0.1mm\" border-style=\"solid\">\n";
				            			tmpFoFileStream.write(sLinea.getBytes());
									        sLinea = "      <fo:block  text-align=\"center\">\n " + sTarjeta + "</fo:block>";
									} else  {
				            			sLinea = "	    <fo:table-cell padding-top=\"0.2mm\" border-width=\"0.1mm\">\n";
				            			tmpFoFileStream.write(sLinea.getBytes());
									        sLinea = "      <fo:block>\n </fo:block>";
									}
					 			            tmpFoFileStream.write(sLinea.getBytes());
				            			sLinea = "	    </fo:table-cell>\n";
				            			tmpFoFileStream.write(sLinea.getBytes());
				            			// Fecha
				            			sLinea = "	    <fo:table-cell padding-top=\"0.2mm\" border-width=\"0.1mm\" border-style=\"solid\">\n";
				            			tmpFoFileStream.write(sLinea.getBytes());
									        sLinea = "      <fo:block  text-align=\"center\">\n "+ sFecha +"</fo:block>\n";
									        tmpFoFileStream.write(sLinea.getBytes());
				            			sLinea = "	    </fo:table-cell>\n";
				            			tmpFoFileStream.write(sLinea.getBytes());
				            			// Hora
				            			sLinea = "	    <fo:table-cell padding-top=\"0.2mm\" border-width=\"0.1mm\" border-style=\"solid\">\n";
				            			tmpFoFileStream.write(sLinea.getBytes());
									        sLinea = "      <fo:block  text-align=\"center\">\n "+ sHora +"</fo:block>\n";
									        tmpFoFileStream.write(sLinea.getBytes());
				            			sLinea = "	    </fo:table-cell>\n";
				            			tmpFoFileStream.write(sLinea.getBytes());
				            			// Concepto
				            			sLinea = "	    <fo:table-cell padding-top=\"0.2mm\" border-width=\"0.1mm\" border-style=\"solid\">\n";
				            			tmpFoFileStream.write(sLinea.getBytes());
								            sLinea = "      <fo:block  text-align=\"center\">\n"+ sConcepto +"</fo:block>\n";
								            tmpFoFileStream.write(sLinea.getBytes());
				            			sLinea = "	    </fo:table-cell>\n";
				            			tmpFoFileStream.write(sLinea.getBytes());
				            			// CIF
				            			sLinea = "	    <fo:table-cell padding-top=\"0.2mm\" border-width=\"0.1mm\" border-style=\"solid\">\n";
				            			tmpFoFileStream.write(sLinea.getBytes());
								            sLinea = "      <fo:block  text-align=\"center\">\n"+sCIF +"</fo:block>\n";
								            tmpFoFileStream.write(sLinea.getBytes());
				            			sLinea = "	    </fo:table-cell>\n";
				            			tmpFoFileStream.write(sLinea.getBytes());
				            			// Establecimiento 
				            			sLinea = "	    <fo:table-cell padding-top=\"0.2mm\" border-width=\"0.1mm\" border-style=\"solid\">\n";
				            			tmpFoFileStream.write(sLinea.getBytes());
									        sLinea = "      <fo:block  text-align=\"center\">\n " + sEstablecimiento + "</fo:block>";
					 			            tmpFoFileStream.write(sLinea.getBytes());
				            			sLinea = "	    </fo:table-cell>\n";
				            			tmpFoFileStream.write(sLinea.getBytes());
				            			// Importe
				            			sLinea = "	    <fo:table-cell padding-top=\"0.2mm\" border-width=\"0.1mm\" border-style=\"solid\">\n";
				            			tmpFoFileStream.write(sLinea.getBytes());
									        sLinea = "      <fo:block  text-align=\"center\">\n "+ sImporte +"</fo:block>\n";
									        tmpFoFileStream.write(sLinea.getBytes());
				            			sLinea = "	    </fo:table-cell>\n";
				            			tmpFoFileStream.write(sLinea.getBytes());
				            			// Cargo/Abono
				            			sLinea = "	    <fo:table-cell padding-top=\"0.2mm\" border-width=\"0.1mm\" border-style=\"solid\">\n";
				            			tmpFoFileStream.write(sLinea.getBytes());
								            sLinea = "      <fo:block text-align=\"center\">\n"+ sCargabon +"</fo:block>\n";
								            tmpFoFileStream.write(sLinea.getBytes());
				            			sLinea = "	    </fo:table-cell>\n";
				            			tmpFoFileStream.write(sLinea.getBytes());
				            		sLinea = "	    </fo:table-row>\n";
				            		tmpFoFileStream.write(sLinea.getBytes());
				            		sTarjetaAnt=sTarjeta;
				            	}  // Fin if tarjeta no existe
							} // Fin bucle while    
	     					//System.out.println("......   FIN WHILE  " );
								
			 	      	    sLinea = "	    </fo:table-body>\n";
			            	tmpFoFileStream.write(sLinea.getBytes());			            								            		
			            sLinea= "       </fo:table>\n";
		            	tmpFoFileStream.write(sLinea.getBytes());
		          //  sLinea = "      </fo:block-container>\n";
		           // tmpFoFileStream.write(sLinea.getBytes());

		         sLinea = "      </fo:flow>\n";
                 tmpFoFileStream.write(sLinea.getBytes());

        /*	sLinea = " 		</fo:static-content>\n"; 
        	tmpFoFileStream.write(sLinea.getBytes());*/
                 
         	 sLinea = "   </fo:page-sequence>\n";
             tmpFoFileStream.write(sLinea.getBytes());
             
         sLinea = "</fo:root>\n";
         tmpFoFileStream.write(sLinea.getBytes());
         
	     					//System.out.println("......   ANTES CLOSE  " );

         tmpFoFileStream.close();
         
         FileInputStream file = new FileInputStream(sFoFileDir + tmpFoFile.getName());
         renderFO(new InputSource(file), response);
         tmpFoFile.delete();
         response.flushBuffer();

		 fncBorrarCargaGastosTarjetas(id);
  		 conn.commit();
	     					//System.out.println("......   DESPUES COMMIT  " );

      } catch (Exception ex) {
      	try {
			response.sendRedirect("m05bError.jsp");
		} catch (IOException e) {
			// TODO Auto-generated catch block
			miLog.addTraza(e);
		}
      } finally{
	  }
    }  // Fin funcion performTask

    /**
     * renders an FO inputsource into a PDF file which is rendered
     * directly to the response object's OutputStream
     */
    public void renderFO(InputSource foFile, HttpServletResponse response) throws ServletException
    {
        try  {
            ByteArrayOutputStream out = new ByteArrayOutputStream();

	    	response.reset();
            OutputStream oOut=response.getOutputStream();
            BufferedOutputStream bOut=new BufferedOutputStream(oOut);
            Driver driver = new Driver(foFile, out);
            driver.setRenderer(Driver.RENDER_PDF);
            driver.run();

            response.setContentLength(out.size());
	    	response.setContentType("application/pdf");


            bOut.write(out.toByteArray());
	    	out.close();
	    	bOut.flush();
            bOut.close();
//	    response.flushBuffer();
        }  catch (Exception ex) {
            throw new ServletException(ex);
        }
    }
}