package tarjetasServlet;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.sql.Clob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import m05bClasses.m05bComun;
import m05bClasses.m05bConexion;
import m05bClasses.m05bConstantes;
import m05bClasses.m05bConstantesInformes;
import m05bClasses.m05bFileLog;
import m05bClasses.m05bInformes;

import org.apache.fop.apps.Driver;
import org.xml.sax.InputSource;


/**
 * Inserte aqu la descripcin del tipo.
 * Fecha de creacin: (13/10/05)
 */
    
public class m05bImpTarjCajasServlet extends javax.servlet.http.HttpServlet    {
		java.sql.Connection conn=null;
        File tmpFoFile ;
		FileOutputStream tmpFoFileStream ;
		m05bFileLog miLog = new m05bFileLog();
	    m05bComun miComun = new m05bComun();
		m05bInformes miInforme = new m05bInformes();
	    public static final String FO_REQUEST_PARAM = "fo";
//      Logger log = null;

   public void doPost(javax.servlet.http.HttpServletRequest request, javax.servlet.http.HttpServletResponse response) throws javax.servlet.ServletException, java.io.IOException
   {
 	   try{
		      doGet(request, response);
		    }catch (Exception e){
		      miLog.addTraza(e);
		    }
   }

   public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException
   {
      performTask(request, response);
   }


public Clob fncLeerCLOB(String id) throws java.lang.Exception {
	   String sql;
	   PreparedStatement pstmt = null;
	   ResultSet rs = null;
	   java.sql.Clob lob = null;
	   // Comprueba si ya se ha cargado ese fichero
	   try  {
			   sql = "select " + m05bConstantes.COL_43_FICHERO + 
			   	   		" from " +  m05bConstantes.TAB_CARGAGASTOSTARJETAS + 
			   		  	" where " + m05bConstantes.COL_43_ID + " = " + id ;
			   //miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC, "SQL: " + sql, m05bConstantes.LOG_NIVEL_BAJO);
		       pstmt = conn.prepareStatement(sql);
			   rs=pstmt.executeQuery();
	   		   if (rs.next()){
	            	lob = rs.getClob(1);
		 	   } else {
	       					miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC, "         ------   FICHERO CLOB NO ENCONTRADO",m05bConstantes.LOG_NIVEL_BAJO);
		 	   }
	   } catch (Exception ex) {
			try {
	  			conn.rollback();  // Ha habido problemas, se deshacen todos los cambios
	  		} catch (SQLException e1){
	  			miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC, "EXCEPTION-1: LEER FICHERO --> " + e1, m05bConstantes.LOG_NIVEL_BAJO);
	  		}
			miLog.addTraza(ex);
	  		throw new Exception(ex);
	   } finally{
	   	    try {
	   	    	if (rs != null)
	   	    		rs.close();
				if (pstmt != null)
					pstmt.close();
			} catch (SQLException e2) {
				miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC, "EXCEPTION-2: LEER FICHERO --> " + e2, m05bConstantes.LOG_NIVEL_BAJO);
	  		}
	   }
	   return lob;
} // Fin funcion fncLeerCLOB
	
public boolean fncComprobarTarjExiste(String tarjeta,String fecha) throws java.lang.Exception {
	   String sql;
	   PreparedStatement pstmt = null;
	   ResultSet rs=null;
	   boolean rdo = false;
	   // Comprobar si la matricula existe en la aplicacion

	   try  {
			sql = "select 1 " + 
				  " from " + m05bConstantes.TAB_HIST_TARJETAS +
				  " where " + m05bConstantes.COL_14_TARJETA + " = '" + tarjeta +
				  "' AND "+m05bConstantes.COL_14_FALTA+"<= TO_DATE('"+fecha+"','YYYYMMDD') " ;
   	   		//miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC, "sql2"+sql,m05bConstantes.LOG_NIVEL_BAJO);			
	       pstmt = conn.prepareStatement(sql);
		   rs=pstmt.executeQuery();
		   if (rs.next()){
	        	    rdo=true;
		   	   		miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC, " -----   Resultado TRUE ",m05bConstantes.LOG_NIVEL_BAJO);
	 	   } 
	   } catch (Exception ex) {
			try {
	  			conn.rollback();  // Ha habido problemas, se deshacen todos los cambios
	  			throw new Exception(ex);
	  		} catch (SQLException e1){
	  			miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC, "Exception: COMPROBAR TARJ EXISTE --> " + e1, m05bConstantes.LOG_NIVEL_BAJO);
	  		}
			miLog.addTraza(ex);
 			throw new Exception(ex);
	   } finally{
	   	    try {
				if (rs != null)
					rs.close();
				if (pstmt != null)
					pstmt.close();
			} catch (SQLException e2) {
				miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC, "Exception: COMPROBAR TARJ EXISTE --> " + e2, m05bConstantes.LOG_NIVEL_BAJO);
	  		}
	   }
   	   return rdo;
} // Fin funcion fncComprobarTarjExiste
	
	
public void fncBorrarCargaGastosTarjetas(String id) throws java.lang.Exception {
	   String sql;
	   PreparedStatement pstmt = null;
	
   	// Insertar un registro en la tabla M0516T00
	   try  {
		   sql = "delete from " +  m05bConstantes.TAB_CARGAGASTOSTARJETAS +
		   			" where " + m05bConstantes.COL_43_ID + " = " + id ;
	       miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC, "BORRAR CARGA GASTOS TARJETAS: " + sql,m05bConstantes.LOG_NIVEL_BAJO );
	       pstmt = conn.prepareStatement(sql);
		   pstmt.executeUpdate();
	   } catch (Exception ex) {
			try {
	  			conn.rollback();  // Ha habido problemas, se deshacen todos los cambios
	  			throw new Exception(ex);
	  		} catch (SQLException e1){
	  			miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC, "EXCEPTION-1: BORRAR CARGA GASTOS TARJETAS --> " + e1, m05bConstantes.LOG_NIVEL_BAJO);
	  		}
			miLog.addTraza(ex);
	   } finally{
	   	    try {
				if (pstmt != null)
					pstmt.close();
			} catch (SQLException e2) {
				miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC, "EXCEPTION-2: BORRAR CARGA GASTOS TARJETAS --> " + e2, m05bConstantes.LOG_NIVEL_BAJO);
	  		}
	   }
} // Fin funcion fncBorrarCargaGastosTarjetas
	

   public void performTask(javax.servlet.http.HttpServletRequest request, javax.servlet.http.HttpServletResponse response) throws ServletException {
   	   
      String sTarjeta="", sFecha="",sFechaTemp="", sHora="", sConcepto = "", sTarjetaAnt="";
      String sCIF= "", sEstablecimiento="", sImporte="", sCargabon="";
      String sSentencia, id="", inputLine="", persona="";
      
      java.sql.Clob lob = null;
	  BufferedReader bf=null;
	  StringBuffer sb = null;
     
      try {  
      	 HttpSession session = request.getSession(true);
      	 persona = (String) session.getAttribute("persona");
      	 	 
		 m05bConexion miConex = new m05bConexion();
		 conn = miConex.getConnection();
		 
	     miLog.addTraza("Anabel", "Importar Tarjetas Cajas PDF", "Tarjetas NO Registradas",m05bConstantes.LOG_NIVEL_BAJO);
	     miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC, "......   LEER FICHERO",m05bConstantes.LOG_NIVEL_BAJO);
   	     id=request.getParameter("Id");
	     miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC, "......   ID =  " + id,m05bConstantes.LOG_NIVEL_BAJO);
   	     
         lob = fncLeerCLOB(id);
       	 miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC, "......   TRATAR FICHERO",m05bConstantes.LOG_NIVEL_BAJO);
		 sb = new StringBuffer(100);
		 bf = new BufferedReader(new InputStreamReader( ( (Clob)	lob).getAsciiStream()));
 
         //String foParam = request.getParameter(FO_REQUEST_PARAM);
         /*String sFoFileDir = "/datos/m05b/tmp/";
         File foFileDir = new File(sFoFileDir);
         File tmpFoFile = File.createTempFile("m05b", "Fo", foFileDir);

         FileOutputStream tmpFoFileStream = new FileOutputStream(tmpFoFile);*/
	     tmpFoFileStream=miInforme.fncAbrirFicheroTemporal();
		 	 
         String sLinea;
         sLinea = "<?xml version=\"1.0\" encoding=\"windows-1252\"?>\n";
         tmpFoFileStream.write(sLinea.getBytes());
         
         sLinea = "<fo:root xmlns:fo=\"http://www.w3.org/1999/XSL/Format\">\n";
         tmpFoFileStream.write(sLinea.getBytes());
		 // LAYOUT DEL LISTADO
         miInforme.fncGenerarLayout(tmpFoFileStream, m05bConstantesInformes.DIR_VERTICAL, m05bConstantesInformes.NUM_LINEAS_1);

		 // PAGE-SEQUENCE DEL LISTADO 
	         sLinea = "<fo:page-sequence master-reference=\"general\">\n";
	         tmpFoFileStream.write(sLinea.getBytes());
	         
	     miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC, "......   REGION BEFORE",m05bConstantes.LOG_NIVEL_BAJO);

//REGION BEFORE
        	sLinea = "		<fo:static-content flow-name=\"xsl-region-before\" >\n";
        	tmpFoFileStream.write(sLinea.getBytes());
		           // --------------    CABECERA DEL LISTADO    --------------
                        //Cabecera 1
		            /*sLinea = "      <fo:block text-align=\"end\">\n";
		            tmpFoFileStream.write(sLinea.getBytes());
			            sLinea = "p. <fo:page-number/>\n";
			            tmpFoFileStream.write(sLinea.getBytes());
		            sLinea = "      </fo:block>\n";
		            tmpFoFileStream.write(sLinea.getBytes());*/
                    sLinea = "      <fo:block font-weight=\"bold\" padding-top=\"10pt\">\n " + "TARJETAS NO REGISTRADAS EN LA APLICACION" + "</fo:block>\n";
			        tmpFoFileStream.write(sLinea.getBytes());
        	sLinea = " 		</fo:static-content>\n"; 
        	tmpFoFileStream.write(sLinea.getBytes());

	     miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC, "......   PIE PAGINA",m05bConstantes.LOG_NIVEL_BAJO);

            //PIE DE PAGINA Pie
		 miInforme.fncGenerarPiePagina(tmpFoFileStream, m05bConstantesInformes.DIR_VERTICAL); 


	     miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC, "......   BODY",m05bConstantes.LOG_NIVEL_BAJO);

			//BODY
		         sLinea = "	<fo:flow flow-name=\"xsl-region-body\">\n";
		         tmpFoFileStream.write(sLinea.getBytes());
		         Context ctx =  new InitialContext(System.getProperties());
      	         // --------------    DETALLE DEL LISTADO    --------------
		           		sLinea= "        <fo:table space-after.optimum=\"12pt\">\n";
		            	tmpFoFileStream.write(sLinea.getBytes());
		            		sLinea = "	    <fo:table-column column-width=\"28mm\"/>\n";
			            	tmpFoFileStream.write(sLinea.getBytes());
		            		sLinea = "	    <fo:table-column column-width=\"18mm\"/>\n";
			            	tmpFoFileStream.write(sLinea.getBytes());
		            		sLinea = "	    <fo:table-column column-width=\"10mm\"/>\n";
			            	tmpFoFileStream.write(sLinea.getBytes());
		            		sLinea = "	    <fo:table-column column-width=\"22mm\"/>\n";
			            	tmpFoFileStream.write(sLinea.getBytes());
		            		sLinea = "	    <fo:table-column column-width=\"20mm\"/>\n";
			            	tmpFoFileStream.write(sLinea.getBytes());
		            		sLinea = "	    <fo:table-column column-width=\"40mm\"/>\n";
			            	tmpFoFileStream.write(sLinea.getBytes());
		            		sLinea = "	    <fo:table-column column-width=\"13mm\"/>\n";
			            	tmpFoFileStream.write(sLinea.getBytes());
		            		sLinea = "	    <fo:table-column column-width=\"20mm\"/>\n";
			            	tmpFoFileStream.write(sLinea.getBytes());
		                    /*sLinea = "	    <fo:table-header font-family=\"Helvetica\" font-size=\"7pt\" >\n";
			                tmpFoFileStream.write(sLinea.getBytes());
			                sLinea = "	    </fo:table-header>\n";
			                tmpFoFileStream.write(sLinea.getBytes());*/
			            		
			            		///DETALLE
		            		sLinea = "	    <fo:table-body font-family=\"Helvetica\" font-size=\"8pt\">\n";
			            	tmpFoFileStream.write(sLinea.getBytes());
   		                        sLinea = "	    <fo:table-row >\n";
			            		tmpFoFileStream.write(sLinea.getBytes());
			            			// Tarjeta 
			            			sLinea = "	    <fo:table-cell padding-before=\"1mm\" padding-after=\"0.6mm\" border-width=\"0.1mm\" border-style=\"solid\">\n";
			            			tmpFoFileStream.write(sLinea.getBytes());
								        sLinea = "      <fo:block text-align=\"center\" font-weight=\"bold\">\n Tarjeta </fo:block>";
				 			            tmpFoFileStream.write(sLinea.getBytes());
			            			sLinea = "	    </fo:table-cell>\n";
			            			tmpFoFileStream.write(sLinea.getBytes());
			            			// Fecha
			            			sLinea = "	    <fo:table-cell padding-before=\"1mm\" padding-after=\"0.6mm\" border-width=\"0.1mm\" border-style=\"solid\">\n";
			            			tmpFoFileStream.write(sLinea.getBytes());
								        sLinea = "      <fo:block  text-align=\"center\" font-weight=\"bold\">\n Fecha </fo:block>\n";
								        tmpFoFileStream.write(sLinea.getBytes());
			            			sLinea = "	    </fo:table-cell>\n";
			            			tmpFoFileStream.write(sLinea.getBytes());
			            			// Hora
			            			sLinea = "	    <fo:table-cell padding-before=\"1mm\" padding-after=\"0.6mm\" border-width=\"0.1mm\" border-style=\"solid\">\n";
			            			tmpFoFileStream.write(sLinea.getBytes());
								        sLinea = "      <fo:block  text-align=\"center\" font-weight=\"bold\">\n Hora </fo:block>\n";
								        tmpFoFileStream.write(sLinea.getBytes());
			            			sLinea = "	    </fo:table-cell>\n";
			            			tmpFoFileStream.write(sLinea.getBytes());
			            			// Concepto
			            			sLinea = "	    <fo:table-cell padding-before=\"1mm\" padding-after=\"0.6mm\" border-width=\"0.1mm\" border-style=\"solid\">\n";
			            			tmpFoFileStream.write(sLinea.getBytes());
							            sLinea = "      <fo:block  text-align=\"center\" font-weight=\"bold\">\n Concepto </fo:block>\n";
							            tmpFoFileStream.write(sLinea.getBytes());
			            			sLinea = "	    </fo:table-cell>\n";
			            			tmpFoFileStream.write(sLinea.getBytes());
			            			// CIF
			            			sLinea = "	    <fo:table-cell padding-before=\"1mm\" padding-after=\"0.6mm\" border-width=\"0.1mm\" border-style=\"solid\">\n";
			            			tmpFoFileStream.write(sLinea.getBytes());
							            sLinea = "      <fo:block  text-align=\"center\" font-weight=\"bold\">\n CIF </fo:block>\n";
							            tmpFoFileStream.write(sLinea.getBytes());
			            			sLinea = "	    </fo:table-cell>\n";
			            			tmpFoFileStream.write(sLinea.getBytes());
			            			// Establecimiento 
			            			sLinea = "	    <fo:table-cell padding-before=\"1mm\" padding-after=\"0.6mm\" border-width=\"0.1mm\" border-style=\"solid\">\n";
			            			tmpFoFileStream.write(sLinea.getBytes());
								        sLinea = "      <fo:block  text-align=\"center\" font-weight=\"bold\">\n Establecimiento </fo:block>";
				 			            tmpFoFileStream.write(sLinea.getBytes());
			            			sLinea = "	    </fo:table-cell>\n";
			            			tmpFoFileStream.write(sLinea.getBytes());
			            			// Importe
			            			sLinea = "	    <fo:table-cell padding-before=\"1mm\" padding-after=\"0.6mm\" border-width=\"0.1mm\" border-style=\"solid\">\n";
			            			tmpFoFileStream.write(sLinea.getBytes());
								        sLinea = "      <fo:block  text-align=\"center\" font-weight=\"bold\">\n Importe </fo:block>\n";
								        tmpFoFileStream.write(sLinea.getBytes());
			            			sLinea = "	    </fo:table-cell>\n";
			            			tmpFoFileStream.write(sLinea.getBytes());
			            			// Cargo/Abono
			            			sLinea = "	    <fo:table-cell padding-before=\"1mm\" padding-after=\"0.6mm\" border-width=\"0.1mm\" border-style=\"solid\">\n";
			            			tmpFoFileStream.write(sLinea.getBytes());
							            sLinea = "      <fo:block  text-align=\"center\" font-weight=\"bold\">\n Cargo/Abono </fo:block>\n";
							            tmpFoFileStream.write(sLinea.getBytes());
			            			sLinea = "	    </fo:table-cell>\n";
			            			tmpFoFileStream.write(sLinea.getBytes());
			            		sLinea = "	    </fo:table-row>\n";
			            		tmpFoFileStream.write(sLinea.getBytes());
			            	
			            	int cont=0;
	     					miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC, "......   PRIMER REGISTRO: " + inputLine,m05bConstantes.LOG_NIVEL_BAJO);
		 					while ( (inputLine = bf.readLine()) != null) {
			   		    	    sTarjeta = inputLine.substring(11,27);
			   		    	    sFechaTemp = inputLine.substring(95,99)+inputLine.substring(99,101)+inputLine.substring(101,103);			   		    	    
			   		    	    if (!(fncComprobarTarjExiste(sTarjeta,sFechaTemp))) {
				   		    	    sFecha = inputLine.substring(101,103)+"/"+inputLine.substring(99,101)+"/"+inputLine.substring(95,99);
			       	    			sHora = inputLine.substring(103,105)+ ":" +inputLine.substring(105,107) ;
									sConcepto = inputLine.substring(28,47);
									sCIF = inputLine.substring(47,56);
			       	    			sEstablecimiento = inputLine.substring(65,95);
			       	    			sCargabon = inputLine.substring(116,117);
			       	    			sImporte = inputLine.substring(107,114)+"."+inputLine.substring(114,116);
			       	    			while (sImporte.length() > 0)  {
			       	    				//Quitar ceros a la izda
			       	    				if (sImporte.substring(0,1).equals("0"))  {
			       	    					sImporte=sImporte.substring(1,sImporte.length());
			       	    				}  else {
			       	    					break;
			       	    				}
			       	    			}
								   if (sCargabon.equals(m05bConstantes.TAR_ABONO))  {
								   	   sImporte = "-" + sImporte;
								   }
								   
	   		                        sLinea = "	    <fo:table-row >\n";
				            		tmpFoFileStream.write(sLinea.getBytes());
				            			// Tarjeta 
				            		if (!(sTarjeta.equals(sTarjetaAnt)))  {
				            			sLinea = "	    <fo:table-cell padding-top=\"0.2mm\" border-width=\"0.1mm\" border-style=\"solid\">\n";
				            			tmpFoFileStream.write(sLinea.getBytes());
									        sLinea = "      <fo:block  text-align=\"center\">\n " + sTarjeta + "</fo:block>";
									} else  {
				            			sLinea = "	    <fo:table-cell padding-top=\"0.2mm\" border-width=\"0.1mm\">\n";
				            			tmpFoFileStream.write(sLinea.getBytes());
									        sLinea = "      <fo:block>\n </fo:block>";
									}
					 			            tmpFoFileStream.write(sLinea.getBytes());
				            			sLinea = "	    </fo:table-cell>\n";
				            			tmpFoFileStream.write(sLinea.getBytes());
				            			// Fecha
				            			sLinea = "	    <fo:table-cell padding-top=\"0.2mm\" border-width=\"0.1mm\" border-style=\"solid\">\n";
				            			tmpFoFileStream.write(sLinea.getBytes());
									        sLinea = "      <fo:block  text-align=\"center\">\n "+ sFecha +"</fo:block>\n";
									        tmpFoFileStream.write(sLinea.getBytes());
				            			sLinea = "	    </fo:table-cell>\n";
				            			tmpFoFileStream.write(sLinea.getBytes());
				            			// Hora
				            			sLinea = "	    <fo:table-cell padding-top=\"0.2mm\" border-width=\"0.1mm\" border-style=\"solid\">\n";
				            			tmpFoFileStream.write(sLinea.getBytes());
									        sLinea = "      <fo:block  text-align=\"center\">\n "+ sHora +"</fo:block>\n";
									        tmpFoFileStream.write(sLinea.getBytes());
				            			sLinea = "	    </fo:table-cell>\n";
				            			tmpFoFileStream.write(sLinea.getBytes());
				            			// Concepto
				            			sLinea = "	    <fo:table-cell padding-top=\"0.2mm\" border-width=\"0.1mm\" border-style=\"solid\">\n";
				            			tmpFoFileStream.write(sLinea.getBytes());
								            sLinea = "      <fo:block  text-align=\"center\">\n"+ sConcepto +"</fo:block>\n";
								            tmpFoFileStream.write(sLinea.getBytes());
				            			sLinea = "	    </fo:table-cell>\n";
				            			tmpFoFileStream.write(sLinea.getBytes());
				            			// CIF
				            			sLinea = "	    <fo:table-cell padding-top=\"0.2mm\" border-width=\"0.1mm\" border-style=\"solid\">\n";
				            			tmpFoFileStream.write(sLinea.getBytes());
								            sLinea = "      <fo:block  text-align=\"center\">\n"+sCIF +"</fo:block>\n";
								            tmpFoFileStream.write(sLinea.getBytes());
				            			sLinea = "	    </fo:table-cell>\n";
				            			tmpFoFileStream.write(sLinea.getBytes());
				            			// Establecimiento 
				            			sLinea = "	    <fo:table-cell padding-top=\"0.2mm\" border-width=\"0.1mm\" border-style=\"solid\">\n";
				            			tmpFoFileStream.write(sLinea.getBytes());
									        sLinea = "      <fo:block  text-align=\"left\">\n " + sEstablecimiento + "</fo:block>";
					 			            tmpFoFileStream.write(sLinea.getBytes());
				            			sLinea = "	    </fo:table-cell>\n";
				            			tmpFoFileStream.write(sLinea.getBytes());
				            			// Importe
				            			sLinea = "	    <fo:table-cell padding-top=\"0.2mm\" border-width=\"0.1mm\" border-style=\"solid\">\n";
				            			tmpFoFileStream.write(sLinea.getBytes());
									        sLinea = "      <fo:block  text-align=\"center\">\n "+ miComun.formatearDblMilesDec( Double.parseDouble(sImporte) ) +"</fo:block>\n";
									        tmpFoFileStream.write(sLinea.getBytes());
				            			sLinea = "	    </fo:table-cell>\n";
				            			tmpFoFileStream.write(sLinea.getBytes());
				            			// Cargo/Abono
				            			sLinea = "	    <fo:table-cell padding-top=\"0.2mm\" border-width=\"0.1mm\" border-style=\"solid\">\n";
				            			tmpFoFileStream.write(sLinea.getBytes());
								            sLinea = "      <fo:block text-align=\"center\">\n"+ sCargabon +"</fo:block>\n";
								            tmpFoFileStream.write(sLinea.getBytes());
				            			sLinea = "	    </fo:table-cell>\n";
				            			tmpFoFileStream.write(sLinea.getBytes());
				            		sLinea = "	    </fo:table-row>\n";
				            		tmpFoFileStream.write(sLinea.getBytes());
				            		sTarjetaAnt=sTarjeta;
				            	}  // Fin if tarjeta no existe
							} // Fin bucle while    
	     					miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC, "......   FIN WHILE  ",m05bConstantes.LOG_NIVEL_BAJO );
								
			 	      	    sLinea = "	    </fo:table-body>\n";
			            	tmpFoFileStream.write(sLinea.getBytes());
			            sLinea= "       </fo:table>\n";
		            	tmpFoFileStream.write(sLinea.getBytes());
		          //  sLinea = "      </fo:block-container>\n";
		           // tmpFoFileStream.write(sLinea.getBytes());

		         sLinea = "      </fo:flow>\n";
                 tmpFoFileStream.write(sLinea.getBytes());

        /*	sLinea = " 		</fo:static-content>\n"; 
        	tmpFoFileStream.write(sLinea.getBytes());*/
                 
         	 sLinea = "   </fo:page-sequence>\n";
             tmpFoFileStream.write(sLinea.getBytes());
             
         sLinea = "</fo:root>\n";
         tmpFoFileStream.write(sLinea.getBytes());

         tmpFoFileStream.close();
         //FileInputStream file = new FileInputStream(sFoFileDir + tmpFoFile.getName());
         //renderFO(new InputSource(file), response);
         miInforme.renderFO(response);
         //tmpFoFile.delete();
         //response.flushBuffer();

		 fncBorrarCargaGastosTarjetas(id);
  		 conn.commit();
	     miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC, "......   DESPUES COMMIT  ",m05bConstantes.LOG_NIVEL_BAJO );

      } catch (Exception ex) {
      		try {
      			miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC, "EXCEPTION m05bImpTarjCajasServlet.performTask --> " + ex.getMessage(), m05bConstantes.LOG_NIVEL_BAJO);
      			miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC, "iniro TARJETA --> " + sTarjeta, m05bConstantes.LOG_NIVEL_BAJO);
				response.sendRedirect("m05bError.jsp");
			} catch (IOException e) {
				// TODO Auto-generated catch block
				miLog.addTraza(e);
			}
      } finally{
		if (conn != null)
			try {
				conn.close();
			} catch (SQLException e) {
				// TODO Auto-generated catch block
				miLog.addTraza(e);
				try {
					response.sendRedirect("m05bError.jsp");
				} catch (IOException e1) {
					// TODO Auto-generated catch block
					miLog.addTraza(e1);
				}
			}
	  	}
    }  // Fin funcion performTask

    /**
     * renders an FO inputsource into a PDF file which is rendered
     * directly to the response object's OutputStream
     */
    public void renderFO(InputSource foFile, HttpServletResponse response) throws ServletException
    {
        try  {
            ByteArrayOutputStream out = new ByteArrayOutputStream();

	    	response.reset();
            OutputStream oOut=response.getOutputStream();
            BufferedOutputStream bOut=new BufferedOutputStream(oOut);
            Driver driver = new Driver(foFile, out);
            driver.setRenderer(Driver.RENDER_PDF);
            driver.run();

            response.setContentLength(out.size());
	    	response.setContentType("application/pdf");


            bOut.write(out.toByteArray());
	    	out.close();
	    	bOut.flush();
            bOut.close();
//	    response.flushBuffer();
        }  catch (Exception ex) {
            throw new ServletException(ex);
        }
    }
}