package tarjetasServlet;


import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.Clob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import m05bClasses.m05bComun;
import m05bClasses.m05bConexion;
import m05bClasses.m05bConstantes;
import m05bClasses.m05bConstantesInformes;
import m05bClasses.m05bFileLog;
import m05bClasses.m05bInformes;

/**
 * Inserte aqu la descripcin del tipo.
 * Fecha de creacin: (18/10/05)
 */

public class m05bImpCentrosCajasServlet extends javax.servlet.http.HttpServlet    {

	    public static final String FO_REQUEST_PARAM = "fo";

		java.sql.Connection conn=null;
		String sMatricula = "", sCentroTarj="";
		String sLinea;
        File foFileDir ;
        File tmpFoFile ;
		FileOutputStream tmpFoFileStream ;

		m05bFileLog miLog = new m05bFileLog();
		m05bInformes miInforme = new m05bInformes();
	    m05bComun miComun = new m05bComun();
	    m05bConexion miConex = new m05bConexion();


   public void doPost(javax.servlet.http.HttpServletRequest request, javax.servlet.http.HttpServletResponse response) throws javax.servlet.ServletException, java.io.IOException
   {
 	   try{
		      doGet(request, response);
		    }catch (Exception e){
		      miLog.addTraza(e);
		    }
   }

   public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException
   {
      performTask(request, response);
   }


public Clob fncLeerCLOB(String id) throws java.lang.Exception {
	   String sql;
	   PreparedStatement pstmt = null;
	   ResultSet rs = null;
	   java.sql.Clob lob = null;
	   // Comprueba si ya se ha cargado ese fichero
	   try  {
			   sql = "select " + m05bConstantes.COL_43_FICHERO + 
			   	   		" from " +  m05bConstantes.TAB_CARGAGASTOSTARJETAS + 
			   		  	" where " + m05bConstantes.COL_43_ID + " = " + id ;
			   miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC,"SQL LEER CLOB: " + sql, m05bConstantes.LOG_NIVEL_BAJO);
		       pstmt = conn.prepareStatement(sql);
			   rs=pstmt.executeQuery();
	   		   if (rs.next()){
	            	lob = rs.getClob(1);
		 	   } else {
	       			miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC,"         ------   FICHERO CLOB NO ENCONTRADO",m05bConstantes.LOG_NIVEL_BAJO);
		 	   }
	   } catch (Exception ex) {
			try {
	  			conn.rollback();  // Ha habido problemas, se deshacen todos los cambios
	  		} catch (SQLException e1){
	  			miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC,"EXCEPTION-1: LEER FICHERO --> " + e1, m05bConstantes.LOG_NIVEL_BAJO);
	  		}
			miLog.addTraza(ex);
	  		throw new Exception(ex);
	   } finally{
	   	    try {
	   	    	if (rs != null)
	   	    		rs.close();
				if (pstmt != null)
					pstmt.close();
			} catch (SQLException e2) {
				miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC,"EXCEPTION-2: LEER FICHERO --> " + e2, m05bConstantes.LOG_NIVEL_BAJO);
	  		}
	   }
	   return lob;
} // Fin funcion fncLeerCLOB
	
public boolean fncComprobarCentro(String tarjeta, String centroFich) throws java.lang.Exception {
	   String sql;
	   PreparedStatement pstmt = null;
	   ResultSet rs=null;
	   boolean rdo = false;
	   // Comprobar si la matricula existe en la aplicacion

	   try  {
			sql = "select " + m05bConstantes.COL_14_MATRICULA + ", " + m05bConstantes.COL_14_CTRO +
				  " from " + m05bConstantes.TAB_HIST_TARJETAS +
				  " where " + m05bConstantes.COL_14_TARJETA + " = '" + tarjeta + "'" +
				  " order by " + m05bConstantes.COL_14_TARJHIST + " desc";				  
	       pstmt = conn.prepareStatement(sql);
	       //miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC,"COMPROBAR CENTRO : " + sql,m05bConstantes.LOG_NIVEL_BAJO);
		   rs=pstmt.executeQuery();
		   if (rs.next()){
	        	    sMatricula= rs.getString(1)==null?"":rs.getString(1);
	        	    sCentroTarj = rs.getString(2)==null?"":rs.getString(2);
	        	    if ((sCentroTarj.equals(centroFich))) {
	        	    	rdo=true;
	        	    }
	 	   } 
	   } catch (Exception ex) {
			try {
	  			conn.rollback();  // Ha habido problemas, se deshacen todos los cambios
	  			throw new Exception(ex);
	  		} catch (SQLException e1){
	  			miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC,"Exception-1: COMPROBAR TARJ EXISTE --> " + e1, m05bConstantes.LOG_NIVEL_BAJO);
	  		}
			miLog.addTraza(ex);
 			throw new Exception(ex);
	   } finally{
	   	    try {
				if (rs != null)
					rs.close();
				if (pstmt != null)
					pstmt.close();
			} catch (SQLException e2) {
				miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC,"Exception-2: COMPROBAR TARJ EXISTE --> " + e2, m05bConstantes.LOG_NIVEL_BAJO);
	  		}
	   }
   	   return rdo;
} // Fin funcion fncComprobarCentro
	
	
public void fncBorrarCargaGastosTarjetas(String id) throws java.lang.Exception {
	   String sql;
	   PreparedStatement pstmt = null;
	
   	// Insertar un registro en la tabla M0516T00
	   try  {
		   sql = "delete from " +  m05bConstantes.TAB_CARGAGASTOSTARJETAS +
		   			" where " + m05bConstantes.COL_43_ID + " = " + id ;
	       miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC,"BORRAR CARGA GASTOS TARJETAS: " + sql,m05bConstantes.LOG_NIVEL_BAJO);
	       pstmt = conn.prepareStatement(sql);
		   pstmt.executeUpdate();
	   } catch (Exception ex) {
			try {
	  			conn.rollback();  // Ha habido problemas, se deshacen todos los cambios
	  			throw new Exception(ex);
	  		} catch (SQLException e1){
	  			miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC,"EXCEPTION-1: BORRAR CARGA GASTOS TARJETAS --> " + e1, m05bConstantes.LOG_NIVEL_BAJO);
	  		}
			miLog.addTraza(ex);
	   } finally{
	   	    try {
				if (pstmt != null)
					pstmt.close();
			} catch (SQLException e2) {
				miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC,"EXCEPTION-2: BORRAR CARGA GASTOS TARJETAS --> " + e2, m05bConstantes.LOG_NIVEL_BAJO);
	  		}
	   }
} // Fin funcion fncBorrarCargaGastosTarjetas
	

   public void performTask(javax.servlet.http.HttpServletRequest request, javax.servlet.http.HttpServletResponse response) throws ServletException {
   	   
      String sTarjeta="", sTarjetaAnt="", sFecha="", sHora="", sCentro= "", 
      			sTipo="", sCargabon="", sConcepto="", sCIF="", sImporte="";
      String sSentencia, id="", inputLine="";
      java.sql.Clob lob = null;
	  BufferedReader bf=null;
	  StringBuffer sb = null;
     
      try {  
      	 HttpSession session = request.getSession(true);
		 conn = miConex.getConnection();
		 
	     miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC,"......   LEER FICHERO",m05bConstantes.LOG_NIVEL_BAJO);

   	     id=request.getParameter("Id");
	     miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC,"......   ID =  " + id,m05bConstantes.LOG_NIVEL_BAJO);

         lob = fncLeerCLOB(id);
       	 miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC,"......   TRATAR FICHERO",m05bConstantes.LOG_NIVEL_BAJO);
		 sb = new StringBuffer(100);
		 bf = new BufferedReader(new InputStreamReader( ( (Clob)	lob).getAsciiStream()));

         tmpFoFileStream=miInforme.fncAbrirFicheroTemporal();

         String sLinea;
         sLinea = "<?xml version=\"1.0\" encoding=\"windows-1252\"?>\n";
         tmpFoFileStream.write(sLinea.getBytes());
         
         sLinea = "<fo:root xmlns:fo=\"http://www.w3.org/1999/XSL/Format\">\n";
         tmpFoFileStream.write(sLinea.getBytes());
		 // LAYOUT DEL LISTADO 
	         sLinea = "<fo:layout-master-set>\n";
	         tmpFoFileStream.write(sLinea.getBytes());
		           sLinea = "	<fo:simple-page-master master-name=\"general\"  page-height=\"21cm\" page-width=\"29.5cm\" margin-top=\"2cm\" margin-bottom=\"2cm\" margin-left=\"2.5cm\" margin-right=\"2.5cm\">\n";
			       tmpFoFileStream.write(sLinea.getBytes());
			         sLinea = "		<fo:region-before extent=\"2cm\"/>\n";
			         tmpFoFileStream.write(sLinea.getBytes());
			         sLinea = "		<fo:region-body  margin-top=\"2cm\" margin-bottom=\"2cm\" />\n";
			         tmpFoFileStream.write(sLinea.getBytes());
			         sLinea = "		<fo:region-after  extent=\"1cm\"/>\n";
			         tmpFoFileStream.write(sLinea.getBytes());
			         sLinea = "		<fo:region-start extent=\"0cm\"/>\n";
			         tmpFoFileStream.write(sLinea.getBytes());
			         sLinea = "		<fo:region-end extent=\"0cm\"/>\n";
			         tmpFoFileStream.write(sLinea.getBytes());
			         
		            sLinea = "	</fo:simple-page-master>\n";
		          tmpFoFileStream.write(sLinea.getBytes());
	         sLinea = "</fo:layout-master-set>\n";
	         tmpFoFileStream.write(sLinea.getBytes());

		 // PAGE-SEQUENCE DEL LISTADO 
	         sLinea = "<fo:page-sequence master-reference=\"general\">\n";
	         tmpFoFileStream.write(sLinea.getBytes());
	         

		//REGION BEFORE
        	sLinea = "		<fo:static-content flow-name=\"xsl-region-before\" >\n";
        	tmpFoFileStream.write(sLinea.getBytes());
                    sLinea = "      <fo:block font-weight=\"bold\" padding-top=\"10pt\">\n " + "CENTROS EN FICHERO DE CAJAS DISTINTOS EN TARJETAS" + "</fo:block>\n";
			        tmpFoFileStream.write(sLinea.getBytes());
        	sLinea = " 		</fo:static-content>\n"; 
        	tmpFoFileStream.write(sLinea.getBytes());

            //PIE DE PAGINA
		    miInforme.fncGenerarPiePagina(tmpFoFileStream, m05bConstantesInformes.DIR_HORIZONTAL); 

			//BODY
		         sLinea = "	<fo:flow flow-name=\"xsl-region-body\">\n";
		         tmpFoFileStream.write(sLinea.getBytes());
		         Context ctx =  new InitialContext(System.getProperties());
      	         // --------------    DETALLE DEL LISTADO    --------------
		           		sLinea= "        <fo:table space-after.optimum=\"12pt\">\n";
		            	tmpFoFileStream.write(sLinea.getBytes());
		            		sLinea = "	    <fo:table-column column-width=\"30mm\"/>\n";
			            	tmpFoFileStream.write(sLinea.getBytes());
		            		sLinea = "	    <fo:table-column column-width=\"20mm\"/>\n";
			            	tmpFoFileStream.write(sLinea.getBytes());
		            		sLinea = "	    <fo:table-column column-width=\"20mm\"/>\n";
			            	tmpFoFileStream.write(sLinea.getBytes());
		            		sLinea = "	    <fo:table-column column-width=\"25mm\"/>\n";
			            	tmpFoFileStream.write(sLinea.getBytes());
		            		sLinea = "	    <fo:table-column column-width=\"20mm\"/>\n";
			            	tmpFoFileStream.write(sLinea.getBytes());
		            		sLinea = "	    <fo:table-column column-width=\"25mm\"/>\n";
			            	tmpFoFileStream.write(sLinea.getBytes());
		            		sLinea = "	    <fo:table-column column-width=\"20mm\"/>\n";
			            	tmpFoFileStream.write(sLinea.getBytes());
		            		sLinea = "	    <fo:table-column column-width=\"40mm\"/>\n";
			            	tmpFoFileStream.write(sLinea.getBytes());
		            		sLinea = "	    <fo:table-column column-width=\"15mm\"/>\n";
			            	tmpFoFileStream.write(sLinea.getBytes());
		            		sLinea = "	    <fo:table-column column-width=\"20mm\"/>\n";
			            	tmpFoFileStream.write(sLinea.getBytes());
		            		sLinea = "	    <fo:table-column column-width=\"20mm\"/>\n";
			            	tmpFoFileStream.write(sLinea.getBytes());
		                    /*sLinea = "	    <fo:table-header font-family=\"Helvetica\" font-size=\"7pt\" >\n";
			                tmpFoFileStream.write(sLinea.getBytes());
			                sLinea = "	    </fo:table-header>\n";
			                tmpFoFileStream.write(sLinea.getBytes());*/
			            		
			            		///DETALLE
		            		sLinea = "	    <fo:table-body font-family=\"Helvetica\" font-size=\"8pt\">\n";
			            	tmpFoFileStream.write(sLinea.getBytes());
   		                        sLinea = "	    <fo:table-row >\n";
			            		tmpFoFileStream.write(sLinea.getBytes());
			            			// Tarjeta 
			            			sLinea = "	    <fo:table-cell padding-before=\"1mm\" padding-after=\"0.6mm\" border-width=\"0.1mm\" border-style=\"solid\">\n";
			            			tmpFoFileStream.write(sLinea.getBytes());
								        sLinea = "      <fo:block text-align=\"center\" font-weight=\"bold\">\n Tarjeta </fo:block>";
				 			            tmpFoFileStream.write(sLinea.getBytes());
			            			sLinea = "	    </fo:table-cell>\n";
			            			tmpFoFileStream.write(sLinea.getBytes());
			            			// Fecha
			            			sLinea = "	    <fo:table-cell padding-before=\"1mm\" padding-after=\"0.6mm\" border-width=\"0.1mm\" border-style=\"solid\">\n";
			            			tmpFoFileStream.write(sLinea.getBytes());
								        sLinea = "      <fo:block  text-align=\"center\" font-weight=\"bold\">\n Fecha </fo:block>\n";
								        tmpFoFileStream.write(sLinea.getBytes());
			            			sLinea = "	    </fo:table-cell>\n";
			            			tmpFoFileStream.write(sLinea.getBytes());
			            			// Hora
			            			sLinea = "	    <fo:table-cell padding-before=\"1mm\" padding-after=\"0.6mm\" border-width=\"0.1mm\" border-style=\"solid\">\n";
			            			tmpFoFileStream.write(sLinea.getBytes());
								        sLinea = "      <fo:block  text-align=\"center\" font-weight=\"bold\">\n Hora </fo:block>\n";
								        tmpFoFileStream.write(sLinea.getBytes());
			            			sLinea = "	    </fo:table-cell>\n";
			            			tmpFoFileStream.write(sLinea.getBytes());
			            			// Matricula
			            			sLinea = "	    <fo:table-cell padding-before=\"1mm\" padding-after=\"0.6mm\" border-width=\"0.1mm\" border-style=\"solid\">\n";
			            			tmpFoFileStream.write(sLinea.getBytes());
							            sLinea = "      <fo:block  text-align=\"center\" font-weight=\"bold\">\n Matrcula </fo:block>\n";
							            tmpFoFileStream.write(sLinea.getBytes());
			            			sLinea = "	    </fo:table-cell>\n";
			            			tmpFoFileStream.write(sLinea.getBytes());
			            			// Centro Cajas
			            			sLinea = "	    <fo:table-cell padding-before=\"1mm\" padding-after=\"0.6mm\" border-width=\"0.1mm\" border-style=\"solid\">\n";
			            			tmpFoFileStream.write(sLinea.getBytes());
							            sLinea = "      <fo:block  text-align=\"center\" font-weight=\"bold\">\n Centro Cajas</fo:block>\n";
							            tmpFoFileStream.write(sLinea.getBytes());
			            			sLinea = "	    </fo:table-cell>\n";
			            			tmpFoFileStream.write(sLinea.getBytes());
			            			// Centro Tarjetas 
			            			sLinea = "	    <fo:table-cell padding-before=\"1mm\" padding-after=\"0.6mm\" border-width=\"0.1mm\" border-style=\"solid\">\n";
			            			tmpFoFileStream.write(sLinea.getBytes());
								        sLinea = "      <fo:block  text-align=\"center\" font-weight=\"bold\">\n Centro Tarjetas</fo:block>";
				 			            tmpFoFileStream.write(sLinea.getBytes());
			            			sLinea = "	    </fo:table-cell>\n";
			            			tmpFoFileStream.write(sLinea.getBytes());
			            			// Tipo
			            			sLinea = "	    <fo:table-cell padding-before=\"1mm\" padding-after=\"0.6mm\" border-width=\"0.1mm\" border-style=\"solid\">\n";
			            			tmpFoFileStream.write(sLinea.getBytes());
								        sLinea = "      <fo:block  text-align=\"center\" font-weight=\"bold\">\n Tipo </fo:block>\n";
								        tmpFoFileStream.write(sLinea.getBytes());
			            			sLinea = "	    </fo:table-cell>\n";
			            			tmpFoFileStream.write(sLinea.getBytes());
			            			// Concepto
			            			sLinea = "	    <fo:table-cell padding-before=\"1mm\" padding-after=\"0.6mm\" border-width=\"0.1mm\" border-style=\"solid\">\n";
			            			tmpFoFileStream.write(sLinea.getBytes());
							            sLinea = "      <fo:block  text-align=\"center\" font-weight=\"bold\">\n Concepto </fo:block>\n";
							            tmpFoFileStream.write(sLinea.getBytes());
			            			sLinea = "	    </fo:table-cell>\n";
			            			tmpFoFileStream.write(sLinea.getBytes());
			            			// CIF 
			            			sLinea = "	    <fo:table-cell padding-before=\"1mm\" padding-after=\"0.6mm\" border-width=\"0.1mm\" border-style=\"solid\">\n";
			            			tmpFoFileStream.write(sLinea.getBytes());
								        sLinea = "      <fo:block  text-align=\"center\" font-weight=\"bold\">\n CIF </fo:block>";
				 			            tmpFoFileStream.write(sLinea.getBytes());
			            			sLinea = "	    </fo:table-cell>\n";
			            			tmpFoFileStream.write(sLinea.getBytes());
			            			// Importe
			            			sLinea = "	    <fo:table-cell padding-before=\"1mm\" padding-after=\"0.6mm\" border-width=\"0.1mm\" border-style=\"solid\">\n";
			            			tmpFoFileStream.write(sLinea.getBytes());
								        sLinea = "      <fo:block  text-align=\"center\" font-weight=\"bold\">\n Importe </fo:block>\n";
								        tmpFoFileStream.write(sLinea.getBytes());
			            			sLinea = "	    </fo:table-cell>\n";
			            			tmpFoFileStream.write(sLinea.getBytes());
			            			// Cargo/Abono
			            			sLinea = "	    <fo:table-cell padding-before=\"1mm\" padding-after=\"0.6mm\" border-width=\"0.1mm\" border-style=\"solid\">\n";
			            			tmpFoFileStream.write(sLinea.getBytes());
							            sLinea = "      <fo:block  text-align=\"center\" font-weight=\"bold\">\n Cargo/Abono </fo:block>\n";
							            tmpFoFileStream.write(sLinea.getBytes());
			            			sLinea = "	    </fo:table-cell>\n";
			            			tmpFoFileStream.write(sLinea.getBytes());
			            		sLinea = "	    </fo:table-row>\n";
			            		tmpFoFileStream.write(sLinea.getBytes());
			            	
			            	int cont=0;
	     					miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC,"......   PRIMER REGISTRO: " + inputLine,m05bConstantes.LOG_NIVEL_BAJO);
		 					while ( (inputLine = bf.readLine()) != null) {
			   		    	    sTarjeta = inputLine.substring(11,27);
			       	    		sCentro = inputLine.substring(2,5);
			       	    		sCentroTarj="";
		   		    	    	if ( (fncComprobarCentro(sTarjeta, sCentro))==false ) {
				   		    	    sFecha = inputLine.substring(101,103)+"/"+inputLine.substring(99,101)+"/"+inputLine.substring(95,99);
			       	    			sHora = inputLine.substring(103,105)+ ":" +inputLine.substring(105,107) ;
									sConcepto = inputLine.substring(28,47);
						            sTipo=inputLine.substring(27,28);
									sCIF = inputLine.substring(47,56);
			       	    			sCargabon = inputLine.substring(116,117);
		       	    				sImporte = inputLine.substring(107,114)+","+inputLine.substring(114,116);
			       	    			while (sImporte.length() > 0)  {
			       	    				//Quitar ceros a la izda
			       	    				if (sImporte.substring(0,2).equals("0,"))  {
			       	    					break;
			       	    				}  else if (sImporte.substring(0,1).equals("0")) {
			       	    					sImporte=sImporte.substring(1,sImporte.length());
			       	    				}  else {
		       	    						break;
		       	    					}			       	    				
			       	    		   }
								   if (sCargabon.equals(m05bConstantes.TAR_ABONO))  {
								   	   sTipo = "-" + sTipo;
								   }
	   		                        sLinea = "	    <fo:table-row >\n";
				            		tmpFoFileStream.write(sLinea.getBytes());
				            			// Tarjeta 
				            		if (!(sTarjeta.equals(sTarjetaAnt)))  {
				            			sLinea = "	    <fo:table-cell padding-top=\"0.2mm\" border-width=\"0.1mm\" border-style=\"solid\">\n";
				            			tmpFoFileStream.write(sLinea.getBytes());
									        sLinea = "      <fo:block  text-align=\"center\">\n " + sTarjeta + "</fo:block>";
									} else  {
				            			sLinea = "	    <fo:table-cell padding-top=\"0.2mm\" border-width=\"0.1mm\">\n";
				            			tmpFoFileStream.write(sLinea.getBytes());
									        sLinea = "      <fo:block>\n </fo:block>";
									}
					 			        	tmpFoFileStream.write(sLinea.getBytes());
				            			sLinea = "	    </fo:table-cell>\n";
				            			tmpFoFileStream.write(sLinea.getBytes());
				            			// Fecha
				            			sLinea = "	    <fo:table-cell padding-top=\"0.2mm\" border-width=\"0.1mm\" border-style=\"solid\">\n";
				            			tmpFoFileStream.write(sLinea.getBytes());
									        sLinea = "      <fo:block  text-align=\"center\">\n "+ sFecha +"</fo:block>\n";
									        tmpFoFileStream.write(sLinea.getBytes());
				            			sLinea = "	    </fo:table-cell>\n";
				            			tmpFoFileStream.write(sLinea.getBytes());
				            			// Hora
				            			sLinea = "	    <fo:table-cell padding-top=\"0.2mm\" border-width=\"0.1mm\" border-style=\"solid\">\n";
				            			tmpFoFileStream.write(sLinea.getBytes());
									        sLinea = "      <fo:block  text-align=\"center\">\n "+ sHora +"</fo:block>\n";
									        tmpFoFileStream.write(sLinea.getBytes());
				            			sLinea = "	    </fo:table-cell>\n";
				            			tmpFoFileStream.write(sLinea.getBytes());
				            			// Matricula
				            			sLinea = "	    <fo:table-cell padding-top=\"0.2mm\" border-width=\"0.1mm\" border-style=\"solid\">\n";
				            			tmpFoFileStream.write(sLinea.getBytes());
								            sLinea = "      <fo:block  text-align=\"center\">\n"+ sMatricula +"</fo:block>\n";
								            tmpFoFileStream.write(sLinea.getBytes());
				            			sLinea = "	    </fo:table-cell>\n";
				            			tmpFoFileStream.write(sLinea.getBytes());
				            			// CentroFich
				            			sLinea = "	    <fo:table-cell padding-top=\"0.2mm\" border-width=\"0.1mm\" border-style=\"solid\">\n";
				            			tmpFoFileStream.write(sLinea.getBytes());
								            sLinea = "      <fo:block  text-align=\"center\">\n"+sCentro +"</fo:block>\n";
								            tmpFoFileStream.write(sLinea.getBytes());
				            			sLinea = "	    </fo:table-cell>\n";
				            			tmpFoFileStream.write(sLinea.getBytes());
				            			// CentroTarj 
				            			sLinea = "	    <fo:table-cell padding-top=\"0.2mm\" border-width=\"0.1mm\" border-style=\"solid\">\n";
				            			tmpFoFileStream.write(sLinea.getBytes());
									        sLinea = "      <fo:block  text-align=\"center\">\n " + sCentroTarj + "</fo:block>";
					 			            tmpFoFileStream.write(sLinea.getBytes());
				            			sLinea = "	    </fo:table-cell>\n";
				            			tmpFoFileStream.write(sLinea.getBytes());
				            			// Tipo
				            			sLinea = "	    <fo:table-cell padding-top=\"0.2mm\" border-width=\"0.1mm\" border-style=\"solid\">\n";
				            			tmpFoFileStream.write(sLinea.getBytes());
									        sLinea = "      <fo:block  text-align=\"center\">\n "+ sTipo +"</fo:block>\n";
									        tmpFoFileStream.write(sLinea.getBytes());
				            			sLinea = "	    </fo:table-cell>\n";
				            			tmpFoFileStream.write(sLinea.getBytes());
				            			// Concepto
				            			sLinea = "	    <fo:table-cell padding-top=\"0.2mm\" border-width=\"0.1mm\" border-style=\"solid\">\n";
				            			tmpFoFileStream.write(sLinea.getBytes());
								            sLinea = "      <fo:block text-align=\"center\">\n"+ sConcepto +"</fo:block>\n";
								            tmpFoFileStream.write(sLinea.getBytes());
				            			sLinea = "	    </fo:table-cell>\n";
				            			tmpFoFileStream.write(sLinea.getBytes());
				            			// CIF 
				            			sLinea = "	    <fo:table-cell padding-top=\"0.2mm\" border-width=\"0.1mm\" border-style=\"solid\">\n";
				            			tmpFoFileStream.write(sLinea.getBytes());
									        sLinea = "      <fo:block  text-align=\"center\">\n " + sCIF + "</fo:block>";
					 			            tmpFoFileStream.write(sLinea.getBytes());
				            			sLinea = "	    </fo:table-cell>\n";
				            			tmpFoFileStream.write(sLinea.getBytes());
				            			// Importe
				            			sLinea = "	    <fo:table-cell padding-top=\"0.2mm\" border-width=\"0.1mm\" border-style=\"solid\">\n";
				            			tmpFoFileStream.write(sLinea.getBytes());
									        sLinea = "      <fo:block  text-align=\"center\">\n "+ sImporte +"</fo:block>\n";
									        tmpFoFileStream.write(sLinea.getBytes());
				            			sLinea = "	    </fo:table-cell>\n";
				            			tmpFoFileStream.write(sLinea.getBytes());
				            			// Cargo/Abono
				            			sLinea = "	    <fo:table-cell padding-top=\"0.2mm\" border-width=\"0.1mm\" border-style=\"solid\">\n";
				            			tmpFoFileStream.write(sLinea.getBytes());
								            sLinea = "      <fo:block text-align=\"center\">\n"+ sCargabon +"</fo:block>\n";
								            tmpFoFileStream.write(sLinea.getBytes());
				            			sLinea = "	    </fo:table-cell>\n";
				            			tmpFoFileStream.write(sLinea.getBytes());
				            		sLinea = "	    </fo:table-row>\n";
				            		tmpFoFileStream.write(sLinea.getBytes());
				            		sTarjetaAnt=sTarjeta;
				            	}  // Fin if 
							} // Fin bucle while
	     					miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC,"......   FIN WHILE  ",m05bConstantes.LOG_NIVEL_BAJO );
								
			 	      	    sLinea = "	    </fo:table-body>\n";
			            	tmpFoFileStream.write(sLinea.getBytes());			            								            		
			            sLinea= "       </fo:table>\n";
		            	tmpFoFileStream.write(sLinea.getBytes());
		          //  sLinea = "      </fo:block-container>\n";
		           // tmpFoFileStream.write(sLinea.getBytes());

		         sLinea = "      </fo:flow>\n";
                 tmpFoFileStream.write(sLinea.getBytes());

        /*	sLinea = " 		</fo:static-content>\n"; 
        	tmpFoFileStream.write(sLinea.getBytes());*/
                 
         	 sLinea = "   </fo:page-sequence>\n";
             tmpFoFileStream.write(sLinea.getBytes());
             
         sLinea = "</fo:root>\n";
         tmpFoFileStream.write(sLinea.getBytes());

         tmpFoFileStream.close();
         
		 miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC, "Antes Generar PDF desde FO" , m05bConstantes.LOG_NIVEL_BAJO);
         miInforme.generarPDFdesdeFO(response);
		 miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC, "Despues Generar PDF desde FO" , m05bConstantes.LOG_NIVEL_BAJO);

		 //fncBorrarCargaGastosTarjetas(id);
  		 conn.commit();

      } catch (Exception ex) {
      	try {
			response.sendRedirect("m05bError.jsp");
		} catch (IOException e) {
			// TODO Auto-generated catch block
			miLog.addTraza(e);
		}
      } finally{
	   	    try {
				if (conn != null)
					conn.close();
			} catch (SQLException e2) {
				miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC,"Exception: COMPROBAR TARJ EXISTE --> " + e2, m05bConstantes.LOG_NIVEL_BAJO);
				try {
					response.sendRedirect("m05bError.jsp");
				} catch (IOException e) {
					// TODO Auto-generated catch block
					miLog.addTraza(e);
				}
			}  
	  }  
	}  // Fin funcion performTask


}