package tarjetasServlet;



import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Locale;

import javax.servlet.http.HttpSession;

import m05bBD.m05bHisTarjetas;
import m05bClasses.m05bComun;
import m05bClasses.m05bConexion;
import m05bClasses.m05bConstantes;
import m05bClasses.m05bFileLog;
import m05bClasses.m05bGenerarClave;
import m05bClasses.m05bMensajes;


/**
 * Inserte aqu la descripcin del tipo.
 * Fecha de creacin: (27/08/04)
 */
public class m05bGrabarTarjetasServlet extends javax.servlet.http.HttpServlet {
	m05bFileLog miLog = new m05bFileLog();

/**
 * Process incoming HTTP POST requests
 *
 * @param request Object that encapsulates the request to the servlet
 * @param response Object that encapsulates the response from the servlet
 */
 
   java.sql.Connection conn=null;
   PreparedStatement  pstmt = null; 
   ResultSet rs = null;
   SimpleDateFormat formatterDate = new SimpleDateFormat ("dd/MM/yyyy");
   m05bComun miComun = new m05bComun();

   m05bHisTarjetas tarjetas=null;
   
   String sNumeroHist="", sNumero="",sMatricula="",sCentro="",sCentroBD="",sDescCentroBD="",sLimite="", sDescCentro="";
   String sFAlta="", sFBaja="", sFSolic="", sFCaduc="", sFCambio="", sFSolicI="", sLiteral="", sNCta="", sPlastic="";
   String sSituacion="", sIncidencia="", sTAG="",sFExped="",sSituacionBD="",accion="",sql = "",sMotivo="",sModificacion="";     
   String sTipo="";  
   String sNumeroHistAnt="";
   String sErrorCentro="0";
   String sRegistroEnCurso="0";
   String sCambio=m05bConstantes.VERIFICADO_SI ;
   
   HttpSession session = null;
   String persona="";
   
public void doPost(javax.servlet.http.HttpServletRequest request, javax.servlet.http.HttpServletResponse response) throws javax.servlet.ServletException, java.io.IOException {

	performTask(request, response);




}
/**
 * Returns the servlet info string.
 */
public String getServletInfo() {

	return super.getServletInfo();

}
/**
 * Initializes the servlet.
 */
public void init() {
	// insert code to initialize the servlet here

}


   private void recogerParametros(javax.servlet.http.HttpServletRequest request, javax.servlet.http.HttpServletResponse response){
	   session = request.getSession(true);
	   persona = (String) session.getAttribute("persona");       
   	   
		tarjetas = (m05bHisTarjetas)session.getAttribute("m05bHisTarjetas");
   	   
        sNumeroHist = request.getParameter("CodInterno");
		tarjetas.setTar_hisnumero(sNumeroHist);
        miLog.addTraza(persona , "Tarjetas RecogerParametros" , "sNumeroHist:  " + sNumeroHist,m05bConstantes.LOG_NIVEL_BAJO);
        sNumero = request.getParameter("Codigo");
        if (sNumero == null )
           sNumero="";
		tarjetas.setTar_numero(sNumero);
		
		sCentro=request.getParameter("CentroT").trim().toUpperCase();
        if (sCentro==null)
            sCentro="";
		tarjetas.setTar_centro(sCentro);
 
        sDescCentro=request.getParameter("DescCentro").trim().toUpperCase();
        if (sDescCentro==null)
        	sDescCentro="";		        
        sMatricula=request.getParameter("Matricula");
        tarjetas.setTar_matricula(sMatricula);
        
        sLimite=request.getParameter("Limite");
        if (sLimite == null )
           sLimite=m05bConstantes.TAR_LIMITE;
        sLimite= miComun.ImportesABasedatos(sLimite);
        tarjetas.setTar_limite(sLimite);
        
        sFAlta=request.getParameter("FAlta");
        if (sFAlta == null )
           sFAlta="";
        tarjetas.setTar_falta(sFAlta);
        
        sFBaja=request.getParameter("FBaja");
        if (sFBaja == null )
           sFBaja="";
        tarjetas.setTar_fbaja(sFBaja);
        
        sFSolic=request.getParameter("FSolic");
        if (sFSolic == null )
           sFSolic="";
        tarjetas.setTar_fsolic(sFSolic);
        
        sFCaduc=request.getParameter("FCaduc");
        if (sFCaduc == null )
           sFCaduc="";
        tarjetas.setTar_fcaduc(sFCaduc);
        
        sFExped=request.getParameter("FExped");
        if (sFExped == null )
           sFExped="";
        tarjetas.setTar_fexped(sFExped);
        
        sLiteral=request.getParameter("Literal");
        tarjetas.setTar_literal(sLiteral);
        
        sNCta=request.getParameter("NCta");
        tarjetas.setTar_banco(sNCta);
        
        sPlastic=request.getParameter("Plastic");
        tarjetas.setTar_plastic(sPlastic);
        
        sSituacion=request.getParameter("SituacionT");
        tarjetas.setTar_situacion(sSituacion);
        
        sIncidencia=request.getParameter("Incidencia");
        if (sIncidencia == null )
           sIncidencia="";
        tarjetas.setTar_incidencia(sIncidencia);

        sModificacion=request.getParameter("Modificacion");
        if (sModificacion == null )
           sModificacion="";
        
        //sTAG=request.getParameter("TAG");
        //if (sTAG == null )
        //   sTAG="";
        //tarjetas.setTar_tag(sTAG);
		
		accion=request.getParameter("Accion");
		
		sMotivo=request.getParameter("Motivo");
		
		
		// Tipo.G o V
        sTipo=request.getParameter("Tipo");
        miLog.addTraza(persona , "Tarjetas RecogerParametros" , "sTipo:  " + sTipo,m05bConstantes.LOG_NIVEL_BAJO);
        
        if (sTipo == null )
           sTipo="";
        tarjetas.setTar_tipo(sTipo);
		//Metemos en Sesion
  	    session.setAttribute("m05bHisTarjetas",tarjetas);
   }
   
  private String FechaDelSistema()throws java.lang.Exception{
  String verified = "0";
  
  	try{
	  sql =  "select TO_CHAR (SYSDATE,'dd/mm/yyyy') from DUAL"; 
      miLog.addTraza(persona , "Tarjetas" , "Fecha del Sistema: " + sql,m05bConstantes.LOG_NIVEL_BAJO);
	  pstmt = conn.prepareStatement(sql);
	  rs = pstmt.executeQuery();
	  if (rs.next()){sFSolicI = rs.getString(1);}
	  verified="0";
      ////System.out.println(sql);
     } catch (Exception ex) {
			try {
	  			verified="2";
	  			conn.rollback();  // Ha habido problemas, se deshacen todos los cambios
	  			throw new Exception(ex);
	  		} catch (SQLException e1){
                miLog.addTraza(persona , "Tarjetas FechaDelSistema" , "Exception: SQL: " + e1,m05bConstantes.LOG_NIVEL_BAJO);
	  		}
			miLog.addTraza(ex);
	   } finally{
	   	    try {
				if (rs != null)
					rs.close();
				if (pstmt != null)
					pstmt.close();
				
			} catch (SQLException e2) {
                miLog.addTraza(persona , "Tarjetas FechaDelSistema" , "Exception: SQL: " + e2,m05bConstantes.LOG_NIVEL_BAJO);
				
	  		}
	   }
   //System.out.println("m05b - Grabar Tarjetas: Ejecutar fecha del sistema: " + verified );
   return verified;
}
  private String ExisteTarjeta()throws java.lang.Exception{
  String verified = "0";
  
  	try{
        sql =  "select 1" +
        " from " + m05bConstantes.TAB_TARJETAS +
        " where " +  m05bConstantes.COL_31_TARJETA + " ='" + sNumero  +"' AND " +
                   m05bConstantes.COL_31_MATRICULA + " != '" + sMatricula + "'";	  		
  		if (sTipo.equals(m05bConstantes.TAR_VIAT)){
  			
  			sql=sql+ " AND "+ m05bConstantes.COL_31_SITUACION+" in ('"+m05bConstantes.TAR_ALTA+ "','"+m05bConstantes.TAR_SOLICITADA+"')";
  		}
	
      miLog.addTraza(persona , "Tarjetas" , "Existe la Tarjeta en la 31: " + sql,m05bConstantes.LOG_NIVEL_BAJO);
      pstmt = conn.prepareStatement(sql);
      rs = pstmt.executeQuery();
      if (rs.next()){  
          verified = "1";}
     } catch (Exception ex) {
			try {
	  			verified="2";
	  			conn.rollback();  // Ha habido problemas, se deshacen todos los cambios
	  			throw new Exception(ex);
	  		} catch (SQLException e1){
                miLog.addTraza(persona , "Tarjetas ExisteTarjeta" , "Exception: SQL: " + e1,m05bConstantes.LOG_NIVEL_BAJO);
	  		}
			miLog.addTraza(ex);
	   } finally{
	   	    try {
				if (rs != null)
					rs.close();
				if (pstmt != null)
					pstmt.close();
				
			} catch (SQLException e2) {
                miLog.addTraza(persona , "Tarjetas ExisteTarjeta" , "Exception: SQL: " + e2,m05bConstantes.LOG_NIVEL_BAJO);
	  		}
	   }
   ////System.out.println("m05b - Grabar Tarjetas: Ejecutar fecha del sistema: " + verified );
   return verified;
}
  private String RegistroEnCurso()throws java.lang.Exception{
  String verified = "0";
  
  	try{
     sql = "select 1" +
	       " from " + m05bConstantes.TAB_TARJETAS  +
           " where	" + m05bConstantes.COL_31_TARJHIST + " = '" + sNumeroHist + "'" ;
      miLog.addTraza(persona , "Tarjetas" , "RegistroEnCurso: " + sql,m05bConstantes.LOG_NIVEL_BAJO);
      pstmt = conn.prepareStatement(sql);
      rs = pstmt.executeQuery();
      if (!(rs.next())){  
          verified = "1";}
      ////System.out.println(sql);
     } catch (Exception ex) {
			try {
	  			verified="2";
	  			conn.rollback();  // Ha habido problemas, se deshacen todos los cambios
	  			throw new Exception(ex);
	  		} catch (SQLException e1){
                miLog.addTraza(persona , "Tarjetas RegistroEnCurso" , "Exception: SQL: " + e1,m05bConstantes.LOG_NIVEL_BAJO);
	  		}
			miLog.addTraza(ex);
	   } finally{
	   	    try {
				if (rs != null)
					rs.close();
				if (pstmt != null)
					pstmt.close();
				
			} catch (SQLException e2) {
                miLog.addTraza(persona , "Tarjetas RegistroEnCurso" , "Exception: SQL: " + e2,m05bConstantes.LOG_NIVEL_BAJO);
	  		}
	   }
   ////System.out.println("m05b - Grabar Tarjetas: Ejecutar fecha del sistema: " + verified );
   return verified;
}
  private String RecogerDepartamentoSituacion()throws java.lang.Exception{
  String verified = "0";
  
  	try{
		sql =  "select " + m05bConstantes.COL_31_SITUACION + ","+
		        m05bConstantes.COL_31_CENTRO + "," + m05bConstantes.COL_05_DESC + 
			    " from " + m05bConstantes.TAB_TARJETAS  + "," + m05bConstantes.TAB_CENTROS +
			    " where " +  m05bConstantes.COL_31_TARJHIST + " = '" + sNumeroHist + "' AND " +
			    m05bConstantes.COL_31_CENTRO + "=" + m05bConstantes.COL_05_CODIGO+"(+)"  ;
        miLog.addTraza(persona , "Tarjetas" , "RecogerDepartamentoSituacion: " + sql,m05bConstantes.LOG_NIVEL_BAJO);
        pstmt = conn.prepareStatement(sql);
        rs = pstmt.executeQuery();
        if (rs.next()){  
          sSituacionBD= rs.getString(1);
          sCentroBD= rs.getString(2);
          sDescCentroBD= rs.getString(3);
        }
      ////System.out.println(sql);
     } catch (Exception ex) {
			try {
	  			verified="2";
	  			conn.rollback();  // Ha habido problemas, se deshacen todos los cambios
	  			throw new Exception(ex);
	  		} catch (SQLException e1){
                miLog.addTraza(persona , "Tarjetas RecogerDepartamentoSituacion" , "Exception: SQL: " + e1,m05bConstantes.LOG_NIVEL_BAJO);
	  		}
			miLog.addTraza(ex);
	   } finally{
	   	    try {
				if (rs != null)
					rs.close();
				if (pstmt != null)
					pstmt.close();
				
			} catch (SQLException e2) {
                miLog.addTraza(persona , "Tarjetas RecogerDepartamentoSituacion" , "Exception: SQL: " + e2,m05bConstantes.LOG_NIVEL_BAJO);
	  		}
	   }
   ////System.out.println("m05b - Grabar Tarjetas: Ejecutar fecha del sistema: " + verified );
   return verified;
}
  private String RecogerDescripcionCentro()throws java.lang.Exception{
  String verified = "0";
  
  	try{
	 sql =  "select " + m05bConstantes.COL_05_DESC + "," + "TO_CHAR (SYSDATE,'dd/mm/yyyy')" +
	        " from " + m05bConstantes.TAB_CENTROS +
	        " where " +  m05bConstantes.COL_05_CODIGO + " ='" + sCentro +"'"  ;
      miLog.addTraza(persona , "Tarjetas" , "RecogerDescripcionCentro: " + sql,m05bConstantes.LOG_NIVEL_BAJO);
	 
     pstmt = conn.prepareStatement(sql);
   	 rs = pstmt.executeQuery();
     if (rs.next()){  
         sDescCentro= rs.getString(1);	  
         sFCambio= rs.getString(2);	}       	    
      ////System.out.println(sql);
     } catch (Exception ex) {
			try {
	  			verified="2";
	  			conn.rollback();  // Ha habido problemas, se deshacen todos los cambios
	  			throw new Exception(ex);
	  		} catch (SQLException e1){
                miLog.addTraza(persona , "Tarjetas RecogerDescripcionCentro" , "Exception: SQL: " + e1,m05bConstantes.LOG_NIVEL_BAJO);
	  		}
			miLog.addTraza(ex);
	   } finally{
	   	    try {
				if (rs != null)
					rs.close();
				if (pstmt != null)
					pstmt.close();
				
			} catch (SQLException e2) {
                miLog.addTraza(persona , "Tarjetas RecogerDescripcionCentro" , "Exception: SQL: " + e2,m05bConstantes.LOG_NIVEL_BAJO);
	  		}
	   }
   ////System.out.println("m05b - Grabar Tarjetas: Ejecutar fecha del sistema: " + verified );
   return verified;
}
  private String InsertarCambioCentro()throws java.lang.Exception{
  String verified = "0";
  
  	try{
	 sql = "insert into " +m05bConstantes.TAB_HIST_CENTROS+
	       " ("+m05bConstantes.COL_10_MATRICULA+", "+m05bConstantes.COL_10_TARJETA+
           ","+m05bConstantes.COL_10_CODCTRANT+","+m05bConstantes.COL_10_DESCTRANT+
           ","+m05bConstantes.COL_10_CODCTRNUE+","+m05bConstantes.COL_10_DESCTRNUE+
           ","+m05bConstantes.COL_10_MOTIVO+","+m05bConstantes.COL_10_FCAMBIO+") " +
	       " values " +
		   "( '" + sMatricula +  "','" + sNumero + 
		   "','" + sCentroBD + "','" + sDescCentroBD +
		   "','" + sCentro + "','" + sDescCentro +
		   "','" + sMotivo + "' , to_date('" + sFCambio + "','dd/mm/yyyy'))";
     miLog.addTraza(persona , "Tarjetas InsertarCambioCentro" , " SQL: " + sql,m05bConstantes.LOG_NIVEL_BAJO);
     pstmt = conn.prepareStatement(sql);
     pstmt.executeUpdate();
     } catch (Exception ex) {
			try {
	  			verified="2";
	  			conn.rollback();  // Ha habido problemas, se deshacen todos los cambios
	  			throw new Exception(ex);
	  		} catch (SQLException e1){
                miLog.addTraza(persona , "Tarjetas InsertarCambioCentro" , "Exception: SQL: " + e1,m05bConstantes.LOG_NIVEL_BAJO);
	  		}
			miLog.addTraza(ex);
	   } finally{
	   	    try {
				if (pstmt != null)
					pstmt.close();
				
			} catch (SQLException e2) {
                miLog.addTraza(persona , "Tarjetas InsertarCambioCentro" , "Exception: SQL: " + e2,m05bConstantes.LOG_NIVEL_BAJO);
	  		}
	   }
   ////System.out.println("m05b - Grabar Tarjetas: Ejecutar fecha del sistema: " + verified );
   return verified;
}
  private String ActualizarTabla31(String Cambio,String formatoFecha)throws java.lang.Exception{
  String verified = "0";
  
  	try{
			       sql = "update " + m05bConstantes.TAB_TARJETAS+
				   " set " + m05bConstantes.COL_31_FBAJA + " = to_date('" + sFBaja + "','"+formatoFecha+"')" +
				         " , "+m05bConstantes.COL_31_TARJETA +  " = '" + sNumero + "'" +
                         " , "+m05bConstantes.COL_31_FCADUC + " = to_date('" + sFCaduc + 
                         "','"+formatoFecha+"')" +
                         " , "+m05bConstantes.COL_31_FSOLIC + " = to_date('" + sFSolic + 
                         "','"+formatoFecha+"')" +
                         " , "+m05bConstantes.COL_31_FALTA + " = to_date('" + sFAlta + 
                         "','"+formatoFecha+"')" ;
                       
			             if (!(Cambio.equals(""))){
			            	 sql=sql+  " , "+m05bConstantes.COL_31_FCAMBIO + " = to_date('" + sFCambio + 
	                         "','"+formatoFecha+"')"+
                             " , "+m05bConstantes.COL_31_CAMBIO +  " = '" + sCambio + "'" ;
			             }
                         sql=sql+" , "+m05bConstantes.COL_31_LIMITE +  " = " + sLimite +
                         " , "+m05bConstantes.COL_31_LITERAL + " = '" + sLiteral + "'" +
                         " , "+m05bConstantes.COL_31_CUENTA+ " = '" + sNCta + "'" +
                         " , "+m05bConstantes.COL_31_PLASTIC+ " = UPPER('" + sPlastic + "')" +
                         " , "+m05bConstantes.COL_31_INCIDENCIA+ " = '" + sIncidencia + "'" +
                         " , "+m05bConstantes.COL_31_SITUACION+ " = '" + sSituacion + "'" +
                         " , "+m05bConstantes.COL_31_CENTRO+ " = '" + sCentro + "'" +
                         //" , "+m05bConstantes.COL_31_TAG+ " = '" + sTAG + "'" +
                         " , "+m05bConstantes.COL_31_TIPO+ " = '" + sTipo + "'" +
                         " where	" + m05bConstantes.COL_31_TARJHIST + " = " + sNumeroHist  ;
     miLog.addTraza(persona , "Tarjetas ActualizarTabla31" , " SQL: " + sql,m05bConstantes.LOG_NIVEL_BAJO);
     pstmt = conn.prepareStatement(sql);
     pstmt.executeUpdate();
     ////System.out.println(sql);
     } catch (Exception ex) {
			try {
	  			verified="2";
	  			conn.rollback();  // Ha habido problemas, se deshacen todos los cambios
	  			throw new Exception(ex);
	  		} catch (SQLException e1){
                miLog.addTraza(persona , "Tarjetas ActualizarTabla31" , "Exception: SQL: " + e1,m05bConstantes.LOG_NIVEL_BAJO);
	  		}
			miLog.addTraza(ex);
	   } finally{
	   	    try {
				if (pstmt != null)
					pstmt.close();
				
			} catch (SQLException e2) {
                miLog.addTraza(persona , "Tarjetas ActualizarTabla31" , "Exception: SQL: " + e2,m05bConstantes.LOG_NIVEL_BAJO);
	  		}
	   }
   ////System.out.println("m05b - Grabar Tarjetas: Ejecutar fecha del sistema: " + verified );
   return verified;
}

  private String ActualizarTabla141(String formatoFecha)throws java.lang.Exception{
  String verified = "0";
  
  	try{
			       sql = "update " +m05bConstantes.TAB_HIST_TARJETAS+
				         " set " + m05bConstantes.COL_14_FBAJA + " = to_date('" + sFBaja + "','dd/mm/yyyy')" +
				         " , "+m05bConstantes.COL_14_TARJETA +  " = '" + sNumero + "'" +
                         " , "+m05bConstantes.COL_14_FCADUC + " = to_date('" + sFCaduc + 
                         "','"+formatoFecha+"')" +
                         " , "+m05bConstantes.COL_14_FSOLIC + " = to_date('" + sFSolic + 
                         "','"+formatoFecha+"')" +
                         " , "+m05bConstantes.COL_14_FALTA + " = to_date('" + sFAlta + 
                         "','"+formatoFecha+"')" +
                         " , "+m05bConstantes.COL_14_FEXPED + " = to_date('" + sFExped + 
                         "','"+formatoFecha+"')" +
                         " , "+m05bConstantes.COL_14_LIMITE +  " = " + sLimite  +
                         " , "+m05bConstantes.COL_14_LITERAL + " = '" + sLiteral + "'" +
                         " , "+m05bConstantes.COL_14_BANCO+ " = '" + sNCta + "'" +
                         " , "+m05bConstantes.COL_14_PLASTIC+ " = UPPER('" + sPlastic + "')" +
                         " , "+m05bConstantes.COL_14_INCIDENCIA+ " = '" + sIncidencia + "'" +
                         " , "+m05bConstantes.COL_14_SITUACION+ " = '" + sSituacion + "'" +
                         " , "+m05bConstantes.COL_14_CTRO+ " = '" + sCentro + "'" +
                         //" , "+m05bConstantes.COL_14_TAG+ " = '" + sTAG + "'" +
                         " , "+m05bConstantes.COL_14_TIPO+ " = '" + sTipo + "'" +
                         " where	" + m05bConstantes.COL_14_TARJHIST + " = " + sNumeroHist  ;
     miLog.addTraza(persona , "Tarjetas ActualizarTabla14-1" , " SQL: " + sql,m05bConstantes.LOG_NIVEL_BAJO);
                   
				    pstmt = conn.prepareStatement(sql);
			        pstmt.executeUpdate();
      //System.out.println(sql);
     } catch (Exception ex) {
			try {
	  			verified="2";
	  			conn.rollback();  // Ha habido problemas, se deshacen todos los cambios
	  			throw new Exception(ex);
	  		} catch (SQLException e1){
                miLog.addTraza(persona , "Tarjetas ActualizarTabla14-1" , "Exception: SQL: " + e1,m05bConstantes.LOG_NIVEL_BAJO);
	  		}
			miLog.addTraza(ex);
	   } finally{
	   	    try {
				if (pstmt != null)
					pstmt.close();
				
			} catch (SQLException e2) {
                miLog.addTraza(persona , "Tarjetas ActualizarTabla14-1" , "Exception: SQL: " + e2,m05bConstantes.LOG_NIVEL_BAJO);
	  		}
	   }
   //System.out.println("m05b - Grabar Tarjetas: Ejecutar fecha del sistema: " + verified );
   return verified;
}
  private String InsertarTabla141(String formatoFecha)throws java.lang.Exception{
  String verified = "0";
  
  	try{
				sql = "insert into " +m05bConstantes.TAB_HIST_TARJETAS+
					" ("+m05bConstantes.COL_14_TARJHIST+", "+m05bConstantes.COL_14_TARJETA+
                    ","+m05bConstantes.COL_14_MATRICULA+","+m05bConstantes.COL_14_LIMITE+
                    ","+m05bConstantes.COL_14_FALTA+","+m05bConstantes.COL_14_FBAJA+
                    ","+m05bConstantes.COL_14_FSOLIC+","+m05bConstantes.COL_14_FEXPED+
                    ","+m05bConstantes.COL_14_FCADUC+","+m05bConstantes.COL_14_LITERAL+
                    ","+m05bConstantes.COL_14_BANCO+","+m05bConstantes.COL_14_PLASTIC+
                    ","+m05bConstantes.COL_14_SITUACION+","+m05bConstantes.COL_14_INCIDENCIA+
                    ","+m05bConstantes.COL_14_CTRO+","+
                    //m05bConstantes.COL_14_TAG+","+
                    m05bConstantes.COL_14_TIPO+") " +
					" values " +
					"(" + sNumeroHist + ",'" + sNumero +  "','" + sMatricula + "'," + sLimite +"," +
                              " to_date('" + sFAlta + "','"+formatoFecha+"'), " ;
				     if (sFBaja.equals("")){
                       sql=sql+" to_date(TO_CHAR( sysdate,'ddmmyyyy'),'"+formatoFecha+"'), " ;
    
				     }else{
	                       sql=sql+" to_date( '"+sFBaja+"','"+formatoFecha+"'), " ;
                       }
				     sql=sql+ " to_date('" + sFSolic + "','"+formatoFecha+"'), " +
                     " to_date('" + sFExped + "','"+formatoFecha+"'), " +                    
                     " to_date('" + sFCaduc + "','"+formatoFecha+"'), '" +
                     sLiteral +  "','" + sNCta + "',UPPER('" + sPlastic + "'),'" + sSituacion +"','" +
                     sIncidencia+  "','" + sCentro +  "','" + 
                     //sTAG+"','" + 
                     sTipo + "')";       
     miLog.addTraza(persona , "Tarjetas ActualizarTabla14-1" , " SQL: " + sql,m05bConstantes.LOG_NIVEL_BAJO);
	 pstmt = conn.prepareStatement(sql);
	 pstmt.executeUpdate();
      //System.out.println(sql);
     } catch (Exception ex) {
			try {
	  			verified="2";
	  			conn.rollback();  // Ha habido problemas, se deshacen todos los cambios
	  			throw new Exception(ex);
	  		} catch (SQLException e1){
                miLog.addTraza(persona , "Tarjetas InsertarTabla14-1" , "Exception: SQL: " + e1,m05bConstantes.LOG_NIVEL_BAJO);
	  		}
			miLog.addTraza(ex);
	   } finally{
	   	    try {
				if (pstmt != null)
					pstmt.close();
				
			} catch (SQLException e2) {
                miLog.addTraza(persona , "Tarjetas InsertarTabla14-1" , "Exception: SQL: " + e2,m05bConstantes.LOG_NIVEL_BAJO);
	  		}
	   }
   //System.out.println("m05b - Grabar Tarjetas: Ejecutar fecha del sistema: " + verified );
   return verified;
}
  private String Actualizar31ImpresoAN(String formatoFecha)throws java.lang.Exception{
  String verified = "0";
  
  	try{
				sql = "Update "+m05bConstantes.TAB_TARJETAS+ " set " +m05bConstantes.COL_31_TARJHIST +
					  " = " + sNumeroHist + "," + m05bConstantes.COL_31_IMPRESO + " = 'N'" +
					  ","+m05bConstantes.COL_31_FBAJA+"=";
			         if (sFBaja.equals("")){
                        sql=sql+" to_date(TO_CHAR( sysdate,'ddmmyyyy'),'"+formatoFecha+"') " ;
  
				      }else{
	                       sql=sql+" to_date( '"+sFBaja+"','"+formatoFecha+"') " ;
                      }				
					  sql=sql+" where " + m05bConstantes.COL_31_TARJHIST  +"=" + sNumeroHistAnt + "";
     miLog.addTraza(persona , "Tarjetas Actualizar31ImpresoAN" , " SQL: " + sql,m05bConstantes.LOG_NIVEL_BAJO);
 	 pstmt = conn.prepareStatement(sql);
	 pstmt.executeUpdate();
      //System.out.println(sql);
     } catch (Exception ex) {
			try {
	  			verified="2";
	  			conn.rollback();  // Ha habido problemas, se deshacen todos los cambios
	  			throw new Exception(ex);
	  		} catch (SQLException e1){
                miLog.addTraza(persona , "Tarjetas Actualizar31ImpresoAN" , "Exception: SQL: " + e1,m05bConstantes.LOG_NIVEL_BAJO);
	  		}
			miLog.addTraza(ex);
	   } finally{
	   	    try {
				if (pstmt != null)
					pstmt.close();
				
			} catch (SQLException e2) {
                miLog.addTraza(persona , "Tarjetas Actualizar31ImpresoAN" , "Exception: SQL: " + e2,m05bConstantes.LOG_NIVEL_BAJO);
	  		}
	   }
   //System.out.println("m05b - Grabar Tarjetas: Ejecutar fecha del sistema: " + verified );
   return verified;
}
  private String ExisteSeguro()throws java.lang.Exception{
  String verified = "0";
  
  	try{
	            sql = "SELECT 1  FROM "+ m05bConstantes.TAB_HIST_SEGUROS +
  	            " WHERE " + m05bConstantes.COL_13_MATRICULA + "='" + sMatricula +
  	            "' AND " + m05bConstantes.COL_13_ESTADO + "='A'" ;
     miLog.addTraza(persona , "Tarjetas ExisteSeguro" , " SQL: " + sql,m05bConstantes.LOG_NIVEL_BAJO);
     pstmt = conn.prepareStatement(sql);
   	 rs = pstmt.executeQuery();
     if (!(rs.next())){  
       	verified="1";}
     } catch (Exception ex) {
			try {
	  			verified="2";
	  			conn.rollback();  // Ha habido problemas, se deshacen todos los cambios
	  			throw new Exception(ex);
	  		} catch (SQLException e1){
                miLog.addTraza(persona , "Tarjetas ExisteSeguro" , "Exception: SQL: " + e1,m05bConstantes.LOG_NIVEL_BAJO);
	  		}
			miLog.addTraza(ex);
	   } finally{
	   	    try {
				if (rs != null)
					rs.close();
				if (pstmt != null)
					pstmt.close();
				
			} catch (SQLException e2) {
                miLog.addTraza(persona , "Tarjetas ExisteSeguro" , "Exception: SQL: " + e2,m05bConstantes.LOG_NIVEL_BAJO);
	  		}
	   }
   //System.out.println("m05b - Grabar Tarjetas: Ejecutar fecha del sistema: " + verified );
   return verified;
}
  private String PonerPendiente()throws java.lang.Exception{
  String verified = "0";
  
  	try{
  		if (sTipo.equals(m05bConstantes.TAR_GASTO)){
				    sql = "Update "+m05bConstantes.TAB_VEHICULOS+ " set " +m05bConstantes.COL_34_SITUACION +
					      " = 'P'" +
					      " where " + m05bConstantes.COL_34_MATRICULA  +"='" + sMatricula + "'";
     miLog.addTraza(persona , "Tarjetas PonerPendiente" , "SQL: " + sql,m05bConstantes.LOG_NIVEL_BAJO);
     pstmt = conn.prepareStatement(sql);
     pstmt.executeUpdate();
  		}
     } catch (Exception ex) {
			try {
	  			verified="2";
	  			conn.rollback();  // Ha habido problemas, se deshacen todos los cambios
	  			throw new Exception(ex);
	  		} catch (SQLException e1){
                miLog.addTraza(persona , "Tarjetas PonerPendiente" , "Exception: SQL: " + e1,m05bConstantes.LOG_NIVEL_BAJO);
	  		}
			miLog.addTraza(ex);
	   } finally{
	   	    try {
				if (pstmt != null)
					pstmt.close();
				
			} catch (SQLException e2) {
                miLog.addTraza(persona , "Tarjetas PonerPendiente" , "Exception: SQL: " + e2,m05bConstantes.LOG_NIVEL_BAJO);
	  		}
	   }
   //System.out.println("m05b - Grabar Tarjetas: Ejecutar fecha del sistema: " + verified );
   return verified;
}

  private String ExisteTarjetaNoCancelada()throws java.lang.Exception{
  String verified = "0";
  
  	try{
			    sql =  "select 1" +
				       " from " + m05bConstantes.TAB_TARJETAS +
				       " where " +  m05bConstantes.COL_31_MATRICULA + " ='" + sMatricula +"' AND " +
				        m05bConstantes.COL_31_SITUACION + " !='" + m05bConstantes.TAR_CANCELADA +"' AND " +
				        m05bConstantes.COL_31_TIPO + " = '" + sTipo + "'"; 
     miLog.addTraza(persona , "Tarjetas PonerPendiente" , " SQL: " + sql,m05bConstantes.LOG_NIVEL_BAJO);
     pstmt = conn.prepareStatement(sql);
     rs = pstmt.executeQuery();
     if (rs.next()){  
       	verified="1";}
		   	    
     } catch (Exception ex) {
			try {
	  			verified="2";
	  			conn.rollback();  // Ha habido problemas, se deshacen todos los cambios
	  			throw new Exception(ex);
	  		} catch (SQLException e1){
                miLog.addTraza(persona , "Tarjetas ExisteTarjetaNoCancelada" , "Exception: SQL: " + e1,m05bConstantes.LOG_NIVEL_BAJO);
	  		}
			miLog.addTraza(ex);
	   } finally{
	   	    try {
				if (rs != null)
					rs.close();
				if (pstmt != null)
					pstmt.close();
				
			} catch (SQLException e2) {
                miLog.addTraza(persona , "Tarjetas ExisteTarjetaNoCancelada" , "Exception: SQL: " + e2,m05bConstantes.LOG_NIVEL_BAJO);
	  		}
	   }
   //System.out.println("m05b - Grabar Tarjetas: Ejecutar fecha del sistema: " + verified );
   return verified;
}
  private String EliminarTarjeta31()throws java.lang.Exception{
  String verified = "0";
  
  	try{
			    sql =  "delete " +
				        m05bConstantes.TAB_TARJETAS +
				       " where " +  m05bConstantes.COL_31_MATRICULA + " ='" + sMatricula  +"' AND " +
				        m05bConstantes.COL_31_TIPO + " = '" + sTipo + "'"; 
                miLog.addTraza(persona , "Tarjetas EliminarTarjeta31" , " SQL: " + sql,m05bConstantes.LOG_NIVEL_BAJO);
		        pstmt = conn.prepareStatement(sql);
		   	    rs = pstmt.executeQuery();	
     } catch (Exception ex) {
			try {
	  			verified="2";
	  			conn.rollback();  // Ha habido problemas, se deshacen todos los cambios
	  			throw new Exception(ex);
	  		} catch (SQLException e1){
                miLog.addTraza(persona , "Tarjetas EliminarTarjeta31" , "Exception: SQL: " + e1,m05bConstantes.LOG_NIVEL_BAJO);
	  		}
			miLog.addTraza(ex);
	   } finally{
	   	    try {
				if (rs != null)
					rs.close();
				if (pstmt != null)
					pstmt.close();
				
			} catch (SQLException e2) {
                miLog.addTraza(persona , "Tarjetas EliminarTarjeta31" , "Exception: SQL: " + e2,m05bConstantes.LOG_NIVEL_BAJO);
	  		}
	   }
   //System.out.println("m05b - Grabar Tarjetas: Ejecutar fecha del sistema: " + verified );
   return verified;
}

  private String InsertarNuevo31()throws java.lang.Exception{
  String verified = "0";
  
  	try{
			   sql = "insert into " +m05bConstantes.TAB_TARJETAS+
					" ("+ m05bConstantes.COL_31_TARJHIST + ","+m05bConstantes.COL_31_TARJETA+", "+m05bConstantes.COL_31_CENTRO+
                    ","+m05bConstantes.COL_31_MATRICULA+","+m05bConstantes.COL_31_LIMITE+
                    ","+m05bConstantes.COL_31_FALTA+","+m05bConstantes.COL_31_FBAJA+
                    ","+m05bConstantes.COL_31_FSOLIC+","+m05bConstantes.COL_31_FCADUC+
                    ","+m05bConstantes.COL_31_LITERAL+","+m05bConstantes.COL_31_CUENTA+
                    ","+m05bConstantes.COL_31_PLASTIC+","+m05bConstantes.COL_31_SITUACION+
                    ","+m05bConstantes.COL_31_INCIDENCIA+","+
                    //m05bConstantes.COL_31_TAG+","+
                    m05bConstantes.COL_31_TIPO+","+
                    m05bConstantes.COL_31_CAMBIO + ") " +
					" values " +
					"( " +sNumeroHist+",'" + sNumero +  "','" + sCentro + "','" + sMatricula + "'," + sLimite +"," +
                              " to_date('" + sFAlta + "','dd/mm/yyyy'), " +
                              " to_date('" + sFBaja + "','dd/mm/yyyy'), " +
                              " to_date('" + sFSolicI + "','dd/mm/yyyy'), " +
                              " to_date('" + sFCaduc + "','dd/mm/yyyy'), '" +
                              sLiteral +  "','" + sNCta + "',UPPER('" + sPlastic + "'),'" + sSituacion +"','" +
                              sIncidencia +  "','" + 
                              //sTAG +  "','" + 
                              sTipo + "' , '"+
                              m05bConstantes.VERIFICADO_SI +                              
                              "')";
                miLog.addTraza(persona , "Tarjetas InsertarNuevo31" , " SQL: " + sql,m05bConstantes.LOG_NIVEL_BAJO);
				pstmt = conn.prepareStatement(sql);
				pstmt.executeUpdate();
     } catch (Exception ex) {
			try {
	  			verified="2";
	  			conn.rollback();  // Ha habido problemas, se deshacen todos los cambios
	  			throw new Exception(ex);
	  		} catch (SQLException e1){
                miLog.addTraza(persona , "Tarjetas InsertarNuevo31" , "Exception: SQL: " + e1,m05bConstantes.LOG_NIVEL_BAJO);
	  		}
			miLog.addTraza(ex);
	   } finally{
	   	    try {
				if (pstmt != null)
					pstmt.close();
				
			} catch (SQLException e2) {
                miLog.addTraza(persona , "Tarjetas InsertarNuevo31" , "Exception: SQL: " + e2,m05bConstantes.LOG_NIVEL_BAJO);
	  		}
	   }
   //System.out.println("m05b - Grabar Tarjetas: Ejecutar fecha del sistema: " + verified );
   return verified;
}

  private String InsertarNuevo14()throws java.lang.Exception{
  String verified = "0";
  
  	try{
				sql = "insert into " +m05bConstantes.TAB_HIST_TARJETAS+
					" ("+m05bConstantes.COL_14_TARJHIST+", "+m05bConstantes.COL_14_TARJETA+
                    ","+m05bConstantes.COL_14_MATRICULA+","+m05bConstantes.COL_14_LIMITE+
                    ","+m05bConstantes.COL_14_FALTA+","+m05bConstantes.COL_14_FBAJA+
                    ","+m05bConstantes.COL_14_FSOLIC+","+m05bConstantes.COL_14_FEXPED+
                    ","+m05bConstantes.COL_14_FCADUC+","+m05bConstantes.COL_14_LITERAL+
                    ","+m05bConstantes.COL_14_BANCO+","+m05bConstantes.COL_14_PLASTIC+
                    ","+m05bConstantes.COL_14_SITUACION+","+m05bConstantes.COL_14_INCIDENCIA+
                    ","+m05bConstantes.COL_14_CTRO+","+
                    //m05bConstantes.COL_14_TAG+","+
                    m05bConstantes.COL_14_TIPO+") " +
					" values " +
					"(" + sNumeroHist + ",'" + sNumero +  "','" + sMatricula + "'," + sLimite +"," +
                              " to_date('" + sFAlta + "','dd/mm/yyyy'), " +
                              " to_date('" + sFBaja + "','dd/mm/yyyy'), " +
                              " to_date('" + sFSolicI + "','dd/mm/yyyy'), " +
                              " to_date('" + sFExped + "','dd/mm/yyyy'), " +                    
                              " to_date('" + sFCaduc + "','dd/mm/yyyy'), '" +
                              sLiteral +  "','" + sNCta + "',UPPER('" + sPlastic + "'),'" + sSituacion +"','" +
                              sIncidencia+  "','" + sCentro +  "','" + 
                              //sTAG+  "','" + 
                              sTipo + "')";
     	        miLog.addTraza(persona , "Tarjetas InsertarNuevo14" , "sql: " + sql,m05bConstantes.LOG_NIVEL_BAJO);
				pstmt = conn.prepareStatement(sql);
				pstmt.executeUpdate();
     } catch (Exception ex) {
			try {
	  			verified="2";
	  			conn.rollback();  // Ha habido problemas, se deshacen todos los cambios
	  			throw new Exception(ex);
	  		} catch (SQLException e1){
                miLog.addTraza(persona , "Tarjetas InsertarNuevo14" , "Exception: SQL: " + e1,m05bConstantes.LOG_NIVEL_BAJO);
	  		}
			miLog.addTraza(ex);
	   } finally{
	   	    try {
				if (pstmt != null)
					pstmt.close();
				
			} catch (SQLException e2) {
                miLog.addTraza(persona , "Tarjetas InsertarNuevo14" , "Exception: SQL: " + e2,m05bConstantes.LOG_NIVEL_BAJO);
	  		}
	   }
   //System.out.println("m05b - Grabar Tarjetas: Ejecutar fecha del sistema: " + verified );
   return verified;
}
/**
 * Process incoming requests for information
 *
 * @param request Object that encapsulates the request to the servlet
 * @param response Object that encapsulates the response from the servlet
 */
public void performTask(javax.servlet.http.HttpServletRequest request, javax.servlet.http.HttpServletResponse response) {


       
    try
	{
       recogerParametros(request,response);
	   m05bConexion miConex = new m05bConexion();
	   conn = miConex.getConnection();
	   conn.setAutoCommit(false);  // Al final si todo ha ido bien se hace commit
	   HttpSession session = request.getSession(true);
   	Locale idiomaLocal = (Locale)session.getAttribute("Local");
		String idiomaSes = ((idiomaLocal.getLanguage()==null)?"es":idiomaLocal.getLanguage());	
	
        String campoTexto="";
        String formatoFecha="dd/MM/yyyy";
        if(!idiomaSes.equals("es")){
			campoTexto="E";
			formatoFecha="yyyy/MM/dd";
        }
        //HttpSession session = request.getSession(true);
	   //String persona = (String) session.getAttribute("persona");
		//m05bHisTarjetas tarjetas = (m05bHisTarjetas)session.getAttribute("m05bHisTarjetas");
	    sErrorCentro="0";
		 if (!(sCentro.equals(""))){
		       sql = "SELECT 1  FROM "+ m05bConstantes.TAB_CENTROS +
		             " WHERE " + m05bConstantes.COL_05_CODIGO+ "='" + sCentro + "'";
               miLog.addTraza(persona , "Tarjetas" , "sql: " + sql,m05bConstantes.LOG_NIVEL_BAJO);
   		   			       
 		  pstmt = conn.prepareStatement(sql);
	    	  rs = pstmt.executeQuery();	 
		      if (!(rs.next())){
		     	 sErrorCentro="1";
		      }
		 }
		 if (sErrorCentro.equals("1")){
		 	  if (accion.equals(m05bConstantes.ACC_ACTUALIZAR))  {
		 	     response.sendRedirect("m05bTarjetasJsp.jsp?Matricula="+ sMatricula+"&CodInterno="+sNumeroHist+"&Tipo=" +sTipo+"&Mensaje=" + m05bConstantes.MSG_NOEXISTECENTRO);
		 	  }else{
		 	     response.sendRedirect("m05bTarjetasJsp.jsp?Matricula="+ sMatricula+"&Tipo=" +sTipo+"&Mensaje=" + m05bConstantes.MSG_NOEXISTECENTRO);		 	  	
		 	  }
		 }
		 else{	
          miLog.addTraza(persona , "Tarjetas" , "RecogerDescripcionCentro: " + sCentro+","+sCentroBD,m05bConstantes.LOG_NIVEL_BAJO);
		  if (FechaDelSistema()=="0"){
		  	  //ACTUALIZAR
				miLog.addTraza(persona , "Tarjetas" , "accion: " + accion,m05bConstantes.LOG_NIVEL_BAJO);
			if (accion.equals(m05bConstantes.ACC_ACTUALIZAR))  {

		   	      //Comprobamos is el Cdigo de Tarjeta se repite
		   	  if (ExisteTarjeta()=="1"){
	               conn.rollback(); 
			       response.sendRedirect("m05bTarjetasJsp.jsp?Matricula="+ sMatricula+"&CodInterno="+sNumeroHist+"&Mensaje=" + "TarjetaExiste");
	          } else {
			     // Comprobar si se trata del registro vigente
	        	  sRegistroEnCurso="0";
		   	     if (RegistroEnCurso()=="0"){  
		   	    	sRegistroEnCurso="1";
		   	        //Recuperamos de la base de datos el departamento y la situacion que tiene en 
		   	        //la base de datos
		   	    	RecogerDepartamentoSituacion();
                    miLog.addTraza(persona , "Tarjetas" , "RecogerDescripcionCentro: " + sCentro+","+sCentroBD,m05bConstantes.LOG_NIVEL_BAJO);
                    sCambio="";
				    if ((!(sCentroBD.equals(""))) &&(!(sCentro.equals(sCentroBD)))){
                        RecogerDescripcionCentro();
                        InsertarCambioCentro();
                        sCambio=m05bConstantes.VERIFICADO_NO;
				    }		
				    if ((sSituacionBD.equals(m05bConstantes.TAR_SOLICITADA)) && (sSituacion.equals(m05bConstantes.TAR_ALTA))){
                    	 tarjetas.setTar_falta(sFSolicI);
        		         sFAlta=sFSolicI;
        		    }
        		    ActualizarTabla31(sCambio,formatoFecha);
                }//Fin registro en curso.
				//Comprobamos si la situacion de la tarjeta se cancela poruqe en vez de actualizar 
				//la tabla 14 habr que insertar un registro.
		   	  if (sRegistroEnCurso.equals("1")){
                if ((sSituacion.equals(sSituacionBD)) || ((!(sSituacion.equals(sSituacionBD))) && (!(sSituacion.equals(m05bConstantes.TAR_CANCELADA))))
                 || ((sSituacion.equals(m05bConstantes.TAR_CANCELADA)) && (sSituacionBD.equals("")))) {
                   miLog.addTraza(persona , "Tarjetas Grabar-1-Actualizar" , "sSituacion,sSituacionBD:  " + sSituacion+","+sSituacionBD,m05bConstantes.LOG_NIVEL_BAJO);
			       ActualizarTabla141(formatoFecha);	
				// Actuaiza el registro historico
                }else if (sSituacion.equals(m05bConstantes.TAR_CANCELADA)){
		   	      //Calcula el nuevo cdigo de la tabla histricos.
   			      String Auxiliar="to_number(" + m05bConstantes.COL_14_TARJHIST + ")";
			      //System.out.println(Auxiliar);
			      sNumeroHistAnt=sNumeroHist;
                  m05bGenerarClave miIdHist = new m05bGenerarClave();
			   	  sNumeroHist = "" + miIdHist.getNextId(m05bConstantes.TAB_HIST_TARJETAS, Auxiliar);
                  miLog.addTraza(persona , "Tarjetas Grabar-2-Insertar" , "sSituacion,sSituacionBD:  " + sSituacion+","+sSituacionBD,m05bConstantes.LOG_NIVEL_BAJO);
    		      InsertarTabla141(formatoFecha);	
                  Actualizar31ImpresoAN(formatoFecha);
                  //if (ExisteSeguro()=="1"){
                   //PonerPendiente();
                  //}
                 }
		   	  }else{
			       ActualizarTabla141(formatoFecha);
		   	  }

		    conn.commit();
		    //System.out.println("Modificacion:" + sModificacion);
		    if (sModificacion.equals("2")){
			    response.sendRedirect("m05bTarjetasJsp.jsp?Matricula="+ sMatricula+"&CodInterno="+sNumeroHist);}
		    else {	
		    	response.sendRedirect("m05bVehTarjetasJsp.jsp?Matricula="+sMatricula);}
	        } //Fin Existe Codigo
	        
	       }//Fin Actualizar
	       
	       	// INSERTAR
			else if (accion.equals(m05bConstantes.ACC_INSERTAR))  {
               //comprobar si existe la tarjeta.

		   	    if (ExisteTarjetaNoCancelada()=="1"){  
			        response.sendRedirect("m05bVehTarjetasJsp.jsp?Matricula="+sMatricula+"&CodError=" + m05bMensajes.MSG_TARJETAEXISTE);
	             }
	            else {
                   EliminarTarjeta31();
				   // Inserta el registro actual de la tabla Tarjetas
                   tarjetas.setTar_fsolic(sFSolicI);
                   sCambio=m05bConstantes.VERIFICADO_SI ;
                   InsertarNuevo31();
                   InsertarNuevo14();
		           conn.commit();
			       response.sendRedirect("m05bVehTarjetasJsp.jsp?Matricula="+sMatricula);
                }
            }//Fin Insertar
          }//Fin Fecha Sistema
		 }//Fin existe centro
	   }	catch(java.io.IOException ioex) {
	   		try {
				response.sendRedirect("m05bError.jsp");
			} catch (IOException e) {
				// TODO Auto-generated catch block
				miLog.addTraza(e);
			}
	   }	catch (Exception SQLException) {
				try {
		  			conn.rollback();  // Ha habido problemas, se deshacen todos los cambios
		  		} catch (SQLException e2){
		  			miLog.addTraza(persona , "Tarjetas" , "Exception: SQL: " + e2,m05bConstantes.LOG_NIVEL_BAJO);
		  		}
			  	try {
					response.sendRedirect("m05bError.jsp");
				} catch (IOException e) {
					// TODO Auto-generated catch block
					miLog.addTraza(e);
				}
	   }	catch(Throwable theException)	{
				miLog.addTraza(theException);
				try {
					response.sendRedirect("m05bError.jsp");
				} catch (IOException e) {
					// TODO Auto-generated catch block
					miLog.addTraza(e);
				}
	  } 	finally{
	  	  			try {
						if (conn != null)
							conn.close();
			  		} catch (SQLException e){
			  			miLog.addTraza(persona , "Tarjetas" , "Exception: SQL: " + e,m05bConstantes.LOG_NIVEL_BAJO);
			  			try {
							response.sendRedirect("m05bError.jsp");
						} catch (IOException e1) {
							// TODO Auto-generated catch block
							miLog.addTraza(e1);
						}
			  		}
	   }
}
}