package tallerServlet;

import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

import javax.servlet.http.HttpSession;

import m05bBD.m05bTaller;
import m05bClasses.m05bConexion;
import m05bClasses.m05bConstantes;
import m05bClasses.m05bFileLog;


/**
 * Inserte aqu la descripcin del tipo.
 * Fecha de creacin: (19/05/04)
 */
public class m05bGrabarTallerServlet extends javax.servlet.http.HttpServlet {m05bFileLog miLog = new m05bFileLog();
/**
 * Process incoming HTTP POST requests
 *
 * @param request Object that encapsulates the request to the servlet
 * @param response Object that encapsulates the response from the servlet
 */
public void doPost(javax.servlet.http.HttpServletRequest request, javax.servlet.http.HttpServletResponse response) throws javax.servlet.ServletException, java.io.IOException {

	performTask(request, response);

}
/**
 * Returns the servlet info string.
 */
public String getServletInfo() {

	return super.getServletInfo();

}
/**
 * Initializes the servlet.
 */
public void init() {
	// insert code to initialize the servlet here

}
/**
 * Process incoming requests for information
 *
 * @param request Object that encapsulates the request to the servlet
 * @param response Object that encapsulates the response from the servlet
 */
public void performTask(javax.servlet.http.HttpServletRequest request, javax.servlet.http.HttpServletResponse response) {

       String sCodigo, sDescripcion, sCodPob, sMarca, sRama, sDirec, sTelef, sPropio, accion;
       String sql = "";
       java.sql.Connection conn=null;
	   PreparedStatement pstmt = null;
	   ResultSet rs = null;
	   boolean finalizado = false;
       try

	{
        HttpSession session = request.getSession(true);

		m05bTaller taller = (m05bTaller)session.getAttribute("m05bTaller");
		sCodigo = request.getParameter("Codigo");
		taller.setTal_codigo(sCodigo);
		sDescripcion=request.getParameter("Descripcion").toUpperCase();
		taller.setTal_descripcion(sDescripcion);
        sCodPob=request.getParameter("Poblacion");
        taller.setTal_poblacion(sCodPob);
        sDirec=request.getParameter("Direccion")==null?"":request.getParameter("Direccion").toUpperCase();
        taller.setTal_direccion(sDirec);
        sTelef=request.getParameter("Telefono");
        taller.setTal_telefono(sTelef);
        sMarca=request.getParameter("Marca").toUpperCase();
        taller.setTal_marca(sMarca);
        sPropio=request.getParameter("Propio");
        if (sPropio == null)
        	sPropio = "N";
        else
        	sPropio = "S";
        taller.setTal_propio(sPropio);
        sRama=request.getParameter("Rama").toUpperCase();
        taller.setTal_rama(sRama);
		accion=request.getParameter("Accion");

        	m05bConexion miConex = new m05bConexion();
			conn = miConex.getConnection();

		try{

			if (accion.equals(m05bConstantes.ACC_ACTUALIZAR))  {
				sql="update	M0530T00 " +
					"set	DESCRIP_30 = '" + sDescripcion + "'" +
                    " , TELEF_30 =  '" + sTelef+ "'" +
                    " , MARCA_30 =  '" + sMarca+ "'" +
                    " , DIREC_30 =  '" + sDirec+ "'" +
                    " , PROPIO_30 =  '" + sPropio+ "'" +
                    " , COD_POB_30 =  '" + sCodPob + "'" +
                    " , RAMA_30 =  '" + sRama + "'" +
					" where	COD_TAL_30 = " + sCodigo;
			       pstmt = conn.prepareStatement(sql);
			}
			else if (accion.equals(m05bConstantes.ACC_INSERTAR))  {
			// Chequear si ya existe un taller con ese codigo
			   sql = "select 1  from M0530T00 where COD_TAL_30 = '" + sCodigo + "'";
		       pstmt = conn.prepareStatement(sql);
			   rs = pstmt.executeQuery();
			   if (rs.next() == true){ 		
       	    			response.sendRedirect("m05bTalleresJsp.jsp?Codigo=" + sCodigo + "&Mensaje=Existe");
       	    			finalizado=true;
			   } 
			   else {
					pstmt = conn.prepareStatement(
						"insert into	M0530T00 " +
						"(COD_TAL_30, DESCRIP_30,MARCA_30,DIREC_30,PROPIO_30,COD_POB_30,TELEF_30, RAMA_30) " +
						" values " +
						"(? ,? , ? ,? ,? , ?, ?,?)" );
					pstmt.setString(1, sCodigo);
					pstmt.setString(2, sDescripcion);
	                pstmt.setString(3, sMarca);
	                pstmt.setString(4, sDirec);
	                pstmt.setString(5, sPropio);
	                pstmt.setString(6, sCodPob);
	                pstmt.setString(7, sTelef);
	                pstmt.setString(8, sRama);
	           }
			}
			else   {

				pstmt = conn.prepareStatement(
					"delete from 	M0530T00 " +
					" where COD_TAL_30 =  ? " );
				pstmt.setString(1, sCodigo);
			}
			if(!finalizado){
				pstmt.executeUpdate();
				response.sendRedirect("m05bRelTalleresJsp.jsp");
			}
		} catch (Exception SQLException) {
			miLog.addTraza(SQLException);
			response.sendRedirect("m05bError.jsp");
		} finally{
				if (rs != null)
					rs.close();
				if (pstmt != null)
					pstmt.close();
				if (conn != null)
					conn.close();
		}
	}
	catch(Throwable theException)
	{
		// uncomment the following line when unexpected exceptions
		// are occuring to aid in debugging the problem.
		miLog.addTraza(theException);
		try {
			response.sendRedirect("m05bError.jsp");
		} catch (IOException e) {
			// TODO Auto-generated catch block
			miLog.addTraza(e);
		}
	}
}
}