package solicitudReservaServlet;

import java.io.IOException;

import javax.naming.InitialContext;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.http.HttpSession;

import m05bBD.m05bSolicitudReserva;
import m05bClasses.m05bConstantes;
import m05bClasses.m05bFileLog;
import m05bSolicitudReservaEJB.m05SolicitudReserva;
import m05bSolicitudReservaEJB.m05SolicitudReservaHome;
import m05bSolicitudReservaEJB.m05SolicitudReservaPK;

public class m05bSolicitudReservaServlet extends javax.servlet.http.HttpServlet {m05bFileLog miLog = new m05bFileLog();

	/**
	 * Process incoming HTTP GET requests
	 *
	 * @param request Object that encapsulates the request to the servlet
	 * @param response Object that encapsulates the response from the servlet
	 */
	public void doPost(javax.servlet.http.HttpServletRequest request, javax.servlet.http.HttpServletResponse response) throws javax.servlet.ServletException, java.io.IOException {
		performTask(request, response);
	}

	/**
	 * Returns the servlet info string.
	 */
	public String getServletInfo() {
		return super.getServletInfo();
	}

	/**
	 * Initializes the servlet.
	 */
	public void init() {
		// insert code to initialize the servlet here
	}

	/**
	 * Process incoming requests for information
	 *
	 * @param request Object that encapsulates the request to the servlet
	 * @param response Object that encapsulates the response from the servlet
	 */
	public void performTask(javax.servlet.http.HttpServletRequest request, javax.servlet.http.HttpServletResponse response) {
		try
		{
			// Insert user code from here.
			String accion, codigo;
			String sURL = "";
			String strOrigen="";//Agurtzane Mar12: relacionar solicitud y asignacin

			m05bFileLog miLog = new m05bFileLog();
			HttpSession session = request.getSession(true);
			String persona = (String) session.getAttribute("persona");

			accion = request.getParameter("Accion");

			if (accion.equals(m05bConstantes.ACCION_ASIGNAR)) { //ASIGNAR
				codigo = new String(request.getParameter("CodigoSolicitudReserva"));
			} else {
				codigo = new String(request.getParameter("Codigo"));
				//strOrigen=request.getParameter("Origen")==null?"":new String(request.getParameter("Origen"));//Agurtzane Mar12: relacionar solicitud y asignacin
				miLog.addTraza(persona, "Solicitud Reserva Servlet", "Cdigo: " + codigo, m05bConstantes.LOG_NIVEL_BAJO);
				miLog.addTraza(persona, "Solicitud Reserva Servlet", "ORIGEN: " + strOrigen, m05bConstantes.LOG_NIVEL_BAJO);
			}

			try {
				session.setAttribute("m05bSolicitudReserva", null);
				
				m05SolicitudReservaPK primaryKey = new m05SolicitudReservaPK();
				primaryKey.idSolicitud = new Integer(codigo);
				InitialContext ctx2 = new InitialContext();
				m05SolicitudReservaHome solicitudReservaEBHome = (m05SolicitudReservaHome) ctx2.lookup("m05SolicitudReserva");
				m05SolicitudReserva solicitudReservaEB = solicitudReservaEBHome.findByPrimaryKey(primaryKey);
				m05bSolicitudReserva solicitudReserva = solicitudReservaEB.getSolicitudReserva();

				session.setAttribute("m05bSolicitudReserva", solicitudReserva);

				//if (accion.equals(m05bConstantes.ACCION_RECHAZAR)) { //RECHAZAR
				//	sURL = response.encodeRedirectURL("m05bSolicitudReservaJsp.jsp?Codigo=" + codigo);
				//}
				//else if (accion.equals(m05bConstantes.ACCION_ASIGNAR)) { //ASIGNAR
				//	sURL = response.encodeRedirectURL("m05bAsignacionesJsp.jsp?Codigo=NUEVO&CodigoSolicitudReserva" + codigo);
				//}
				//else { //VER
				
					//Agurtzane Mar12: relacionar solicitud y asignacin
				if(!strOrigen.equals(""))
				{
					sURL = response.encodeRedirectURL("m05bSolicitudReservaJsp.jsp?Codigo=" + codigo+ "&Origen=" + strOrigen);
				}else{
				//Fin Agurtzane Mar12: relacionar solicitud y asignacin
					sURL = response.encodeRedirectURL("m05bSolicitudReservaJsp.jsp?Codigo=" + codigo);
				}
				//}

		    	miLog.addTraza(persona, "Solicitud Reserva Servlet", "ACCION: " + accion + " sURL: " + sURL, m05bConstantes.LOG_NIVEL_BAJO);

			    RequestDispatcher rd;
			    rd = request.getRequestDispatcher(sURL);

			    try {
			    	rd.forward(request, response);
			    } catch (ServletException e) {
			    	response.sendRedirect("m05bError.jsp");
			    }
			} catch (Exception SQLException) {
				miLog.addTraza(persona, "Solicitud Reserva Servlet ERROR", "ERR: " + SQLException.getMessage(), m05bConstantes.LOG_NIVEL_BAJO);
				
				miLog.addTraza(SQLException);
				response.sendRedirect("m05bError.jsp");
			}
		}
		catch(Throwable theException)
		{
			try {
				// uncomment the following line when unexpected exceptions
				// are occuring to aid in debugging the problem.
				//miLog.addTraza(theException);
				response.sendRedirect("m05bError.jsp");
			} catch (IOException e) {
				// TODO Auto-generated catch block
				miLog.addTraza(e);
			}
		}
	}
}