package solicitudReservaServlet;

import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;

import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.naming.InitialContext;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import m05bBD.m05bSolicitudReserva;
import m05bClasses.m05bComun;
import m05bClasses.m05bConexion;
import m05bClasses.m05bConstantes;
import m05bClasses.m05bFileLog;
import m05bLdap.SecurityHelpperException;
import m05bLdap.SecurityHelpperXLNets;
import m05bLdap.m05bPersonaXLNET;
import m05bSolicitudReservaEJB.m05SolicitudReserva;
import m05bSolicitudReservaEJB.m05SolicitudReservaHome;
import m05bSolicitudReservaEJB.m05SolicitudReservaPK;

public class m05bGrabarSolicitudReservaServlet extends HttpServlet {
	m05bFileLog miLog = new m05bFileLog();
	private static final long serialVersionUID = 1L;

	/**
	 * Process incoming HTTP POST requests
	 *
	 * @param request Object that encapsulates the request to the servlet
	 * @param response Object that encapsulates the response from the servlet
	 */
	public void doPost(HttpServletRequest request, HttpServletResponse response) throws javax.servlet.ServletException, java.io.IOException {
		performTask(request, response);
	}

	/**
	 * Returns the servlet info string.
	 */
	public String getServletInfo() {
		return super.getServletInfo();
	}

	/**
	 * Initializes the servlet.
	 */
	public void init() {
		// insert code to initialize the servlet here
	}

	/**
	 * Process incoming requests for information
	 *
	 * @param request Object that encapsulates the request to the servlet
	 * @param response Object that encapsulates the response from the servlet
	 */
	public void performTask(HttpServletRequest request, HttpServletResponse response) {

		String sCodigo, sOrden, sEnDetalle, sMotivoRechazo, accion;
		String sql = "";
		java.sql.Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		m05bFileLog miLog = new m05bFileLog();

		try {
			HttpSession session = request.getSession(true);

	       	String persona = (String)session.getAttribute("persona");
	       	String personaCodigo = (String)session.getAttribute("personaCodigo");
	       	m05bPersonaXLNET personaXLNET = this.obtenerUsuarioXlNets(personaCodigo, request);

	       	sEnDetalle = (request.getParameter("Detalle")==null || request.getParameter("Detalle").equals("null"))?"":request.getParameter("Detalle");
	       	sOrden = (request.getParameter("Orden")==null || request.getParameter("Orden").equals("null"))?"":request.getParameter("Orden");
	       	sCodigo = request.getParameter("Codigo");
			sMotivoRechazo = request.getParameter("MotivoRechazo");

			miLog.addTraza(persona, "Grabar Solicitud Reserva","Cdigo: " + sCodigo.toUpperCase(), m05bConstantes.LOG_NIVEL_BAJO);

			accion=request.getParameter("Accion");
			
			session.setAttribute("m05bSolicitudReserva", null);

			m05SolicitudReservaPK primaryKey = new m05SolicitudReservaPK();
			primaryKey.idSolicitud = new Integer(sCodigo);
			InitialContext ctx2 = new InitialContext();
			m05SolicitudReservaHome solicitudReservaEBHome = (m05SolicitudReservaHome) ctx2.lookup("m05SolicitudReserva");
			m05SolicitudReserva solicitudReservaEB = solicitudReservaEBHome.findByPrimaryKey(primaryKey);
			m05bSolicitudReserva solicitudReserva = solicitudReservaEB.getSolicitudReserva();

			session.setAttribute("m05bSolicitudReserva", solicitudReserva);

			try {
				m05bConexion miConex = new m05bConexion();
				conn = miConex.getConnection();
				if (accion.equals(m05bConstantes.ACCION_RECHAZAR)) { //RECHAZO
					// Tenemos que cambiar el estado de la solicitud a rechazada y
					// guardar el motivo del rechazo.
					// Mandaremos adems un mail de solicitante.

					miLog.addTraza(persona, "m05bGrabarSolicitudReservaServlet", "VAMOS A RECHAZAR LA SOLICITUD...", m05bConstantes.LOG_NIVEL_BAJO);

					String error = this.validarSolicitud(solicitudReserva.getIdSolicitud().longValue(),
														 accion,
														 sMotivoRechazo,
														 request);

					if (error != null && error != "") {
						// "La solicitud est bloqueada por otro usuario" o no tiene
						// el estado apropiado para aprobarla o rechazarla
						//validarSolicitud.setError(error);
					} else {
						// Enviamos mail al solicitante
						// Y por cada mail enviado actualizamos el campo de mail enviado
						Locale idiomaLocal = (Locale)session.getAttribute("Local");
						String idiomaSes = ((idiomaLocal.getLanguage()==null)?"es":idiomaLocal.getLanguage());
						String retMail = "";

						String mailSolicitante = this.obtenerMailXlnets(solicitudReserva.getUsuario().getCodSolicitante(), request);
						String mailReservador = this.obtenerMailXlnets(solicitudReserva.obtenerValidacionSolicitada().getCodValidador(), request);
						String mailValidador = personaXLNET.getEMail();
						
						/*ANTES DE MANDAR LOS MAILS VOLVEMOS A COGER LA SOLICITUD DE BD*/
						session.setAttribute("m05bSolicitudReserva", null);

						solicitudReservaEB = solicitudReservaEBHome.findByPrimaryKey(primaryKey);
						solicitudReserva = solicitudReservaEB.getSolicitudReserva();

						session.setAttribute("m05bSolicitudReserva", solicitudReserva);

						retMail = "";
						if (!mailSolicitante.equals(""))
							retMail += this.enviarMail(mailSolicitante, true, false, false, solicitudReserva, idiomaSes, request);
						//if (retMail.equals("") && !mailReservador.equals("") && !mailReservador.equals(mailSolicitante))
						//	retMail += this.enviarMail(mailReservador, false, true, false, solicitudReserva, idiomaSes, request);
						//if (retMail.equals("") && !mailValidador.equals("") && !mailValidador.equals(mailSolicitante) && !mailValidador.equals(mailReservador))
							//retMail += this.enviarMail(mailValidador, false, false, true, solicitudReserva, idiomaSes, request);

						if (retMail.equals(""))
						{
							sql = "update m05102t00 "
								+ "set MAIL_ENVIADO_102 = ? "
								+ "where ID_SOLICITUD_102 = ? "
								+ "and COD_VALIDADOR_102 = ? "
								+ "and ESTADO_102 = ? "
								+ "and SITUACION_102 = ? ";

							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, "1");
							pstmt.setString(2, sCodigo);
							pstmt.setString(3, personaCodigo);
							pstmt.setString(4, m05bConstantes.RECHAZADA);
							pstmt.setString(5, m05bConstantes.SITUACION_ALTA);

							miLog.addTraza(persona, "Grabar Solicitud Reserva", "SQL: " + sql, m05bConstantes.LOG_NIVEL_BAJO);
							pstmt.executeUpdate();
						}
					}
					
					if (error == null) {
						error = "";
					}

					if (sEnDetalle.equals("1"))
				    {
						response.sendRedirect("m05bSolicitudReservaJsp.jsp?Accion=" + m05bConstantes.ACCION_VER_DETALLE + "&Codigo=" + sCodigo + "&Orden=" + sOrden + this.obtenerCadenaFiltro(request) + "&Error=" + error);
				    }
				    else
				    {
				    	response.sendRedirect("m05bRelSolicitudesReservaJsp.jsp?Orden=" + sOrden + "&CodigoSel=" + sCodigo + this.obtenerCadenaFiltro(request) + "&Error=" + error);
				    }
					
				} else if (accion.equals(m05bConstantes.ACCION_ASIGNAR)) { //ASIGNACIN
					//TENEMOS QUE COMPROBAR QUE LA SOLICITUD EST PENDIENTE DE ASIGNAR
					//O APROBADA POR EL VALIDADOR Y RECHAZADA POR PARQUE MVIL Y NO ASIGNADA
					//ltimo aadido.
					//PODER ASIGNAR UNA SOLICITUD QUE NO EST APROBADA (SOL)

					miLog.addTraza(persona, "m05bGrabarSolicitudReservaServlet", "VAMOS A ASIGNAR LA SOLICITUD...", m05bConstantes.LOG_NIVEL_BAJO);

					if (this.existeAsignacionSolicitud(solicitudReserva.getIdSolicitud().longValue(), request)) {

						Locale idiomaLocal = (Locale)session.getAttribute("Local");
						ResourceBundle res = ResourceBundle.getBundle("html.datos.etiquetas", idiomaLocal);
						String error = res.getString("general.error.solicitudyaasignada");

						// "La solicitud est bloqueada por otro usuario" o no tiene
						// el estado apropiado para aprobarla o rechazarla
						if (sEnDetalle.equals("1"))
					    {
					    	response.sendRedirect("m05bSolicitudReservaJsp.jsp?Accion=" + m05bConstantes.ACCION_VER_DETALLE + "&Codigo=" + sCodigo + "&Orden=" + sOrden + this.obtenerCadenaFiltro(request) + "&Error=" + error);
					    }
					    else
					    {
					    	response.sendRedirect("m05bRelSolicitudesReservaJsp.jsp?Orden=" + sOrden + "&CodigoSel=" + sCodigo + this.obtenerCadenaFiltro(request) + "&Error=" + error);
					    }

					} else {

					 	String error = this.comprobarAsignacionSolicitud(solicitudReserva.getIdSolicitud().longValue(), request);
		
						if (error != null && error != "") {
							// "La solicitud est bloqueada por otro usuario" o no tiene
							// el estado apropiado para aprobarla o rechazarla
							if (sEnDetalle.equals("1"))
						    {
						    	response.sendRedirect("m05bSolicitudReservaJsp.jsp?Accion=" + m05bConstantes.ACCION_VER_DETALLE + "&Codigo=" + sCodigo + "&Orden=" + sOrden + this.obtenerCadenaFiltro(request) + "&Error=" + error);
						    }
						    else
						    {
						    	response.sendRedirect("m05bRelSolicitudesReservaJsp.jsp?Orden=" + sOrden + "&CodigoSel=" + sCodigo + this.obtenerCadenaFiltro(request) + "&Error=" + error);
						    }
						} else {

							//Agurtzane Feb12: avisar si ms asignaciones
							//Vamos a la pantalla de asignaciones
							//response.sendRedirect("m05bAsignacionesJsp.jsp?Codigo=NUEVO&CodigoSolicitudReserva=" + sCodigo + "&SolicitudBloqueada=1");

							String strMens="";
							String strSql="";	
							//conn=null;
						    pstmt = null;
						    rs = null;
						    try {    
						    	miConex = new m05bConexion();
								//conn = miConex.getConnection();
								
								strSql ="SELECT COUNT(1) FROM M05100S01 WHERE COD_ASIGNACION_100 IS NULL AND ID_SOLICITUD_100 IN" +
								" (SELECT ID_SOLICITUD_101 FROM M05101S01 WHERE COD_SOLICITANTE_101="+ 
								" (SELECT COD_SOLICITANTE_101 FROM M05101S01 WHERE ID_SOLICITUD_101=" + solicitudReserva.getIdSolicitud() + "))";
						        miLog.addTraza(m05bConstantes.LOG_NO_USER , m05bConstantes.LOG_NO_SRC , "SQL avisar si ms asignaciones pendientes: " + strSql, m05bConstantes.LOG_NIVEL_BAJO);
						        pstmt = conn.prepareStatement(strSql);
						        rs = pstmt.executeQuery();	
						        if  (rs.next()) {
						        	miLog.addTraza(m05bConstantes.LOG_NO_USER , m05bConstantes.LOG_NO_SRC , "Entra en el if de ms asignaciones: " + rs.getLong(1) , m05bConstantes.LOG_NIVEL_BAJO);
						        	if(rs.getLong(1) > 1 ){
						        		//ResourceBundle res = ResourceBundle.getBundle("html.datos.etiquetas", (Locale)session.getAttribute("Local"));
						        		strMens=m05bConstantes.MSG_ASIGPEND; //res.getString("general.error.solicitudPendiente");
						        	}
							 	}
						   	} catch (Exception SQLException) {
						   		miLog.addTraza(SQLException);
							} finally {
								if (rs != null)
						        	rs.close();
								if (pstmt != null)
					        	pstmt.close();
						              if (conn != null)
						      	        conn.close();
						      	}
							miLog.addTraza(m05bConstantes.LOG_NO_USER , m05bConstantes.LOG_NO_SRC , "Mensaje de ms asignaciones: " + strMens , m05bConstantes.LOG_NIVEL_BAJO);
							response.sendRedirect("m05bAsignacionesJsp.jsp?Codigo=NUEVO&CodigoSolicitudReserva=" + sCodigo + "&SolicitudBloqueada=1&Mensaje="+strMens);							
							//Fin Agurtzane Feb12: avisar si ms asignaciones
			
													
						}
					}
				}

			} catch (Exception SQLException) {
				miLog.addTraza(SQLException);
				response.sendRedirect("m05bError.jsp");
			} finally {
				if (rs != null)
					rs.close();
				if (pstmt != null)
					pstmt.close();
				if (conn != null)
					conn.close();
			}
		}
		catch(Throwable theException)
		{
			// uncomment the following line when unexpected exceptions
			// are occuring to aid in debugging the problem.
			miLog.addTraza(theException);
			try {
				response.sendRedirect("m05bError.jsp");
			} catch (IOException e) {
				// TODO Auto-generated catch block
				miLog.addTraza(e);
			}
		}
	}

	private String validarSolicitud(long codigoSolicitud, String accion, String motivoRechazo, HttpServletRequest request) {

		StringBuffer sql = new StringBuffer(125);
		java.sql.Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		int i = 0;
		m05bFileLog miLog = new m05bFileLog();
		HttpSession session = request.getSession(true);
		String persona = (String)session.getAttribute("persona");

		try {
			try {
		       	String personaCodigo = (String)session.getAttribute("personaCodigo");
		       	m05bPersonaXLNET personaXLNET = this.obtenerUsuarioXlNets(personaCodigo, request);

				Locale idiomaLocal = (Locale)session.getAttribute("Local");
				ResourceBundle res = ResourceBundle.getBundle("html.datos.etiquetas", idiomaLocal);
				m05bConexion miConex = new m05bConexion();
				conn = miConex.getConnection();

				conn.setAutoCommit(false);

				// Bloqueamos la solicitud
				sql.append("update m05100s01 set BLOQUEO_100 = 1 WHERE ID_SOLICITUD_100 = ? AND NVL(BLOQUEO_100,0)=0");
				pstmt = conn.prepareStatement(sql.toString());
				pstmt.setLong(1, codigoSolicitud);
				int bloqueo = pstmt.executeUpdate();
				miLog.addTraza(persona, "m05bGrabarSolicitudReservaServlet", "SQL: " + sql + " - " + bloqueo + " fila(s) afectada(s)", m05bConstantes.LOG_NIVEL_BAJO);

				if (bloqueo > 0) { // Hemos conseguido bloquear la solicitud

					// Comprobamos el estado de la solicitud
					// Slo se podr aprobar si el estado es SOL o REC
					// Slo se podr rechazar si el estado es SOL o ASA
					sql = new StringBuffer();
					sql.append("select ESTADO_102, NVL(ORIGEN_RECHAZO, '') as ORIGEN_RECHAZO from DETALLE_SOLICITUD WHERE ID_SOLICITUD_100 = ?");
					pstmt = conn.prepareStatement(sql.toString());
					pstmt.setLong(1, codigoSolicitud);
					rs = pstmt.executeQuery();
					miLog.addTraza(persona, "m05bGrabarSolicitudReservaServlet", "SQL: " + sql, m05bConstantes.LOG_NIVEL_BAJO);
					if (rs.next()) {
						String estadoReal = rs.getString("ESTADO_102");
						if (accion.equals(m05bConstantes.ACCION_APROBAR)) {
							String origenReal = rs.getString("ORIGEN_RECHAZO");
							if (!estadoReal.equals(m05bConstantes.SOLICITADA)
									&& !(estadoReal.equals(m05bConstantes.RECHAZADA) 
										 && (origenReal.equals(m05bConstantes.ORIGENWEBSOLICITUDESVALIDADOR)
											 || origenReal.equals(m05bConstantes.ORIGENWEBSOLICITUDESSOLICITANTE)
											)
										)
							    ) {
								// ERROR
								conn.rollback();
								return res.getString("general.error.nosepuedeaprobarporestadoactual");
							}
						} else if (accion.equals(m05bConstantes.ACCION_RECHAZAR)) {
							if (!estadoReal.equals(m05bConstantes.SOLICITADA)
									&& !estadoReal.equals(m05bConstantes.ACEPTADASINASIGNAR)
									&& !estadoReal.equals(m05bConstantes.ACEPTADASINENTREGAR)) {
								// ERROR
								conn.rollback();
								return res.getString("general.error.nosepuederechazarporestadoactual");
							}
						}
					}
					//

					// Cambiamos a BAJA los estados que estn aprobados o
					// rechazados
					sql = new StringBuffer();
					sql.append("update m05102s01 set SITUACION_102=?").append(" where ID_SOLICITUD_102=? AND ESTADO_102=?");
					pstmt = conn.prepareStatement(sql.toString());
					pstmt.setString(1, m05bConstantes.SITUACION_BAJA); // ORIGEN_102
					pstmt.setLong(2, codigoSolicitud); // ID_SOLICITUD_102
					if (accion.equals(m05bConstantes.ACCION_APROBAR)) {
						pstmt.setString(3, m05bConstantes.ACEPTADASINASIGNAR); // ESTADO_102
					} else {
						pstmt.setString(3, m05bConstantes.RECHAZADA); // ESTADO_102
					}
					i = pstmt.executeUpdate();
					miLog.addTraza(persona, "m05bGrabarSolicitudReservaServlet", "SQL: " + sql, m05bConstantes.LOG_NIVEL_BAJO);

					// Insertamos un nuevo estado aprobado o rechazado
					sql = new StringBuffer();
					sql.append(
							"insert into m05102s01 (ID_SOLICITUD_102,COD_VALIDADOR_102,FECHA_VALIDACION_102,")
							.append(" ESTADO_102,MOTIVO_102,OBSERVACIONES_102,COD_DESTINO_102,DESTINO_OTROS_102,")
							.append(" MAIL_ENVIADO_102,DNI_102,NOMBRE_APELLIDOS_102,ORIGEN_102,SITUACION_102,")
							.append(" VALIDACION_POSTERIOR_102)")
							.append(" values (?,?,sysdate,?,?,null,null,null,'0',?,?,?,?,'0')");
					pstmt = conn.prepareStatement(sql.toString());
					pstmt.setLong(1, codigoSolicitud); // ID_SOLICITUD_102
					pstmt.setString(2, personaXLNET.getCodigo()); // COD_VALIDADOR_102
					if (accion.equals(m05bConstantes.ACCION_APROBAR)) {
						pstmt.setString(3, m05bConstantes.ACEPTADASINASIGNAR); // ESTADO_102
						pstmt.setString(4, null); // MOTIVO_102
					} else {
						pstmt.setString(3, m05bConstantes.RECHAZADA); // ESTADO_102
						pstmt.setString(4, motivoRechazo); // MOTIVO_102
					}
					pstmt.setString(5, personaXLNET.getDni()); // DNI_102
					pstmt.setString(6, personaXLNET.getNombre() + " " + personaXLNET.getApellidos()); // NOMBRE_APELLIDOS_102
					pstmt.setString(7, m05bConstantes.ORIGENPARQUEMOVIL); // ORIGEN_102
					pstmt.setString(8, m05bConstantes.SITUACION_ALTA); // ORIGEN_102
					i = pstmt.executeUpdate();
					miLog.addTraza(persona, "m05bGrabarSolicitudReservaServlet", "SQL: " + sql, m05bConstantes.LOG_NIVEL_BAJO);

					// Desbloqueamos la solicitud
					sql = new StringBuffer();
					sql.append("update m05100s01 set BLOQUEO_100 = 0 WHERE ID_SOLICITUD_100 = ? AND NVL(BLOQUEO_100,0)=1");
					pstmt = conn.prepareStatement(sql.toString());
					pstmt.setLong(1, codigoSolicitud);
					int desbloqueo = pstmt.executeUpdate();

					miLog.addTraza(persona, "m05bGrabarSolicitudReservaServlet", "SQL: " + sql + " - " + desbloqueo + " fila(s) afectada(s)", m05bConstantes.LOG_NIVEL_BAJO);

					conn.commit();
				} else {
					conn.rollback();
					return res.getString("general.error.bloqueo");
				}

				miLog.addTraza(persona, "m05bGrabarSolicitudReservaServlet", "FIN", m05bConstantes.LOG_NIVEL_BAJO);

				if (i > 0) {
					return "";
				} else {
					return "ERROR";
				}
			} catch (Exception SQLException) {
				conn.rollback();
				miLog.addTraza(SQLException);
				return SQLException.getMessage();
			} finally {
				if (rs != null) {
					rs.close();
				}
				if (pstmt != null) {
					pstmt.close();
				}
				if (conn != null) {
					conn.close();
				}
			}
		} catch (Throwable theException) {
			miLog.addTraza(persona, "m05bGrabarSolicitudReservaServlet", "ERROR: " + theException.getMessage(), m05bConstantes.LOG_NIVEL_BAJO);
			miLog.addTraza(theException);
			return theException.getMessage();
		}
	}
	
	private String comprobarAsignacionSolicitud(long codigoSolicitud, HttpServletRequest request) {

		StringBuffer sql = new StringBuffer(125);
		java.sql.Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		m05bFileLog miLog = new m05bFileLog();
		HttpSession session = request.getSession(true);
		String persona = (String)session.getAttribute("persona");

		try {
			try {
				Locale idiomaLocal = (Locale)session.getAttribute("Local");
				ResourceBundle res = ResourceBundle.getBundle("html.datos.etiquetas", idiomaLocal);
				m05bConexion miConex = new m05bConexion();
				conn = miConex.getConnection();
				conn.setAutoCommit(false);

				// Bloqueamos la solicitud
				//sql.append("update m05100s01 set BLOQUEO_100 = 1 WHERE ID_SOLICITUD_100 = ? AND NVL(BLOQUEO_100,0)=0");
				//pstmt = conn.prepareStatement(sql.toString());
				//pstmt.setLong(1, codigoSolicitud);
				//int bloqueo = pstmt.executeUpdate();
				//miLog.addTraza(persona, "m05bGrabarSolicitudReservaServlet", "SQL: " + sql + " - " + bloqueo + " fila(s) afectada(s)", m05bConstantes.LOG_NIVEL_BAJO);

				//if (bloqueo > 0) { // Hemos conseguido bloquear la solicitud

					// Comprobamos el estado de la solicitud
					// Slo se podr asignar si el estado es ASA o REC por PARQUE MVIL
					sql = new StringBuffer();

					sql.append("select 1 from ")
						.append("dual where exists (select 1 from DETALLE_SOLICITUD where ID_SOLICITUD_100 = ? AND ESTADO_102 = 'ASA')")
						.append("or exists (select 1 from DETALLE_SOLICITUD where ID_SOLICITUD_100 = ? AND ESTADO_102 = 'SOL')")
						// Agurtzane Mar12: caducar solicitudes
						.append("or exists (select 1 from DETALLE_SOLICITUD where ID_SOLICITUD_100 = ? AND ESTADO_102 = 'CAD')")
						// Fin Agurtzane Mar12: caducar solicitudes
						.append("or (exists (select 1 from DETALLE_SOLICITUD where ID_SOLICITUD_100 = ? AND ESTADO_102 = 'REC' AND ORIGEN_RECHAZO = 'B')")
						//Ahora se pueden asignar aunque no estn aprobadas
						//Se aprueban por el validador a posteriori.
						//.append("    and exists (")
						//.append("          select 1 from dual where")
						//.append("          NVL((select MAX(fecha_validacion_102) from m05102t00 where ID_SOLICITUD_102 = ? AND ESTADO_102 = 'ASA'), TO_DATE('01/01/1900', 'dd/mm/yyyy'))")
						//.append("          >")
						//.append("          NVL((select MAX(fecha_validacion_102) from m05102t00 where ID_SOLICITUD_102 = ? AND ESTADO_102 = 'REC' AND ORIGEN_102 IN ('S','J')), TO_DATE('01/01/1900', 'dd/mm/yyyy'))")
						//.append("        )")
						.append("    )");

					pstmt = conn.prepareStatement(sql.toString());
					pstmt.setLong(1, codigoSolicitud);
					pstmt.setLong(2, codigoSolicitud);
					pstmt.setLong(3, codigoSolicitud);
//					 Agurtzane Mar12: caducar solicitudes
					pstmt.setLong(4, codigoSolicitud);
//					 Fin Agurtzane Mar12: caducar solicitudes
					//pstmt.setLong(4, codigoSolicitud);
					//pstmt.setLong(5, codigoSolicitud);
					rs = pstmt.executeQuery();
					miLog.addTraza(persona, "m05bGrabarSolicitudReservaServlet", "SQL: " + sql, m05bConstantes.LOG_NIVEL_BAJO);
					if (!rs.next()) {
						// ERROR
						conn.rollback();
						return res.getString("general.error.nosepuedeasignarporestadoactual");
					}
					//
					
				//} else {
				//	conn.rollback();
				//	return res.getString("general.error.bloqueo");
				//}

				//SI LLEGAMOS AQU ES QUE SE PUEDE ASIGNAR
				//DEJAMOS LA SOLICITUD BLOQUEADA
				// Desbloqueamos la solicitud
				//sql = new StringBuffer();
				//sql.append("update m05100s01 set BLOQUEO_100 = 0 WHERE ID_SOLICITUD_100 = ? AND NVL(BLOQUEO_100,0)=1");
				//pstmt = conn.prepareStatement(sql.toString());
				//pstmt.setLong(1, codigoSolicitud);
				//int desbloqueo = pstmt.executeUpdate();
				//miLog.addTraza(persona, "m05bGrabarSolicitudReservaServlet", "SQL: " + sql + " - " + desbloqueo + " fila(s) afectada(s)", m05bConstantes.LOG_NIVEL_BAJO);

				conn.commit();

				miLog.addTraza(persona, "m05bGrabarSolicitudReservaServlet", "FIN", m05bConstantes.LOG_NIVEL_BAJO);

				return "";

			} catch (Exception SQLException) {
				conn.rollback();
				miLog.addTraza(SQLException);
				return SQLException.getMessage();
			} finally {
				if (rs != null) {
					rs.close();
				}
				if (pstmt != null) {
					pstmt.close();
				}
				if (conn != null) {
					conn.close();
				}
			}
		} catch (Throwable theException) {
			miLog.addTraza(persona, "m05bGrabarSolicitudReservaServlet", "ERROR: " + theException.getMessage(), m05bConstantes.LOG_NIVEL_BAJO);
			miLog.addTraza(theException);
			return theException.getMessage();
		}
	}

	private boolean existeAsignacionSolicitud(long codigoSolicitud, HttpServletRequest request) {

		StringBuffer sql = new StringBuffer(125);
		java.sql.Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		m05bFileLog miLog = new m05bFileLog();
		HttpSession session = request.getSession(true);
		String persona = (String)session.getAttribute("persona");

		try {
			try {
				m05bConexion miConex = new m05bConexion();
				conn = miConex.getConnection();

				sql = new StringBuffer();

				sql.append("select 1 from m0501t00 ")
					.append("where COD_ASIG_01 in (select COD_ASIGNACION_100 from m05100t00 where ID_SOLICITUD_100 = ?)");

				pstmt = conn.prepareStatement(sql.toString());
				pstmt.setLong(1, codigoSolicitud);
				rs = pstmt.executeQuery();
				miLog.addTraza(persona, "m05bGrabarSolicitudReservaServlet", "SQL: " + sql, m05bConstantes.LOG_NIVEL_BAJO);
				if (!rs.next()) {
					// ERROR
					return false;
				}

				miLog.addTraza(persona, "m05bGrabarSolicitudReservaServlet", "FIN", m05bConstantes.LOG_NIVEL_BAJO);

				return true;

			} catch (Exception SQLException) {
				miLog.addTraza(SQLException);
				return false;
			} finally {
				if (rs != null) {
					rs.close();
				}
				if (pstmt != null) {
					pstmt.close();
				}
				if (conn != null) {
					conn.close();
				}
			}
		} catch (Throwable theException) {
			miLog.addTraza(persona, "m05bGrabarSolicitudReservaServlet", "ERROR: " + theException.getMessage(), m05bConstantes.LOG_NIVEL_BAJO);
			miLog.addTraza(theException);
			return false;
		}
	}


	private String obtenerCadenaFiltro(HttpServletRequest request)
	{
		String miEstadoFiltro = request.getParameter("estadoFiltro")==null?m05bConstantes.ACEPTADASINASIGNAR:request.getParameter("estadoFiltro");
		String mifSolDesdeFiltro = request.getParameter("fSolDesdeFiltro")==null?"":request.getParameter("fSolDesdeFiltro");
		String mifSolHastaFiltro = request.getParameter("fSolHastaFiltro")==null?"":request.getParameter("fSolHastaFiltro");
		String mifDesdeFiltro = request.getParameter("fDesdeFiltro")==null?"":request.getParameter("fDesdeFiltro");
		String mihDesdeFiltro = request.getParameter("hDesdeFiltro")==null?"":request.getParameter("hDesdeFiltro");
		String mifHastaFiltro = request.getParameter("fHastaFiltro")==null?"":request.getParameter("fHastaFiltro");
		String mihHastaFiltro = request.getParameter("hHastaFiltro")==null?"":request.getParameter("hHastaFiltro");

		String retorno = "";

		if (miEstadoFiltro != null && miEstadoFiltro != "")
		{
			retorno = retorno + "&estadoFiltro=" + miEstadoFiltro;
		}
		if (mifSolDesdeFiltro != null && mifSolDesdeFiltro != "")
		{
			retorno = retorno + "&fSolDesdeFiltro=" + mifSolDesdeFiltro;
		}
		if (mifSolHastaFiltro != null && mifSolHastaFiltro != "")
		{
			retorno = retorno + "&fSolHastaFiltro=" + mifSolHastaFiltro;
		}
		if (mifDesdeFiltro != null && mifDesdeFiltro != "")
		{
			retorno = retorno + "&fDesdeFiltro=" + mifDesdeFiltro;
		}
		if (mihDesdeFiltro != null && mihDesdeFiltro != "")
		{
			retorno = retorno + "&hDesdeFiltro=" + mihDesdeFiltro;
		}
		if (mifHastaFiltro != null && mifHastaFiltro != "")
		{
			retorno = retorno + "&fHastaFiltro=" + mifHastaFiltro;
		}
		if (mihHastaFiltro != null && mihHastaFiltro != "")
		{
			retorno = retorno + "&hHastaFiltro=" + mihHastaFiltro;
		}

		return retorno;
	}
	
	private m05bPersonaXLNET obtenerUsuarioXlNets(String usuario, HttpServletRequest request)
	{
		SecurityHelpperXLNets sh;
		ArrayList listaD = null;
		sh = new SecurityHelpperXLNets();
		try {
			sh.setHttpRequest(request);
			listaD = sh.getPersonasXLNETs(usuario, "", "", "");
		} catch (SecurityHelpperException e) {
			// TODO Auto-generated catch block
			miLog.addTraza(e);
		}
		if (listaD != null && listaD.size() > 0)
		{
			return (m05bPersonaXLNET)listaD.get(0);
		}

		return null;
	}

	private String obtenerMailXlnets(String usuario, HttpServletRequest request)
	{
		String mail = "";
		SecurityHelpperXLNets sh;
		ArrayList listaD = null;
		sh = new SecurityHelpperXLNets();
		try {
			sh.setHttpRequest(request);
			listaD = sh.getPersonasXLNETs(usuario, "", "", "");
		} catch (SecurityHelpperException e) {
			// TODO Auto-generated catch block
			miLog.addTraza(e);
		}
		if (listaD != null && listaD.size() > 0)
		{
			mail = ((m05bPersonaXLNET)listaD.get(0)).getEMail();
		}

		return mail;
	}

	private String enviarMail(String destinatario, boolean esSolicitante, boolean esReservador, boolean esValidador, m05bSolicitudReserva solicitudReserva, String idioma, HttpServletRequest request) throws Exception
	{
		String to = "";

		// Acceder a los Diccionarios
		Locale lCas = new Locale("ES");
		Locale lEus = new Locale("EU");
		ResourceBundle resCas = ResourceBundle.getBundle("html.datos.etiquetas", lCas);
		ResourceBundle resEus = ResourceBundle.getBundle("html.datos.etiquetas", lEus);

		m05bFileLog miLog = new m05bFileLog();

		try
		{
			m05bComun miComun = new m05bComun();
			String remitente = miComun.leerPropiedad("user.mail.remitente");

    		if (remitente == null || remitente == "")
    		{
    			String retorno = "";

    			if (idioma.equals("ES"))
    			{
    				retorno = resEus.getString("general.email.error")
    						+ "\n" + resEus.getString("general.email.noExisteEmisor");
    			}
    			else
    			{
    				retorno = resCas.getString("general.email.error")
    						+ "\n" + resCas.getString("general.email.noExisteEmisor");
    			}

    			return retorno;
    		}
    		else
    		{
    			String host = miComun.leerPropiedad("servidor.smtp");

    			miLog.addTraza("EnviarMail", "Grabar Solicitud Reserva Servlet", "ENVIAR MAIL RECHAZO host:" + host, m05bConstantes.LOG_NIVEL_BAJO);

    			to = destinatario;

    			String from = remitente;

    			miLog.addTraza("EnviarMail", "Grabar Solicitud Reserva Servlet", "ENVIAR MAIL RECHAZO from:" + remitente + " to:" + to, m05bConstantes.LOG_NIVEL_BAJO);

	            Properties props = System.getProperties();
	            props.put("mail.smtp.host", host);

	            // Esta lnea indica que vamos a autenticarnos en el servidor SMTP
	            //props.put("mail.smtp.auth", "true");
	            props.put("mail.smtp.auth", "false");

	            // Obtener una sesin con las propiedades anteriormente definidas
	            // Authenticator auth = new MiAutenticador();
	            // Session sesion = Session.getDefaultInstance(props, auth);
	            Session sesion = Session.getInstance(props);
	            
	            String asunto = "";
	            if (esSolicitante)
	            	asunto = resCas.getString("rechazo.email.asunto") + " / " + resEus.getString("rechazo.email.asunto");
	            else if (esReservador)
	            	asunto = resCas.getString("rechazo.email.asunto") + " / " + resEus.getString("rechazo.email.asunto");
	            else if (esValidador)
	            	asunto = resCas.getString("rechazo.email.asunto") + " / " + resEus.getString("rechazo.email.asunto");
	            
	    	    StringBuffer contenido = new StringBuffer("<p>"+resCas.getString("rechazo.email.titulo")+"</p>");
	    	    
	    	    //String saludo = resCas.getString("rechazo.email.saludo");
	    	    //if (esSolicitante)
	    	    //	saludo = saludo.replaceAll("@TEXTO", resCas.getString("rechazo.email.solicitante"));
	            //else if (esReservador)
	            //	saludo = saludo.replaceAll("@TEXTO", resCas.getString("rechazo.email.reservador"));
	            //else if (esValidador)
	            //	saludo = saludo.replaceAll("@TEXTO", resCas.getString("rechazo.email.validador"));
    	    	//contenido.append("<p>"+saludo+"</p>");
	    	    contenido.append("<p>"+resCas.getString("rechazo.email.texto")+"</p>");
	    	    
	    	    contenido.append("<p>");
	    	    if (esSolicitante) {
					contenido.append(resCas.getString("rechazo.email.textoenlaceS"));
					contenido.append(" ");
					contenido.append("<a href='" + miComun.leerPropiedad("solicitudes.url.gestion") + "'>");
	    	    } else if (esReservador) {
	    	    	contenido.append(resCas.getString("rechazo.email.textoenlaceS"));
	    	    	contenido.append(" ");
	    	    	contenido.append("<a href='" + miComun.leerPropiedad("solicitudes.url.gestion") + "'>");
	    	    } else if (esValidador) {
	    	    	contenido.append(resCas.getString("rechazo.email.textoenlaceS"));
	    	    	contenido.append(" ");
	    	    	contenido.append("<a href='" + miComun.leerPropiedad("solicitudes.url.validacion") + "'>");
	    	    }
				contenido.append(resCas.getString("rechazo.email.enlace"));
				contenido.append("</a>");
				contenido.append("</p>");
	    	    contenido.append("<p>"+resCas.getString("rechazo.email.despedida")+"</p>");

	    	    //contenido.append("<br>");
	    	    contenido.append("_________________________________________________________________________________________");
	    	    contenido.append("<br>"+"<br>");
	    	    contenido.append("<p>"+resEus.getString("rechazo.email.titulo")+"</p>");
	    	    //saludo = resEus.getString("rechazo.email.saludo");
	    	    //if (esSolicitante)
	    	    //	saludo = saludo.replaceAll("@TEXTO", resEus.getString("rechazo.email.solicitante"));
	            //else if (esReservador)
	            //	saludo = saludo.replaceAll("@TEXTO", resEus.getString("rechazo.email.reservador"));
	            //else if (esValidador)
	            //	saludo = saludo.replaceAll("@TEXTO", resEus.getString("rechazo.email.validador"));
	    	    //contenido.append("<p>"+saludo+"</p>");
	    	    contenido.append("<p>"+resEus.getString("rechazo.email.texto")+"</p>");

	    	    contenido.append("<p>");
	    	    if (esSolicitante) {
					contenido.append(resEus.getString("rechazo.email.textoenlaceS"));
					contenido.append(" ");
					contenido.append("<a href='" + miComun.leerPropiedad("solicitudes.url.gestion") + "'>");
	    	    } else if (esReservador) {
	    	    	contenido.append(resEus.getString("rechazo.email.textoenlaceS"));
	    	    	contenido.append(" ");
	    	    	contenido.append("<a href='" + miComun.leerPropiedad("solicitudes.url.gestion") + "'>");
	    	    } else if (esValidador) {
	    	    	contenido.append(resEus.getString("rechazo.email.textoenlaceS"));
	    	    	contenido.append(" ");
	    	    	contenido.append("<a href='" + miComun.leerPropiedad("solicitudes.url.validacion") + "'>");
	    	    }
				contenido.append(resEus.getString("rechazo.email.enlace"));
				contenido.append("</a>");
				contenido.append("</p>");
	    	    contenido.append("<p>"+resEus.getString("rechazo.email.despedida")+"</p>");

	    	    String strTextoSolicitud = "";
	    	    strTextoSolicitud += "<b>" + resCas.getString("etDatosGenerales") + " / " + resEus.getString("etDatosGenerales") + "</b>";
	    	    strTextoSolicitud += "<br>";
	    	    strTextoSolicitud += resCas.getString("etFechaSolicitud") + " / " + resEus.getString("etFechaSolicitud") + ": ";
	    	    strTextoSolicitud += miComun.formatearFechaHora2(solicitudReserva.getFechaSolicitud());
	    	    strTextoSolicitud += "<br>";
	    	    strTextoSolicitud += resCas.getString("etNombreYApellidos") + " / " + resEus.getString("etNombreYApellidos") + ": ";
	    	    strTextoSolicitud += solicitudReserva.getUsuario().getNombre_apellidos();
	    	    strTextoSolicitud += "<br><br>";
	    	    strTextoSolicitud += "<b>" + resCas.getString("etDatosSolicitud") + " / " + resEus.getString("etDatosSolicitud") + "</b>";
	    	    strTextoSolicitud += "<br>";
	    	    strTextoSolicitud += resCas.getString("etFechaDesde") + " / " + resEus.getString("etFechaDesde") + ": ";
	    	    strTextoSolicitud += miComun.formatearFechaHora2(solicitudReserva.getFechaIni());
	    	    strTextoSolicitud += "<br>";
	    	    strTextoSolicitud += resCas.getString("etFechaHasta") + " / " + resEus.getString("etFechaHasta") + ": ";
	    	    strTextoSolicitud += miComun.formatearFechaHora2(solicitudReserva.getFechaFin());
	    	    strTextoSolicitud += "<br>";
	    	    strTextoSolicitud += resCas.getString("etMotivoSolicitud") + " / " + resEus.getString("etMotivoSolicitud") + ": ";
	    	    strTextoSolicitud += "<br>";
	    	    strTextoSolicitud += solicitudReserva.obtenerValidacionSolicitada().getMotivo().replaceAll("\n", "<br>");
	    	    strTextoSolicitud += "<br><br>";
	    	    strTextoSolicitud += "<b>" + resCas.getString("etDatosAnulacion") + " / " + resEus.getString("etDatosAnulacion") + "</b>";
	    	    strTextoSolicitud += "<br>";
	    	    strTextoSolicitud += resCas.getString("etFechaAnulacion") + " / " + resEus.getString("etFechaAnulacion") + ": ";
	    	    strTextoSolicitud += miComun.formatearFechaHora2(solicitudReserva.obtenerValidacionRechazada().getFechaValidacion());
	    	    strTextoSolicitud += "<br>";
	    	    strTextoSolicitud += resCas.getString("etAnuladoPor") + " / " + resEus.getString("etAnuladoPor") + ": ";
	    	    strTextoSolicitud += solicitudReserva.obtenerValidacionRechazada().getNombre_apellidos();
	    	    strTextoSolicitud += "<br>";
	    	    if (solicitudReserva.obtenerValidacionRechazada().getOrigen().equals(m05bConstantes.ORIGENPARQUEMOVIL)) {
	    	    	strTextoSolicitud += "(" + resCas.getString("etParqueMovil") + " / " + resEus.getString("etParqueMovil") + ")";
	    	    } else {
	    	    	strTextoSolicitud += "(" + resCas.getString("etValidador") + " / " + resEus.getString("etValidador") + ")";
    	    	}
	    	    strTextoSolicitud += "<br>";
	    	    strTextoSolicitud += resCas.getString("etMotivoAnulacion") + " / " + resEus.getString("etMotivoAnulacion") + ": ";
	    	    strTextoSolicitud += "<br>";
	    	    strTextoSolicitud += solicitudReserva.obtenerValidacionRechazada().getMotivo().replaceAll("\n", "<br>");
	    	    strTextoSolicitud += "<br>";
	    	    
	    	    if (solicitudReserva.obtenerValidacionSolicitada().getObservaciones() != null
						&& !("".equals(solicitudReserva.obtenerValidacionSolicitada().getObservaciones()))) {
					strTextoSolicitud += resCas.getString("etObservacionesFinDeSemanaOPeriodoLargo");
					strTextoSolicitud += " / ";
					strTextoSolicitud += resEus.getString("etObservacionesFinDeSemanaOPeriodoLargo");
					strTextoSolicitud += ": ";
					strTextoSolicitud += "<br>";
					strTextoSolicitud += solicitudReserva.obtenerValidacionSolicitada().getObservaciones().replaceAll("\n", "<br>");
					strTextoSolicitud += "<br>";
				}
	    	    strTextoSolicitud += "<br>";

	    	    contenido.append("<p>"+strTextoSolicitud+"</p>");

	    	    // create a message
		        MimeMessage msg = new MimeMessage(sesion);
		        msg.setFrom(new InternetAddress(from));
		        msg.addRecipient(Message.RecipientType.TO, new InternetAddress(to));

	    	    // create and fill the first message part
	    	    MimeBodyPart mbp1 = new MimeBodyPart();
	    	    mbp1.setText(contenido.toString());
	    	    mbp1.setHeader("Content-Type", "text/html");

	    	    // create the Multipart and add its parts to it
	    	    Multipart mp = new MimeMultipart();
	    	    mp.addBodyPart(mbp1);

	    	    // add the Multipart to the message
	    	    msg.setContent(mp);
	    	    msg.setSubject(asunto);
	    	    // set the Date: header
	    	    msg.setSentDate(new Date());

	    	    // send the message
	    	    Transport.send(msg);

	    	    return "";
    		}
		}
		catch (Exception ex)
		{
			miLog.addTraza("EnviarMail", "Grabar Solicitud Reserva Servlet", "ENVIAR MAIL RECHAZO to:" + to + " " + ex.getMessage(), m05bConstantes.LOG_NIVEL_BAJO);
			String retorno = "";
			if (idioma.equals("ES"))
			{
				retorno = resEus.getString("general.email.error")
						+ "\n" + resEus.getString("general.email.noExisteEmisor");
			}
			else
			{
				retorno = resCas.getString("general.email.error")
						+ "\n" + resCas.getString("general.email.noExisteEmisor");
			}

			retorno += " " + to;
			return retorno;
		}
	}

//	/**
//	 * Clase creada para obtener la autenticacin de un usuario en un servidor de correo.
//	 */
//    private static class MiAutenticador extends Authenticator
//    {
//        /**
//         * Devuelve un objeto de autenticacin de contrasea utilizado para
//         * verificar la cuenta de un usuario en un servidor de correo.
//         *
//         * @return PasswordAuthentication Objeto de autenticacin de contrasea.
//         */
//       public PasswordAuthentication getPasswordAuthentication()
//       {
//    	   m05bComun miComun = new m05bComun();
//    	   String username = miComun.leerPropiedad("user.servidor.smtp");
//    	   String passwordUser = miComun.leerPropiedad("password.servidor.smtp");
//    	   return new PasswordAuthentication(username, passwordUser);
//       }
//    }
}