package seguroServlet;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Locale;
import java.util.ResourceBundle;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import m05bClasses.m05bComun;
import m05bClasses.m05bConexion;
import m05bClasses.m05bConstantes;
import m05bClasses.m05bFileLog;

import org.apache.fop.apps.Driver;
import org.xml.sax.InputSource;

public class m05bImpPolizasPorSeguroServlet extends
		javax.servlet.http.HttpServlet {
	java.sql.Connection conn = null;
	String sLinea;
	String sFoFileDir = "/datos/m05b/tmp/";
	File foFileDir;
	File tmpFoFile;
	FileOutputStream tmpFoFileStream;

	m05bComun miComun = new m05bComun();
	m05bFileLog miLog = new m05bFileLog();
	m05bConexion miConex = new m05bConexion();

	String sSituacion = "", sSituacionSeguro = "", sCia = "", sCodDpto = "",
			sDesDpto = "";
	String contCia = "", contModal = "", sModalidad = "", sCodModalidad = "",
			sCodModalidadAnt = "", sEstado = "", sTipoVehiculo = "",
			sFSolicitud = "", sFCaducidad = "", sFBaja = "", sFAlta = "",
			sMatricula = "";

	String persona = "";

	public static final String FO_REQUEST_PARAM = "fo";

	// Logger log = null;

	public void doPost(javax.servlet.http.HttpServletRequest request,
			javax.servlet.http.HttpServletResponse response)
			throws javax.servlet.ServletException, java.io.IOException {
		try {
			doGet(request, response);
		} catch (Exception e) {
			miLog.addTraza(e);
		}
	}

	public void doGet(HttpServletRequest request, HttpServletResponse response)
			throws ServletException {
		performTask(request, response);
	}

	// if(log == null)
	// {
	// Hierarchy hierarchy = Hierarchy.getDefaultHierarchy();
	// log = hierarchy.getLoggerFor("fop");
	// log.setPriority(Priority.WARN);
	// }

	private void fncAbrirFicheroTemporal() throws java.io.IOException {
		foFileDir = new File(sFoFileDir);
		tmpFoFile = File.createTempFile("m05b", "Fo", foFileDir);
		tmpFoFileStream = new FileOutputStream(tmpFoFile);

	}

	private void fncImprimirFinPagina() throws java.io.IOException {
		sLinea = "	    </fo:table-body>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "       </fo:table>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "      </fo:flow>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "   </fo:page-sequence>\n";
		tmpFoFileStream.write(sLinea.getBytes());

	}

	private void fncImprimirComienzoPagina(ResourceBundle res, String idioma)
			throws java.io.IOException, javax.naming.NamingException {
		sLinea = "<fo:page-sequence master-reference=\"general\">\n";
		tmpFoFileStream.write(sLinea.getBytes());

		// REGION BEFORE
		sLinea = "		<fo:static-content flow-name=\"xsl-region-before\" >\n";
		tmpFoFileStream.write(sLinea.getBytes());
		// -------------- CABECERA DEL LISTADO --------------
		// Cabecera 1
		sLinea = "      <fo:block text-align=\"end\">\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "      </fo:block>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "      <fo:block font-weight=\"bold\" padding-top=\"10pt\">\n "
				+ res.getString("infPolizasSeg.titulo") + "</fo:block>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "      <fo:block  text-align=\"left\">\n <![CDATA[" + sCia + " -  "
				+ res.getString("infPolizasSeg.text1") + contCia
				+ "]]></fo:block>";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "      <fo:block  text-align=\"left\">\n <![CDATA[ "
				+ res.getString("infPolizasSeg.text2") + sCodModalidad + " "
				+ sModalidad + " -  " + res.getString("infPolizasSeg.text1")
				+ contModal + "]]></fo:block>";
		tmpFoFileStream.write(sLinea.getBytes());

		sLinea = " 		</fo:static-content>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		// PIE DE PAGINA Pie
		sLinea = "		<fo:static-content flow-name=\"xsl-region-after\">\n";
		tmpFoFileStream.write(sLinea.getBytes());
		// PIE DE PAGINA Pie
		sLinea = "      <fo:block >\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "       <fo:table>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    <fo:table-column column-width=\"127mm\"/>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    <fo:table-column column-width=\"125mm\"/>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    <fo:table-body font-family=\"Helvetica\" font-size=\"6pt\">\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    <fo:table-row>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    <fo:table-cell >\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "      <fo:block text-align=\"left\">"
				+ miComun.getDetFechaActual(idioma) + "</fo:block>";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    </fo:table-cell>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    <fo:table-cell >\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "      <fo:block text-align=\"right\">";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = res.getString("pagina") + " <fo:page-number/> \n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "</fo:block>";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    </fo:table-cell>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    </fo:table-row>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    </fo:table-body>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "       </fo:table>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "      </fo:block>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = " 		</fo:static-content>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		// BODY
		sLinea = "	<fo:flow flow-name=\"xsl-region-body\">\n";
		tmpFoFileStream.write(sLinea.getBytes());
		Context ctx = new InitialContext(System.getProperties());
		// -------------- DETALLE DEL LISTADO --------------
		sLinea = "        <fo:table space-after.optimum=\"12pt\">\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    <fo:table-column column-width=\"30mm\"/>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    <fo:table-column column-width=\"20mm\"/>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    <fo:table-column column-width=\"20mm\"/>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    <fo:table-column column-width=\"20mm\"/>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    <fo:table-column column-width=\"20mm\"/>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    <fo:table-column column-width=\"65mm\"/>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    <fo:table-column column-width=\"20mm\"/>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    <fo:table-column column-width=\"57mm\"/>\n";
		tmpFoFileStream.write(sLinea.getBytes());

		sLinea = "	    <fo:table-body font-family=\"Helvetica\" font-size=\"8pt\">\n";
		tmpFoFileStream.write(sLinea.getBytes());
		// Linea titulos
		sLinea = "	    <fo:table-row>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		// Matricula
		sLinea = "	    <fo:table-cell padding-top=\"2mm\">\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "      <fo:block font-weight=\"bold\" text-align=\"center\">\n "
				+ res.getString("infPolizasSeg.col1") + "</fo:block>";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    </fo:table-cell>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		// Fecha Solicitud
		sLinea = "	    <fo:table-cell padding-top=\"2mm\">\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "      <fo:block font-weight=\"bold\"  text-align=\"center\">\n "
				+ res.getString("infPolizasSeg.col2") + "</fo:block>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    </fo:table-cell>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		// Fecha Alta
		sLinea = "	    <fo:table-cell padding-top=\"2mm\">\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "      <fo:block font-weight=\"bold\"  text-align=\"center\">\n"
				+ res.getString("infPolizasSeg.col3") + "</fo:block>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    </fo:table-cell>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		// Fecha baja
		sLinea = "	    <fo:table-cell padding-top=\"2mm\">\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "      <fo:block font-weight=\"bold\"  text-align=\"center\">\n "
				+ res.getString("infPolizasSeg.col4") + "</fo:block>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    </fo:table-cell>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		// Estado
		sLinea = "	    <fo:table-cell padding-top=\"2mm\">\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "      <fo:block font-weight=\"bold\"  text-align=\"center\">\n "
				+ res.getString("infPolizasSeg.col5") + "</fo:block>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    </fo:table-cell>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		// Tipo
		sLinea = "	    <fo:table-cell padding-top=\"2mm\">\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "      <fo:block font-weight=\"bold\"  text-align=\"center\">\n "
				+ res.getString("infPolizasSeg.col6") + "</fo:block>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    </fo:table-cell>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		// Codigo Dpto
		sLinea = "	    <fo:table-cell padding-top=\"2mm\">\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "      <fo:block font-weight=\"bold\"  text-align=\"center\">\n "
				+ res.getString("infPolizasSeg.col7") + "</fo:block>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    </fo:table-cell>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		// Desc Dpto
		sLinea = "	    <fo:table-cell padding-top=\"2mm\">\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "      <fo:block font-weight=\"bold\"  text-align=\"center\">\n "
				+ res.getString("infPolizasSeg.col8") + "</fo:block>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    </fo:table-cell>\n";
		tmpFoFileStream.write(sLinea.getBytes());

		sLinea = "	    </fo:table-row>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    <fo:table-row >\n";
		tmpFoFileStream.write(sLinea.getBytes());

	}

	public void performTask(javax.servlet.http.HttpServletRequest request,
			javax.servlet.http.HttpServletResponse response)
			throws ServletException {
		java.sql.Connection conn = null;

		PreparedStatement pstmt = null;
		PreparedStatement pstmt2 = null;

		ResultSet rs = null;
		ResultSet rs2 = null;

		String sCiaAnt = "";

		try {
			HttpSession session = request.getSession(true);
			/* Iker. idioma */
			Locale idiomaLocal = (Locale) session.getAttribute("Local");
			String idiomaSes = ((idiomaLocal.getLanguage() == null) ? "es"
					: idiomaLocal.getLanguage());
			String campoTexto = "";
			String campoTexto2 = "";
			String campoTexto3 = "C";
			String formatoFecha="dd/MM/yyyy";
			ResourceBundle res = (ResourceBundle) session
					.getAttribute("resTit");
			if (!idiomaSes.equals("es")) {
				campoTexto = "E";
				campoTexto2 = "E_";
				campoTexto3 = "E";
				formatoFecha = "yyyy/MM/dd";
			}
			persona = (String) session.getAttribute("persona");
			conn = miConex.getConnection();

			// Obtencin de informacin de BD
			// Vehculo
			// Recogemos la situacion
			sSituacion = request.getParameter("Situacion");
			if ((sSituacion == null) || (sSituacion.equals(""))) {
				sSituacion = "";
			} else {
				sSituacion = miComun.ListaCaracteres(sSituacion);
			}
			// Recogemos la situacion del seguro
			sSituacionSeguro = request.getParameter("SituacionSeguro");
			if ((sSituacionSeguro == null) || (sSituacionSeguro.equals(""))) {
				sSituacionSeguro = "";
			} else {
				sSituacionSeguro = miComun.ListaCaracteres(sSituacionSeguro);
			}
			// Recogemos la situacion del seguro
			sCia = request.getParameter("Cia");
			if ((sCia == null) || (sCia.equals(""))) {
				sCia = "";
			}
			String dpto= request.getParameter("Dpto");
			if ((dpto == null) || (dpto.equals(""))) {
				dpto = "";
			}
			String sSentenciaCount = " SELECT COUNT(*) ";
			String sSentencia = " SELECT " + m05bConstantes.COL_13_MATRICULA
					+ "," + m05bConstantes.COL_13_CODIGO + ",NVL(S." + campoTexto
					+ m05bConstantes.COL_99_DESCRIPCION + ",S."
					+ m05bConstantes.COL_99_DESCRIPCION + "),"
					+ m05bConstantes.COL_13_CIA + ","
					+ m05bConstantes.COL_06_DESCDPTO + ",NVL(M."
					+ campoTexto+ m05bConstantes.COL_99_DESCRIPCION + ",M."
					+ m05bConstantes.COL_99_DESCRIPCION + "),M."
					+ m05bConstantes.COL_99_CODDESC + ",NVL(T."
					+ campoTexto+ m05bConstantes.COL_99_DESCRIPCION + ",T."
					+ m05bConstantes.COL_99_DESCRIPCION + "),TO_CHAR("
					+ m05bConstantes.COL_13_FSOLIC + ",'"+formatoFecha+"'),TO_CHAR("
					+ m05bConstantes.COL_13_FCADUC + ",'"+formatoFecha+"'),TO_CHAR("
					+ m05bConstantes.COL_13_FALTA + ",'"+formatoFecha+"'),TO_CHAR("
					+ m05bConstantes.COL_13_FBAJA + ",'"+formatoFecha+"'),"
					+ m05bConstantes.COL_13_ESTADO + " , DECODE("
					+ campoTexto2+m05bConstantes.COL_06_DESCDPTO + ",'','Parque Movil',"
					+ campoTexto2+m05bConstantes.COL_06_DESCDPTO + "),NVL(R."
					+ campoTexto+ m05bConstantes.COL_99_DESCRIPCION + ",R."
					+ m05bConstantes.COL_99_DESCRIPCION + "),"
					+ m05bConstantes.COL_06_CODDPTO;

			String sFrom = " FROM " + m05bConstantes.TAB_HIST_SEGUROS + ","
					+ m05bConstantes.TAB_VEHICULOS + ","
					+ m05bConstantes.TAB_DESCRIPCIONES + " R,"
					+ m05bConstantes.TAB_DESCRIPCIONES + " M,"
					+ m05bConstantes.TAB_DESCRIPCIONES + " S,"
					+ m05bConstantes.TAB_DESCRIPCIONES + " T,"
					+ m05bConstantes.TAB_DEPARTAMENTOS + " WHERE "
					+ m05bConstantes.COL_13_MATRICULA + "="
					+ m05bConstantes.COL_34_MATRICULA + " AND " + " M."
					+ m05bConstantes.COL_99_CODTABLA + "='8' AND "
					+ m05bConstantes.COL_13_MODAL + "= M."
					+ m05bConstantes.COL_99_CODDESC + "(+) AND " + " R."
					+ m05bConstantes.COL_99_CODTABLA + "='11'   AND "
					+ m05bConstantes.COL_34_RANGO + "= R."
					+ m05bConstantes.COL_99_CODDESC + " AND " + " S."
					+ m05bConstantes.COL_99_CODTABLA + "='9'   AND "
					+ m05bConstantes.COL_34_SITUACION + "= S."
					+ m05bConstantes.COL_99_CODDESC + " AND " + " T."
					+ m05bConstantes.COL_99_CODTABLA + "='14'   AND "
					+ m05bConstantes.COL_13_ESTADO + "= T."
					+ m05bConstantes.COL_99_CODDESC + " AND "
					+ m05bConstantes.COL_06_CODDPTO + "="
					+ m05bConstantes.COL_34_CODDPTO + " AND "
					+ m05bConstantes.COL_13_MATRICULA + "||"
					+ m05bConstantes.COL_13_CODIGO + "  in(" + " SELECT "
					+ m05bConstantes.COL_13_MATRICULA + "||MAX(TO_NUMBER("
					+ m05bConstantes.COL_13_CODIGO + "))" + " FROM "
					+ m05bConstantes.TAB_HIST_SEGUROS + " GROUP BY "
					+ m05bConstantes.COL_13_MATRICULA + ")";

			if (!(sSituacion.equals(""))) {
				sFrom = sFrom + " AND " + m05bConstantes.COL_34_SITUACION
						+ " in (" + sSituacion + ")";
			}
			if (!(sSituacionSeguro.equals(""))) {
				sFrom = sFrom + " AND " + m05bConstantes.COL_13_ESTADO
						+ " in (" + sSituacionSeguro + ")";
			}
			if (!(sCia.equals(""))) {
				sFrom = sFrom + " AND " + m05bConstantes.COL_13_CIA + " = '"
						+ sCia + "'";
			}
			if(!dpto.equals("")){
				sFrom= sFrom + " AND " + m05bConstantes.COL_06_CODDPTO+ " = '"+dpto+"'";
			} 
			// ORDER
			sSentencia = sSentencia + sFrom + " ORDER BY "
					+ m05bConstantes.COL_13_CIA + ","
					+ m05bConstantes.COL_99_CODDESC + ","
					+ m05bConstantes.COL_13_MATRICULA;
			sSentenciaCount = sSentenciaCount + sFrom;

			// pstmt2 = conn.prepareStatement(sSentenciaDPTO);
			// rs2= pstmt2.executeQuery();
			// if (rs2.next()){
			// sDepartamento=rs2.getString(1)==null ? "":rs2.getString(1);}
			// rs2.close();

			pstmt = conn.prepareStatement(sSentencia);
			rs = pstmt.executeQuery();

			// String foParam = request.getParameter(FO_REQUEST_PARAM);
			fncAbrirFicheroTemporal();

			sLinea = "<?xml version=\"1.0\" encoding=\"windows-1252\"?>\n";
			tmpFoFileStream.write(sLinea.getBytes());

			sLinea = "<fo:root xmlns:fo=\"http://www.w3.org/1999/XSL/Format\">\n";
			tmpFoFileStream.write(sLinea.getBytes());
			// LAYOUT DEL LISTADO
			sLinea = "<fo:layout-master-set>\n";
			tmpFoFileStream.write(sLinea.getBytes());
			sLinea = "	<fo:simple-page-master master-name=\"general\"  page-height=\"21cm\" page-width=\"29.5cm\" margin-top=\"2cm\" margin-bottom=\"2cm\" margin-left=\"2.5cm\" margin-right=\"2.5cm\">\n";
			tmpFoFileStream.write(sLinea.getBytes());
			sLinea = "		<fo:region-before extent=\"2cm\"/>\n";
			tmpFoFileStream.write(sLinea.getBytes());
			sLinea = "		<fo:region-body  margin-top=\"2.8cm\" margin-bottom=\"1.5cm\" />\n";
			tmpFoFileStream.write(sLinea.getBytes());
			sLinea = "		<fo:region-after  extent=\"1cm\"/>\n";
			tmpFoFileStream.write(sLinea.getBytes());
			sLinea = "		<fo:region-start extent=\"0cm\"/>\n";
			tmpFoFileStream.write(sLinea.getBytes());
			sLinea = "		<fo:region-end extent=\"0cm\"/>\n";
			tmpFoFileStream.write(sLinea.getBytes());

			sLinea = "	</fo:simple-page-master>\n";
			tmpFoFileStream.write(sLinea.getBytes());

			sLinea = "</fo:layout-master-set>\n";
			tmpFoFileStream.write(sLinea.getBytes());
			int cont = 0;
			contCia = "";
			contModal = "";
			String sSentenciaCountAux = "";
			while (rs.next()) {
				sCia = rs.getString(4) == null ? "" : rs.getString(4);
				if (!(sCia.equals(sCiaAnt))) {
					sSentenciaCountAux = sSentenciaCount + " AND "
							+ m05bConstantes.COL_13_CIA + " = '" + sCia + "'";
					miLog.addTraza(persona,
							"m05b - ImpPolizasSeguroServlet:  ",
							"sSentenciaCountAux: " + sSentenciaCountAux,
							m05bConstantes.LOG_NIVEL_BAJO);
					pstmt2 = conn.prepareStatement(sSentenciaCountAux);
					rs2 = pstmt2.executeQuery();
					if (rs2.next()) {
						contCia = rs2.getString(1);
					}
				}
				sCodModalidad = rs.getString(7) == null ? "" : rs.getString(7);
				sModalidad = rs.getString(6) == null ? "" : rs.getString(6);
				if ((!(sCodModalidad.equals(sCodModalidadAnt)))
						|| ((sCodModalidad.equals(sCodModalidadAnt)) && (!(sCia
								.equals(sCiaAnt))))) {
					sSentenciaCountAux = sSentenciaCount + " AND "
							+ m05bConstantes.COL_13_CIA + " = '" + sCia + "'";
					sSentenciaCountAux = sSentenciaCountAux + " AND "
							+ m05bConstantes.COL_13_MODAL + " = '"
							+ sCodModalidad + "'";
					miLog.addTraza(persona,
							"m05b - ImpPolizasSeguroServlet:  ",
							"sSentenciaCountAux: " + sSentenciaCountAux,
							m05bConstantes.LOG_NIVEL_BAJO);

					pstmt2 = conn.prepareStatement(sSentenciaCountAux);
					rs2 = pstmt2.executeQuery();
					if (rs2.next()) {
						contModal = rs2.getString(1);
					}
				}

				sMatricula = rs.getString(1) == null ? "" : rs.getString(1);

				sFSolicitud = rs.getString(9) == null ? "" : rs.getString(9);

				sFAlta = rs.getString(11) == null ? "" : rs.getString(11);

				sFCaducidad = rs.getString(10) == null ? "" : rs.getString(10);

				sFBaja = rs.getString(12) == null ? "" : rs.getString(12);

				sEstado = rs.getString(8) == null ? "" : rs.getString(8);

				sTipoVehiculo = rs.getString(15) == null ? "" : rs
						.getString(15);

				sCodDpto = rs.getString(16) == null ? "" : rs.getString(16);
				miLog.addTraza(persona, "m05b - ImpPolizasSeguroServlet:  ",
						"sCodDpto: " + sCodDpto, m05bConstantes.LOG_NIVEL_BAJO);

				sDesDpto = rs.getString(14) == null ? "" : rs.getString(14);
				miLog.addTraza(persona, "m05b - ImpPolizasSeguroServlet:  ",
						"sDesDpto: " + sDesDpto, m05bConstantes.LOG_NIVEL_BAJO);
				if (((!(sCia.equals(sCiaAnt))))
						|| ((!(sCodModalidad.equals(sCodModalidadAnt))))
						|| (cont == 17)) {
					if (sCiaAnt != "") {
						fncImprimirFinPagina();
					}
					fncImprimirComienzoPagina(res, campoTexto3);

					cont = 0;

				} else {
					cont = cont + 1;
					sLinea = "	    <fo:table-row >\n";
					tmpFoFileStream.write(sLinea.getBytes());
				}
				sCiaAnt = sCia;
				sCodModalidadAnt = sCodModalidad;
				// Matricula
				sLinea = "	    <fo:table-cell padding-top=\"1mm\" border-width=\"0.1mm\" border-style=\"solid\">\n";
				tmpFoFileStream.write(sLinea.getBytes());
				sLinea = "      <fo:block  text-align=\"center\">\n<![CDATA[ "
						+ sMatricula + "]]></fo:block>";
				tmpFoFileStream.write(sLinea.getBytes());
				sLinea = "	    </fo:table-cell>\n";
				tmpFoFileStream.write(sLinea.getBytes());
				// Fecha Solicitud
				sLinea = "	    <fo:table-cell padding-top=\"1mm\" border-width=\"0.1mm\" border-style=\"solid\">\n";
				tmpFoFileStream.write(sLinea.getBytes());
				sLinea = "      <fo:block  text-align=\"center\">\n<![CDATA[ "
						+ sFSolicitud + "]]></fo:block>\n";
				tmpFoFileStream.write(sLinea.getBytes());
				sLinea = "	    </fo:table-cell>\n";
				tmpFoFileStream.write(sLinea.getBytes());
				// Fecha Alta
				sLinea = "	    <fo:table-cell padding-top=\"1mm\" border-width=\"0.1mm\" border-style=\"solid\">\n";
				tmpFoFileStream.write(sLinea.getBytes());
				sLinea = "      <fo:block  text-align=\"center\">\n<![CDATA[" + sFAlta
						+ "]]></fo:block>\n";
				tmpFoFileStream.write(sLinea.getBytes());
				sLinea = "	    </fo:table-cell>\n";
				tmpFoFileStream.write(sLinea.getBytes());
				// Fecha Baja
				sLinea = "	    <fo:table-cell padding-top=\"1mm\" border-width=\"0.1mm\" border-style=\"solid\">\n";
				tmpFoFileStream.write(sLinea.getBytes());
				sLinea = "      <fo:block  text-align=\"center\">\n<![CDATA[" + sFBaja
						+ "]]></fo:block>\n";
				tmpFoFileStream.write(sLinea.getBytes());
				sLinea = "	    </fo:table-cell>\n";
				tmpFoFileStream.write(sLinea.getBytes());
				// Estado
				sLinea = "	    <fo:table-cell padding-top=\"1mm\" border-width=\"0.1mm\" border-style=\"solid\">\n";
				tmpFoFileStream.write(sLinea.getBytes());
				sLinea = "      <fo:block  text-align=\"center\">\n<![CDATA[" + sEstado
						+ "]]></fo:block>\n";
				tmpFoFileStream.write(sLinea.getBytes());
				sLinea = "	    </fo:table-cell>\n";
				tmpFoFileStream.write(sLinea.getBytes());
				// Tipo de vehiculo
				sLinea = "	    <fo:table-cell padding-top=\"1mm\" border-width=\"0.1mm\" border-style=\"solid\">\n";
				tmpFoFileStream.write(sLinea.getBytes());
				sLinea = "      <fo:block  text-align=\"left\">\n<![CDATA["
						+ sTipoVehiculo + "]]></fo:block>\n";
				tmpFoFileStream.write(sLinea.getBytes());
				sLinea = "	    </fo:table-cell>\n";
				tmpFoFileStream.write(sLinea.getBytes());
				// codigo dpto
				sLinea = "	    <fo:table-cell padding-top=\"1mm\" border-width=\"0.1mm\" border-style=\"solid\">\n";
				tmpFoFileStream.write(sLinea.getBytes());
				sLinea = "      <fo:block  text-align=\"left\">\n<![CDATA[" + sCodDpto
						+ "]]></fo:block>\n";
				tmpFoFileStream.write(sLinea.getBytes());
				sLinea = "	    </fo:table-cell>\n";
				tmpFoFileStream.write(sLinea.getBytes());
				// Desc Dpto
				sLinea = "	    <fo:table-cell padding-top=\"1mm\" border-width=\"0.1mm\" border-style=\"solid\">\n";
				tmpFoFileStream.write(sLinea.getBytes());
				sLinea = "      <fo:block  text-align=\"left\">\n<![CDATA[" + sDesDpto
						+ "]]></fo:block>\n";
				tmpFoFileStream.write(sLinea.getBytes());
				sLinea = "	    </fo:table-cell>\n";
				tmpFoFileStream.write(sLinea.getBytes());

				sLinea = "	    </fo:table-row>\n";
				tmpFoFileStream.write(sLinea.getBytes());
			}
			rs.close();
			rs2.close();

			sLinea = "	    </fo:table-body>\n";
			tmpFoFileStream.write(sLinea.getBytes());
			sLinea = "       </fo:table>\n";
			tmpFoFileStream.write(sLinea.getBytes());
			// sLinea = "      </fo:block-container>\n";
			// tmpFoFileStream.write(sLinea.getBytes());

			sLinea = "      </fo:flow>\n";
			tmpFoFileStream.write(sLinea.getBytes());

			sLinea = "   </fo:page-sequence>\n";
			tmpFoFileStream.write(sLinea.getBytes());

			sLinea = "</fo:root>\n";
			tmpFoFileStream.write(sLinea.getBytes());

			tmpFoFileStream.close();

			FileInputStream file = new FileInputStream(sFoFileDir
					+ tmpFoFile.getName());

			renderFO(new InputSource(file), response);

			tmpFoFile.delete();

			response.flushBuffer();

		} catch (Exception ex) {
			try {
				response.sendRedirect("m05bError.jsp");
			} catch (IOException e) {
				// TODO Auto-generated catch block
				miLog.addTraza(e);
			}
		} finally {
			try {
				if (rs != null)
					rs.close();
				if (rs2 != null)
					rs2.close();
				if (pstmt != null)
					pstmt.close();
				if (pstmt2 != null)
					pstmt2.close();
				if (conn != null)
					conn.close();
			} catch (SQLException e2) {
				try {
					response.sendRedirect("m05bError.jsp");
				} catch (IOException e) {
					// TODO Auto-generated catch block
					miLog.addTraza(e);
				}
			}
		}
	}

	/**
	 * renders an FO inputsource into a PDF file which is rendered directly to
	 * the response object's OutputStream
	 */
	public void renderFO(InputSource foFile, HttpServletResponse response)
			throws ServletException {
		try {
			ByteArrayOutputStream out = new ByteArrayOutputStream();

			response.reset();
			OutputStream oOut = response.getOutputStream();
			BufferedOutputStream bOut = new BufferedOutputStream(oOut);
			Driver driver = new Driver(foFile, out);
			driver.setRenderer(Driver.RENDER_PDF);
			driver.run();

			response.setContentLength(out.size());
			response.setContentType("application/pdf");

			bOut.write(out.toByteArray());
			out.close();
			bOut.flush();
			bOut.close();
			// response.flushBuffer();
		} catch (Exception ex) {
			throw new ServletException(ex);
		}
	}
}