package seguroServlet;

import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

import javax.servlet.http.HttpSession;

import m05bBD.m05bSeguro;
import m05bClasses.m05bConexion;
import m05bClasses.m05bConstantes;
import m05bClasses.m05bFileLog;

/**
 * Inserte aqu la descripcin del tipo.
 * Fecha de creacin: (17/12/28)
 */
public class m05bGrabarSeguroServlet extends javax.servlet.http.HttpServlet {m05bFileLog miLog = new m05bFileLog();
/**
 * Process incoming HTTP POST requests 
 * 
 * @param request Object that encapsulates the request to the servlet 
 * @param response Object that encapsulates the response from the servlet
 */
public void doPost(javax.servlet.http.HttpServletRequest request, javax.servlet.http.HttpServletResponse response) throws javax.servlet.ServletException, java.io.IOException {

	performTask(request, response);

}
/**
 * Returns the servlet info string.
 */
public String getServletInfo() {

	return super.getServletInfo();

}
/**
 * Initializes the servlet.
 */
public void init() {
	// insert code to initialize the servlet here

}
/**
 * Process incoming requests for information
 * 
 * @param request Object that encapsulates the request to the servlet 
 * @param response Object that encapsulates the response from the servlet
 */
public void performTask(javax.servlet.http.HttpServletRequest request, javax.servlet.http.HttpServletResponse response) {

       	String sCodigo;
       	String sCia;
       	String sDireccion;
       	String sTelefono;
       	String sPoliza;
       	String sModalidad;
       	String accion;
       	String sql = "";
		java.sql.Connection conn=null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		boolean finalizado = false;
       try

	{

		HttpSession session = request.getSession(true);

        m05bSeguro seguro = (m05bSeguro)session.getAttribute("m05bSeguro");
		sCodigo = request.getParameter("Codigo");
		seguro.setSeg_codigo(sCodigo);
		sCia=request.getParameter("Cia").toUpperCase();
		seguro.setSeg_cia(sCia);
		sDireccion=request.getParameter("Direccion").toUpperCase();
		seguro.setSeg_cia(sDireccion);
		sTelefono=request.getParameter("Telefono").toUpperCase();
		seguro.setSeg_telefono(sTelefono);
		sPoliza=request.getParameter("Poliza").toUpperCase();
		seguro.setSeg_poliza(sPoliza);
		sModalidad=request.getParameter("Modalidad").toUpperCase();
		seguro.setSeg_modalidad(sModalidad);

		accion=request.getParameter("Accion");
                
		try{
			m05bConexion miConex = new m05bConexion();
			conn = miConex.getConnection();
			if (accion.equals(m05bConstantes.ACC_ACTUALIZAR))  {
			
			       pstmt = conn.prepareStatement("update	M0528T00 " + 
					"set	CIA_28 = ? " + 
					" ,	DIREC_28 = ? " + 
					" ,	TELEF_28 = ? " +
					" ,	POLIZA_28 = ? " + 
					" ,	MODAL_28 = ? " +
					"where	COD_SEG_28 = ?");
				pstmt.setString(1, sCia);
				pstmt.setString(2, sDireccion);
				pstmt.setString(3, sTelefono);
				pstmt.setString(4, sPoliza);
				pstmt.setString(5, sModalidad);
				pstmt.setString(6, sCodigo);
					
			       
			}
			else if (accion.equals(m05bConstantes.ACC_INSERTAR))  {
			// Chequear si ya existe un seguro con ese codigo
			   sql = "select 1  from M0528T00 where COD_SEG_28 = " + sCodigo ;
		       pstmt = conn.prepareStatement(sql);
			   rs = pstmt.executeQuery();
			   if (rs.next() == true){ 		
       	    			response.sendRedirect("m05bSegurosJsp.jsp?Codigo=" + sCodigo + "&Mensaje=Existe");
       	    			finalizado = true;
			   } 
			   else {
					pstmt = conn.prepareStatement(
						"insert into	M0528T00 " + 
						"(COD_SEG_28, CIA_28, DIREC_28,TELEF_28,POLIZA_28,MODAL_28) " +
						" values " + 
						"(? ,?, ?, ? ,?, ? )" );
					pstmt.setString(1, sCodigo);
					pstmt.setString(2, sCia);
					pstmt.setString(3, sDireccion);
					pstmt.setString(4, sTelefono);
					pstmt.setString(5, sPoliza);
					pstmt.setString(6, sModalidad);
				}
			}
			else   {
			        
				pstmt = conn.prepareStatement(
					"delete from 	M0528T00 " + 
					" where COD_SEG_28 =  ? " );
				pstmt.setString(1, sCodigo);
				
			}
			if(!finalizado){
				pstmt.executeUpdate();
				conn.commit();
				response.sendRedirect("m05bRelSegurosJsp.jsp");
			}
		} 	catch (Exception SQLException) {
					miLog.addTraza(SQLException);
					response.sendRedirect("m05bError.jsp");
		} 	finally{
				if (rs != null)
					rs.close();
				if (pstmt != null)
					pstmt.close();
				if (conn != null)
					conn.close();
		}


	}
	catch(Throwable theException)
	{
		// uncomment the following line when unexpected exceptions
		// are occuring to aid in debugging the problem.
		miLog.addTraza(theException);
		try {
			response.sendRedirect("m05bError.jsp");
		} catch (IOException e) {
			// TODO Auto-generated catch block
			miLog.addTraza(e);
		}
	}
}
}
