package sancionesServlet;

import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

import javax.naming.InitialContext;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.http.HttpSession;

import m05bBD.m05bSanciones;
import m05bClasses.m05bConexion;
import m05bClasses.m05bFileLog;
import m05bSancionesEJB.m05Sanciones;
import m05bSancionesEJB.m05SancionesHome;
import m05bSancionesEJB.m05SancionesPK;

public class m05bGenerarSancionesServlet extends javax.servlet.http.HttpServlet{
	m05bFileLog miLog = new m05bFileLog();

/**
 * Process incoming HTTP GET requests
 *
 * @param request Object that encapsulates the request to the servlet
 * @param response Object that encapsulates the response from the servlet
 */
public void doPost(javax.servlet.http.HttpServletRequest request, javax.servlet.http.HttpServletResponse response) throws javax.servlet.ServletException, java.io.IOException {

	performTask(request, response);

}
/**
 * Returns the servlet info string.
 */
public String getServletInfo() {

	return super.getServletInfo();

}
/**
 * Initializes the servlet.
 */
public void init() {
	// insert code to initialize the servlet here

}
/**
 * Process incoming requests for information
 *
 * @param request Object that encapsulates the request to the servlet
 * @param response Object that encapsulates the response from the servlet
 */
public void performTask(javax.servlet.http.HttpServletRequest request, javax.servlet.http.HttpServletResponse response) {

	try

	{
		// Insert user code from here.

		String codigo;
		String sURL = "";
		String msg;
		HttpSession session = request.getSession(true);

		codigo = new String(request.getParameter("Codigo"));
		try{
			m05SancionesPK primaryKey = new m05SancionesPK();
			primaryKey.san_codigo = codigo;
			InitialContext ctx2 = new InitialContext();
			m05SancionesHome sancionesEBHome = (m05SancionesHome) ctx2.lookup("m05Sanciones");
			m05Sanciones sancionesEB = sancionesEBHome.findByPrimaryKey(primaryKey);
			m05bSanciones sanciones = sancionesEB.getSanciones();
			
			if(sanciones.getSan_codorg()!=null 
					&& !sanciones.getSan_codorg().trim().equals("") ){
				String descripcion = "";
				String edescripcion = "";
				
				String sql = "";
				java.sql.Connection conn=null;
				PreparedStatement pstmt = null;
				ResultSet rs = null;
				
				try{
					m05bConexion miConex = new m05bConexion();
					conn = miConex.getConnection();
					pstmt = conn.prepareStatement(
							"SELECT	DESCRIP_48, E_DESCRIP_48 FROM M0548T00 " + 
							"WHERE	COD_ORG_48 = ?");
					pstmt.setString(1, sanciones.getSan_codorg());
					rs=pstmt.executeQuery();
					if(rs.next()){
						descripcion = rs.getString(1);
						edescripcion = rs.getString(2);
					}
				}catch(Exception e){
					miLog.addTraza(e);
					if(rs!=null)
						rs.close();
					if(pstmt!=null)
						pstmt.close();
					if(conn!=null)
						conn.close();
				}finally{
					if(rs!=null)
						rs.close();
					if(pstmt!=null)
						pstmt.close();
					if(conn!=null)
						conn.close();
				}
				sanciones.setSan_descripcioncorg(descripcion);
				sanciones.setSan_edescripcioncorg(edescripcion);
			}
			session.setAttribute("m05bSanciones", sanciones);

	    	sURL = response.encodeRedirectURL("m05bSancionesJsp.jsp?Codigo=" + codigo + "&Mensaje=false");

			RequestDispatcher rd;
		    rd = request.getRequestDispatcher(sURL);

		    try{
		      rd.forward(request, response);
	    	}
		    catch (ServletException e){
		    	response.sendRedirect("m05bError.jsp");
		    }
		} catch (Exception SQLException) {
			miLog.addTraza(SQLException);
			response.sendRedirect("m05bError.jsp");
		}

	}
	catch(Throwable theException)
	{
		try {
			// uncomment the following line when unexpected exceptions
			// are occuring to aid in debugging the problem.
			//miLog.addTraza(theException);
			response.sendRedirect("m05bError.jsp");
		} catch (IOException e) {
			// TODO Auto-generated catch block
			miLog.addTraza(e);
		}
	}
}
}
