package revisionesServlet;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Locale;
import java.util.ResourceBundle;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import m05bClasses.m05bComun;
import m05bClasses.m05bConexion;
import m05bClasses.m05bConstantes;
import m05bClasses.m05bFileLog;

import org.apache.fop.apps.Driver;
import org.apache.fop.apps.FOPException;
import org.xml.sax.InputSource;

public class m05bImpRevisionesVehiculosServlet extends
		javax.servlet.http.HttpServlet {
	java.sql.Connection conn = null;
	String sLinea;
	String sFoFileDir = "/datos/m05b/tmp/";
	File foFileDir;
	File tmpFoFile;
	FileOutputStream tmpFoFileStream;
	m05bComun miComun = new m05bComun();
	m05bFileLog miLog = new m05bFileLog();
	String sFecDesde = "";
	String sFecHasta = "";

	public static final String FO_REQUEST_PARAM = "fo";

	// Logger log = null;

	public void doPost(javax.servlet.http.HttpServletRequest request,
			javax.servlet.http.HttpServletResponse response)
			throws javax.servlet.ServletException, java.io.IOException {
		try {
			doGet(request, response);
		} catch (Exception e) {
			miLog.addTraza(e);
		}
	}

	public void doGet(HttpServletRequest request, HttpServletResponse response)
			throws ServletException {
		performTask(request, response);
	}

	// if(log == null)
	// {
	// Hierarchy hierarchy = Hierarchy.getDefaultHierarchy();
	// log = hierarchy.getLoggerFor("fop");
	// log.setPriority(Priority.WARN);
	// }
	private void fncAbrirFicheroTemporal() throws java.io.IOException {
		foFileDir = new File(sFoFileDir);
		tmpFoFile = File.createTempFile("m05b", "Fo", foFileDir);
		tmpFoFileStream = new FileOutputStream(tmpFoFile);

	}

	private void fncImprimirFinPagina() throws java.io.IOException {
		sLinea = "	    </fo:table-body>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "       </fo:table>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "      </fo:flow>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "   </fo:page-sequence>\n";
		tmpFoFileStream.write(sLinea.getBytes());

	}

	private void fncImprimirComienzoPagina(ResourceBundle res, String idioma) throws java.io.IOException,
			javax.naming.NamingException {
		sLinea = "<fo:page-sequence master-reference=\"general\">\n";
		tmpFoFileStream.write(sLinea.getBytes());

		// REGION BEFORE
		sLinea = "		<fo:static-content flow-name=\"xsl-region-before\" >\n";
		tmpFoFileStream.write(sLinea.getBytes());
		// -------------- CABECERA DEL LISTADO --------------
		// Cabecera 1
		sLinea = "      <fo:block text-align=\"end\">\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "      </fo:block>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "      <fo:block font-weight=\"bold\" padding-top=\"10pt\">\n "
				+ res.getString("infRevVeh.titulo") + "</fo:block>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		if (sFecDesde != "") {
			sLinea = "      <fo:block font-weight=\"bold\" padding-top=\"5pt\">\n <![CDATA["
					+ res.getString("infRevVeh.texto1")
					+ sFecDesde
					+ res.getString("infRevVeh.texto2")
					+ sFecHasta + "]]></fo:block>\n";
			tmpFoFileStream.write(sLinea.getBytes());
		}

		sLinea = " 		</fo:static-content>\n";
		tmpFoFileStream.write(sLinea.getBytes());

		// PIE DE PAGINA Pie
		sLinea = "		<fo:static-content flow-name=\"xsl-region-after\">\n";
		tmpFoFileStream.write(sLinea.getBytes());
		// PIE DE PAGINA Pie
		sLinea = "      <fo:block >\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "       <fo:table>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    <fo:table-column column-width=\"80mm\"/>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    <fo:table-column column-width=\"80mm\"/>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    <fo:table-body font-family=\"Helvetica\" font-size=\"6pt\">\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    <fo:table-row>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    <fo:table-cell >\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "      <fo:block text-align=\"left\">"
				+ miComun.getDetFechaActual(idioma)
				+ "</fo:block>";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    </fo:table-cell>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    <fo:table-cell >\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "      <fo:block text-align=\"right\">";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = res.getString("pagina")+" <fo:page-number/> \n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "</fo:block>";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    </fo:table-cell>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    </fo:table-row>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    </fo:table-body>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "       </fo:table>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "      </fo:block>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = " 		</fo:static-content>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		// BODY
		sLinea = "	<fo:flow flow-name=\"xsl-region-body\">\n";
		tmpFoFileStream.write(sLinea.getBytes());
		Context ctx = new InitialContext(System.getProperties());
		// -------------- DETALLE DEL LISTADO --------------
		sLinea = "        <fo:table space-after.optimum=\"12pt\">\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    <fo:table-column column-width=\"20mm\"/>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    <fo:table-column column-width=\"20mm\"/>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    <fo:table-column column-width=\"30mm\"/>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    <fo:table-column column-width=\"90mm\"/>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    <fo:table-header font-family=\"Helvetica\" font-size=\"10pt\" >\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    <fo:table-row>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		// Matricula.
		sLinea = "	    <fo:table-cell  padding-top=\"2mm\">\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "      <fo:block font-weight=\"bold\" text-align=\"center\">\n "+res.getString("infRevVeh.col1")
				+ "</fo:block>";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    </fo:table-cell>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		// Kilometros
		sLinea = "	    <fo:table-cell padding-top=\"2mm\">\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "      <fo:block font-weight=\"bold\"  text-align=\"center\">\n "+res.getString("infRevVeh.col2")+"</fo:block>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    </fo:table-cell>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		// Fec. Revision
		sLinea = "	    <fo:table-cell padding-top=\"2mm\">\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "      <fo:block font-weight=\"bold\"  text-align=\"center\">\n "+res.getString("infRevVeh.col3")+"</fo:block>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    </fo:table-cell>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		// Descripcion
		sLinea = "	    <fo:table-cell  padding-top=\"2mm\">\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "      <fo:block font-weight=\"bold\"  text-align=\"center\">\n "+res.getString("infRevVeh.col4")+"</fo:block>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    </fo:table-cell>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    </fo:table-row>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		// /DETALLE
		sLinea = "	    </fo:table-header>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    <fo:table-body font-family=\"Helvetica\" font-size=\"8pt\">\n";
		tmpFoFileStream.write(sLinea.getBytes());

	}

	// Agurtzane Mar12: contador en listados
	private void imprimirTotal(int intCont,ResourceBundle res) throws java.io.IOException,
			javax.naming.NamingException {
		sLinea = "	    <fo:table-row>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		// vacas
		for (int i = 0; i < 3; i++) {
			sLinea = "	    <fo:table-cell>\n<fo:block>\n</fo:block>\n</fo:table-cell>\n";
			tmpFoFileStream.write(sLinea.getBytes());
		}
		// Contador
		sLinea = "	    <fo:table-cell>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "      <fo:block font-weight=\"bold\" text-align=\"right\"  padding-top=\"26pt\">\n<![CDATA[ "
				+ res.getString("infGastoAnual.col14")+ intCont + "]]></fo:block>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    </fo:table-cell>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    </fo:table-row>\n";
		tmpFoFileStream.write(sLinea.getBytes());
	}

	// Fin Agurtzane Mar12: contador en listados
	public void performTask(javax.servlet.http.HttpServletRequest request,
			javax.servlet.http.HttpServletResponse response)
			throws ServletException {
		java.sql.Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		double dNumero = 0.0;
		try {
			HttpSession session = request.getSession(true);
			ResourceBundle res = (ResourceBundle) session
					.getAttribute("resTit");
			/* Iker. idioma */
			Locale idiomaLocal = (Locale) session.getAttribute("Local");
			String idiomaSes = ((idiomaLocal.getLanguage() == null) ? "es"
					: idiomaLocal.getLanguage());

			String campoTexto = "";
			String campoTexto2 = "";
			String campoTexto3 = "C";
			String formatoFecha="dd/MM/yyyy";
			if (!idiomaSes.equals("es")) {
				campoTexto = "E";
				campoTexto2 = "E_";
				campoTexto3 = "E";
				formatoFecha = "yyyy/MM/dd";
			}
			m05bConexion miConex = new m05bConexion();
			conn = miConex.getConnection();
			m05bComun miComun = new m05bComun();
			// Obtencin de informacin de BD
			// Vehculo
			sFecDesde = request.getParameter("FecDesde");
			if (sFecDesde == null) {
				sFecDesde = "";
			}
			sFecHasta = request.getParameter("FecHasta");
			if (sFecHasta == null) {
				sFecHasta = "";
			}
			String matricula = "";
			String sMatricula = "";
			String sKilometros = "";
			String sFecha = "";
			String sDescripcion = "";
			String sMatriculaAnt = "";

			String sSentencia = " SELECT " + m05bConstantes.COL_35_MATRICULA
					+ ",TO_CHAR(" + m05bConstantes.COL_35_FECHA
					+ ",'"+formatoFecha+"')," + m05bConstantes.COL_35_KMRE + ","
					+ m05bConstantes.COL_35_DESC + " FROM "
					+ m05bConstantes.TAB_REVISIONES + " WHERE "
					+ m05bConstantes.COL_35_FECHA + ">= TO_DATE('" + sFecDesde
					+ "','"+formatoFecha+"')AND " + m05bConstantes.COL_35_FECHA
					+ "<= TO_DATE('" + sFecHasta + "','"+formatoFecha+"') "
					+ " ORDER BY " + m05bConstantes.COL_35_MATRICULA + ","
					+ m05bConstantes.COL_35_FECHA;

			pstmt = conn.prepareStatement(sSentencia);
			rs = pstmt.executeQuery();

			fncAbrirFicheroTemporal();

			sLinea = "<?xml version=\"1.0\" encoding=\"windows-1252\"?>\n";
			tmpFoFileStream.write(sLinea.getBytes());

			sLinea = "<fo:root xmlns:fo=\"http://www.w3.org/1999/XSL/Format\">\n";
			tmpFoFileStream.write(sLinea.getBytes());
			// LAYOUT DEL LISTADO
			sLinea = "<fo:layout-master-set>\n";
			tmpFoFileStream.write(sLinea.getBytes());
			sLinea = "	<fo:simple-page-master master-name=\"general\"  page-height=\"29.5cm\" page-width=\"21cm\" margin-top=\"2.5cm\" margin-bottom=\"2.5cm\" margin-left=\"2cm\" margin-right=\"2cm\">\n";
			tmpFoFileStream.write(sLinea.getBytes());
			sLinea = "		<fo:region-before extent=\"2cm\"/>\n";
			tmpFoFileStream.write(sLinea.getBytes());
			sLinea = "		<fo:region-body  margin-top=\"2.8cm\" margin-bottom=\"1.5cm\" />\n";
			tmpFoFileStream.write(sLinea.getBytes());
			sLinea = "		<fo:region-after  extent=\"1cm\"/>\n";
			tmpFoFileStream.write(sLinea.getBytes());
			sLinea = "		<fo:region-start extent=\"0cm\"/>\n";
			tmpFoFileStream.write(sLinea.getBytes());
			sLinea = "		<fo:region-end extent=\"0cm\"/>\n";
			tmpFoFileStream.write(sLinea.getBytes());

			sLinea = "	</fo:simple-page-master>\n";
			tmpFoFileStream.write(sLinea.getBytes());

			sLinea = "</fo:layout-master-set>\n";
			tmpFoFileStream.write(sLinea.getBytes());
			fncImprimirComienzoPagina(res,campoTexto3);

			// REGION BEFORE

			int cont = 0;
			String dNumeroS = "";
			int intCont = 0; // Agurtzane Mar12: contador en listados
			while (rs.next()) {

				intCont++; // Agurtzane Mar12: contador en listados
				sMatricula = rs.getString(1) == null ? "" : rs.getString(1);
				sFecha = rs.getString(2) == null ? "" : rs.getString(2);
				sDescripcion = rs.getString(4) == null ? "" : rs.getString(4);
				sKilometros = rs.getString(3) == null ? "" : rs.getString(3);
				dNumeroS = (rs.getString(3) == null) ? "0" : rs.getString(3);
				sKilometros = miComun.formatearDblMiles(new Double(dNumeroS)
						.doubleValue());
				sKilometros = sKilometros.replaceAll(",", ".");
				sLinea = "	    <fo:table-row >\n";
				tmpFoFileStream.write(sLinea.getBytes());
				sMatriculaAnt = sMatricula;
				// Matricula
				sLinea = "	    <fo:table-cell padding-top=\"0.4mm\" border-width=\"0.1mm\" border-style=\"solid\"  >\n";
				tmpFoFileStream.write(sLinea.getBytes());
				sLinea = "      <fo:block  text-align=\"center\">\n<![CDATA[ "
						+ sMatricula + "]]></fo:block>";
				tmpFoFileStream.write(sLinea.getBytes());
				sLinea = "	    </fo:table-cell>\n";
				tmpFoFileStream.write(sLinea.getBytes());
				// Kilometros
				sLinea = "	    <fo:table-cell padding-top=\"0.4mm\" border-width=\"0.1mm\" border-style=\"solid\" >\n";
				tmpFoFileStream.write(sLinea.getBytes());
				sLinea = "      <fo:block  text-align=\"center\">\n<![CDATA["
						+ sKilometros + "]]></fo:block>\n";
				tmpFoFileStream.write(sLinea.getBytes());
				sLinea = "	    </fo:table-cell>\n";
				tmpFoFileStream.write(sLinea.getBytes());
				// Fecha
				sLinea = "	    <fo:table-cell padding-top=\"0.4mm\" border-width=\"0.1mm\" border-style=\"solid\" >\n";
				tmpFoFileStream.write(sLinea.getBytes());
				sLinea = "      <fo:block  text-align=\"center\">\n<![CDATA[" + sFecha
						+ "]]></fo:block>\n";
				tmpFoFileStream.write(sLinea.getBytes());
				sLinea = "	    </fo:table-cell>\n";
				tmpFoFileStream.write(sLinea.getBytes());
				// Descripcion
				sLinea = "	    <fo:table-cell padding-top=\"0.4mm\" border-width=\"0.1mm\" border-style=\"solid\" >\n";
				tmpFoFileStream.write(sLinea.getBytes());
				sLinea = "      <fo:block  text-align=\"center\">\n<![CDATA["
						+ sDescripcion + "]]></fo:block>\n";
				tmpFoFileStream.write(sLinea.getBytes());
				sLinea = "	    </fo:table-cell>\n";
				tmpFoFileStream.write(sLinea.getBytes());
				sLinea = "	    </fo:table-row>\n";
				tmpFoFileStream.write(sLinea.getBytes());
			}
			imprimirTotal(intCont,res); // Agurtzane Mar12: contador en listados
			fncImprimirFinPagina();

			rs.close();
			sLinea = "</fo:root>\n";
			tmpFoFileStream.write(sLinea.getBytes());

			tmpFoFileStream.close();
			// renderFO(new InputSource(file), response);
			generarPDFdesdeFO(sFoFileDir + tmpFoFile.getName(), sFoFileDir,
					response);

			// tmpFoFile.delete();

			// response.flushBuffer();

		} catch (Exception ex) {
			try {
				response.sendRedirect("m05bError.jsp");
			} catch (IOException e) {
				// TODO Auto-generated catch block
				miLog.addTraza(e);
			}
		} finally {
			try {
				if (rs != null)
					rs.close();
				if (pstmt != null)
					pstmt.close();
				if (conn != null)
					conn.close();
			} catch (SQLException e2) {
				try {
					response.sendRedirect("m05bError.jsp");
				} catch (IOException e) {
					// TODO Auto-generated catch block
					miLog.addTraza(e);
				}
			}
		}
	}

	/**
	 * renders an FO inputsource into a PDF file which is rendered directly to
	 * the response object's OutputStream
	 */
	public void renderFO(InputSource foFile, HttpServletResponse response)
			throws ServletException {
		try {
			ByteArrayOutputStream out = new ByteArrayOutputStream();

			response.reset();
			OutputStream oOut = response.getOutputStream();
			BufferedOutputStream bOut = new BufferedOutputStream(oOut);
			Driver driver = new Driver(foFile, out);
			driver.setRenderer(Driver.RENDER_PDF);
			driver.run();

			response.setContentLength(out.size());
			response.setContentType("application/pdf");

			bOut.write(out.toByteArray());
			out.close();
			bOut.flush();
			bOut.close();
			// response.flushBuffer();
		} catch (Exception ex) {
			throw new ServletException(ex);
		}
	}

	public void generarPDFdesdeFO(String ficheroFO, String rutaPDF,
			HttpServletResponse response) throws FOPException {
		try {

			Driver driver = new Driver();

			driver.setRenderer(Driver.RENDER_PDF);

			// Si no existe el directrio lo crea
			File f = new File(rutaPDF);

			if (!f.exists()) {

				f.mkdir();

			}
			// Cargar los datos del .FO
			FileInputStream file = new FileInputStream(ficheroFO);

			BufferedInputStream bfile = new BufferedInputStream(file);

			driver.setInputSource(new InputSource(bfile));

			// Crear un temporal que va a ser el .pdf
			String sPdfFileDir = rutaPDF;
			File pdfFileDir = new File(sPdfFileDir);
			File tmpPdfFile = File.createTempFile("m05b", ".pdf", pdfFileDir);

			FileOutputStream fileout = new FileOutputStream(tmpPdfFile);

			BufferedOutputStream bfileout = new BufferedOutputStream(fileout);

			driver.setOutputStream(bfileout);

			driver.run();

			bfile.close();

			bfileout.close();
			// Longitus del Fichero PDF.
			Long longitud = new Long(tmpPdfFile.length());
			String sLongitud = "" + longitud;
			int iLongitud = Integer.parseInt(sLongitud);

			response.setContentLength((int) iLongitud);
			response.setContentType("application/pdf");

			byte[] fileBytes = new byte[longitud.intValue()];
			FileInputStream fisficheroPdf = new FileInputStream(tmpPdfFile);
			fisficheroPdf.read(fileBytes);
			ServletOutputStream os = response.getOutputStream();
			((OutputStream) os).write(fileBytes);
			((OutputStream) os).flush();
			((OutputStream) os).close();

			// BORRAR EL FICHERO FO

			File fichero = new File(ficheroFO);

			boolean borrado = fichero.delete();
			boolean borrado2 = tmpPdfFile.delete();

		} catch (Exception e) {

			// System.err.println("EXCEPCION !!! : Error pasando de FO a PDF: "
			// + e);

		}

	}

}