package revisionesServlet;

import java.io.IOException;
import java.sql.PreparedStatement;
import java.util.Locale;

import javax.servlet.http.HttpSession;

import m05bBD.m05bRevisiones;
import m05bClasses.m05bComun;
import m05bClasses.m05bConexion;
import m05bClasses.m05bConstantes;
import m05bClasses.m05bFileLog;

public class m05bGrabarRevisionesServlet extends javax.servlet.http.HttpServlet{
	m05bFileLog miLog = new m05bFileLog();
/**
 * Process incoming HTTP POST requests
 *
 * @param request Object that encapsulates the request to the servlet
 * @param response Object that encapsulates the response from the servlet
 */
public void doPost(javax.servlet.http.HttpServletRequest request, javax.servlet.http.HttpServletResponse response) throws javax.servlet.ServletException, java.io.IOException {

	performTask(request, response);

}
/**
 * Returns the servlet info string.
 */
public String getServletInfo() {

	return super.getServletInfo();

}
/**
 * Initializes the servlet.
 */
public void init() {
	// insert code to initialize the servlet here

}
/**
 * Process incoming requests for information
 *
 * @param request Object that encapsulates the request to the servlet
 * @param response Object that encapsulates the response from the servlet
 */

public void performTask(javax.servlet.http.HttpServletRequest request, javax.servlet.http.HttpServletResponse response) {


       String sMatricula, sFecInspec, sFecProx, sFecRep, sEstado, sAnomalia, sCodigo, sResultado;
       String accion, sql;
       String forFecha="YYYYMMDDHH24MISS";
       java.sql.Connection conn=null;
       PreparedStatement pstmt = null;
       
       try

		{
		HttpSession session = request.getSession(true);
	 	Locale idiomaLocal = (Locale)session.getAttribute("Local");
		String idiomaSes = ((idiomaLocal.getLanguage()==null)?"es":idiomaLocal.getLanguage());	
	
        String campoTexto="C";
        String formatoFecha="dd/MM/yyyy";
        if(!idiomaSes.equals("es")){
			campoTexto="E";
			formatoFecha="yyyy/MM/dd";
        }
        m05bRevisiones revisiones = (m05bRevisiones)session.getAttribute("m05bRevisiones");
        m05bComun comun = new m05bComun();

        sCodigo = request.getParameter("Codigo");
        revisiones.setRev_codigo(sCodigo);
		sMatricula = request.getParameter("Matricula");
		revisiones.setRev_matricula(sMatricula);
		sFecInspec=request.getParameter("FecInspec");

        if ( (sFecInspec==null) || sFecInspec.equals("") )
            sFecInspec="";
        else
            sFecInspec= comun.FechaBD(sFecInspec,"00:00",campoTexto);
        revisiones.setRev_fecinspec(sFecInspec);
        sEstado = request.getParameter("Estado");
        if ( (sEstado==null) || sEstado.equals("") )
          	sEstado="";
        else 
        	sEstado = sEstado.toUpperCase();
        revisiones.setRev_estado(sEstado);
        sResultado=request.getParameter("Resultado");
        if ( (sResultado==null) || sResultado.equals("") )
            sResultado="";
        else
        	sResultado=sResultado.toUpperCase();
        revisiones.setRev_estado(sResultado);
        
        sAnomalia=request.getParameter("Anomalia");
        if ( (sAnomalia==null) || sAnomalia.equals("") )
            sAnomalia="";
        else
        	sAnomalia=sAnomalia.toUpperCase();
        revisiones.setRev_anomalia(sAnomalia);

        sFecProx=request.getParameter("FecProxInspec");
        if ( (sFecProx==null) || sFecProx.equals("") )
            sFecProx="";
        else
            sFecProx= comun.FechaBD(sFecProx,"00:00",campoTexto);
        revisiones.setRev_fecprox(sFecProx);

        sFecRep=request.getParameter("FecRepInspec");
        if ( (sFecRep==null) || sFecRep.equals("") )
            sFecRep="";
        else
            sFecRep= comun.FechaBD(sFecRep,"00:00",campoTexto);
        revisiones.setRev_fecrep(sFecRep);

		accion=request.getParameter("Accion");

		try{
			m05bConexion miConex = new m05bConexion();
			conn = miConex.getConnection();
			if (accion.equals(m05bConstantes.ACC_ACTUALIZAR))  {
					sql = "update " + m05bConstantes.TAB_ITV +
						" set " + m05bConstantes.COL_27_ANOMALIA + " = '" + sAnomalia  +
	                    "', " + m05bConstantes.COL_27_FPRXINSPEC + " = TO_DATE ('" + sFecProx + "','" + forFecha + "')" +
	                    ", " + m05bConstantes.COL_27_FREPINSP + " = TO_DATE ('" + sFecRep + "','" + forFecha + "')" +
	                    ", " + m05bConstantes.COL_27_FINSPEC + " = TO_DATE ('" + sFecInspec + "','" + forFecha + "')" +
	                    ", " + m05bConstantes.COL_27_ESTADO + " = '" + sEstado +
	                    "', " + m05bConstantes.COL_27_RESULTADO + " = '" + sResultado +
						"' where	 " + m05bConstantes.COL_27_CODIGO + " = '" + sCodigo + "'";
					pstmt = conn.prepareStatement(sql);
			} else if (accion.equals(m05bConstantes.ACC_INSERTAR))  {
					sql = "insert into " + m05bConstantes.TAB_ITV +
	 				" (" + m05bConstantes.COL_27_ANOMALIA + "," + m05bConstantes.COL_27_ESTADO +
                    "," + m05bConstantes.COL_27_MATRICULA + "," + m05bConstantes.COL_27_FINSPEC +
                    "," + m05bConstantes.COL_27_FREPINSP + "," + m05bConstantes.COL_27_FPRXINSPEC +
                    "," + m05bConstantes.COL_27_RESULTADO + "," + m05bConstantes.COL_27_CODIGO + ") " +
					" values " +
					"(?,?,? , TO_DATE (?,'" + forFecha + "'), TO_DATE (?,'" + forFecha + "'),TO_DATE (?,'" + forFecha + "'),? ,? )";
	                pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, sAnomalia);
					pstmt.setString(2, sEstado);
	                pstmt.setString(3, sMatricula);
	                pstmt.setString(4, sFecInspec);
					pstmt.setString(5, sFecRep);
	                pstmt.setString(6, sFecProx);
	                pstmt.setString(7, sResultado);
	                pstmt.setString(8, sCodigo);
			} else   {
					pstmt = conn.prepareStatement(
						"delete from  " +m05bConstantes.TAB_ITV+
						" where	"+m05bConstantes.COL_27_CODIGO+" = ?   ");
	                pstmt.setString(1, sCodigo);
			}
			pstmt.executeUpdate();
			response.sendRedirect("m05bVehITVJsp.jsp?Matricula="+sMatricula);
		} 	catch (Exception SQLException) {
				miLog.addTraza(SQLException);
				response.sendRedirect("m05bError.jsp");
		} 	finally{
				if (pstmt != null)
					pstmt.close();
				if (conn != null)
					conn.close();
		}
	}
	catch(Throwable theException)
	{
		miLog.addTraza(theException);
		try {
			response.sendRedirect("m05bError.jsp");
		} catch (IOException e) {
			// TODO Auto-generated catch block
			miLog.addTraza(e);
		}
	}
}
}