package reparacionServlet;

import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import javax.servlet.http.HttpSession;

import m05bBD.m05bReparacion;
import m05bClasses.m05bConexion;
import m05bClasses.m05bConstantes;
import m05bClasses.m05bFileLog;


/**
 * Inserte aqu la descripcin del tipo.
 * Fecha de creacin: (02/03/04)
 */
public class m05bGrabarReparacionServlet extends javax.servlet.http.HttpServlet {m05bFileLog miLog = new m05bFileLog();
/**
 * Process incoming HTTP POST requests
 *
 * @param request Object that encapsulates the request to the servlet
 * @param response Object that encapsulates the response from the servlet
 */
public void doPost(javax.servlet.http.HttpServletRequest request, javax.servlet.http.HttpServletResponse response) throws javax.servlet.ServletException, java.io.IOException {

	performTask(request, response);

}
/**
 * Returns the servlet info string.
 */
public String getServletInfo() {

	return super.getServletInfo();

}
/**
 * Initializes the servlet.
 */
public void init() {
	// insert code to initialize the servlet here

}
/**
 * Process incoming requests for information
 *
 * @param request Object that encapsulates the request to the servlet
 * @param response Object that encapsulates the response from the servlet
 */
public void performTask(javax.servlet.http.HttpServletRequest request, javax.servlet.http.HttpServletResponse response) {

       	String codigo, descripcion, observacion,descripcionEu,observacionEu;
       	String accion, sql = "";
        java.sql.Connection conn=null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        boolean finalizado = false;   
        try   {
            HttpSession session = request.getSession(true);
            m05bReparacion reparacion  = (m05bReparacion)session.getAttribute("m05bReparacion");
            codigo = request.getParameter("Codigo");
            reparacion.setRep_codigo(codigo);
            descripcion=request.getParameter("Descripcion").toUpperCase();
            descripcionEu=request.getParameter("DescripcionEu").toUpperCase();
            reparacion.setRep_descripcion(descripcion);
            observacion=request.getParameter("Observacion").toUpperCase();
            observacionEu=request.getParameter("ObservacionEu").toUpperCase();
            reparacion.setRep_observacion(observacion);
            accion=request.getParameter("Accion");

            try{
                m05bConexion miConex = new m05bConexion();
                conn = miConex.getConnection();
                if (accion.equals(m05bConstantes.ACC_ACTUALIZAR))  {
					sql="update	M0525T00 " +
                        "set	DESCRIP_25 = ? ,OBSERV_25 = ?,EDESCRIP_25 = ? ,EOBSERV_25 = ? where	COD_REP_25 = ?";
					
					pstmt = conn.prepareStatement(sql);
					
					pstmt.setString(1, descripcion);
                    pstmt.setString(2, observacion);
                    pstmt.setString(3, descripcionEu);
                    pstmt.setString(4, observacionEu);
                    pstmt.setString(5, codigo);
					
                } else if (accion.equals(m05bConstantes.ACC_INSERTAR))  {
				// Chequear si ya existe una reparacion con ese cdigo
				   sql = "select 1  from M0525T00 where COD_REP_25 = '" + codigo + "'";
			       pstmt = conn.prepareStatement(sql);
				   rs = pstmt.executeQuery();
				   if (rs.next() == true){ 		
	       	    			response.sendRedirect("m05bReparacionJsp.jsp?Codigo=" + codigo + "&Mensaje=Existe");
	       	    			finalizado = true;
				   } else {
	                    pstmt = conn.prepareStatement(
	                        "insert into	M0525T00 " +
	                        "(COD_REP_25, DESCRIP_25, OBSERV_25, EDESCRIP_25, EOBSERV_25) " +
	                        " values " +
	                        "(? ,?, ?,?,? )" );
	                    
	                    pstmt.setString(1, codigo);
	                    pstmt.setString(2, descripcion);
	                    pstmt.setString(3, observacion);
	                    pstmt.setString(4, descripcionEu);
	                    pstmt.setString(5, observacionEu);
	               }
                } else   {
                    pstmt = conn.prepareStatement(
                        "delete from 	M0525T00 " +
                        " where COD_REP_25 =  ? " );
                    pstmt.setString(1, codigo);
                }
                if(!finalizado){
	                pstmt.executeUpdate();
	                response.sendRedirect("m05bRelReparacionJsp.jsp");
                }
          } 	catch (SQLException ex) {
				miLog.addTraza(ex);
				if (ex.getErrorCode() == m05bConstantes.ERR_INTEGRIDAD)
					response.sendRedirect("m05bReparacionJsp.jsp?Codigo=" + codigo + "&Mensaje=" + m05bConstantes.MSG_INTEGRIDAD);
				else
					response.sendRedirect("m05bError.jsp");
          } 	finally{
				if (rs != null)
					rs.close();
				if (pstmt != null)
					pstmt.close();
				if (conn != null)
					conn.close();
		}
	}
	catch(Throwable theException)
	{
		// uncomment the following line when unexpected exceptions
		// are occuring to aid in debugging the problem.
		miLog.addTraza(theException);
		try {
			response.sendRedirect("m05bError.jsp");
		} catch (IOException e) {
			// TODO Auto-generated catch block
			miLog.addTraza(e);
		}
	}
}
}