package reformasServlet;

import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Locale;

import javax.servlet.http.HttpSession;

import m05bBD.m05bReformas;
import m05bClasses.m05bComun;
import m05bClasses.m05bConexion;
import m05bClasses.m05bConstantes;
import m05bClasses.m05bFileLog;


/**
 * Inserte aqu la descripcin del tipo.
 * Fecha de creacin: (19/05/04)
 */
public class m05bGrabarReformasServlet extends javax.servlet.http.HttpServlet {m05bFileLog miLog = new m05bFileLog();
/**
 * Process incoming HTTP POST requests
 *
 * @param request Object that encapsulates the request to the servlet
 * @param response Object that encapsulates the response from the servlet
 */
public void doPost(javax.servlet.http.HttpServletRequest request, javax.servlet.http.HttpServletResponse response) throws javax.servlet.ServletException, java.io.IOException {

	performTask(request, response);

}
/**
 * Returns the servlet info string.
 */
public String getServletInfo() {

	return super.getServletInfo();

}
/**
 * Initializes the servlet.
 */
public void init() {
	// insert code to initialize the servlet here

}
/**
 * Process incoming requests for information
 *
 * @param request Object that encapsulates the request to the servlet
 * @param response Object that encapsulates the response from the servlet
 */
public void performTask(javax.servlet.http.HttpServletRequest request, javax.servlet.http.HttpServletResponse response) {

       String sCodigo;
       String sFecha;
       String sMatricula;
       String sTipo;
       String sTaller;
       String sMarca;
       String sNumero;
       String sObserv;
       String accion;
       String sql="";
       String sErrorTaller="0";
	   java.sql.Connection conn=null;
	   PreparedStatement pstmt = null;
	   ResultSet rs = null;
	   boolean finalizado = false;
       try{
        HttpSession session = request.getSession(true);
    	Locale idiomaLocal = (Locale)session.getAttribute("Local");
		String idiomaSes = ((idiomaLocal.getLanguage()==null)?"es":idiomaLocal.getLanguage());	
	
        String campoTexto="C";
        String formatoFecha="dd/MM/yyyy";
        if(!idiomaSes.equals("es")){
			campoTexto="E";
			formatoFecha="yyyy/MM/dd";
        }
        m05bComun comun = new m05bComun();
	   m05bFileLog miLog = new m05bFileLog();
        
		m05bReformas reformas = (m05bReformas)session.getAttribute("m05bReformas");
		sCodigo = request.getParameter("Codigo");
		reformas.setRef_codigo(sCodigo);
		sFecha=request.getParameter("Fecha");
    	miLog.addTraza(m05bConstantes.LOG_NO_USER , m05bConstantes.LOG_NO_SRC, "sFecha: " + sFecha, m05bConstantes.LOG_NIVEL_BAJO);
		
        if (sFecha!=null)
        reformas.setRef_fecha(comun.FechaObj(sFecha,"")); 	
        sFecha=comun.FechaBD(sFecha,"00:00",campoTexto);
        sTipo=request.getParameter("Tipo");
        reformas.setRef_tipref(sTipo);
        sNumero=request.getParameter("Numero").toUpperCase();
        reformas.setRef_numero(sNumero);
        sTaller=request.getParameter("CodTaller");
        reformas.setRef_taller(sTaller);
        sMarca=request.getParameter("Marca").toUpperCase();
        reformas.setRef_marca(sMarca);
        sObserv=request.getParameter("Observacion").toUpperCase();
        reformas.setRef_observ(sObserv);
        sMatricula=request.getParameter("Matricula");
        reformas.setRef_observ(sMatricula);
		accion=request.getParameter("Accion");

		try{
			m05bConexion miConex = new m05bConexion();
			conn = miConex.getConnection();
		 if (!(sTaller.equals(""))){			
			 sql = "SELECT 1  FROM "+ m05bConstantes.TAB_TALLER +
		       " WHERE " + m05bConstantes.COL_30_CODIGO+ "='" + sTaller + "'";
		     pstmt = conn.prepareStatement(sql);
		     rs = pstmt.executeQuery();
	         if (!(rs.next())){
	     	    sErrorTaller="1";
	         }
	     }		 
		 if (sErrorTaller.equals("1")){
			response.sendRedirect("m05bReformasJsp.jsp?Matricula="+sMatricula+"&Mensaje="+m05bConstantes.MSG_NOEXISTETALL+"&Accion="+accion+"&Codigo="+sCodigo);
			finalizado = true;
		 }else {			
			if (accion.equals(m05bConstantes.ACC_ACTUALIZAR))  {
			       pstmt = conn.prepareStatement("update " +m05bConstantes.TAB_REFORMAS+
					" set "+m05bConstantes.COL_37_FECHA+" = TO_DATE(?,'YYYYMMDDHH24MISS')" +
                    " , "+m05bConstantes.COL_37_TIPO+" = ? "+
                    " , "+m05bConstantes.COL_37_MARCA+" = ? "+
                    " , "+m05bConstantes.COL_37_NUMERO+" = ? "+
                    " , "+m05bConstantes.COL_37_TALLER+" = ? "+
                    " , "+m05bConstantes.COL_37_OBSERV+" = ? "+
					" where	"+m05bConstantes.COL_37_CODIGO+" = ?");
				pstmt.setString(1, sFecha);
                pstmt.setString(2, sTipo);
                pstmt.setString(3, sMarca);
                pstmt.setString(4, sNumero);
                pstmt.setString(5, sTaller);
                pstmt.setString(6, sObserv);
				pstmt.setString(7, sCodigo);
			}
			else if (accion.equals(m05bConstantes.ACC_INSERTAR))  {
				pstmt = conn.prepareStatement(
					"insert into	 " +m05bConstantes.TAB_REFORMAS+
					"("+m05bConstantes.COL_37_CODIGO+","+m05bConstantes.COL_37_MATRICULA+","+m05bConstantes.COL_37_MARCA+
                     ","+m05bConstantes.COL_37_FECHA+","+m05bConstantes.COL_37_TIPO+","+m05bConstantes.COL_37_NUMERO+
                     ", "+m05bConstantes.COL_37_TALLER+","+m05bConstantes.COL_37_OBSERV+") " +
					" values (?,?,?,TO_DATE(?,'YYYYMMDDHH24MISS'),?,?,?,?)" );
                    pstmt.setString(1, sCodigo); 
                    pstmt.setString(2, sMatricula); 
                    pstmt.setString(3, sMarca);
                    pstmt.setString(4, sFecha);
                    pstmt.setString(5, sTipo);
                    pstmt.setString(6, sNumero);
                    pstmt.setString(7, sTaller);
                    pstmt.setString(8, sObserv);
			}
			else   {

				pstmt = conn.prepareStatement(
					"delete from  " +m05bConstantes.TAB_REFORMAS+
					" where "+m05bConstantes.COL_37_CODIGO+" =  ? " );
				pstmt.setString(1, sCodigo);

			}
			if(!finalizado){
				pstmt.executeUpdate();
				response.sendRedirect("m05bVehReformasJsp.jsp?Matricula="+sMatricula);
			}
		  } 
		}	catch (Exception SQLException) {
				miLog.addTraza(SQLException);
				response.sendRedirect("m05bError.jsp");
		} 	finally{
				if (pstmt != null)
					pstmt.close();
				if (conn != null)
					conn.close();
		}

	}
	catch(Throwable theException)
	{
		// uncomment the following line when unexpected exceptions
		// are occuring to aid in debugging the problem.
		miLog.addTraza(theException);
		try {
			response.sendRedirect("m05bError.jsp");
		} catch (IOException e) {
			// TODO Auto-generated catch block
			miLog.addTraza(e);
		}
	}
}
}