package piezasrepaServlet;


import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.SQLException;

import javax.servlet.http.HttpSession;

import m05bBD.m05bPiezasRepa;
import m05bClasses.m05bCampos;
import m05bClasses.m05bComun;
import m05bClasses.m05bConexion;
import m05bClasses.m05bConstantes;
import m05bClasses.m05bFileLog;

public class m05bGrabarPiezasRepaServlet extends javax.servlet.http.HttpServlet{
	m05bFileLog miLog = new m05bFileLog();
/**
 * Process incoming HTTP POST requests
 *
 * @param request Object that encapsulates the request to the servlet
 * @param response Object that encapsulates the response from the servlet
 */
public void doPost(javax.servlet.http.HttpServletRequest request, javax.servlet.http.HttpServletResponse response) throws javax.servlet.ServletException, java.io.IOException {

	performTask(request, response);

}
/**
 * Returns the servlet info string.
 */
public String getServletInfo() {

	return super.getServletInfo();

}
/**
 * Initializes the servlet.
 */
public void init() {
	// insert code to initialize the servlet here

}

/**
 * Process incoming requests for information
 *
 * @param request Object that encapsulates the request to the servlet
 * @param response Object that encapsulates the response from the servlet
 *
*/

public void performTask(javax.servlet.http.HttpServletRequest request, javax.servlet.http.HttpServletResponse response) {

       String sql="", accion;
       String sCodigo, sNOrden, sPieza, sDescripcion, sTotal, sPrecio, sCantidad, persona;

       java.sql.Connection conn=null;
	   PreparedStatement pstmt = null;
       
       try  {
			HttpSession session = request.getSession(true);
			persona = (String) session.getAttribute("persona");
			m05bComun miComun = new m05bComun();
			m05bFileLog miLog = new m05bFileLog();

	        m05bPiezasRepa piezasrepa = (m05bPiezasRepa)session.getAttribute("m05bPiezasRepa");
			sCodigo = request.getParameter("Codigo");
			miLog.addTraza(persona, "Grabar Piezas Repa", "CODIGO: " +sCodigo, m05bConstantes.LOG_NIVEL_BAJO);
			
			piezasrepa.setPir_codigo(sCodigo);
			sNOrden=request.getParameter("NOrden");
			piezasrepa.setPir_orden(sNOrden);
			sPieza=request.getParameter("Pieza");
	     	piezasrepa.setPir_pieza(sPieza);
	        sDescripcion=request.getParameter("Descripcion")==null?"":request.getParameter("Descripcion").toUpperCase();
	        piezasrepa.setPir_descrip(sDescripcion);
	        sCantidad=request.getParameter("Cantidad");
	        piezasrepa.setPir_cantidad(sCantidad);
	        sTotal=request.getParameter("Total");
			miLog.addTraza("", "", "TOTAL-1: " +sCodigo, m05bConstantes.LOG_NIVEL_BAJO);	        
            sTotal=miComun.ImportesABasedatos(sTotal);
            if ( (sTotal == null) || (sTotal.equals("")) ){
            	sTotal="0";
            }
			miLog.addTraza(persona, "Grabar Piezas Repa", "TOTAL-2: " +sCodigo, m05bConstantes.LOG_NIVEL_BAJO);	             
	        piezasrepa.setPir_total(sTotal);
	        sPrecio=request.getParameter("Precio");
			miLog.addTraza(persona, "Grabar Piezas Repa", "PRECIO-1: " +sPrecio, m05bConstantes.LOG_NIVEL_BAJO);	 	        
            sPrecio=miComun.ImportesABasedatos(sPrecio);
            if ( (sPrecio == null) || (sPrecio.equals("")) ){
            	sPrecio="0";
            }            
			miLog.addTraza(persona, "Grabar Piezas Repa", "PRECIO-2: " +sPrecio, m05bConstantes.LOG_NIVEL_BAJO);            
	        piezasrepa.setPir_preciou(sPrecio);
	        accion=request.getParameter("Accion");

			try{
			   
				    m05bConexion miConex = new m05bConexion();
				    conn = miConex.getConnection();
				    if (accion.equals(m05bConstantes.ACC_ACTUALIZAR))  {
					    sql=" update " +m05bConstantes.TAB_PIEZAREP+
					    		" set "+m05bConstantes.COL_23_CANTIDAD+" = '" + sCantidad+
			                    "', "+m05bConstantes.COL_23_DESCRIP+" = '"+sDescripcion+
			                    "', "+m05bConstantes.COL_23_TOTAL+" = "+sTotal+
			                    ", "+m05bConstantes.COL_23_PRECIO+" = "+sPrecio+
					    		"  where "+m05bConstantes.COL_23_CODIGO+"	 ='"+sCodigo+"' AND "+m05bConstantes.COL_23_ORDEN+
					    		"='"+sNOrden+"'  AND "+m05bConstantes.COL_23_PIE+"='"+sPieza+"'";
			            pstmt = conn.prepareStatement(sql);
					}
					else if (accion.equals(m05bConstantes.ACC_INSERTAR))  {
						sql = "insert into " +m05bConstantes.TAB_PIEZAREP+
							" ("+m05bConstantes.COL_23_ORDEN+","+m05bConstantes.COL_23_CODIGO+","+
		                    m05bConstantes.COL_23_PIE+","+m05bConstantes.COL_23_CANTIDAD+","+
		                    m05bConstantes.COL_23_DESCRIP+","+m05bConstantes.COL_23_TOTAL+","+
		                    m05bConstantes.COL_23_PRECIO+") " +
		                    " values " +"('"+sNOrden+"' ,'"+sCodigo+"','"+sPieza+"','"+sCantidad+
		                    "' ,'"+sDescripcion+"',"+sTotal+","+sPrecio+" )";
						pstmt = conn.prepareStatement(sql); 

					}
					else   {
						sql = "delete from " +m05bConstantes.TAB_PIEZAREP+
							" where "+m05bConstantes.COL_23_CODIGO+" =  ? " +
							" AND "+m05bConstantes.COL_23_ORDEN+" = ? AND "+
							m05bConstantes.COL_23_PIE+" = ?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, sCodigo);
						pstmt.setString(2, sNOrden);
						pstmt.setString(3, sPieza);
					}
			        miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC, "SQL: " +sql, m05bConstantes.LOG_NIVEL_BAJO);				    
					pstmt.executeUpdate();
				    if (sTotal != "")  {
				    	// Llamar a funcion que actualiza importes de reparaciones y OT
				    	m05bCampos miCampo = new m05bCampos();
						miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC,"IMP REP: " +(String) session.getAttribute("OTImpRep"), m05bConstantes.LOG_NIVEL_BAJO);
				    	miCampo.actImporteOT(sNOrden,sCodigo,(String) session.getAttribute("OTImpRep"));
				    }
					response.sendRedirect("m05bVehOrdPiezaJsp.jsp?NOrden="+sNOrden + "&Codigo=" + sCodigo);

			} 	catch (SQLException ex1) {
					miLog.addTraza(ex1);
					if (ex1.getErrorCode() == m05bConstantes.ERR_DUPLICADOS)
							response.sendRedirect("m05bVehOrdPiezaJsp.jsp?NOrden="+sNOrden + "&Codigo=" + sCodigo + "&Mensaje="+ m05bConstantes.MSG_EXISTE);
					else
						response.sendRedirect("m05bError.jsp");
			} 	finally{
					if (pstmt != null)
						pstmt.close();
					if (conn != null)
						conn.close();
			}
	} catch(Throwable theException) {
		miLog.addTraza(theException);
		try {
			response.sendRedirect("m05bError.jsp");
		} catch (IOException e) {
			// TODO Auto-generated catch block
			miLog.addTraza(e);
		}
	}
}

}