package personalServlet;

import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import javax.servlet.http.HttpSession;
import m05bBD.m05bPersonal;
import m05bClasses.m05bConexion;
import m05bClasses.m05bConstantes;
import m05bClasses.m05bFileLog;
import m05bClasses.m05bGenerarClave;
import m05bClasses.m05bUtils;

/**
 * Inserte aqu la descripcin del tipo.
 * Fecha de creacin: (04/03/04)
 */
public class m05bGrabarPersonalServlet extends javax.servlet.http.HttpServlet {

	m05bFileLog miLog = new m05bFileLog();
	
	/**
	 * Process incoming HTTP POST requests 
	 *
	 * @param request Object that encapsulates the request to the servlet
	 * @param response Object that encapsulates the response from the servlet
	 */
	public void doPost(javax.servlet.http.HttpServletRequest request, javax.servlet.http.HttpServletResponse response) throws javax.servlet.ServletException, java.io.IOException {
		performTask(request, response);
	}
	
	/**
	 * Returns the servlet info string.
	 */
	public String getServletInfo() {
		return super.getServletInfo();
	}
	
	/**
	 * Initializes the servlet.
	 */
	public void init() {
		// insert code to initialize the servlet here
	}
	
	/**
	 * Process incoming requests for information
	 *
	 * @param request Object that encapsulates the request to the servlet
	 * @param response Object that encapsulates the response from the servlet
	 */
	public void performTask(javax.servlet.http.HttpServletRequest request, javax.servlet.http.HttpServletResponse response) {
		String sDni, sNombre, sDirec, sTelef, sCargo, sRango, sActGIP, sDpto, sTipoPer,sProvincia,sMunicipio,sCodPostal;
		String sCodDptoAnt, accion, sIDHist="";
		String sql = "";
		java.sql.Connection conn=null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		m05bGenerarClave miIdHist = new m05bGenerarClave();
		m05bFileLog miLog = new m05bFileLog();
	
		try {
			HttpSession session = request.getSession(true);
	
	       	m05bPersonal personal = (m05bPersonal)session.getAttribute("m05bPersonal");
	       	String persona = (String) session.getAttribute("persona");
	
			sDni = request.getParameter("Codigo");
			miLog.addTraza(persona,"Grabar Persona","DNI: " + sDni, m05bConstantes.LOG_NIVEL_BAJO);
			personal.setPer_dni(sDni);
			sNombre=request.getParameter("Nombre").toUpperCase();
			personal.setPer_nombre(sNombre);
			sDirec=request.getParameter("Direccion").toUpperCase();
			personal.setPer_direc(sDirec);
			sTelef=request.getParameter("Telefono");
			personal.setPer_telef(sTelef);
			sCargo=request.getParameter("Cargo").toUpperCase();
			personal.setPer_cod_car(sCargo);
			sDpto=request.getParameter("Departamento").toUpperCase();
			personal.setPer_coddpto(sDpto);
			sRango=request.getParameter("Rango").toUpperCase();
			personal.setPer_cod_car(sRango);
			sProvincia = request.getParameter("Provincia")==null?"":request.getParameter("Provincia");
			personal.setPer_codprovincia(sProvincia);
			sMunicipio = request.getParameter("Municipio")==null?"":request.getParameter("Municipio");
			personal.setPer_codmunicipio(sMunicipio);
			sCodPostal = request.getParameter("CodPostal")==null?"":request.getParameter("CodPostal");
			personal.setPer_codpostal(sCodPostal);
	
			sActGIP=request.getParameter("Actualizable");
			if (sActGIP == null)
				sActGIP = "N";
			sTipoPer=request.getParameter("TipoPer");
			if (sTipoPer == null)
				sTipoPer = "N";
			accion=request.getParameter("Accion");
			sCodDptoAnt=request.getParameter("CodDptoAnt");
			boolean finalizado = false;
	
			try {
				m05bConexion miConex = new m05bConexion();
				conn = miConex.getConnection();
				if (accion.equals(m05bConstantes.ACC_ACTUALIZAR)) {
					if ( !(sCodDptoAnt.equals(sDpto)) ) {
						// Inserta el registro historico si ha cambiado el departamento
						sIDHist = "" + miIdHist.getNextId(m05bConstantes.TAB_HIST_PERSONAL, m05bConstantes.COL_12_ID);
						sql = "insert into	M0512T00 " +
							"(COD_PERH_12, DNI_12, NOMBRE_12, DIREC_12,TELEF_12,CODCARGO_12,CODRANGO_P_12,CODDPTO_12,FCAMBIO_12,ACT_GIP_12,CODPROVINCIA_12,CODMUNICIPIO_12,CODPOSTAL_12) " +
							" values " +
							"(" + sIDHist + ", '" + sDni + "', '" + sNombre + "', '" + sDirec + "', '" + sTelef + "', '" + sCargo +
							"', '" + sRango + "', '" + sCodDptoAnt + "', sysdate, '" + sActGIP + "', '" + sProvincia + "', '" + sMunicipio + "', '" + sCodPostal +  "'  )";
						pstmt = conn.prepareStatement(sql);
						pstmt.executeUpdate();
					}
	
					// Actualiza el registro actual de la tabla Personal
					sql = "update	M0521T00 " +
						//Agurtzane Feb12: guardar maysculas
						"set	NOMBRE_21 = '" + sNombre.toUpperCase() + "'" +
						" ,	DIREC_21 = '" + sDirec + "'" +
						" ,	TELEF_21 = '" + sTelef + "'" +
						" ,	CODCARGO_21 = '" + sCargo + "'" +
						" ,	CODRANG_P_21 = '" + sRango + "'" +
						" ,	CODDPTO_21 = '" + sDpto + "'" +
						" ,	ACT_GIP_21 = '" + sActGIP + "'" +
						" ,	TIPO_PER_21 = '" + sTipoPer + "'" +
						" ,	CODPROVINCIA_21 = '" + sProvincia + "'" +
						" ,	CODMUNICIPIO_21 = '" + sMunicipio + "'" +
						" ,	CODPOSTAL_21 = '" + sCodPostal + "'" +
						"where	DNI_21 = '" + sDni + "'";
					pstmt = conn.prepareStatement(sql);
				}
				else if (accion.equals(m05bConstantes.ACC_INSERTAR)) {
					// 20140925 - INIGO
					// Chequear si ya existe una persona con ese dni con o sin letra
					String sDniSinLetra = sDni;
					if (sDni.length() > 0) {
						if (!Character.isDigit(sDni.charAt(sDni.length() - 1))) {
							sDniSinLetra = sDniSinLetra.substring(0, sDni.length() - 1);
						}
					}
					sql = "select 1 from M0521T00 where DNI_21 = '" + sDni + "' or DNI_21 LIKE '" + sDniSinLetra + "%'";
					pstmt = conn.prepareStatement(sql);
					rs = pstmt.executeQuery();
					if (rs.next() == true) {
						response.sendRedirect("m05bPersonalJsp.jsp?Codigo=" + sDni + "&Mensaje=Existe");
						finalizado = true;
					} else {
						sql = "insert into	M0521T00 " +
							"(DNI_21, NOMBRE_21, DIREC_21,TELEF_21,CODCARGO_21,CODRANG_P_21,CODDPTO_21,ACT_GIP_21,TIPO_PER_21,CODPROVINCIA_21,CODMUNICIPIO_21,CODPOSTAL_21) " +
							" values " +
							"(? ,?, ?, ?, ?, ?, ?, ?, ?,?,?,? )";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, m05bUtils.dniConLetra(sDni));
						//Agurtzane Feb12: guardar maysculas
						pstmt.setString(2, sNombre.toUpperCase());
						pstmt.setString(3, sDirec);
						pstmt.setString(4, sTelef);
						pstmt.setString(5, sCargo);
						pstmt.setString(6, sRango);
						pstmt.setString(7, sDpto);
						pstmt.setString(8, sActGIP);
						pstmt.setString(9, sTipoPer);
						pstmt.setString(10, sProvincia);
						pstmt.setString(11, sMunicipio);
						pstmt.setString(12, sCodPostal);
					}
				} else {
					/*	if (sCodDptoAnt != sDpto) {
						// Inserta el registro historico si ha cambiado el departamento
					        sIDHist = "" + miIdHist.getNextId(m05bConstantes.TAB_HIST_PERSONAL, m05bConstantes.COL_12_ID);
					        sql = "insert into	M0512T00 " +
								"(COD_PERH_12, DNI_12, NOMBRE_12, DIREC_12,TELEF_12,CODCARGO_12,CODRANGO_P_12,CODDPTO_12,FCAMBIO_12,ACT_GIP_12) " +
								" values " +
								"(" + sIDHist + ", '" + sDni + "', '" + sNombre + "', '" + sDirec + "', '" + sTelef + "', '" + sCargo +
								"', '" + sRango + "', '" + CodDptoAnt + "', sysdate, '" + sActGIP + "'  )";
							pstmt = conn.prepareStatement( sql );
							pstmt.executeUpdate();
					}*/
					// Actualiza el registro actual de la tabla Personal
					sql = "delete from 	M0521T00 where DNI_21 = ? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, sDni);
				}
	
				if(!finalizado) {
					miLog.addTraza(persona, "Grabar Personas", "SQL: " + sql, m05bConstantes.LOG_NIVEL_BAJO);
					pstmt.executeUpdate();
					//Si todo ha ido bien se actualizan los cambios en la BD
				    conn.commit();
	
				    String vVieneDeSolicitudReserva = request.getParameter("VieneDeSolicitudReserva");
				    if (vVieneDeSolicitudReserva == null || vVieneDeSolicitudReserva.equals("")) {
				    	response.sendRedirect("m05bRelPersonalJsp.jsp?Orden=DPTO");
				    }
				}
			} catch (Exception SQLException) {
				conn.rollback();  // Ha habido problemas, se deshacen todos los cambios
				miLog.addTraza(SQLException);
				response.sendRedirect("m05bError.jsp");
			} finally {
				if (rs != null)
					rs.close();
				if (pstmt != null)
					pstmt.close();
				if (conn != null)
					conn.close();
			}
		} catch(Throwable theException) {
			miLog.addTraza(theException);
			try {
				response.sendRedirect("m05bError.jsp");
			} catch (IOException e) {
				miLog.addTraza(e);
			}
		}
	}
}