package organismoServlet;

import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import javax.servlet.http.HttpSession;

import m05bBD.m05bOrganismo;
import m05bClasses.m05bConexion;
import m05bClasses.m05bConstantes;
import m05bClasses.m05bFileLog;

/**
 * Inserte aqu la descripcin del tipo.
 * Fecha de creacin: (04/12/03)
 */
public class m05bGrabarOrganismoServlet extends javax.servlet.http.HttpServlet {m05bFileLog miLog = new m05bFileLog();
/**
 * Process incoming HTTP POST requests 
 * 
 * @param request Object that encapsulates the request to the servlet 
 * @param response Object that encapsulates the response from the servlet
 */
public void doPost(javax.servlet.http.HttpServletRequest request, javax.servlet.http.HttpServletResponse response) throws javax.servlet.ServletException, java.io.IOException {

	performTask(request, response);

}
/**
 * Returns the servlet info string.
 */
public String getServletInfo() {

	return super.getServletInfo();

}
/**
 * Initializes the servlet.
 */
public void init() {
	// insert code to initialize the servlet here

}
/**
 * Process incoming requests for information
 * 
 * @param request Object that encapsulates the request to the servlet 
 * @param response Object that encapsulates the response from the servlet
 */
public void performTask(javax.servlet.http.HttpServletRequest request, javax.servlet.http.HttpServletResponse response) {

       	String sCodigo;
       	String sDescripcion, sDescripcionAnt;
       	String sEdescripcion, sEdescripcionAnt;
       	String accion;
       	String sql = "";
		java.sql.Connection conn=null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		boolean finalizado = false;
       try

		{
		HttpSession session = request.getSession(true);


		m05bOrganismo organismo = (m05bOrganismo)session.getAttribute("m05bOrganismo");
		sCodigo = request.getParameter("Codigo").toUpperCase();
		//System.out.println("m05b - Grabar Dptos: CODIGO: " + sCodigo);
		organismo.setOrg_codigo(sCodigo);
		sDescripcion=request.getParameter("Descripcion").toUpperCase();
		sDescripcionAnt=request.getParameter("DescripcionAnt").toUpperCase();
		organismo.setOrg_descripcion(sDescripcion);
		sEdescripcion=request.getParameter("Edescripcion").toUpperCase();
		sEdescripcionAnt=request.getParameter("EdescripcionAnt").toUpperCase();
		organismo.setOrg_edescripcion(sEdescripcion);
		accion=request.getParameter("Accion");

		try{
			m05bConexion miConex = new m05bConexion();
			conn = miConex.getConnection();
			if (accion.equals(m05bConstantes.ACC_ACTUALIZAR))  {
				pstmt = conn.prepareStatement(
					"update	M0548T00 " + 
					"set	DESCRIP_48 = ? " + 
					" ,		E_DESCRIP_48 = ? " + 
					"where	COD_ORG_48 = ?");
				pstmt.setString(1, sDescripcion);
				pstmt.setString(2, sEdescripcion);
				pstmt.setString(3, sCodigo);
				pstmt.executeUpdate();
			}
			else if (accion.equals(m05bConstantes.ACC_INSERTAR))  {
			   //Chequear si ya existe un departamento con ese codigo
			   sql = "select 1  from M0548T00 where COD_ORG_48 = '" + sCodigo + "'";
		       pstmt = conn.prepareStatement(sql);
			   rs = pstmt.executeQuery();
			   if (rs.next() == true){ 		
       	    			response.sendRedirect("m05bOrganismosJsp.jsp?Codigo=" + sCodigo + "&Mensaje=" + m05bConstantes.MSG_EXISTE);
       	    			finalizado = true;
			   } 
			   else {
					pstmt = conn.prepareStatement(
						"insert into M0548T00 " + 
						"(COD_ORG_48, DESCRIP_48, E_DESCRIP_48) " + 
						" values " + 
						"(? ,?, ? )" );
					pstmt.setString(1, sCodigo);
					pstmt.setString(2, sDescripcion);
					pstmt.setString(3, sEdescripcion);
				}
			}
			else   {  
				pstmt = conn.prepareStatement(
					"delete from 	M0548T00 " + 
					" where COD_ORG_48 =  ? " );
				pstmt.setString(1, sCodigo);
				pstmt.executeUpdate();
			}
			if(!finalizado){
				pstmt.executeUpdate();
				response.sendRedirect("m05bRelOrganismosJsp.jsp");
			}
		} 	catch (SQLException ex) {
				if (ex.getErrorCode() == m05bConstantes.ERR_INTEGRIDAD)
					response.sendRedirect("m05bOrganismosJsp.jsp?Codigo=" + sCodigo + "&Mensaje=" + m05bConstantes.MSG_INTEGRIDAD);
				else
					response.sendRedirect("m05bError.jsp");
				miLog.addTraza(ex);
		} finally{
			if (rs != null)
				rs.close();
			if (pstmt != null)
				pstmt.close();
			if (conn != null)
				conn.close();
		}

	}
	catch(Throwable theException)
	{
		// uncomment the following line when unexpected exceptions
		// are occuring to aid in debugging the problem.
		miLog.addTraza(theException);
		try {
			response.sendRedirect("m05bError.jsp");
		} catch (IOException e) {
			// TODO Auto-generated catch block
			miLog.addTraza(e);
		}
	}
}

}
