package informesServlet;

import java.io.IOException;
import java.util.ArrayList;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import m05bClasses.m05bConstantes;
import m05bClasses.m05bConstantesInformes;
import m05bClasses.m05bConstantesPaginas;
import m05bClasses.m05bFileLog;
import m05bIdioma.m05bCResources;
import m05bServices.m05bAsignacionesService;
import m05bServices.m05bCTKService;
import m05bServices.m05bMunicipiosService;
import m05bServices.m05bOrdenesTrabajoService;
import m05bServices.m05bSancionesService;
import m05bServices.m05bVistaVehiculosService;
import n05bModelosVistas.m05bCombustible;

import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

import utiliServlet.m05bInformesXML;
import utiliServlet.m05bPdfMaker;

public class m05bInformesPdfControllerServlet extends
		javax.servlet.http.HttpServlet {
	m05bFileLog miLog = new m05bFileLog();
	/**
	 * 
	 */
	private static final long serialVersionUID = 4982885644901979955L;

	java.sql.Connection conn = null;

	public static final String FO_REQUEST_PARAM = "fo";

	Logger logger = Logger.getLogger(m05bInformesPdfControllerServlet.class);

	public void doPost(javax.servlet.http.HttpServletRequest request,
			javax.servlet.http.HttpServletResponse response)
			throws javax.servlet.ServletException, java.io.IOException {
		try {
			doGet(request, response);
		} catch (Exception e) {
			StackTraceElement[] stackTraceElements = Thread.currentThread()
					.getStackTrace();
			for (StackTraceElement stackTrace : stackTraceElements) {
				logger.error(stackTrace.getClassName() + "  "
						+ stackTrace.getMethodName() + " "
						+ stackTrace.getLineNumber());
			}
		}
	}

	public void doGet(HttpServletRequest request, HttpServletResponse response)
			throws ServletException, IOException {
		performTask(request, response);
	}

	/**
	 * Initializes the servlet.
	 */
	public void init() {
		// insert code to initialize the servlet here

	}

	/**
	 * Realiza la funcin de controlador de informes
	 * 
	 * @param request
	 * @param response
	 * @throws ServletException
	 * @throws IOException
	 */
	public void performTask(javax.servlet.http.HttpServletRequest request,
			javax.servlet.http.HttpServletResponse response)
			throws ServletException, IOException {
		try {
			crearPdf(request, response);
		} catch (Exception e) {
			StackTraceElement[] stackTraceElements = Thread.currentThread()
					.getStackTrace();
			for (StackTraceElement stackTrace : stackTraceElements) {
				logger.error(stackTrace.getClassName() + "  "
						+ stackTrace.getMethodName() + " "
						+ stackTrace.getLineNumber());
			}
		}

	}

	/**
	 * Crear un pdf
	 * 
	 * @param request
	 * @param response
	 * @throws ServletException
	 * @throws IOException
	 */
	private void crearPdf(javax.servlet.http.HttpServletRequest request,
			javax.servlet.http.HttpServletResponse response)
			throws ServletException, IOException {
		// Se obtiene el tipo informe y el formato
		int tipoInforme = Integer.parseInt(request.getParameter("tipoInforme"));
		HttpSession session = request.getSession(true);
		int anio = 2012;
		if (request.getParameter("anio") != null)
			anio = Integer.parseInt(request.getParameter("anio"));
		String[] situaciones = request.getParameterValues("situaciones");
		String[] departamentos = request.getParameterValues("departamentos");
		String[] rangos = request.getParameterValues("rangos");

		String municipio="";
		if (request.getParameter("municipio") != null) {
			municipio=request.getParameter("municipio");
		}
		String identificado="";
		if (request.getParameter("identificado") != null) {
			identificado=request.getParameter("identificado");
			if (identificado != null) {
				if (identificado.equals("0")) {
					identificado = "";
				} else if (identificado.equals("2")) {
					identificado = "0";
				}
			}
		}

		String idioma = m05bConstantesInformes.CASTELLANO;
		try {
			idioma = ((m05bCResources) session.getAttribute("IdiomaActual")).getIdiomaActual();
		} catch (Exception e) {
			idioma = m05bConstantesInformes.CASTELLANO;
		}
		String localeStr="dd/MM/yyyy";
		if(!idioma.equals(m05bConstantesInformes.CASTELLANO))
			localeStr="yyyy/MM/dd";
		request.setAttribute("formatoFecha",localeStr);
		response.setContentType("application/pdf");
		response.setHeader("Content-Disposition",
				"attachment;filename=\"datos.pdf\"");
		int tipoConsulta;
		m05bInformesXML ixml = new m05bInformesXML();
		m05bPdfMaker pdfs = new m05bPdfMaker(idioma);
		logger.info("hay que crear un pdf tipo " + tipoInforme);
		Element cabecera;
		try {
			Document xml = null;
			String xslplantilla = "";
			switch (tipoInforme) {
			case m05bConstantes.INF_ALTASVEHICULOS:// Altas por ao
				logger.info("Altas llamando al DAO");
				xml = ixml.informeAltasXML(
						(ArrayList)m05bVistaVehiculosService.getInstance().altasPorAnio(
								anio, situaciones, idioma, -1), anio,idioma);
				xslplantilla = m05bConstantesPaginas.XSLALTAS;
				break;
			case m05bConstantes.INF_BAJASVEHICULOS:// Bajas por ao
				logger.info("Bajas llamando al DAO");
				xml = ixml.informeAltasXML((ArrayList)
						m05bVistaVehiculosService.getInstance().bajasPorAnio(
								anio, departamentos, rangos, idioma, -1), anio,idioma);
				xslplantilla = m05bConstantesPaginas.XSLBAJAS;
				break;
			case m05bConstantes.INF_ASIGPORTIPOVEH:
				logger.info("Asignaciones por tipo de vehiculo llamando al DAO");
				String fechaasig1 = request.getParameter("fechaasigdesde");
				String fechaasig2 = request.getParameter("fechaasighasta");
				String fechadev1 = request.getParameter("fechadesde");
				String fechadev2 = request.getParameter("fechahasta");
				String  fechadec1= request.getParameter("fechadecretodesde");
				String fechadec2 = request.getParameter("fechadecretohasta");
				String[] cargos = request.getParameterValues("cargos");
				xml = ixml
						.informeAsignacionesXML((ArrayList) m05bAsignacionesService
								.getInstance().asignacionesPorTipo(rangos,
										fechaasig1, fechaasig2, fechadev1,
										fechadev2, fechadec1, fechadec2,
										cargos,departamentos, idioma, -1),idioma);
				if (rangos!=null) {
					ixml.setOptionList(xml, (ArrayList) m05bAsignacionesService
							.getInstance().getRangos(rangos, idioma, -1),
							"rangos");
				}
				if (cargos!=null) {
					ixml.setOptionList(xml, (ArrayList) m05bAsignacionesService
							.getInstance().getCargos(cargos, idioma, -1),
							"cargos");
				}
				ixml.setFecha(xml,fechaasig1,fechaasig2,"fechaasignacion");
				ixml.setFecha(xml,fechadev1,fechadev2,"fechadevolucion");
				ixml.setFecha(xml,fechadec1,fechadec2,"fechadecreto");
				xslplantilla = m05bConstantesPaginas.XSLSIGNACIONESPORVEH;

				break;
			case m05bConstantes.INF_ASIGFECHAS:
				logger.info("Asignaciones entre fechas llamando al DAO");
				fechadev1 = request.getParameter("fechadesde");
				fechadev2 = request.getParameter("fechahasta");
				xml = ixml
						.informeAsignacionesXML((ArrayList) m05bAsignacionesService
								.getInstance().asignacionesPorFecha(fechadev1,
										fechadev2, rangos, idioma, -1),idioma);
				xslplantilla = m05bConstantesPaginas.XSLSIGNACIONESFECHAS;
				break;
			case m05bConstantes.INF_ASIGPERSONAS:
				logger.info("Asinaciones por personas llamando al DAO");
				xml = ixml
						.informeAltasXML((ArrayList) m05bAsignacionesService
								.getInstance().asignacionesPorPersonas(
										anio + "", idioma, -1),anio,idioma);
				xslplantilla = m05bConstantesPaginas.XSLSIGNACIONESPERSONAS;
				break;
			case m05bConstantes.INF_ASIGVIVAS:
				logger.info("Asig vivas llamando al DAO");
				xml = ixml
						.informeAsignacionesXML((ArrayList) m05bAsignacionesService
								.getInstance().asignacionesVivas(departamentos,idioma, -1),idioma);
				if (departamentos!=null) {
					ixml.setOptionList(xml, (ArrayList) m05bVistaVehiculosService
							.getInstance().getDepartamentos(departamentos, idioma, -1),
							"departamentos");
				}
				xslplantilla = m05bConstantesPaginas.XSLSIGNACIONESVIVAS;
				break;
			case m05bConstantes.INF_COCHES:
				logger.info("Coches llamando al DAO");
				String[] tipos = request.getParameterValues("tipocoche");
				xml = ixml
						.informeAsignacionesXML((ArrayList) m05bVistaVehiculosService
								.getInstance().cocherPorTipo(rangos,
										situaciones, departamentos, idioma, -1),idioma);
				if (rangos!=null) {
					ixml.setOptionList(xml, (ArrayList) m05bVistaVehiculosService
							.getInstance().getRangos(rangos, idioma, -1),
							"rangos");
				}
				if (situaciones!=null) {
					ixml.setOptionList(xml, (ArrayList) m05bVistaVehiculosService
							.getInstance().getSituaciones(situaciones, idioma, -1),
							"situaciones");
				}
				if (departamentos!=null) {
					ixml.setOptionList(xml, (ArrayList) m05bVistaVehiculosService
							.getInstance().getDepartamentos(departamentos, idioma, -1),
							"departamentos");
				}
				xslplantilla = m05bConstantesPaginas.XSLCOCHES;
				break;
			case m05bConstantes.INF_CONDUCTORES:
				logger.info("conductores llamando al DAO");
				String[] marcas = request.getParameterValues("marcas2");
				String[] modelos = request.getParameterValues("modelos");
				String disponible = request.getParameter("disponible");
				xml = ixml
						.informeAsignacionesXML((ArrayList) m05bAsignacionesService
								.getInstance().asignacionesAConductores(marcas,
										modelos, rangos, situaciones,
										Integer.parseInt(disponible), idioma,
										-1),idioma);
				if (rangos!=null) {
					ixml.setOptionList(xml, (ArrayList) m05bVistaVehiculosService
							.getInstance().getRangos(rangos, idioma, -1),
							"rangos");
				}
				if (situaciones!=null) { 
					ixml.setOptionList(xml, (ArrayList) m05bVistaVehiculosService
							.getInstance().toArrayList(situaciones),
							"situaciones");
				}
				if (marcas!=null) {
					ixml.setOptionList(xml, (ArrayList) m05bVistaVehiculosService
							.getInstance().toArrayList(marcas),
							"marcas");
				}
				if (modelos!=null) {
					ixml.setOptionList(xml, (ArrayList) m05bVistaVehiculosService
							.getInstance().toArrayList(modelos),
							"modelos");
				}
				xslplantilla = m05bConstantesPaginas.XSLCONDUCTORES;
				break;
			case m05bConstantes.INF_CTKAMORTIZACION:
				logger.info("CTK amortizacin llamando al DAO");
				fechadev1 = request.getParameter("fechadesde");
				fechadev2 = request.getParameter("fechahasta");
				String tipoAmortizacion = request
						.getParameter("tipoAmortizacion");

				if (tipoAmortizacion.equals("0")) {
					logger.info("resumen");
					xml = ixml
							.informeAsignacionesXML((ArrayList) m05bCTKService
									.getInstance().amortizacion(fechadev1,
											fechadev2, idioma, -1),idioma);
					ixml.setFecha(xml,fechadev1,fechadev2,"fechas");
					xslplantilla = m05bConstantesPaginas.XSLCTKAMORTIZACIONES;
				} else {
					logger.info("BASE");
					xml = ixml
							.informeAsignacionesXML((ArrayList) m05bCTKService
									.getInstance().amortizacionBase(fechadev1,
											fechadev2, idioma, -1),idioma);
					ixml.setFecha(xml,fechadev1,fechadev2,"fechas");
					xslplantilla = m05bConstantesPaginas.XSLCTKAMORTIZACIONESBASE;
				}
				break;
			case m05bConstantes.INF_LISTADOGENERAL:// Listado general
				logger.info("Listado general llamando al DAO");
				xml = ixml
						.informeAsignacionesXML((ArrayList) m05bVistaVehiculosService
								.getInstance().listadoGeneral(situaciones,
										idioma, -1),idioma);
				xslplantilla = m05bConstantesPaginas.XSLLISTADOGENERAL;
				break;
			case m05bConstantes.INF_LISTADOORDENES:// Ordenes
				String fechaEntrada1 = request.getParameter("fechaEntrada1");
				String fechaEntrada2 = request.getParameter("fechaEntrada2");
				String fechaSalida1 = request.getParameter("fechaSalida1");
				String fechaSalida2 = request.getParameter("fechaSalida2");
				logger.info("Ordenes de trabajo por fechas llamando al DAO");
				int tipoTaller = Integer.parseInt(request
						.getParameter("tipoTaller"));
				tipoConsulta = Integer.parseInt(request
						.getParameter("tipoConsulta"));
				if (tipoConsulta == m05bConstantes.INF_TIPOLISTADO) {
					logger.info("ORDENES");
					xml = ixml
							.informeAsignacionesXML((ArrayList) m05bOrdenesTrabajoService
									.getInstance().ordenes(fechaEntrada1,
											fechaEntrada2, fechaSalida1,
											fechaSalida2, tipoTaller, idioma,
											-1),idioma);
		
					xslplantilla = m05bConstantesPaginas.XSLORDENES;
				}// agrupado por departamento, matricula
				else if (tipoConsulta == m05bConstantes.INF_TIPORESUMEN) {
					logger.info("agrupado");
					xml = ixml
							.informeAsignacionesXML((ArrayList) m05bOrdenesTrabajoService
									.getInstance().ordenesAgrup(fechaEntrada1,
											fechaEntrada2, fechaSalida1,
											fechaSalida2, tipoTaller, idioma,
											-1),idioma);
					xslplantilla = m05bConstantesPaginas.XSLORDENESFECHASAGRUP;
				} else {// agrupado por departament,matricula rango
					logger.info("agrupado por rango");
					xml = ixml
							.informeAsignacionesXML((ArrayList) m05bOrdenesTrabajoService
									.getInstance().ordenesAgrupRango(
											fechaEntrada1, fechaEntrada2,
											fechaSalida1, fechaSalida2,
											tipoTaller, idioma, -1),idioma);
					xslplantilla = m05bConstantesPaginas.XSLORDENESRANGOAGRUP;
				}
				ixml.setFecha(xml,fechaEntrada1,fechaEntrada2,"fechaentrada");
				ixml.setFecha(xml,fechaSalida1,fechaSalida2,"fechasalida");
				ixml.setTipo(xml, request
						.getParameter("tipoTaller"), "tipo");
				break;
			case m05bConstantes.INF_LISTADOORDENESDETALLE:// ordenes de trabajo
															// detalle
				logger.info("Ordenes de trabajo detalle llamando al DAO");
				String fechaEntrada = request.getParameter("fechaEntrada");
				String matricula = request.getParameter("matricula");
				xml = ixml
						.informeAsignacionesXML((ArrayList) m05bOrdenesTrabajoService
								.getInstance().ordenesDetalle(fechaEntrada,
										matricula, idioma, -1),idioma);
				ixml.setFecha(xml,fechaEntrada,matricula,"fechamatricula");
				xslplantilla = m05bConstantesPaginas.XSLORDENESDETALLE;
				break;
			case m05bConstantes.INF_LISTADOORDENESFECHAS:
				logger.info("Ordenes de trabajo por fechas llamando al DAO");
				fechaEntrada1 = request.getParameter("fechaEntrada1");
				fechaEntrada2 = request.getParameter("fechaEntrada2");
				tipoTaller = Integer.parseInt(request
						.getParameter("tipoTaller"));
				tipoConsulta = Integer.parseInt(request
						.getParameter("tipoConsulta"));
				if (tipoConsulta == m05bConstantes.INF_TIPOLISTADO) {
					logger.info("lista");
					xml = ixml
							.informeAsignacionesXML((ArrayList) m05bOrdenesTrabajoService
									.getInstance().ordenesporFecha(
											fechaEntrada1, fechaEntrada2,
											tipoTaller, idioma, -1),idioma);
					xslplantilla = m05bConstantesPaginas.XSLORDENESFECHAS;
				} else {
					logger.info("agrupado");
					xml = ixml
							.informeAsignacionesXML((ArrayList) m05bOrdenesTrabajoService
									.getInstance().ordenesporFechaAgrup(
											fechaEntrada1, fechaEntrada2,
											tipoTaller, idioma, -1),idioma);
					xslplantilla = m05bConstantesPaginas.XSLORDENESFECHASAGRUP;
				}

				break;
			case m05bConstantes.INF_CTKCOMBUSTIBLE:
				fechadev1 = request.getParameter("fechadesde");
				fechadev2 = request.getParameter("fechahasta");
				tipoAmortizacion = request.getParameter("tipoAmortizacion");
				logger.info("CTK combustible : llamando al DAO");

				ArrayList<m05bCombustible> aux;
				if (tipoAmortizacion.equals("0")) {
					logger.info("Resumen combustible");
					aux = m05bCTKService.getInstance().combustible(fechadev1,
							fechadev2, idioma, -1);
					xslplantilla = m05bConstantesPaginas.XSLCTKCOMBUSTIBLERESUMEN;

				} else if (tipoAmortizacion.equals("2")) {
					logger.info("Combustible banco");
					aux = m05bCTKService.getInstance().combustibleBanco(
							fechadev1, fechadev2, idioma, -1);
					xslplantilla = m05bConstantesPaginas.XSLCTKCOMBUSTIBLELISTA;

				} else if (tipoAmortizacion.equals("1")) {
					logger.info("Combustible Gastos");
					aux = m05bCTKService.getInstance().combustibleGastos(
							fechadev1, fechadev2, idioma, -1);
					xslplantilla = m05bConstantesPaginas.XSLCTKCOMBUSTIBLELISTA;

				} else {// AmortizacionBase
					logger.info("Combustible total");
					aux = m05bCTKService.getInstance().combustibleTotal(
							fechadev1, fechadev2, idioma, -1);
					xslplantilla = m05bConstantesPaginas.XSLCTKCOMBUSTIBLELISTA;

				}
			
				xml = ixml.informeAsignacionesXML((ArrayList) aux,idioma);
				ixml.setFecha(xml,fechadev1,fechadev2,"fechas");
				break;
			case m05bConstantes.INF_CTKKILOMETRAJE:

				tipoAmortizacion = request.getParameter("tipoAmortizacion");
				fechaEntrada1 = request.getParameter("fechadesde");
				fechaEntrada2 = request.getParameter("fechahasta");
				if (tipoAmortizacion.equals("1")) {
					// base
					logger.info("CTK kilometros base");
//					fechaEntrada1 = request.getParameter("fechadesde");
//					fechaEntrada2 = request.getParameter("fechahasta");
					xml = ixml
							.informeAsignacionesXML((ArrayList) m05bCTKService
									.getInstance().kilometrajesBase(
											fechaEntrada1, fechaEntrada2,
											idioma, -1),idioma);
					ixml.setFecha(xml,fechaEntrada1,fechaEntrada2,"fechas");
					xslplantilla = m05bConstantesPaginas.XSLCTKKILOMETROSBASE;

				} else {

					String personaCodigo = (String) session
							.getAttribute("personaCodigo");

					xml = ixml
							.informeAsignacionesXML((ArrayList) m05bCTKService
									.getInstance().kilometrosRecorrido(
											personaCodigo, idioma, -1),idioma);
					ixml.setFecha(xml,fechaEntrada1,fechaEntrada2,"fechas");
					xslplantilla = m05bConstantesPaginas.XSLCTKKILOMETROS;

				}
				break;
			case m05bConstantes.INF_CTKVEHICULOS:
				logger.info("CTK Vehiculos");
				tipoAmortizacion = request.getParameter("tipoAmortizacion");
				fechaEntrada1 = request.getParameter("fechadesde");
				fechaEntrada2 = request.getParameter("fechahasta");
				if (tipoAmortizacion.equals("1")) {
					logger.info("CTK vehiculos de altas entre fechas");
					xml = ixml
							.informeAsignacionesXML((ArrayList) m05bCTKService
									.getInstance().getVehiculosAltaEntreFechas(
											fechaEntrada1, fechaEntrada2,
											idioma, -1),idioma);
					ixml.setFecha(xml,fechaEntrada1,fechaEntrada2,"fechas");
					xslplantilla = m05bConstantesPaginas.XSLCTKVEHICULOSBASE;
				} else if (tipoAmortizacion.equals("0")) {
					logger.info("CTK Nmero medio de vehiculos");
					xml = ixml
							.informeAsignacionesXML((ArrayList) m05bCTKService
									.getInstance().getMediaVehiculos(
											fechaEntrada1, fechaEntrada2,
											idioma, -1),idioma);
					ixml.setFecha(xml,fechaEntrada1,fechaEntrada2,"fechas");
					xslplantilla = m05bConstantesPaginas.XSLCTKVEHICULOS;
				} else {
					logger.info("CTK Nmero medio de vehiculos");
					xml = ixml
							.informeAsignacionesXML((ArrayList) m05bCTKService
									.getInstance().numeroVehiculos(
											fechaEntrada2, idioma, -1),idioma);
					ixml.setFecha(xml,fechaEntrada1,fechaEntrada2,"fechas");
					xslplantilla = m05bConstantesPaginas.XSLCTKVEHICULOSNUM;

				}
			case m05bConstantes.INF_TASAS:
				logger.info("listado de tasas");
				xml = ixml.informeAsignacionesXML((ArrayList)m05bMunicipiosService.getInstance().getTasas(municipio, situaciones, idioma, -1),idioma);
				xslplantilla = m05bConstantesPaginas.XSLTASAS;
				break;

			case m05bConstantes.INF_SANCIONES:
				logger.info("listado de sanciones");
				xml = ixml.informeAsignacionesXML((ArrayList)m05bSancionesService.getInstance().getSanciones(-1, identificado, anio, rangos), idioma);
				xslplantilla = m05bConstantesPaginas.XSLSANCIONES;
				break;
			}

			pdfs.generarPDF(response, xml, xslplantilla);
		} catch (Exception e) {
			e.printStackTrace();
			// TODO Auto-generated catch block
			miLog.addTraza(e);
			logger.error(e.getMessage());
			StackTraceElement[] stackTraceElements = Thread.currentThread()
					.getStackTrace();
			for (StackTraceElement stackTrace : stackTraceElements) {
				logger.error(stackTrace.getClassName() + "  "
						+ stackTrace.getMethodName() + " "
						+ stackTrace.getLineNumber());
			}
		}
	}
}