package informesServlet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.ResourceBundle;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import m05bClasses.m05bConstantes;
import m05bClasses.m05bConstantesInformes;
import m05bClasses.m05bConstantesPaginas;
import m05bClasses.m05bFileLog;
import m05bIdioma.m05bCResources;
import m05bServices.m05bAsignacionesService;
import m05bServices.m05bCTKService;
import m05bServices.m05bMunicipiosService;
import m05bServices.m05bOrdenesTrabajoService;
import m05bServices.m05bSancionesService;
import m05bServices.m05bVistaVehiculosService;
import n05bModelosVistas.m05bCombustible;
import n05bModelosVistas.m05bTasasMunicipio;

import org.apache.log4j.Logger;

import utiliServlet.m05bExcel;

public class m05bInformesExcelControllerServlet extends
		javax.servlet.http.HttpServlet {
	m05bFileLog miLog = new m05bFileLog();
	/**
	 * 
	 */
	private static final long serialVersionUID = 4982885644901979955L;

	java.sql.Connection conn = null;

	public static final String FO_REQUEST_PARAM = "fo";

	private static Logger logger = Logger
			.getLogger(m05bInformesExcelControllerServlet.class);

	public void doPost(javax.servlet.http.HttpServletRequest request,
			javax.servlet.http.HttpServletResponse response)
			throws javax.servlet.ServletException, java.io.IOException {
		try {
			doGet(request, response);
		} catch (Exception e) {
			// miLog.addTraza(e);
		}
	}

	public void doGet(HttpServletRequest request, HttpServletResponse response)
			throws ServletException, IOException {
		performTask(request, response);
	}

	/**
	 * Initializes the servlet.
	 */
	public void init() {
		// insert code to initialize the servlet here

	}

	/**
	 * Realiza la funcin de controlador de informes
	 * 
	 * @param request
	 * @param response
	 * @throws ServletException
	 * @throws IOException
	 */
	public void performTask(javax.servlet.http.HttpServletRequest request,
			javax.servlet.http.HttpServletResponse response)
			throws ServletException, IOException {

		// Se obtiene el tipo informe y el formato

		try {
			crearExcel(request, response);
		} catch (Exception e) {
			StackTraceElement[] stackTraceElements = Thread.currentThread()
					.getStackTrace();
			for (StackTraceElement stackTrace : stackTraceElements) {
				logger.error(stackTrace.getClassName() + "  "
						+ stackTrace.getMethodName() + " "
						+ stackTrace.getLineNumber());
			}
		}

	}

	/**
	 * Crear un excel
	 * 
	 * @param request
	 * @param response
	 * @throws ServletException
	 * @throws IOException
	 */
	private void crearExcel(javax.servlet.http.HttpServletRequest request,
			javax.servlet.http.HttpServletResponse response)
			throws ServletException, IOException {
		// Se obtiene el tipo informe y el formato
		int tipoInforme = Integer.parseInt(request.getParameter("tipoInforme"));

		int anio = 2012, tipoConsulta;
		if (request.getParameter("anio") != null)
			anio = Integer.parseInt(request.getParameter("anio"));
		String[] situaciones = request.getParameterValues("situaciones");
		String[] departamentos = request.getParameterValues("departamentos");
		String[] rangos = request.getParameterValues("rangos");
		
		String municipio="";
		if (request.getParameter("municipio") != null) {
			municipio=request.getParameter("municipio");
		}
		String identificado="";
		if (request.getParameter("identificado") != null) {
			identificado=request.getParameter("identificado");
			if (identificado != null) {
				if (identificado.equals("0")) {
					identificado = "";
				} else if (identificado.equals("2")) {
					identificado = "0";
				}
			}
		}

		m05bExcel excel;
		response.setContentType("application/vnd.ms-excel");
		response.setHeader("Content-Disposition",
				"attachment;filename=\"datos.xls\"");
		logger.info("Se ha pedido crear un excel: tipoInforme" + tipoInforme);
		HttpSession session = request.getSession(true);
		 ResourceBundle res =  (ResourceBundle)session.getAttribute("res");
	  	 
		String idioma = "";
		try {
			idioma = ((m05bCResources) session.getAttribute("IdiomaActual"))
					.getIdiomaActual();
		} catch (Exception e) {
			idioma = m05bConstantesInformes.CASTELLANO;
		}

		excel = new m05bExcel(idioma);
		try {
			switch (tipoInforme) {
			case m05bConstantes.INF_ALTASVEHICULOS:// Altas por ao
				logger.info("Altas llamando al DAO y creando excel");
				excel.createFileAltas(m05bVistaVehiculosService.getInstance()
						.altasPorAnio(anio, situaciones, idioma, -1), anio,
						response.getOutputStream());

				break;
			case m05bConstantes.INF_BAJASVEHICULOS:// Altas por ao
				logger.info("Bajas llamando al DAO y creando excel");
				excel.createFileBajas(m05bVistaVehiculosService.getInstance()
						.bajasPorAnio(anio, departamentos, rangos, idioma, -1),
						anio, response.getOutputStream());
				break;
			case m05bConstantes.INF_ASIGPORTIPOVEH:
				String fechaasig1 = request.getParameter("fechaasigdesde");
				String fechaasig2 = request.getParameter("fechaasighasta");
				String fechadev1 = request.getParameter("fechadesde");
				String fechadev2 = request.getParameter("fechahasta");
				String fechadec1 = request.getParameter("fechadecretodesde");
				String fechadec2 = request.getParameter("fechadecretohasta");
				String[] cargos = request.getParameterValues("cargos");
				logger.info("Asignaciones por tipo de vehiculo llamando al DAO y creando excel");
				ArrayList<String> str = new ArrayList<String>();
				String lag = excel.setFecha(fechaasig1, fechaasig2,
						res.getString("etFechaAsignacion"));
				if (lag != null && lag.length() > 0)
					str.add(lag);
				lag = excel.setFecha(fechadev1, fechadev2, res.getString("etTablaAsignaciones3"));
				if (lag != null && lag.length() > 0)
					str.add(lag);
				lag = excel.setFecha(fechadec1, fechadec2,  res.getString("etTablaAsignaciones2"));
				if (lag != null && lag.length() > 0)
					str.add(lag);
				if (rangos != null) {
					str.add(excel.setOptionList(
							(ArrayList) m05bAsignacionesService.getInstance()
									.getRangos(rangos, idioma, -1), res.getString("etRangos")));
				}
				if (cargos != null) {
					str.add(excel.setOptionList(
							(ArrayList) m05bAsignacionesService.getInstance()
									.getCargos(cargos, idioma, -1),res.getString("etCargo")));
				}

				excel.createFileAsignacionesPorVeh(
						m05bAsignacionesService.getInstance()
								.asignacionesPorTipo(rangos, fechaasig1,
										fechaasig2, fechadev1, fechadev2,
										fechadec1, fechadec2, cargos,departamentos, idioma,
										-1), str, response.getOutputStream());
				break;
			case m05bConstantes.INF_ASIGFECHAS:
				fechadev1 = request.getParameter("fechadesde");
				fechadev2 = request.getParameter("fechahasta");
				logger.info("Asignaciones fechas llamando al DAO y creando excel");
				excel.createFileAsignacionesFechas(
						m05bAsignacionesService.getInstance()
								.asignacionesPorFecha(fechadev1, fechadev2,
										rangos, idioma, -1), fechadev1,
						fechadev2, response.getOutputStream());

				break;
			case m05bConstantes.INF_ASIGPERSONAS:
				logger.info("Asignaciones por personas llamando al DAO y creando excel");
				excel.createFileAsignacionesPersonas(
						m05bAsignacionesService.getInstance()
								.asignacionesPorPersonas(anio + "", idioma, -1),
						anio + "", response.getOutputStream());

				break;
			case m05bConstantes.INF_ASIGVIVAS:
				logger.info("Asignaciones vivas llamando al DAO y creando excel");
				str = new ArrayList<String>();
				str.add(excel
						.setOptionList(
								(ArrayList) m05bVistaVehiculosService
										.getInstance().getDepartamentos(
												departamentos, idioma, -1),
												res.getString("etDepartamentos")));
				excel.createFileAsignacionesVivas(m05bAsignacionesService
						.getInstance().asignacionesVivas(departamentos,idioma, -1),str, response
						.getOutputStream());
				break;
			case m05bConstantes.INF_COCHES:
				logger.info("coches llamando al DAO y creando excel");
				String[] tipos = request.getParameterValues("tipocoche");

				str = new ArrayList<String>();
				if (rangos != null) {
					str.add(excel.setOptionList(
							(ArrayList) m05bVistaVehiculosService.getInstance()
									.getRangos(rangos, idioma, -1), res.getString("etRangos")));
				}
				if (situaciones != null) {
					str.add(excel.setOptionList(
							(ArrayList) m05bVistaVehiculosService.getInstance()
									.getSituaciones(situaciones, idioma, -1),
									res.getString("etSituaciones")));
				}
				if (departamentos != null) {
					str.add(excel
							.setOptionList(
									(ArrayList) m05bVistaVehiculosService
											.getInstance().getDepartamentos(
													departamentos, idioma, -1),
													res.getString("etDepartamentos")));
				}

				excel.createFileCoches(
						m05bVistaVehiculosService.getInstance().cocherPorTipo(
								rangos, situaciones, departamentos, idioma, -1),
						str, response.getOutputStream());

				break;
			case m05bConstantes.INF_CONDUCTORES:
				String[] marcas = request.getParameterValues("marcas2");
				String[] modelos = request.getParameterValues("modelos");
				String disponible = request.getParameter("disponible");
				logger.info("Inf_conductores llamando al DAO y creando excel");

				str = new ArrayList<String>();

				if (rangos != null) {
					str.add(excel.setOptionList(
							(ArrayList) m05bVistaVehiculosService.getInstance()
									.getRangos(rangos, idioma, -1),  res.getString("etRangos")));
				}
				if (situaciones != null) {
					str.add(excel.setOptionList(
							(ArrayList) m05bVistaVehiculosService.getInstance()
									.toArrayList(situaciones),
							"Situacin actual"));
				}
				if (marcas != null) {
					str.add(excel.setOptionList(
							(ArrayList) m05bVistaVehiculosService.getInstance()
									.toArrayList(marcas), res.getString("etTablaAltas3")));
				}
				if (modelos != null) {
					str.add(excel.setOptionList(
							(ArrayList) m05bVistaVehiculosService.getInstance()
									.toArrayList(modelos), res.getString("etTablaAltas4")));
				}
				excel.createFileConductores(
						m05bAsignacionesService.getInstance()
								.asignacionesAConductores(marcas, modelos,
										rangos, situaciones,
										Integer.parseInt(disponible), idioma,
										-1), str, response.getOutputStream());
				break;
			case m05bConstantes.INF_CTKAMORTIZACION:
				fechadev1 = request.getParameter("fechadesde");
				fechadev2 = request.getParameter("fechahasta");
				String tipoAmoritzacion = request
						.getParameter("tipoAmortizacion");
				logger.info("CTK amortizacion llamando al DAO y creando excel");
				str = new ArrayList<String>();
				if (tipoAmoritzacion.equals("0")) {
					logger.info("resumen");
					str.add(excel.setFecha(fechadev1, fechadev2, res.getString("etCtk6")));
					excel.createFileCTKAmortizacion(
							m05bCTKService.getInstance().amortizacion(
									fechadev1, fechadev2, idioma, -1), str,
							response.getOutputStream());

				} else {
					logger.info("base");
					str.add(excel.setFecha(fechadev1, fechadev2, res.getString("etCtk6")));
					excel.createFileCTKAmortizacionBase(
							m05bCTKService.getInstance().amortizacionBase(
									fechadev1, fechadev2, idioma, -1), str,
							response.getOutputStream());
				}
				break;
			case m05bConstantes.INF_LISTADOGENERAL:// Listado general
				logger.info("Listado general llamando al DAO y creando excel");
				excel.createFileListadoGeneral(
						(ArrayList) m05bVistaVehiculosService.getInstance()
								.listadoGeneral(situaciones, idioma, -1),
						response.getOutputStream());
				break;
			case m05bConstantes.INF_LISTADOORDENES:// Ordenes
				logger.info("Ordenes de trabajo llamando al DAO y creando excel");
				String fechaEntrada1 = request.getParameter("fechaEntrada1");
				String fechaEntrada2 = request.getParameter("fechaEntrada2");
				String fechaSalida1 = request.getParameter("fechaSalida1");
				String fechaSalida2 = request.getParameter("fechaSalida2");
				int tipoTaller = Integer.parseInt(request
						.getParameter("tipoTaller"));
				tipoConsulta = Integer.parseInt(request
						.getParameter("tipoConsulta"));
				str = new ArrayList<String>();
				lag = excel.setFecha(fechaEntrada1, fechaEntrada2,
						"Fecha de entrada");
				if (lag != null && lag.length() > 0)
					str.add(lag);
				lag = excel.setFecha(fechaSalida1, fechaSalida2, "fechasalida");
				if (lag != null && lag.length() > 0)
					str.add(lag);

				if (tipoTaller == 0)
					str.add("Cualquier tipo de taller");
				else if (tipoTaller == 1)
					str.add("Taller parque mvil");
				else
					str.add("Talleres distintos al parqu mvil");
				if (tipoConsulta == m05bConstantes.INF_TIPOLISTADO) {
					logger.info("Listado");
					excel.createFileOrdenes(
							m05bOrdenesTrabajoService.getInstance().ordenes(
									fechaEntrada1, fechaEntrada2, fechaSalida1,
									fechaSalida2, tipoTaller, idioma, -1), str,
							response.getOutputStream());
				} else if (tipoConsulta == m05bConstantes.INF_TIPORESUMEN) {
					logger.info("Agrupado1");
					excel.createFileOrdenesFechasAgrup(
							m05bOrdenesTrabajoService.getInstance()
									.ordenesAgrup(fechaEntrada1, fechaEntrada2,
											fechaSalida1, fechaSalida2,
											tipoTaller, idioma, -1), str,
							response.getOutputStream());
				} else {
					logger.info("Agrupado Rango");
					excel.createFileOrdenesRangoAgrup(
							m05bOrdenesTrabajoService.getInstance()
									.ordenesAgrupRango(fechaEntrada1,
											fechaEntrada2, fechaSalida1,
											fechaSalida2, tipoTaller, idioma,
											-1), str, response
									.getOutputStream());
				}

				break;
			case m05bConstantes.INF_LISTADOORDENESDETALLE:// ordenes de trabajo
															// detalle
				logger.info("Ordenes de trabajo detalle llamando al DAO y creando excel");
				String fechaEntrada = request.getParameter("fechaEntrada");
				String matricula = request.getParameter("matricula");
				str = new ArrayList<String>();
				str.add("Fecha de entrada(desde):"+fechaEntrada);
				if(matricula!=null &&matricula.length()>0)
				 str.add("Matrcula:"+matricula);
				excel.createFileOrdenesDetalle(
						m05bOrdenesTrabajoService.getInstance().ordenesDetalle(
								fechaEntrada, matricula, idioma, -1),str,
						response.getOutputStream());
				
				break;

			case m05bConstantes.INF_LISTADOORDENESFECHAS:
				fechaEntrada1 = request.getParameter("fechaEntrada1");
				fechaEntrada2 = request.getParameter("fechaEntrada2");
				tipoTaller = Integer.parseInt(request
						.getParameter("tipoTaller"));
				tipoConsulta = Integer.parseInt(request
						.getParameter("tipoConsulta"));
				logger.info("Ordenes de trabajo por fechas llamando al DAO y creando excel");
				if (tipoConsulta == m05bConstantes.INF_TIPOLISTADO) {
					logger.info("resumen");
					excel.createFileOrdenesFechas(
							m05bOrdenesTrabajoService.getInstance()
									.ordenesporFecha(fechaEntrada1,
											fechaEntrada2, tipoTaller, idioma,
											-1), response.getOutputStream());
				} else {
					logger.info("Agrupado");
					excel.createFileOrdenesFechasAgrup(
							m05bOrdenesTrabajoService.getInstance()
									.ordenesporFechaAgrup(fechaEntrada1,
											fechaEntrada2, tipoTaller, idioma,
											-1), null, response
									.getOutputStream());
				}

				break;
			case m05bConstantes.INF_CTKCOMBUSTIBLE:
				fechadev1 = request.getParameter("fechadesde");
				fechadev2 = request.getParameter("fechahasta");
				String tipoAmortizacion = request
						.getParameter("tipoAmortizacion");
				logger.info("CTK combustible : llamando al DAO");
				str = new ArrayList<String>();
				ArrayList<m05bCombustible> aux;
				if (tipoAmortizacion.equals("0")) {
					logger.info("Resumen combustible");
					aux = m05bCTKService.getInstance().combustible(fechadev1,
							fechadev2, idioma, -1);
					str.add(excel.setFecha(fechadev1, fechadev2, res.getString("etCtk6")));
					excel.createFileCtkCombustibleResumen(aux, str,
							response.getOutputStream());

				} else if (tipoAmortizacion.equals("2")) {
					logger.info("Combustible banco");
					aux = m05bCTKService.getInstance().combustibleBanco(
							fechadev1, fechadev2, idioma, -1);
					str.add(excel.setFecha(fechadev1, fechadev2, res.getString("etCtk6")));
					excel.createFileCtkCombustible(aux, str,
							response.getOutputStream());
				} else if (tipoAmortizacion.equals("1")) {
					logger.info("Combustible Gastos");
					aux = m05bCTKService.getInstance().combustibleGastos(
							fechadev1, fechadev2, idioma, -1);
					str.add(excel.setFecha(fechadev1, fechadev2, res.getString("etCtk6")));
					excel.createFileCtkCombustible(aux, str,
							response.getOutputStream());
				} else {// AmortizacionBase
					logger.info("Combustible total");
					aux = m05bCTKService.getInstance().combustibleTotal(
							fechadev1, fechadev2, idioma, -1);
					str.add(excel.setFecha(fechadev1, fechadev2,  res.getString("etCtk6")));
					excel.createFileCtkCombustible(aux, str,
							response.getOutputStream());
				}

				break;

			case m05bConstantes.INF_CTKKILOMETRAJE:
				tipoAmortizacion = request.getParameter("tipoAmortizacion");
				logger.info("CTK kilometros:");
				fechaEntrada1 = request.getParameter("fechadesde");
				fechaEntrada2 = request.getParameter("fechahasta");
				str = new ArrayList<String>();
				if (tipoAmortizacion.equals("1")) {
					logger.info("Informe base");

					str.add(excel.setFecha(fechaEntrada1, fechaEntrada2,
							res.getString("etCtk6")));
					excel.createFileCTKKilometrosBase(
							m05bCTKService.getInstance().kilometrajesBase(
									fechaEntrada1, fechaEntrada2, idioma, -1),
							str, response.getOutputStream());

				} else {
					logger.info("Informe resumen");

					String personaCodigo = (String) session
							.getAttribute("personaCodigo");
					str.add(excel.setFecha(fechaEntrada1, fechaEntrada2,
							res.getString("etCtk6")));
					excel.createFileCTKKilometros(m05bCTKService.getInstance()
							.kilometrosRecorrido(personaCodigo, idioma, -1),
							str, response.getOutputStream());
				}
				break;
			case m05bConstantes.INF_CTKVEHICULOS:
				logger.info("CTK Vehiculos");
				tipoAmortizacion = request.getParameter("tipoAmortizacion");
				fechaEntrada1 = request.getParameter("fechadesde");
				fechaEntrada2 = request.getParameter("fechahasta");
				str = new ArrayList<String>();
				if (tipoAmortizacion.equals("1")) {
					logger.info("CTK vehiculos de altas entre fechas");
					str.add(excel.setFecha(fechaEntrada1, fechaEntrada2,
							res.getString("etCtk6")));
					excel.createFileCTKVehiculosBase(
							m05bCTKService.getInstance()
									.getVehiculosAltaEntreFechas(fechaEntrada1,
											fechaEntrada2, idioma, -1), str,
							response.getOutputStream());

				} else if (tipoAmortizacion.equals("0")) {
					logger.info("CTK Nmero medio de vehiculos");
					str.add(excel.setFecha(fechaEntrada1, fechaEntrada2,
							res.getString("etCtk6")));
					excel.createFileCTKVehiculos(
							m05bCTKService.getInstance().getMediaVehiculos(
									fechaEntrada1, fechaEntrada2, idioma, -1),
							str, response.getOutputStream());
				} else {
					logger.info("CTK Nmero de vehiculos");
					str.add(excel.setFecha(fechaEntrada1, fechaEntrada2,
							res.getString("etCtk6")));
					excel.createFileCTKVehiculosNUM(
							m05bCTKService.getInstance().numeroVehiculos(
									fechaEntrada2, idioma, -1), str,
							response.getOutputStream());
				}
				break;
			case m05bConstantes.INF_TASAS:
				logger.info("listado de tasas");
				excel.createFileTasas(m05bMunicipiosService.getInstance().getTasas(municipio, situaciones, idioma, -1),null,response.getOutputStream());
				break;
				
			case m05bConstantes.INF_SANCIONES:
				logger.info("listado de sanciones");				
				excel.createFileSanciones(m05bSancionesService.getInstance().getSanciones(-1, identificado, anio, rangos),null,response.getOutputStream());	
				break;
			
			default:
				break;
			}
		} catch (Exception e) {
			// TODO Auto-generated catch block
			miLog.addTraza(e);
			StackTraceElement[] stackTraceElements = Thread.currentThread()
					.getStackTrace();
			for (StackTraceElement stackTrace : stackTraceElements) {
				logger.error(stackTrace.getClassName() + "  "
						+ stackTrace.getMethodName() + " "
						+ stackTrace.getLineNumber());
			}
		}
	}

}
