package informesServlet;

import java.io.IOException;
import java.util.ArrayList;

import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import m05bClasses.m05bConstantes;
import m05bClasses.m05bConstantesInformes;
import m05bClasses.m05bConstantesPaginas;
import m05bDaos.m05bPaginator;
import m05bIdioma.m05bCResources;
import m05bServices.m05bAsignacionesService;
import m05bServices.m05bCTKService;
import m05bServices.m05bGastosService;
import m05bServices.m05bMunicipiosService;
import m05bServices.m05bOrdenesTrabajoService;
import m05bServices.m05bSancionesService;
import m05bServices.m05bVistaVehiculosService;
import n05bModelosVistas.m05bAmortizacionBase;
import n05bModelosVistas.m05bAsignacion;
import n05bModelosVistas.m05bCombustible;
import n05bModelosVistas.m05bKilometrajes;
import n05bModelosVistas.m05bOrdenTrabajo;
import n05bModelosVistas.m05bPersonaEstadisticas;
import n05bModelosVistas.m05bSancion;
import n05bModelosVistas.m05bTasasMunicipio;
import n05bModelosVistas.m05bVehiculoV;

import org.apache.log4j.Logger;

public class m05bInformesControllerServlet extends
		javax.servlet.http.HttpServlet {
	/**
	 * 
	 */
	private static final long serialVersionUID = 4982885644901979955L;
	private static Logger logger = Logger
			.getLogger(m05bInformesControllerServlet.class);
	java.sql.Connection conn = null;

	public static final String FO_REQUEST_PARAM = "fo";

	// Logger log = null;

	public void doPost(javax.servlet.http.HttpServletRequest request,
			javax.servlet.http.HttpServletResponse response)
			throws javax.servlet.ServletException, java.io.IOException {
		try {
			doGet(request, response);
		} catch (Exception e) {
			//miLog.addTraza(e);
		}
	}

	public void doGet(HttpServletRequest request, HttpServletResponse response)
			throws ServletException, IOException {
		performTask(request, response);
	}

	/**
	 * Initializes the servlet.
	 */
	public void init() {
		// insert code to initialize the servlet here

	}

	/**
	 * Realiza la funcin de controlador de informes
	 * 
	 * @param request
	 * @param response
	 * @throws ServletException
	 * @throws IOException
	 */
	public void performTask(javax.servlet.http.HttpServletRequest request,
			javax.servlet.http.HttpServletResponse response)
			throws ServletException, IOException {

		// Se obtiene el tipo informe y el formato

		crearHtml(request, response);

	}

	/**
	 * Crear un html
	 * 
	 * @param request
	 * @param response
	 * @throws ServletException
	 * @throws IOException
	 */
	private void crearHtml(javax.servlet.http.HttpServletRequest request,
			javax.servlet.http.HttpServletResponse response)
			throws ServletException, IOException {
		try {
			// Se obtiene el tipo informe y el formato
			int tipoInforme = Integer.parseInt(request
					.getParameter("tipoInforme"));
			String fechadev1, fechadev2, fechadec1, fechadec2, fechaEntrada1, fechaEntrada2,fechaasig1,fechaasig2;
			String[] cargos;
			String resultado = "";
			int anio = 2012, tipoTaller;
			if (request.getParameter("anio") != null)
				anio = Integer.parseInt(request.getParameter("anio"));
			String[] situaciones = request.getParameterValues("situaciones");
			String[] departamentos = request
					.getParameterValues("departamentos");
			String[] rangos = request.getParameterValues("rangos");
			
			String municipio="";
			if (request.getParameter("municipio") != null) {
				municipio=request.getParameter("municipio");
			}
			String identificado="";
			if (request.getParameter("identificado") != null) {
				identificado=request.getParameter("identificado");
				if (identificado != null) {
					if (identificado.equals("0")) {
						identificado = "";
					} else if (identificado.equals("2")) {
						identificado = "0";
					}
				}
			}

			logger.info("Creando HTML con los parmetros enviados. Tipo informe: "
					+ tipoInforme);
			HttpSession session = request.getSession(true);
			
			String idioma=	"";
		
			try{
				idioma=	((m05bCResources)	session.getAttribute("IdiomaActual")).getIdiomaActual();
				}
				catch(Exception e){
					idioma=m05bConstantesInformes.CASTELLANO;
				}
				String localeStr="dd/MM/yyyy";
				if(!idioma.equals(m05bConstantesInformes.CASTELLANO))
						 localeStr="yyyy/MM/dd";
				request.setAttribute("formatoFecha",localeStr);
				ArrayList<m05bVehiculoV> salidaveh;
				ArrayList<m05bAsignacion> salidaasg;
				ArrayList <m05bPersonaEstadisticas> salidaEstds;
				
			int tipoConsulta;
			switch (tipoInforme) {
			case m05bConstantes.INF_ALTASVEHICULOS:// Altas por ao
				logger.info("Altas :llamando al DAO");
				salidaveh=m05bVistaVehiculosService.getInstance().altasPorAnio(
						anio, situaciones,idioma,m05bPaginator.NO);
				//Se obtiene el nmero y se elemina el primer registro				
				//request.setAttribute("numpaginas", salidaveh.get(0).getKmActuales());
				//salidaveh.remove(0);
				
				request.setAttribute(
						"listavehiculos",salidaveh
						);
				request.setAttribute("anio", anio);
				request.setAttribute("tipoInforme", tipoInforme);
				request.setAttribute("situaciones", situaciones);
				resultado = m05bConstantesPaginas.PRC_INFORMESALTASLISTA;
				break;
			case m05bConstantes.INF_BAJASVEHICULOS:// Altas por ao
				logger.info("Bajas " + anio);
				request.setAttribute(
						"listavehiculos",
						m05bVistaVehiculosService.getInstance().bajasPorAnio(
								anio, departamentos, rangos,idioma,m05bPaginator.NO));
				request.setAttribute("anio", anio);
				request.setAttribute("tipoInforme", tipoInforme);
				request.setAttribute("departamentos", departamentos);
				request.setAttribute("rangos", rangos);

				resultado = m05bConstantesPaginas.PRC_INFORMESBAJASLISTA;
				break;
			case m05bConstantes.INF_ASIGPORTIPOVEH:
				fechaasig1 = request.getParameter("fechaasigdesde"); 
				fechaasig2 = request.getParameter("fechaasighasta");
				fechadev1 = request.getParameter("fechadesde");
				fechadev2 = request.getParameter("fechahasta");
				fechadec1 = request.getParameter("fechadecretodesde");
				fechadec2 = request.getParameter("fechadecretohasta");
				cargos = request.getParameterValues("cargos");
				logger.info("Asignaciones  : llamando al DAO");
				salidaasg=m05bAsignacionesService
				.getInstance()
				.asignacionesPorTipo(rangos,fechaasig1, fechaasig2, fechadev1,
						fechadev2, fechadec1, fechadec2, cargos,departamentos,idioma,m05bPaginator.INITPAGE);
				//Paginador
				request.setAttribute("numpaginas", salidaasg.get(0).getNumeroPaginas());
				request.setAttribute("numeroRegistros", salidaasg.get(0).getNumeroRegistros());
				request.setAttribute("departamentos", departamentos);
				salidaasg.remove(0);
				//
				request.setAttribute(
						"listasiganaciones",salidaasg
						);
				resultado = m05bConstantesPaginas.PRC_INFORMESASIGNACIONESLISTA;
				request.setAttribute("tipoInforme", tipoInforme);
				request.setAttribute("rangos", rangos);
				request.setAttribute("cargos", cargos);
				request.setAttribute("fechadesde", fechadev1);
				request.setAttribute("fechahasta", fechadev2);
				request.setAttribute("fechadecretodesde", fechadec1);
				request.setAttribute("fechadecretohasta", fechadec2);
				request.setAttribute("fechaasigdesde", fechaasig1);
				request.setAttribute("fechaasighasta", fechaasig2);
				break;
			case m05bConstantes.INF_ASIGFECHAS:
				fechadev1 = request.getParameter("fechadesde");
				fechadev2 = request.getParameter("fechahasta");
				logger.info("Asignaciones por fechas : llamando al DAO");
				salidaasg=m05bAsignacionesService.getInstance()
				.asignacionesPorFecha(fechadev1, fechadev2,
						rangos,idioma,m05bPaginator.INITPAGE);
				request.setAttribute(
						"listasiganaciones",salidaasg
						);
				//Paginador
				request.setAttribute("numpaginas", salidaasg.get(0).getKmActuales());
				salidaasg.remove(0);
				//
				resultado = m05bConstantesPaginas.PRC_INFORMEASIGNENTREFECHASLISTA;
				request.setAttribute("tipoInforme", tipoInforme);
				request.setAttribute("rangos", rangos);
				request.setAttribute("fechadesde", fechadev1);
				request.setAttribute("fechahasta", fechadev2);
				break;
			case m05bConstantes.INF_ASIGPERSONAS:
				logger.info("Asignaciones por personas : llamando al DAO");
				salidaEstds=m05bAsignacionesService.getInstance()
							.asignacionesPorPersonas(anio + "",idioma,m05bPaginator.INITPAGE);
				request.setAttribute("lsitaestadisticas",salidaEstds);
				//Paginador
				request.setAttribute("numpaginas", salidaEstds.get(0).getNumeroPaginas());
				request.setAttribute("numeroRegistros", salidaEstds.get(0).getNumeroRegistros());
				salidaEstds.remove(0);
				//
				resultado = m05bConstantesPaginas.PRC_INFORMESASIGNACIONESPERSONASLISTA;
				request.setAttribute("anio", anio);
				request.setAttribute("tipoInforme", tipoInforme);
				break;
			case m05bConstantes.INF_ASIGVIVAS:
				resultado = m05bConstantesPaginas.PRC_INFORMESASIGNACIONESVIVASLISTA;
				logger.info("Asignaciones vivas : llamando al DAO");
				salidaasg=m05bAsignacionesService.getInstance()
				.asignacionesVivas(departamentos,idioma,m05bPaginator.INITPAGE);
				request.setAttribute("listasiganaciones",salidaasg
						);
				//Paginador
			
				request.setAttribute("numpaginas", salidaasg.get(0).getNumeroPaginas());
				request.setAttribute("numeroRegistros", salidaasg.get(0).getNumeroRegistros());
				salidaasg.remove(0);
				request.setAttribute("departamentos", departamentos);
				request.setAttribute("tipoInforme", tipoInforme);
				break;
			case m05bConstantes.INF_COCHES:
				logger.info("Coches : llamando al DAO");
				resultado = m05bConstantesPaginas.PRC_INFORMESCOCHESLISTA;
				
				//int tipo = Integer.parseInt(request.getParameter("tipocoche"));
			
				salidaveh=m05bVistaVehiculosService
					.getInstance().cocherPorTipo(rangos, situaciones,departamentos,idioma,m05bPaginator.INITPAGE);
				//paginar
		
				request.setAttribute("numpaginas", salidaveh.get(0).getNumeroPaginas());
				request.setAttribute("numeroRegistros", salidaveh.get(0).getNumeroRegistros());
				salidaveh.remove(0);
				//
				request.setAttribute("listaCoches", salidaveh);
				request.setAttribute("tipoInforme", tipoInforme);
				request.setAttribute("rangos", rangos);
				request.setAttribute("situaciones", situaciones);
				request.setAttribute("departamentos", departamentos);
				break;
			case m05bConstantes.INF_CONDUCTORES:
				
				String[] marcas = request.getParameterValues("marcas2");
				String[] modelos = request.getParameterValues("modelos");
				String disponible = request.getParameter("disponible");
				logger.info("Conductores : llamando al DAO");
				salidaasg=m05bAsignacionesService.getInstance()
						.asignacionesAConductores(marcas, modelos,
						rangos, situaciones,
						Integer.parseInt(disponible),idioma,m05bPaginator.INITPAGE);
				request.setAttribute(
						"listaConductores",salidaasg
						);
				//Paginador
				request.setAttribute("numpaginas", salidaasg.get(0).getNumeroPaginas());
				request.setAttribute("numeroRegistros", salidaasg.get(0).getNumeroRegistros());
				salidaasg.remove(0);
				//
				request.setAttribute("marcas2", marcas);
			
				request.setAttribute("modelos", modelos);
				request.setAttribute("disponible", disponible);
				request.setAttribute("rangos", rangos);
				request.setAttribute("situaciones", situaciones);
				request.setAttribute("tipoInforme", tipoInforme);
				resultado = m05bConstantesPaginas.PRC_INFORMESCONDUCTORESLISTA;
				break;
			case m05bConstantes.INF_CTKAMORTIZACION:

				fechadev1 = request.getParameter("fechadesde");
				fechadev2 = request.getParameter("fechahasta");
				String tipoAmortizacion = request
						.getParameter("tipoAmortizacion");
				logger.info("Amortizaciones : llamando al DAO");
				if (tipoAmortizacion.equals("0")) {
					logger.info("Resumen");
					request.setAttribute("listaamortizaciones", m05bCTKService
							.getInstance().amortizacion(fechadev1, fechadev2,idioma,m05bPaginator.NO));
					resultado = m05bConstantesPaginas.PRC_INFORMESCTKAMORTIZACIONLISTA;
				} else {// AmortizacionBase
					logger.info("Base");
					ArrayList<m05bAmortizacionBase>listbase=m05bCTKService.getInstance().amortizacionBase(
							fechadev1, fechadev2,idioma,m05bPaginator.INITPAGE);
					//Paginador
				
					request.setAttribute("numpaginas", listbase.get(0).getNumeroPaginas());
					request.setAttribute("numeroRegistros", listbase.get(0).getNumeroRegistros());
					listbase.remove(0);
					//
					request.setAttribute("listaamortizaciones",listbase	);
					resultado = m05bConstantesPaginas.PRC_INFORMESCTKAMORTIZACIONBASELISTA;
				}

				request.setAttribute("fechadesde", fechadev1);
				request.setAttribute("fechahasta", fechadev2);
				request.setAttribute("tipoInforme", tipoInforme);
				request.setAttribute("tipoAmortizacion", tipoAmortizacion);

				break;
			case m05bConstantes.INF_LISTADOGENERAL:// Listado general
				logger.info("Listado general. Llamando al DAO");
				salidaveh=m05bVistaVehiculosService.getInstance().listadoGeneral(
						situaciones,idioma,m05bPaginator.INITPAGE);
				//Paginacin
			
				request.setAttribute("numpaginas", salidaveh.get(0).getNumeroPaginas());
				request.setAttribute("numeroRegistros", salidaveh.get(0).getNumeroRegistros());
				salidaveh.remove(0);
				
				request.setAttribute(
						"listavehiculos",salidaveh);

				request.setAttribute("tipoInforme", tipoInforme);
				request.setAttribute("situaciones", situaciones);
				resultado = m05bConstantesPaginas.PRC_INFORMESLISTADOGENERALLISTA;
				break;
			case m05bConstantes.INF_LISTADOORDENES:// Ordenes de trabajo
				logger.info("Ordenes de trabajo. Llamando al DAO");
				fechaEntrada1 = request.getParameter("fechaEntrada1");
				fechaEntrada2 = request.getParameter("fechaEntrada2");
				String fechaSalida1 = request.getParameter("fechaSalida1");
				String fechaSalida2 = request.getParameter("fechaSalida2");
				tipoTaller = Integer.parseInt(request
						.getParameter("tipoTaller"));
				tipoConsulta = Integer.parseInt(request
						.getParameter("tipoConsulta"));
				ArrayList<m05bOrdenTrabajo> aux;
				if (tipoConsulta == m05bConstantes.INF_TIPOLISTADO) {
					
					logger.info("Normal");
					aux=
						m05bOrdenesTrabajoService.getInstance().ordenes(
								fechaEntrada1, fechaEntrada2, fechaSalida1,
								fechaSalida2, tipoTaller,idioma,m05bPaginator.INITPAGE);
	
					resultado = m05bConstantesPaginas.PRC_INFORMESORDENESLISTA;
				} else if (tipoConsulta == m05bConstantes.INF_TIPORESUMEN) {
					logger.info("Resumen por matricula y departameto");
					aux=m05bOrdenesTrabajoService.getInstance()
					.ordenesAgrup(fechaEntrada1, fechaEntrada2,
							fechaSalida1, fechaSalida2,
							tipoTaller,idioma,m05bPaginator.INITPAGE);
				
					resultado = m05bConstantesPaginas.PRC_INFORMESORDENESFECHASAGRUPLISTA;
				} else {// resumen por departamento, matricula y rango
					logger.info("Resumen por departamento,matricula y rango");
					aux=m05bOrdenesTrabajoService.getInstance()
					.ordenesAgrupRango(fechaEntrada1,
							fechaEntrada2, fechaSalida1,
							fechaSalida2, tipoTaller,idioma,m05bPaginator.INITPAGE);
					
					resultado = m05bConstantesPaginas.PRC_INFORMESORDENESFECHASAGRUPRANGOLISTA;

				}
				//Paginacin

				request.setAttribute("numpaginas", aux.get(0).getNumeroPaginas());
				request.setAttribute("numeroRegistros", aux.get(0).getNumeroRegistros());
				aux.remove(0);
				request.setAttribute(
						"listaordenes",
						aux);
				request.setAttribute("tipoInforme", tipoInforme);
				request.setAttribute("fechaEntrada1", fechaEntrada1);
				request.setAttribute("fechaEntrada2", fechaEntrada2);
				request.setAttribute("fechaSalida1", fechaSalida1);
				request.setAttribute("fechaSalida2", fechaSalida2);
				request.setAttribute("tipoTaller", tipoTaller);
				request.setAttribute("tipoConsulta", tipoConsulta);
				break;
			case m05bConstantes.INF_LISTADOORDENESDETALLE:// ordenes de trabajo
															// detalle
				String fechaEntrada = request.getParameter("fechaEntrada");
				String matricula = request.getParameter("matricula");
				logger.info("Ordenes de trabajo detalle. Llamando al DAO");
				aux= m05bOrdenesTrabajoService
				.getInstance().ordenesDetalle(fechaEntrada, matricula,idioma,m05bPaginator.INITPAGE);
				request.setAttribute("listaordenes",aux);
				//Paginacin
				request.setAttribute("numpaginas", aux.get(0).getNumeroPaginas());
				request.setAttribute("numeroRegistros", aux.get(0).getNumeroRegistros());
				aux.remove(0);
				request.setAttribute("fechaEntrada", fechaEntrada);
				request.setAttribute("matricula", matricula);
				request.setAttribute("tipoInforme", tipoInforme);
				resultado = m05bConstantesPaginas.PRC_INFORMESORDENESDETALLELISTA;
				break;
			case m05bConstantes.INF_LISTADOORDENESFECHAS:
				fechaEntrada1 = request.getParameter("fechaEntrada1");
				fechaEntrada2 = request.getParameter("fechaEntrada2");
				tipoTaller = Integer.parseInt(request
						.getParameter("tipoTaller"));
				tipoConsulta = Integer.parseInt(request
						.getParameter("tipoConsulta"));
				logger.info("Ordenes de trabajo por fechas. Llamando al DAO");
				if (tipoConsulta == m05bConstantes.INF_TIPOLISTADO) {
					logger.info("Listado");
					aux=m05bOrdenesTrabajoService.getInstance()
					.ordenesporFecha(fechaEntrada1,
							fechaEntrada2, tipoTaller,idioma,m05bPaginator.INITPAGE);
			
					resultado = m05bConstantesPaginas.PRC_INFORMESORDENESFECHASLISTA;
				} else {
					logger.info("Agrupado");
					aux=m05bOrdenesTrabajoService.getInstance()
					.ordenesporFechaAgrup(fechaEntrada1,
							fechaEntrada2, tipoTaller,idioma,m05bPaginator.INITPAGE);
					
					resultado = m05bConstantesPaginas.PRC_INFORMESORDENESFECHASAGRUPLISTA;
				}
				//Paginacin
				request.setAttribute("numpaginas", aux.get(0).getNumeroPaginas());
				request.setAttribute("numeroRegistros", aux.get(0).getNumeroRegistros());
				aux.remove(0);
				
				request.setAttribute("listaordenes",aux	);
				request.setAttribute("tipoInforme", tipoInforme);
				request.setAttribute("fechaEntrada1", fechaEntrada1);
				request.setAttribute("fechaEntrada2", fechaEntrada2);
				request.setAttribute("tipoTaller", tipoTaller);
				request.setAttribute("tipoConsulta", tipoConsulta);
				break;
			case m05bConstantes.INF_CTKCOMBUSTIBLE:
				fechadev1 = request.getParameter("fechadesde");
				fechadev2 = request.getParameter("fechahasta");
				 tipoAmortizacion = request
						.getParameter("tipoAmortizacion");
				logger.info("CTK combustible : llamando al DAO");
	
				ArrayList<m05bCombustible> aux2=null;
				if (tipoAmortizacion.equals("0")) {
					logger.info("Resumen combustible");
					aux2=m05bCTKService.getInstance().combustible(fechadev1, fechadev2,idioma,m05bPaginator.NO);
				
					resultado = m05bConstantesPaginas.PRC_INFORMESCTKCOMBUSTIBLERESUMEN;
				} else 	if (tipoAmortizacion.equals("2")) {
					logger.info("Combustible banco");
					aux2=m05bCTKService.getInstance().combustibleBanco(fechadev1, fechadev2,idioma,m05bPaginator.INITPAGE);
					//Paginador
					request.setAttribute("numpaginas", aux2.get(0).getNumeroPaginas());
					request.setAttribute("numeroRegistros", aux2.get(0).getNumeroRegistros());
					aux2.remove(0);
					
					resultado = m05bConstantesPaginas.PRC_INFORMESCTKCOMBUSTIBLELISTA;
				} else 	if (tipoAmortizacion.equals("1")) {
					logger.info("Combustible Gastos");
					aux2=m05bCTKService.getInstance().combustibleGastos(fechadev1, fechadev2,idioma,m05bPaginator.INITPAGE);
					//Paginador
					request.setAttribute("numpaginas", aux2.get(0).getNumeroPaginas());
					request.setAttribute("numeroRegistros", aux2.get(0).getNumeroRegistros());
					aux2.remove(0);
					
					resultado = m05bConstantesPaginas.PRC_INFORMESCTKCOMBUSTIBLELISTA;
				} else {// AmortizacionBase
					logger.info("Combustible total");
					aux2=m05bCTKService.getInstance().combustibleTotal(fechadev1, fechadev2,idioma,m05bPaginator.INITPAGE);
					//Paginador
					request.setAttribute("numpaginas", aux2.get(0).getNumeroPaginas());
					request.setAttribute("numeroRegistros", aux2.get(0).getNumeroRegistros());
					aux2.remove(0);	
					resultado = m05bConstantesPaginas.PRC_INFORMESCTKCOMBUSTIBLELISTA;
				}
				
				
				request.setAttribute("listacombustible", aux2);
				request.setAttribute("fechadesde", fechadev1);
				request.setAttribute("fechahasta", fechadev2);
				request.setAttribute("tipoInforme", tipoInforme);
				request.setAttribute("tipoAmortizacion", tipoAmortizacion);
				break;
			case m05bConstantes.INF_CTKKILOMETRAJE:
				logger.info("CTK kilometros:");
				 tipoAmortizacion = request
				.getParameter("tipoAmortizacion");
				request.setAttribute("tipoInforme", tipoInforme);
				request.setAttribute("tipoAmortizacion", tipoAmortizacion);
				fechaEntrada1 = request.getParameter("fechadesde");
				fechaEntrada2 = request.getParameter("fechahasta");
				if(tipoAmortizacion.equals("1")){
					logger.info("Informe base");
					//base
					
					ArrayList<m05bKilometrajes> listkilo=m05bCTKService.getInstance().kilometrajesBase(fechaEntrada1,fechaEntrada2,idioma,m05bPaginator.INITPAGE);
				
					request.setAttribute("numpaginas", listkilo.get(0).getNumeroPaginas());
					request.setAttribute("numeroRegistros", listkilo.get(0).getNumeroRegistros());
					listkilo.remove(0);	
//					
					request.setAttribute("listakilometraje", listkilo);
					resultado = m05bConstantesPaginas.PRC_INFORMESCTKKILOMETRAJEBASELISTA;
				
				}
				else{
					logger.info("Informe resumen");
					
					String personaCodigo = (String) session.getAttribute("personaCodigo");
					request.setAttribute("listakilometraje", m05bCTKService.getInstance().kilometrosRecorrido(personaCodigo,idioma,m05bPaginator.NO));
					resultado = m05bConstantesPaginas.PRC_INFORMESCTKKILOMETRAJELISTA;
				}
				request.setAttribute("fechadesde", fechaEntrada1);
				request.setAttribute("fechahasta", fechaEntrada2);
				break;
			case m05bConstantes.INF_CTKVEHICULOS:
				logger.info("CTK Vehiculos");
				tipoAmortizacion = request
				.getParameter("tipoAmortizacion");
				request.setAttribute("tipoInforme", tipoInforme);
				request.setAttribute("tipoAmortizacion", tipoAmortizacion);
				fechaEntrada1 = request.getParameter("fechadesde");
				fechaEntrada2 = request.getParameter("fechahasta");
				if(tipoAmortizacion.equals("1")){
					logger.info("CTK vehiculos de altas entre fechas");		
					ArrayList<m05bKilometrajes> listkilo=m05bCTKService.getInstance().getVehiculosAltaEntreFechas(fechaEntrada1,fechaEntrada2,idioma,m05bPaginator.INITPAGE);
					//paginacin
					request.setAttribute("numpaginas", listkilo.get(0).getNumeroPaginas());
					request.setAttribute("numeroRegistros", listkilo.get(0).getNumeroRegistros());
					listkilo.remove(0);	
//
					request.setAttribute("listakilometraje",listkilo );
					resultado = m05bConstantesPaginas.PRC_INFORMESCTKVEHICULOSBASELISTA;					
				}
				else if(tipoAmortizacion.equals("0")){	
					logger.info("CTK Nmero medio de vehiculos");		
					request.setAttribute("listakilometraje", m05bCTKService.getInstance().getMediaVehiculos(fechaEntrada1, fechaEntrada2,idioma,m05bPaginator.NO));
					resultado = m05bConstantesPaginas.PRC_INFORMESCTKVEHICULOSLISTA;
				}
				else{
					logger.info("CTK Nmero  de vehiculos");		
					request.setAttribute("listakilometraje", m05bCTKService.getInstance().numeroVehiculos(fechaEntrada2,idioma,m05bPaginator.NO));
					resultado = m05bConstantesPaginas.PRC_INFORMESCTKVEHICULOSNUMLISTA;
				}
				request.setAttribute("fechadesde", fechaEntrada1);
				request.setAttribute("fechahasta", fechaEntrada2);
				break;
			case m05bConstantes.INF_BUSCMATRI:
				logger.info("BUSQUEDA DE MATRICULA POR GASTO Y DA");
				fechaEntrada = request.getParameter("fechaEntrada");
				double importe=Double.parseDouble(request.getParameter("importe").replace(',', '.'));
				request.setAttribute("matriculas",m05bGastosService.getInstance().getMatriculas(fechaEntrada, importe, idioma));
				request.setAttribute("fecha",fechaEntrada);
				request.setAttribute("importe", request.getParameter("importe"));
				resultado = m05bConstantesPaginas.PRC_INFORMESBUSCVEHICULOSLISTA;
				break;
			case m05bConstantes.INF_TASAS:
				logger.info("listado de tasas");
				ArrayList<m05bTasasMunicipio> res=m05bMunicipiosService.getInstance().getTasas(municipio, situaciones, idioma, m05bPaginator.INITPAGE);
				request.setAttribute("numpaginas", res.get(0).getNumeroPaginas());
				request.setAttribute("numeroRegistros", res.get(0).getNumeroRegistros());
				res.remove(0);	
				request.setAttribute("listadatos", res);
				request.setAttribute("municipio", municipio);
				request.setAttribute("tipoInforme", tipoInforme);
				request.setAttribute("situaciones", situaciones);
				resultado=m05bConstantesPaginas.PRC_INFORMESTASASFORMLISTA;
				break;
			case m05bConstantes.INF_SANCIONES:
				logger.info("listado de sanciones");
				ArrayList<m05bSancion> res1=m05bSancionesService.getInstance().getSanciones(m05bPaginator.INITPAGE, identificado, anio, rangos);
				request.setAttribute("numpaginas", res1.get(0).getNumeroPaginas());
				request.setAttribute("numeroRegistros", res1.get(0).getNumeroRegistros());
				res1.remove(0);
				request.setAttribute("listadatos", res1);
				request.setAttribute("tipoInforme", tipoInforme);

				request.setAttribute("anio", anio);
				request.setAttribute("identificado", request.getParameter("identificado"));
				request.setAttribute("listarangos", request.getParameterMap().get("rangos"));

				resultado=m05bConstantesPaginas.PRC_INFORMESSANCIONESFORMLISTA;
				break;
			default:
				break;
			}
			logger.info("Bajas empieza a escribir el JSP" + resultado);
			RequestDispatcher requestDispatcher;
			requestDispatcher = request.getRequestDispatcher(resultado);
			requestDispatcher.forward(request, response);
		} catch (Exception e) {
			////miLog.addTraza(e);
			StackTraceElement[] stackTraceElements = Thread.currentThread()
					.getStackTrace();
			for (StackTraceElement stackTrace : stackTraceElements) {
				logger.error(stackTrace.getClassName() + "  "
						+ stackTrace.getMethodName() + " "
						+ stackTrace.getLineNumber());
			}
		}
	}

}
