package informesServlet;

import java.io.IOException;
import java.util.ArrayList;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import m05bClasses.m05bConstantes;
import m05bClasses.m05bConstantesInformes;
import m05bClasses.m05bConstantesPaginas;
import m05bDaos.m05bPaginator;
import m05bIdioma.m05bCResources;
import m05bServices.m05bAsignacionesService;
import m05bServices.m05bCTKService;
import m05bServices.m05bMunicipiosService;
import m05bServices.m05bOrdenesTrabajoService;
import m05bServices.m05bSancionesService;
import m05bServices.m05bVistaVehiculosService;
import n05bModelosVistas.m05bCombustible;
import n05bModelosVistas.m05bSancion;
import n05bModelosVistas.m05bTasasMunicipio;

import org.apache.log4j.Logger;

public class m05bInformesAjaxControllerServlet extends
		javax.servlet.http.HttpServlet {
	/**
	 * 
	 */
	private static final long serialVersionUID = 4982885644901979955L;
	private static Logger logger = Logger
			.getLogger(m05bInformesAjaxControllerServlet.class);
	java.sql.Connection conn = null;

	public static final String FO_REQUEST_PARAM = "fo";

	// Logger log = null;

	public void doPost(javax.servlet.http.HttpServletRequest request,
			javax.servlet.http.HttpServletResponse response)
			throws javax.servlet.ServletException, java.io.IOException {
		try {
			doGet(request, response);
		} catch (Exception e) {
			//miLog.addTraza(e);
		}
	}

	public void doGet(HttpServletRequest request, HttpServletResponse response)
			throws ServletException, IOException {
		performTask(request, response);
	}

	/**
	 * Initializes the servlet.
	 */
	public void init() {
		// insert code to initialize the servlet here

	}

	/**
	 * Realiza la funcin de controlador de informes
	 * 
	 * @param request
	 * @param response
	 * @throws ServletException
	 * @throws IOException
	 */
	public void performTask(javax.servlet.http.HttpServletRequest request,
			javax.servlet.http.HttpServletResponse response)
			throws ServletException, IOException {

		// Se obtiene el tipo informe y el formato

		crearAjax(request, response);

	}

	/**
	 * Crear un html
	 * 
	 * @param request
	 * @param response
	 * @throws ServletException
	 * @throws IOException
	 */
	private void crearAjax(javax.servlet.http.HttpServletRequest request,
			javax.servlet.http.HttpServletResponse response)
			throws ServletException, IOException {
		try {
			// Se obtiene el tipo informe y el formato
			int tipoInforme = Integer.parseInt(request
					.getParameter("tipoInforme"));
			String fechadev1, fechadev2, fechadec1, fechadec2, fechaEntrada1, fechaEntrada2;
			String[] cargos;
			
			int anio = 2012, tipoTaller;
			if (request.getParameter("anio") != null)
				anio = Integer.parseInt(request.getParameter("anio"));
			String[] situaciones = request.getParameterValues("situaciones");
			String[] departamentos = request
					.getParameterValues("departamentos");
			String[] rangos = request.getParameterValues("rangos");
			
			String municipio="";
			if (request.getParameter("municipio") != null) {
				municipio=request.getParameter("municipio");
			}
			String identificado="";
			if (request.getParameter("identificado") != null) {
				identificado=request.getParameter("identificado");
				if (identificado != null) {
					if (identificado.equals("0")) {
						identificado = "";
					} else if (identificado.equals("2")) {
						identificado = "0";
					}
				}
			}

			logger.info("Creando HTML con los parmetros enviados. Tipo informe: "
					+ tipoInforme);
			response.setContentType("application/json");
			HttpSession session = request.getSession(true);
			StringBuffer salida=null;
			String idioma=	"";
			
			int pagina=Integer.parseInt(request.getParameter("numPagina"));
			try{
				idioma=	((m05bCResources)	session.getAttribute("IdiomaActual")).getIdiomaActual();
				}
				catch(Exception e){
					idioma=m05bConstantesInformes.CASTELLANO;
				}
				String localeStr="dd/MM/yyyy";
				if(!idioma.equals(m05bConstantesInformes.CASTELLANO))
						 localeStr="yyyy/MM/dd";
				request.setAttribute("formatoFecha",localeStr);
			int tipoConsulta;
			utiliServlet.m05bJson creator=new utiliServlet.m05bJson(idioma);
			switch (tipoInforme) {
				case m05bConstantes.INF_ALTASVEHICULOS:// Altas por ao
					logger.info("Altas llamando al DAO y creando excel");
					salida=creator.createJsonAltas(m05bVistaVehiculosService.getInstance()
							.altasPorAnio(anio, situaciones,idioma,pagina));

					break;
				case m05bConstantes.INF_BAJASVEHICULOS:// Altas por ao
					logger.info("Bajas llamando al DAO y creando excel");
					salida=creator.createJsonBajas(m05bVistaVehiculosService.getInstance()
							.bajasPorAnio(anio, departamentos, rangos,idioma,pagina));
					break;
				case m05bConstantes.INF_ASIGPORTIPOVEH:
					String fechaasig1 = request.getParameter("fechaasigdesde"); 
					String fechaasig2 = request.getParameter("fechaasighasta");
					 fechadev1 = request.getParameter("fechadesde");
					 fechadev2 = request.getParameter("fechahasta");
					 fechadec1 = request.getParameter("fechadecretodesde");
					 fechadec2 = request.getParameter("fechadecretohasta");
					 cargos = request.getParameterValues("cargos");
					logger.info("Asignaciones por tipo de vehiculo llamando al DAO y creando excel");
					salida=creator.createJsonAsignacionesPorVeh(
							m05bAsignacionesService
									.getInstance()
									.asignacionesPorTipo(rangos,fechaasig1,fechaasig2, fechadev1,
											fechadev2, fechadec1, fechadec2, cargos,departamentos,idioma,pagina));
					break;
				case m05bConstantes.INF_ASIGFECHAS:
					fechadev1 = request.getParameter("fechadesde");
					fechadev2 = request.getParameter("fechahasta");
					logger.info("Asignaciones fechas llamando al DAO y creando excel");
					salida=creator.createJsonAsignacionesFechas(
							m05bAsignacionesService.getInstance()
									.asignacionesPorFecha(fechadev1, fechadev2,
											rangos,idioma,pagina));

					break;
				case m05bConstantes.INF_ASIGPERSONAS:
					logger.info("Asignaciones por personas llamando al DAO y creando excel");
					salida=creator.createJsonAsignacionesPersonas(m05bAsignacionesService
							.getInstance().asignacionesPorPersonas(anio + "",idioma,pagina));

					break;
				case m05bConstantes.INF_ASIGVIVAS:
					logger.info("Asignaciones vivas llamando al DAO y creando excel");
					salida=creator.createJsonAsignacionesVivas(m05bAsignacionesService
							.getInstance().asignacionesVivas(departamentos,idioma,pagina));
					break;
				case m05bConstantes.INF_COCHES:
					logger.info("coches llamando al DAO y creando excel");
					String[] tipos = request.getParameterValues("tipocoche");
					salida=creator.createJsonCoches(m05bVistaVehiculosService.getInstance()
							.cocherPorTipo(rangos, situaciones,departamentos,idioma,pagina));
					break;
				case m05bConstantes.INF_CONDUCTORES:
					String[] marcas = request.getParameterValues("marcas2");
					String[] modelos = request.getParameterValues("modelos");
					String disponible = request.getParameter("disponible");
					logger.info("Inf_conductores llamando al DAO y creando excel");
					salida=creator.createJsonConductores(
							m05bAsignacionesService.getInstance()
									.asignacionesAConductores(marcas, modelos,
											rangos, situaciones,
											Integer.parseInt(disponible),idioma,pagina));
					break;
				case m05bConstantes.INF_CTKAMORTIZACION:
					fechadev1 = request.getParameter("fechadesde");
					fechadev2 = request.getParameter("fechahasta");
					String tipoAmoritzacion = request
							.getParameter("tipoAmortizacion");
					logger.info("CTK amortizacion llamando al DAO y creando excel");
					if (tipoAmoritzacion.equals("0")) {
						logger.info("resumen");
						salida=creator.createJsonCTKAmortizacion(m05bCTKService
								.getInstance().amortizacion(fechadev1, fechadev2,idioma,pagina));
					} else {
						logger.info("base");
						salida=creator.createJsonCTKAmortizacionBase(
								m05bCTKService.getInstance().amortizacionBase(
										fechadev1, fechadev2,idioma,pagina));
					}
					break;
				case m05bConstantes.INF_LISTADOGENERAL:// Listado general
					logger.info("Listado general llamando al DAO y creando excel");
					salida=creator.createJsonListadoGeneral(
							(ArrayList) m05bVistaVehiculosService.getInstance()
									.listadoGeneral(situaciones,idioma,pagina));
					break;
				case m05bConstantes.INF_LISTADOORDENES:// Ordenes
					logger.info("Ordenes de trabajo llamando al DAO y creando excel");
					 fechaEntrada1 = request.getParameter("fechaEntrada1");
					 fechaEntrada2 = request.getParameter("fechaEntrada2");
					String fechaSalida1 = request.getParameter("fechaSalida1");
					String fechaSalida2 = request.getParameter("fechaSalida2");
					 tipoTaller = Integer.parseInt(request
							.getParameter("tipoTaller"));
					tipoConsulta = Integer.parseInt(request
							.getParameter("tipoConsulta"));
					if (tipoConsulta == m05bConstantes.INF_TIPOLISTADO) {
						logger.info("Listado");
						salida=creator.createJsonOrdenes(
								m05bOrdenesTrabajoService.getInstance().ordenes(
										fechaEntrada1, fechaEntrada2, fechaSalida1,
										fechaSalida2, tipoTaller,idioma,pagina));
					} else if (tipoConsulta == m05bConstantes.INF_TIPORESUMEN) {
						logger.info("Agrupado1");
						salida=creator.createJsonOrdenesFechasAgrup(
								m05bOrdenesTrabajoService.getInstance()
										.ordenesAgrup(fechaEntrada1, fechaEntrada2,
												fechaSalida1, fechaSalida2,
												tipoTaller,idioma,pagina));
					} else {
						logger.info("Agrupado Rango");
						salida=creator.createJsonOrdenesRangoAgrup(
								m05bOrdenesTrabajoService.getInstance()
										.ordenesAgrupRango(fechaEntrada1,
												fechaEntrada2, fechaSalida1,
												fechaSalida2, tipoTaller,idioma,pagina));
					}
					break;
				case m05bConstantes.INF_LISTADOORDENESDETALLE:// ordenes de trabajo
																// detalle
					logger.info("Ordenes de trabajo detalle llamando al DAO y creando excel");
					String fechaEntrada = request.getParameter("fechaEntrada");
					String matricula = request.getParameter("matricula");
					salida=creator.createJsonOrdenesDetalle(m05bOrdenesTrabajoService
							.getInstance().ordenesDetalle(fechaEntrada, matricula,idioma,pagina));
					break;

				case m05bConstantes.INF_LISTADOORDENESFECHAS:
					fechaEntrada1 = request.getParameter("fechaEntrada1");
					fechaEntrada2 = request.getParameter("fechaEntrada2");
					tipoTaller = Integer.parseInt(request
							.getParameter("tipoTaller"));
					tipoConsulta = Integer.parseInt(request
							.getParameter("tipoConsulta"));
					logger.info("Ordenes de trabajo por fechas llamando al DAO y creando excel");
					if (tipoConsulta == m05bConstantes.INF_TIPOLISTADO) {
						logger.info("resumen");
						salida=creator.createJsonOrdenesFechas(
								m05bOrdenesTrabajoService.getInstance()
										.ordenesporFecha(fechaEntrada1,
												fechaEntrada2, tipoTaller,idioma,pagina));
					} else {
						logger.info("Agrupado");
						salida=creator.createJsonOrdenesFechasAgrup(
								m05bOrdenesTrabajoService.getInstance()
										.ordenesporFechaAgrup(fechaEntrada1,
												fechaEntrada2, tipoTaller,idioma,pagina));
					}

					break;
				case m05bConstantes.INF_CTKCOMBUSTIBLE:
					fechadev1 = request.getParameter("fechadesde");
					fechadev2 = request.getParameter("fechahasta");
					String tipoAmortizacion = request
							.getParameter("tipoAmortizacion");
					logger.info("CTK combustible : llamando al DAO");

					ArrayList<m05bCombustible> aux;
					if (tipoAmortizacion.equals("0")) {
						logger.info("Resumen combustible");
						aux = m05bCTKService.getInstance().combustible(fechadev1,
								fechadev2,idioma,pagina);
						salida=creator.createJsonCtkCombustibleResumen(aux);

					} else if (tipoAmortizacion.equals("2")) {
						logger.info("Combustible banco");
						aux = m05bCTKService.getInstance().combustibleBanco(
								fechadev1, fechadev2,idioma,pagina);
						salida=creator.createJsonCtkCombustible(aux);
					} else if (tipoAmortizacion.equals("1")) {
						logger.info("Combustible Gastos");
						aux = m05bCTKService.getInstance().combustibleGastos(
								fechadev1, fechadev2,idioma,pagina);
						salida=creator.createJsonCtkCombustible(aux);
					} else {// AmortizacionBase
						logger.info("Combustible total");
						aux = m05bCTKService.getInstance().combustibleTotal(
								fechadev1, fechadev2,idioma,pagina);
						salida=creator.createJsonCtkCombustible(aux);
					}

					break;

				case m05bConstantes.INF_CTKKILOMETRAJE:
					tipoAmortizacion = request.getParameter("tipoAmortizacion");
					logger.info("CTK kilometros:");
					if (tipoAmortizacion.equals("1")) {
						logger.info("Informe base");
						fechaEntrada1 = request.getParameter("fechadesde");
						fechaEntrada2 = request.getParameter("fechahasta");
						salida=creator.createJsonCTKKilometrosBase(
								m05bCTKService.getInstance().kilometrajesBase(
										fechaEntrada1, fechaEntrada2,idioma,pagina));

					} else {
						logger.info("Informe resumen");
						
						String personaCodigo = (String) session
								.getAttribute("personaCodigo");
						salida=creator.createJsonCTKKilometros(m05bCTKService.getInstance()
								.kilometrosRecorrido(personaCodigo,idioma,pagina));
					}
					break;
				case m05bConstantes.INF_CTKVEHICULOS:
					logger.info("CTK Vehiculos");
					tipoAmortizacion = request.getParameter("tipoAmortizacion");
					fechaEntrada1 = request.getParameter("fechadesde");
					fechaEntrada2 = request.getParameter("fechahasta");
					if (tipoAmortizacion.equals("1")) {
						logger.info("CTK vehiculos de altas entre fechas");		
						salida=creator.createJsonCTKVehiculosBase(
								m05bCTKService.getInstance()
										.getVehiculosAltaEntreFechas(fechaEntrada1,
												fechaEntrada2,idioma,pagina));

					} else if(tipoAmortizacion.equals("0")){	
						logger.info("CTK Nmero medio de vehiculos");	
						salida=creator.createJsonCTKVehiculos(m05bCTKService.getInstance()
								.getMediaVehiculos(fechaEntrada1, fechaEntrada2,idioma,pagina));
					}
					else{
						logger.info("CTK Nmero de vehiculos");
						salida=creator.createJsonCTKVehiculosNUM(m05bCTKService.getInstance()
								.numeroVehiculos(fechaEntrada2,idioma,pagina));
					}
					break;
				case m05bConstantes.INF_TASAS:
					logger.info("listado de tasas");
					ArrayList<m05bTasasMunicipio> res=m05bMunicipiosService.getInstance().getTasas(municipio, situaciones, idioma, pagina);
					salida=creator.createJsonTasas(res);
					break;
				case m05bConstantes.INF_SANCIONES:
					logger.info("listado de sanciones");
					ArrayList<m05bSancion> res1=m05bSancionesService.getInstance().getSanciones(pagina, identificado, anio, rangos);
					salida=creator.createJsonSanciones(res1);
					break;
				default:
					break;
			}
			logger.info("Bajas empieza a escribir el JOSN" +salida);
			response.getWriter().write(salida.toString());
		} catch (Exception e) {
			
			StackTraceElement[] stackTraceElements = Thread.currentThread()
					.getStackTrace();
			for (StackTraceElement stackTrace : stackTraceElements) {
				logger.error(stackTrace.getClassName() + "  "
						+ stackTrace.getMethodName() + " "
						+ stackTrace.getLineNumber());
			}
		}
	}
}