package informesServlet;

import java.io.IOException;

import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import m05bClasses.m05bConstantes;
import m05bClasses.m05bConstantesInformes;
import m05bClasses.m05bConstantesPaginas;
import m05bIdioma.m05bCResources;
import m05bServices.m05bAsignacionesService;
import m05bServices.m05bCTKService;
import m05bServices.m05bMunicipiosService;
import m05bServices.m05bVistaVehiculosService;

import org.apache.log4j.Logger;

public class m05bFormulariosInformesControllerServlet extends
		javax.servlet.http.HttpServlet {
	/**
	 * 
	 */
	private static final long serialVersionUID = 4982885644901979955L;

	java.sql.Connection conn = null;

	public static final String FO_REQUEST_PARAM = "fo";
	private static Logger logger = Logger.getLogger(m05bFormulariosInformesControllerServlet.class);
	// Logger log = null;

	public void doPost(javax.servlet.http.HttpServletRequest request,
			javax.servlet.http.HttpServletResponse response)
			throws javax.servlet.ServletException, java.io.IOException {
		try {
			doGet(request, response);
		} catch (Exception e) {
			StackTraceElement[] stackTraceElements = Thread.currentThread()
			.getStackTrace();
	for (StackTraceElement stackTrace : stackTraceElements) {
		logger.error(stackTrace.getClassName() + "  "
				+ stackTrace.getMethodName() + " "
				+ stackTrace.getLineNumber());
	}
		}
	}

	public void doGet(HttpServletRequest request, HttpServletResponse response)
			throws ServletException, IOException {
		performTask(request, response);
	}

	/**
	 * Initializes the servlet.
	 */
	public void init() {
		// insert code to initialize the servlet here

	}

	/**
	 * Realiza la funcin de controlador de informes
	 * 
	 * @param request
	 * @param response
	 * @throws ServletException
	 * @throws IOException
	 */
	public void performTask(javax.servlet.http.HttpServletRequest request,
			javax.servlet.http.HttpServletResponse response)
			throws ServletException, IOException {

		// Se obtiene el tipo informe y el formato
		int tipoInforme = Integer.parseInt(request.getParameter("tipoInforme"));
		String resultado = "";
		logger.info("Se ha pedido un nuevo formuloario: tipoFormulario="+tipoInforme);
		HttpSession session = request.getSession(true);
		String idioma=	"";
		try{
			idioma=	((m05bCResources)	session.getAttribute("IdiomaActual")).getIdiomaActual();
			}
			catch(Exception e){
				idioma=m05bConstantesInformes.CASTELLANO;
			}
		
		switch (tipoInforme) {
		case m05bConstantes.INF_ALTASVEHICULOS:// Altas por ao
			logger.info("Altas por ao");
			request.setAttribute("listaanios", m05bVistaVehiculosService
					.getInstance().getAniosAlta());
			request.setAttribute("listasituaciones", m05bVistaVehiculosService
					.getInstance().getSituaciones(idioma,-1));
			
			resultado = m05bConstantesPaginas.PRC_INFORMESALTASFORM;
	
			break;
		case m05bConstantes.INF_BAJASVEHICULOS:// Bajas por ao
			logger.info("Bajas por ao");
			request.setAttribute("listaanios", m05bVistaVehiculosService
					.getInstance().getAniosBaja());
			request.setAttribute("listadepartamentos", m05bVistaVehiculosService
					.getInstance().getDepartamentos(idioma,-1));
			request.setAttribute("listarangos", m05bVistaVehiculosService
					.getInstance().getRangos(idioma,-1));
			resultado = m05bConstantesPaginas.PRC_INFORMESBAJASFORM;
			//resultado = "/m05bInformeBajasJsp.jsp";
			break;
		case m05bConstantes.INF_ASIGPORTIPOVEH://Asignaciones por tipos de vehiculos
			logger.info("Asignaciones por tipo de vehculos");
			request.setAttribute("listacargos", m05bAsignacionesService
					.getInstance().getCargos(idioma,-1));
			request.setAttribute("listarangos", m05bAsignacionesService
					.getInstance().getRangos(idioma,-1));
			request.setAttribute("listadepartamentos", m05bVistaVehiculosService
					.getInstance().getDepartamentos(idioma,-1));
			resultado = m05bConstantesPaginas.PRC_INFORMESASIGNACIONESPORVEH;
			break;
		case m05bConstantes.INF_ASIGFECHAS://Asignaciones por tipos de vehiculos
			logger.info("Asignaciones por fechas");
			request.setAttribute("listarangos", m05bAsignacionesService
					.getInstance().getRangos(idioma,-1));
			resultado = m05bConstantesPaginas.PRC_INFORMESASIGNACIONESFECHAS;
			break;
		case m05bConstantes.INF_ASIGPERSONAS:
			logger.info("Asignaciones personas");
			resultado = m05bConstantesPaginas.PRC_INFORMESASIGNACIONESPERSONAS;
			break;
		case m05bConstantes.INF_ASIGVIVAS:
			logger.info("Asignaciones vivas-->no hay formulario");
			request.setAttribute("listadepartamentos", m05bVistaVehiculosService
					.getInstance().getDepartamentos(idioma,-1));
			//resultado="/m05bInformesControllerServlet?formatoInforme=0&tipoInforme="+m05bConstantes.INF_ASIGVIVAS;
			resultado = m05bConstantesPaginas.PRC_INFORMESASIGNACIONESVIVAS;
			break;
		case m05bConstantes.INF_COCHES:
			logger.info("CONCHES");
			request.setAttribute("listasituaciones", m05bVistaVehiculosService
					.getInstance().getSituaciones(idioma,-1));
			request.setAttribute("listarangos", m05bVistaVehiculosService
					.getInstance().getRangos(idioma,-1));
			request.setAttribute("listadepartamentos", m05bVistaVehiculosService
					.getInstance().getDepartamentos(idioma,-1));
			resultado = m05bConstantesPaginas.PRC_INFORMESCOCHES;
			break;
		case m05bConstantes.INF_CONDUCTORES:
			logger.info("Conductores");
			request.setAttribute("listaMarcas", m05bVistaVehiculosService
					.getInstance().getMarcas(idioma,-1));
			request.setAttribute("listarangos", m05bVistaVehiculosService
					.getInstance().getRangos(idioma,-1));
			request.setAttribute("listasituaciones", m05bVistaVehiculosService
					.getInstance().getSituaciones(idioma,-1));
			resultado = m05bConstantesPaginas.PRC_INFORMESCONDUCTORES;
			break;
		case m05bConstantes.INF_CTKAMORTIZACION:
			logger.info("CTK amortizacion");
			resultado=m05bConstantesPaginas.PRC_INFORMESCTKAMORTIZACIONFORM;
			break;
		case m05bConstantes.INF_LISTADOGENERAL:
			logger.info("listado general");
			request.setAttribute("listasituaciones", m05bVistaVehiculosService
					.getInstance().getSituaciones(idioma,-1));
			resultado=m05bConstantesPaginas.PRC_INFORMESLISTADOGENERAL;
			break;
		case m05bConstantes.INF_LISTADOORDENES:
			logger.info("Ordenes de trabajo");
			resultado=m05bConstantesPaginas.PRC_INFORMESORDENESFORM;
			break;
		case m05bConstantes.INF_LISTADOORDENESDETALLE:
			logger.info("Detalle ordenes de trabajo");
			resultado=m05bConstantesPaginas.PRC_INFORMESORDENESDETALLEFORM;
			break;
		case m05bConstantes.INF_LISTADOORDENESFECHAS:
			logger.info("Ordenes de trabajo entre fechas");
			resultado=m05bConstantesPaginas.PRC_INFORMESORDENESFECHASFORM;
			break;
		case m05bConstantes.INF_CTKCOMBUSTIBLE:
			logger.info("CTK Combustible. Se carga la vista del formulario.");
			resultado=m05bConstantesPaginas.PRC_INFORMESCTKCOMBUSTIBLEFORM;
			break;
		case m05bConstantes.INF_CTKKILOMETRAJE:
			logger.info("CTK kilometraje");
			resultado=m05bConstantesPaginas.PRC_INFORMESCTKKILOMETRAJESFORM;
			break;
		case m05bConstantes.INF_CTKVEHICULOS:
			logger.info("CTK vehculos");
			resultado=m05bConstantesPaginas.PRC_INFORMESCTKVEHICULOSFORM;
			break;
		case m05bConstantes.INF_BUSCMATRI:
			logger.info("Busqueda vehiculos");
			resultado=m05bConstantesPaginas.PRC_INFORMESBUSCVEHICULOSFORM;
			break;
		case m05bConstantes.INF_TASAS:
			logger.info("listado de tasas");
			request.setAttribute("listasituaciones", m05bVistaVehiculosService
					.getInstance().getSituaciones(idioma,-1));
			request.setAttribute("listamunicipios", m05bMunicipiosService
					.getInstance().getMunicipio());
			resultado=m05bConstantesPaginas.PRC_INFORMESTASASFORM;
			break;
		case m05bConstantes.INF_SANCIONES:
			logger.info("listado de tasas");
			request.setAttribute("listaanios", m05bVistaVehiculosService
					.getInstance().getAniosAlta());
			request.setAttribute("listarangos", m05bVistaVehiculosService
					.getInstance().getRangos(idioma,-1));
			request.setAttribute("listasituaciones", m05bVistaVehiculosService
					.getInstance().getSituaciones(idioma,-1));
			request.setAttribute("listamunicipios", m05bMunicipiosService
					.getInstance().getMunicipio());
			resultado=m05bConstantesPaginas.PRC_INFORMESSANCIONESFORM;
			break;
		default:
			break;
		}
		RequestDispatcher requestDispatcher;
		requestDispatcher = request.getRequestDispatcher(resultado);
		requestDispatcher.forward(request, response);
	}
}