package gastostarjetaServlet;

import java.io.IOException;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.StringTokenizer;

import javax.servlet.http.HttpSession;

import m05bClasses.m05bComun;
import m05bClasses.m05bConstantes;
import m05bClasses.m05bFileLog;
import m05bClasses.m05bPaginacion.m05bValueObject.m05bPagGastos;


/**
 * Inserte aqu la descripcin del tipo.
 * Fecha de creacin: (17/06/05)
 */
public class m05bPaginaGastosTarjServlet extends javax.servlet.http.HttpServlet {m05bFileLog miLog = new m05bFileLog();
/**
 * Process incoming HTTP POST requests
 *
 * @param request Object that encapsulates the request to the servlet
 * @param response Object that encapsulates the response from the servlet
 */
	java.sql.Connection conn=null;
	
    String persona = "";
    
public void doPost(javax.servlet.http.HttpServletRequest request, javax.servlet.http.HttpServletResponse response) throws javax.servlet.ServletException, java.io.IOException {

	performTask(request, response);

}
/**
 * Returns the servlet info string.
 */
public String getServletInfo() {

	return super.getServletInfo();

}
/**
 * Initializes the servlet.
 */
public void init() {
	// insert code to initialize the servlet here
}

/**
 * Actualiza la ubicacion del vehculo.
 */
public HashMap fncUpdate(HashMap mapaGastos, String codigo, String km, String litros, String verificacion, String matricula, String fecha, String sSeleccionado) 
		throws java.lang.Exception {
	
	if(sSeleccionado.equals("S")){
		if(!mapaGastos.containsKey(codigo)){
			m05bPagGastos obj = new m05bPagGastos();
			obj.setCodigo(codigo);
			obj.setKm(km);
			obj.setLitros(litros);
			obj.setVerificacion(verificacion);
			obj.setFecha(fecha);
			obj.setMatricula(matricula);
			obj.setSeleccionado(sSeleccionado);
			mapaGastos.put(codigo, obj);		
		}else{
			//Lo machaco
			m05bPagGastos obj = (m05bPagGastos)mapaGastos.get(codigo);
			obj.setCodigo(codigo);
			obj.setKm(km);
			obj.setLitros(litros);
			obj.setVerificacion(verificacion);
			obj.setFecha(fecha);
			obj.setMatricula(matricula);
			obj.setSeleccionado(sSeleccionado);
			mapaGastos.put(codigo, obj);
		}
	}else{
		if(mapaGastos.containsKey(codigo)){
			//Tendr que deseleccionarlo del hashMap de sesin
			m05bPagGastos obj = (m05bPagGastos)mapaGastos.get(codigo);
			obj.setSeleccionado(sSeleccionado);
			mapaGastos.put(codigo, obj);
		}
	}
	return mapaGastos;  
}  // Fin funcion fncUpdate
/**
 * Process incoming requests for information
 *
 * @param request Object that encapsulates the request to the servlet
 * @param response Object that encapsulates the response from the servlet
 */
public void performTask(javax.servlet.http.HttpServletRequest request, javax.servlet.http.HttpServletResponse response) {
	String sRegistro, sTipoAct, sOrden, sPaginaActual, sCodigo, sKm, sLitros, sVerificacion, sFecha, sLista, sURL="", sTipo="", sMatricula="", sSeleccionado;
    m05bComun miComun = new m05bComun();
    HashMap mapaGastos = null;
    try  {
	     HttpSession session = request.getSession(true);
    	 persona = (String)session.getAttribute("persona");
         sMatricula = request.getParameter("Matricula");
         sLista = request.getParameter("listaBD");
         sTipo = request.getParameter("Tipo")== null?"T":request.getParameter("Tipo");
         sOrden = request.getParameter("Orden")== null?"T":request.getParameter("Orden");
         sPaginaActual = request.getParameter("paginaActual")== null?"T":request.getParameter("paginaActual");
         sTipoAct = request.getParameter("tipoAct")== null?"":request.getParameter("tipoAct");
         
         //Obtengo el mapa de gastos
         if(sTipoAct.equals("Pagina")){
         	if(session.getAttribute("__mapaGastos")==null){
         		mapaGastos = new HashMap();
         	}else{
         		mapaGastos = (HashMap)session.getAttribute("__mapaGastos");
         	}
         }
         miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC, "LISTA: " + sLista, m05bConstantes.LOG_NIVEL_BAJO);
         miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC, "TIPO: " + sTipo, m05bConstantes.LOG_NIVEL_BAJO);
		 String delimReg= "@", delimDato="#";
		 StringTokenizer stReg = new StringTokenizer(sLista,delimReg);
		 while (stReg.hasMoreTokens()) {
		         sRegistro=stReg.nextToken();
				 sCodigo=""; sKm=""; sLitros="0"; sVerificacion="";sSeleccionado="N";
				 StringTokenizer stDato = new StringTokenizer(sRegistro,delimDato);
				 if (stDato.hasMoreTokens()) {
			         sCodigo=stDato.nextToken();
					 
			         sKm=stDato.nextToken();
					 if (sKm.equals("null"))
					 	 sKm = "0";
                     sKm=miComun.ImportesABasedatos(sKm);

					 sLitros=stDato.nextToken();
					 if (sLitros.equals("null"))
					 	 sLitros = "0";
                     
					 sVerificacion=stDato.nextToken();
					 
					 sFecha=stDato.nextToken();
					 sSeleccionado=stDato.nextToken();
					 mapaGastos=fncUpdate(mapaGastos, sCodigo, sKm, sLitros, sVerificacion, sMatricula, sFecha, sSeleccionado);
		         }  // Fin if
		 }  // Fin while
		 //Actualizamos el valor en sesin
		 session.setAttribute("__mapaGastos",mapaGastos);
		 
		 //Mantengo la informacin de los conceptos
		 Enumeration e= request.getParameterNames();
		 String aux="";
		 String valor="";
		 String conceptos ="";
		 while (e.hasMoreElements()){
		      aux=(String)e.nextElement();
		      if (aux.indexOf("chkBoxG")!=-1){
		      	valor=request.getParameter(aux);
		      	conceptos+="&"+aux+"="+valor;
		      }
		 }
		 sURL = "m05bVehGastosJsp.jsp?Matricula=" + sMatricula + "&Tipo=" +sTipo+"&Orden="+sOrden+"&paginaActual="+sPaginaActual+conceptos;
		 response.sendRedirect(sURL);
		}catch (Exception SQLException) {
			try {
	  			conn.rollback();  // Ha habido problemas, se deshacen todos los cambios
	  		} catch (SQLException e1){
	   	   		miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC, "EXCEPTION-E1: OutletMaintenanceS.service: PERFORM TASK-1 - " + e1, m05bConstantes.LOG_NIVEL_BAJO);
	  		}
			miLog.addTraza(SQLException);
			try {
				response.sendRedirect("m05bError.jsp");
			} catch (IOException e) {
				// TODO Auto-generated catch block
				miLog.addTraza(e);
			}
		}	catch(Throwable theException) {
			// uncomment the following line when unexpected exceptions
			// are occuring to aid in debugging the problem.
			miLog.addTraza(theException);
			try {
				response.sendRedirect("m05bError.jsp");
			} catch (IOException e) {
				// TODO Auto-generated catch block
				miLog.addTraza(e);
			}
		} 	finally {
			if (conn != null) {
				try {
		  			conn.close();
		  		} catch (SQLException e2){
		   	   		miLog.addTraza(m05bConstantes.LOG_NO_USER, m05bConstantes.LOG_NO_SRC, "EXCEPTION-E1: OutletMaintenanceS.service: PERFORM TASK-2 - " + e2, m05bConstantes.LOG_NIVEL_BAJO);
		   	   		try {
						response.sendRedirect("m05bError.jsp");
					} catch (IOException e) {
						// TODO Auto-generated catch block
						miLog.addTraza(e);
					}
		  		}
		  	} // Fin if
		}  // Fin finally
	
}  // Fin performTask
	
}// Fin m05bModificarGastosTarjetaServlet