package gastostarjetaServlet;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Locale;
import java.util.ResourceBundle;

import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import m05bClasses.m05bComun;
import m05bClasses.m05bConexion;
import m05bClasses.m05bConstantes;
import m05bClasses.m05bFileLog;

import org.apache.fop.apps.Driver;
import org.apache.fop.apps.FOPException;
import org.xml.sax.InputSource;

public class m05bImpGastoMensualServlet extends javax.servlet.http.HttpServlet {m05bFileLog miLog = new m05bFileLog();
	private static final int REDONDEO = BigDecimal.ROUND_HALF_UP;
	private static final int DECIMALES = 2;

	java.sql.Connection conn = null;
	String sLinea;
	String sFoFileDir = "/datos/m05b/tmp/";
	File foFileDir;
	File tmpFoFile;
	FileOutputStream tmpFoFileStream;
	m05bComun miComun = new m05bComun();
	

	String sMatricula = "";
	String sFecDesde = "";
	String sFecHasta = "";
	String sSituacion = "";
	String sTarjeta = "";
	int cont = 0;
	String sSituacionDesc = "";

	public static final String FO_REQUEST_PARAM = "fo";

	// Logger log = null;

	public void doPost(javax.servlet.http.HttpServletRequest request,
			javax.servlet.http.HttpServletResponse response)
			throws javax.servlet.ServletException, java.io.IOException {
		try {
			doGet(request, response);
		} catch (Exception e) {
			miLog.addTraza(e);
		}
	}

	public void doGet(HttpServletRequest request, HttpServletResponse response)
			throws ServletException {
		performTask(request, response);
	}

	// if(log == null)
	// {
	// Hierarchy hierarchy = Hierarchy.getDefaultHierarchy();
	// log = hierarchy.getLoggerFor("fop");
	// log.setPriority(Priority.WARN);
	// }

	private void fncAbrirFicheroTemporal() throws java.io.IOException {
		foFileDir = new File(sFoFileDir);
		tmpFoFile = File.createTempFile("m05b", "Fo", foFileDir);
		tmpFoFileStream = new FileOutputStream(tmpFoFile);

	}

	private void fncImprimirFinPagina() throws java.io.IOException {
		cont = 0;
		sLinea = "	    </fo:table-body>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "       </fo:table>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "      </fo:flow>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "   </fo:page-sequence>\n";
		tmpFoFileStream.write(sLinea.getBytes());

	}

	private void fncImprimirComienzoPagina(ResourceBundle res,String idioma) throws java.io.IOException,
			javax.naming.NamingException {
		sLinea = "<fo:page-sequence master-reference=\"general\">\n";
		tmpFoFileStream.write(sLinea.getBytes());
		// REGION BEFORE
		sLinea = "		<fo:static-content flow-name=\"xsl-region-before\" >\n";
		tmpFoFileStream.write(sLinea.getBytes());
		// -------------- CABECERA DEL LISTADO --------------
		// Cabecera 1
		sLinea = "      <fo:block text-align=\"end\">\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "      </fo:block>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "      <fo:block font-weight=\"bold\" padding-top=\"10pt\">\n "
				+ res.getString("infGastTarj.titulo") + "</fo:block>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = " 		</fo:static-content>\n";
		tmpFoFileStream.write(sLinea.getBytes());

		// PIE DE PAGINA Pie
		sLinea = "		<fo:static-content flow-name=\"xsl-region-after\">\n";
		tmpFoFileStream.write(sLinea.getBytes());
		// PIE DE PAGINA Pie
		sLinea = "      <fo:block >\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "       <fo:table table-layout=\"fixed\">\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    <fo:table-column column-width=\"80mm\"/>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    <fo:table-column column-width=\"80mm\"/>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    <fo:table-body font-family=\"Helvetica\" font-size=\"6pt\">\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    <fo:table-row>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    <fo:table-cell >\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "      <fo:block text-align=\"left\">"
				+ miComun.getDetFechaActual(idioma)
				+ "</fo:block>";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    </fo:table-cell>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    <fo:table-cell >\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "      <fo:block text-align=\"right\">";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea =res.getString("pagina")+ " <fo:page-number/> \n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "</fo:block>";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    </fo:table-cell>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    </fo:table-row>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    </fo:table-body>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "       </fo:table>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "      </fo:block>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = " 		</fo:static-content>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		// BODY
		sLinea = "	<fo:flow flow-name=\"xsl-region-body\">\n";
		tmpFoFileStream.write(sLinea.getBytes());
		// -------------- DETALLE DEL LISTADO --------------
		sLinea = "        <fo:table  table-layout=\"fixed\" space-after.optimum=\"12pt\">\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    <fo:table-column column-width=\"100mm\"/>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    <fo:table-column column-width=\"20mm\"/>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    <fo:table-column column-width=\"20mm\"/>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    <fo:table-column column-width=\"20mm\"/>\n";
		tmpFoFileStream.write(sLinea.getBytes());
		sLinea = "	    <fo:table-body font-family=\"Helvetica\" font-size=\"8pt\">\n";
		tmpFoFileStream.write(sLinea.getBytes());
	}

	public void performTask(javax.servlet.http.HttpServletRequest request,
			javax.servlet.http.HttpServletResponse response)
			throws ServletException {
		java.sql.Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		m05bComun miComun = new m05bComun();

		try {
			HttpSession session = request.getSession(true);

			/* Iker. idioma */
			Locale idiomaLocal = (Locale) session.getAttribute("Local");
			String idiomaSes = ((idiomaLocal.getLanguage() == null) ? "es"
					: idiomaLocal.getLanguage());
			String campoTexto = "";
			String campoTexto2 = "";
			String campoTexto3 = "C";
			String formatoFecha = "dd/mm/YYYY ";
			String[] textos = null;
			ResourceBundle res = (ResourceBundle) session
					.getAttribute("resTit");
			if (!idiomaSes.equals("es")) {
				campoTexto = "E";
				campoTexto2 = "E_";
				 campoTexto3 = "E";
				formatoFecha = "YYYY/mm/dd ";

			}
			m05bConexion miConex = new m05bConexion();
			conn = miConex.getConnection();

			// Obtencin de informacin de BD
			// Vehculo
			// Recogemos la situacion
			sSituacion = request.getParameter("Situacion");
			if ((sSituacion == null) || (sSituacion.equals(""))) {
				sSituacion = "";
			} else {
				sSituacion = miComun.ListaCaracteres(sSituacion);
			}
			// Recogemos Tarjeta
			sTarjeta = request.getParameter("CodTarjeta");
			if (sTarjeta == null) {
				sTarjeta = "";
			}
			// Recogemos Fecha Desde:
			sFecDesde = request.getParameter("FecDesde");
			if (sFecDesde == null) {
				sFecDesde = "";
			}
			// Recogemos Fecha Hasta:
			sFecHasta = request.getParameter("FecHasta");
			if (sFecHasta == null) {
				sFecHasta = "";
			}
			// Recogemos Matricula
			sMatricula = request.getParameter("Matricula");
			if (sMatricula == null) {
				sMatricula = "";
			}

			String sDesDpto = "";
			String sUsuario = "";
			String sFecha = "";
			String sKilometros = "";
			String sLitros = "";
			String sImporte = "";
			double dImporte = 0;
			BigDecimal BdImporte;
			BdImporte = new BigDecimal(0);

			String sImporteTotal = "";
			double dImporteTotal = 0;
			BigDecimal BdImporteTotal;
			BdImporteTotal = new BigDecimal(0);

			String sImporteTotalTipo = "";
			double dImporteTotalTipo = 0;
			BigDecimal BdImporteTotalTipo;
			BdImporteTotalTipo = new BigDecimal(0);

			String sCargo = "";
			String sTipo = "";
			String sRango = "";
			String sTarjetaAnt = "";
			String sTipoAnt = "";
			String sNCta = "";
			String sDia = "";
			String sHora = "";

			String sSituacionD = "";

			if (!(sSituacion.equals(""))) {
				String sSentenciaSituacion = " SELECT "
						+ m05bConstantes.COL_99_DESCRIPCION + " FROM "
						+ m05bConstantes.TAB_DESCRIPCIONES + "  S " + " WHERE "
						+ m05bConstantes.COL_99_CODDESC + " in (" + sSituacion
						+ ") AND " + m05bConstantes.COL_99_CODTABLA + "='"
						+ m05bConstantes.DESC_SITUACIONES + "'";
				pstmt = conn.prepareStatement(sSentenciaSituacion);
				rs = pstmt.executeQuery();
				while (rs.next()) {
					sSituacionD = rs.getString(1);
					if (!(sSituacionDesc.equals(""))) {
						sSituacionDesc = sSituacionDesc + "," + sSituacionD;
					} else {
						sSituacionDesc = sSituacionD;
					}
				}
				if (rs != null)
					rs.close();
				if (pstmt != null)
					pstmt.close();
			}

			String sSentencia = " SELECT " + m05bConstantes.COL_18_IMPORTE
					+ "," + m05bConstantes.COL_03_NOMBRE + ","
					+ m05bConstantes.COL_18_TARJETA + ","
					+ m05bConstantes.COL_18_TIPO + ","
					+ m05bConstantes.COL_18_FECHA + ","
					+ m05bConstantes.COL_18_MATRICULA + ",NVL("
					+ campoTexto2+m05bConstantes.COL_06_DESCDPTO
					+","+m05bConstantes.COL_06_DESCDPTO+") "
					+ "," + " TO_CHAR("
					+ m05bConstantes.COL_18_FECHA + ",'" + formatoFecha + "'),"
					+ " TO_CHAR(" + m05bConstantes.COL_18_FECHA
					+ ",'hh/mi/ss')" + " FROM " + m05bConstantes.TAB_OPEBANCOS
					+ "," + m05bConstantes.TAB_VEHICULOS + ","
					+  m05bConstantes.TAB_DEPARTAMENTOS + ","
					+ m05bConstantes.TAB_TARJETAS + ","
					+ m05bConstantes.TAB_BANCOS + " WHERE "
					+ m05bConstantes.COL_18_MATRICULA + "="
					+ m05bConstantes.COL_34_MATRICULA + " AND "
					+ m05bConstantes.COL_34_CODDPTO + "="
					+ m05bConstantes.COL_06_CODDPTO + " AND "
					+ m05bConstantes.COL_18_MATRICULA + "="
					+ m05bConstantes.COL_31_MATRICULA + " AND "
					+ m05bConstantes.COL_31_CUENTA + "="
					+ m05bConstantes.COL_03_NCUENTA;

			if (!(sSituacion.equals(""))) {
				sSentencia = sSentencia + " AND "
						+ m05bConstantes.COL_34_SITUACION + " in ("
						+ sSituacion + ")";
			}
			if (!(sMatricula.equals(""))) {
				sSentencia = sSentencia + " AND "
						+ m05bConstantes.COL_18_MATRICULA + " = '" + sMatricula
						+ "'";
			}
			if (!(sTarjeta.equals(""))) {
				sSentencia = sSentencia + " AND "
						+ m05bConstantes.COL_18_TARJETA + " = '" + sTarjeta
						+ "'";
			}
			if (!(sFecDesde.equals(""))) {
				sSentencia = sSentencia + " AND " + m05bConstantes.COL_18_FECHA
						+ " >= TO_DATE('" + sFecDesde + "','mm/yyyy')";
			}
			if (!(sFecHasta.equals(""))) {
				sSentencia = sSentencia + " AND " + m05bConstantes.COL_18_FECHA
						+ " <= TO_DATE('" + sFecHasta + "','mm/yyyy')";
			}

			sSentencia = sSentencia + " ORDER BY "
					+ m05bConstantes.COL_18_TARJETA + ","
					+ m05bConstantes.COL_18_TIPO;
//System.out.println(sSentencia);
			pstmt = conn.prepareStatement(sSentencia);
			rs = pstmt.executeQuery();

			fncAbrirFicheroTemporal();
			sLinea = "<?xml version=\"1.0\" encoding=\"windows-1252\"?>\n";
			tmpFoFileStream.write(sLinea.getBytes());

			sLinea = "<fo:root xmlns:fo=\"http://www.w3.org/1999/XSL/Format\">\n";
			tmpFoFileStream.write(sLinea.getBytes());
			// LAYOUT DEL LISTADO
			sLinea = "<fo:layout-master-set>\n";
			tmpFoFileStream.write(sLinea.getBytes());
			sLinea = "	<fo:simple-page-master master-name=\"general\"  page-height=\"29.5cm\" page-width=\"21cm\" margin-top=\"2cm\" margin-bottom=\"2cm\" margin-left=\"2.5cm\" margin-right=\"2.5cm\">\n";
			tmpFoFileStream.write(sLinea.getBytes());
			sLinea = "		<fo:region-before extent=\"2cm\"/>\n";
			tmpFoFileStream.write(sLinea.getBytes());
			sLinea = "		<fo:region-body  margin-top=\"2.8cm\" margin-bottom=\"1.5cm\" />\n";
			tmpFoFileStream.write(sLinea.getBytes());
			sLinea = "		<fo:region-after  extent=\"1cm\"/>\n";
			tmpFoFileStream.write(sLinea.getBytes());
			sLinea = "		<fo:region-start extent=\"0cm\"/>\n";
			tmpFoFileStream.write(sLinea.getBytes());
			sLinea = "		<fo:region-end extent=\"0cm\"/>\n";
			tmpFoFileStream.write(sLinea.getBytes());

			sLinea = "	</fo:simple-page-master>\n";
			tmpFoFileStream.write(sLinea.getBytes());

			sLinea = "</fo:layout-master-set>\n";
			tmpFoFileStream.write(sLinea.getBytes());
			int numero = 0;
			while ((rs.next()) && (numero < 2000)) {
				numero = numero + 1;
				sDesDpto = rs.getString(7) == null ? "" : rs.getString(7);
				sNCta = rs.getString(2) == null ? "" : rs.getString(2);
				sMatricula = rs.getString(6) == null ? "" : rs.getString(6);
				sDia = rs.getString(8) == null ? "" : rs.getString(8);
				sHora = rs.getString(9) == null ? "" : rs.getString(9);
				sImporte = rs.getString(1) == null ? "" : rs.getString(1);
				dImporte = Double.valueOf(sImporte).doubleValue();
				BdImporte = new BigDecimal(sImporte);

				sTipo = rs.getString(4) == null ? "" : rs.getString(4);
				sTarjeta = rs.getString(3) == null ? "" : rs.getString(3);
				if (((!(sTarjeta.equals(sTarjetaAnt))))) {
					if ((sTarjetaAnt != "")) {
						sLinea = "	    <fo:table-row >\n";
						tmpFoFileStream.write(sLinea.getBytes());
						// Tipo
						sLinea = "	    <fo:table-cell>\n";
						tmpFoFileStream.write(sLinea.getBytes());
						sLinea = "      <fo:block font-size=\"10pt\" text-align=\"left\">\n "
								+ "</fo:block>";
						tmpFoFileStream.write(sLinea.getBytes());
						sLinea = "	    </fo:table-cell>\n";
						tmpFoFileStream.write(sLinea.getBytes());
						// Fecha
						sLinea = "	    <fo:table-cell>\n";
						tmpFoFileStream.write(sLinea.getBytes());
						sLinea = "      <fo:block font-size=\"10pt\" font-weight=\"bold\"  text-align=\"center\">\n  </fo:block>\n";
						tmpFoFileStream.write(sLinea.getBytes());
						sLinea = "	    </fo:table-cell>\n";
						tmpFoFileStream.write(sLinea.getBytes());
						// Hora
						sLinea = "	    <fo:table-cell>\n";
						tmpFoFileStream.write(sLinea.getBytes());
						sLinea = "      <fo:block font-size=\"10pt\" font-weight=\"bold\"  text-align=\"center\">\n "+res.getString("infGastTarj.texto9")+" </fo:block>\n";
						tmpFoFileStream.write(sLinea.getBytes());
						sLinea = "	    </fo:table-cell>\n";
						tmpFoFileStream.write(sLinea.getBytes());
						// Importe
						sLinea = "	    <fo:table-cell>\n";
						tmpFoFileStream.write(sLinea.getBytes());
						sLinea = "      <fo:block font-size=\"10pt\" font-weight=\"bold\"  text-align=\"center\">\n "
								+ miComun
										.formatearDblMilesDec(BdImporteTotalTipo
												.doubleValue())
								+ "  </fo:block>\n";
						tmpFoFileStream.write(sLinea.getBytes());
						sLinea = "	    </fo:table-cell>\n";
						tmpFoFileStream.write(sLinea.getBytes());
						sLinea = "	    </fo:table-row>\n";
						tmpFoFileStream.write(sLinea.getBytes());
						BdImporteTotalTipo = new BigDecimal(0);

						sLinea = "	    <fo:table-row >\n";
						tmpFoFileStream.write(sLinea.getBytes());
						// vacio
						sLinea = "	    <fo:table-cell>\n";
						tmpFoFileStream.write(sLinea.getBytes());
						sLinea = "      <fo:block font-size=\"10pt\" font-weight=\"bold\"  text-align=\"center\">\n </fo:block>\n";
						tmpFoFileStream.write(sLinea.getBytes());
						sLinea = "	    </fo:table-cell>\n";
						tmpFoFileStream.write(sLinea.getBytes());
						// Fecha
						sLinea = "	    <fo:table-cell>\n";
						tmpFoFileStream.write(sLinea.getBytes());
						sLinea = "      <fo:block font-size=\"10pt\" font-weight=\"bold\"  text-align=\"center\">\n  </fo:block>\n";
						tmpFoFileStream.write(sLinea.getBytes());
						sLinea = "	    </fo:table-cell>\n";
						tmpFoFileStream.write(sLinea.getBytes());
						// Hora
						sLinea = "	    <fo:table-cell>\n";
						tmpFoFileStream.write(sLinea.getBytes());
						sLinea = "      <fo:block font-size=\"10pt\" font-weight=\"bold\"  text-align=\"center\">\n "+res.getString("infGastTarj.texto9")+" </fo:block>\n";
						tmpFoFileStream.write(sLinea.getBytes());
						sLinea = "	    </fo:table-cell>\n";
						tmpFoFileStream.write(sLinea.getBytes());
						// Importe
						sLinea = "	    <fo:table-cell>\n";
						tmpFoFileStream.write(sLinea.getBytes());
						sLinea = "      <fo:block font-size=\"10pt\" font-weight=\"bold\"  text-align=\"center\">\n "
								+ miComun.formatearDblMilesDec(BdImporteTotal
										.doubleValue()) + "  </fo:block>\n";
						tmpFoFileStream.write(sLinea.getBytes());
						sLinea = "	    </fo:table-cell>\n";
						tmpFoFileStream.write(sLinea.getBytes());
						sLinea = "	    </fo:table-row>\n";
						tmpFoFileStream.write(sLinea.getBytes());
						BdImporteTotal = new BigDecimal(0);
						// sLinea = "	    <fo:table-row >\n";
						// tmpFoFileStream.write(sLinea.getBytes());
						sTarjetaAnt = sTarjeta;
						fncImprimirFinPagina();
					}
					fncImprimirComienzoPagina(res,campoTexto3);

					// Primera Linea
					// Tarjeta
					sLinea = "	    <fo:table-row>\n";
					tmpFoFileStream.write(sLinea.getBytes());
					sLinea = "	    <fo:table-cell border-width=\"0.1mm\" >\n";
					tmpFoFileStream.write(sLinea.getBytes());
					sLinea = "      <fo:block font-size=\"8pt\" text-align=\"left\">\n<![CDATA[ "
							+ res.getString("infGastTarj.texto1")
							+ sTarjeta
							+ res.getString("infGastTarj.texto2")
							+ sNCta
							+ res.getString("infGastTarj.texto3") + sMatricula + "]]></fo:block>";
					tmpFoFileStream.write(sLinea.getBytes());
					sLinea = "	    </fo:table-cell>\n";
					tmpFoFileStream.write(sLinea.getBytes());
					// Dia
					sLinea = "	    <fo:table-cell border-width=\"0.1mm\">\n";
					tmpFoFileStream.write(sLinea.getBytes());
					sLinea = "      <fo:block  text-align=\"center\">\n"
							+ "</fo:block>\n";
					tmpFoFileStream.write(sLinea.getBytes());
					sLinea = "	    </fo:table-cell>\n";
					tmpFoFileStream.write(sLinea.getBytes());
					// Hora
					sLinea = "	    <fo:table-cell border-width=\"0.1mm\">\n";
					tmpFoFileStream.write(sLinea.getBytes());
					sLinea = "      <fo:block  text-align=\"center\">\n"
							+ "</fo:block>\n";
					tmpFoFileStream.write(sLinea.getBytes());
					sLinea = "	    </fo:table-cell>\n";
					tmpFoFileStream.write(sLinea.getBytes());
					// Importe
					sLinea = "	    <fo:table-cell border-width=\"0.1mm\">\n";
					tmpFoFileStream.write(sLinea.getBytes());
					sLinea = "      <fo:block  text-align=\"center\">\n"
							+ "</fo:block>\n";
					tmpFoFileStream.write(sLinea.getBytes());
					sLinea = "	    </fo:table-cell>\n";
					tmpFoFileStream.write(sLinea.getBytes());
					sLinea = "	    </fo:table-row>\n";
					tmpFoFileStream.write(sLinea.getBytes());

					// Segunda Linea
					sLinea = "	    <fo:table-row >\n";
					tmpFoFileStream.write(sLinea.getBytes());
					// Tarjeta
					sLinea = "	    <fo:table-cell border-width=\"0.1mm\" >\n";
					tmpFoFileStream.write(sLinea.getBytes());
					sLinea = "      <fo:block font-size=\"8pt\" text-align=\"left\">\n <![CDATA["
							+ res.getString("infGastTarj.texto4") + sDesDpto + "]]></fo:block>";
					tmpFoFileStream.write(sLinea.getBytes());
					sLinea = "	    </fo:table-cell>\n";
					tmpFoFileStream.write(sLinea.getBytes());
					// Dia
					sLinea = "	    <fo:table-cell border-width=\"0.1mm\">\n";
					tmpFoFileStream.write(sLinea.getBytes());
					sLinea = "      <fo:block  text-align=\"center\">\n"
							+ "</fo:block>\n";
					tmpFoFileStream.write(sLinea.getBytes());
					sLinea = "	    </fo:table-cell>\n";
					tmpFoFileStream.write(sLinea.getBytes());
					// Hora
					sLinea = "	    <fo:table-cell border-width=\"0.1mm\">\n";
					tmpFoFileStream.write(sLinea.getBytes());
					sLinea = "      <fo:block  text-align=\"center\">\n"
							+ "</fo:block>\n";
					tmpFoFileStream.write(sLinea.getBytes());
					sLinea = "	    </fo:table-cell>\n";
					tmpFoFileStream.write(sLinea.getBytes());
					// Importe
					sLinea = "	    <fo:table-cell border-width=\"0.1mm\">\n";
					tmpFoFileStream.write(sLinea.getBytes());
					sLinea = "      <fo:block  text-align=\"center\">\n"
							+ "</fo:block>\n";
					tmpFoFileStream.write(sLinea.getBytes());
					sLinea = "	    </fo:table-cell>\n";
					tmpFoFileStream.write(sLinea.getBytes());
					sLinea = "	    </fo:table-row>\n";
					tmpFoFileStream.write(sLinea.getBytes());

					// Tercera Linea
					sLinea = "	    <fo:table-row>\n";
					tmpFoFileStream.write(sLinea.getBytes());
					// Tipo
					sLinea = "	    <fo:table-cell border-width=\"0.1mm\" >\n";
					tmpFoFileStream.write(sLinea.getBytes());
					sLinea = "      <fo:block font-size=\"8pt\" text-align=\"left\">\n <![CDATA["
							+ res.getString("infGastTarj.texto5") + sTipo + "]]></fo:block>";
					tmpFoFileStream.write(sLinea.getBytes());
					sLinea = "	    </fo:table-cell>\n";
					tmpFoFileStream.write(sLinea.getBytes());
					// Fecha
					sLinea = "	    <fo:table-cell>\n";
					tmpFoFileStream.write(sLinea.getBytes());
					sLinea = "      <fo:block font-weight=\"bold\" font-size=\"10pt\" text-align=\"center\">\n "+res.getString("infGastTarj.texto6")+" </fo:block>\n";
					tmpFoFileStream.write(sLinea.getBytes());
					sLinea = "	    </fo:table-cell>\n";
					tmpFoFileStream.write(sLinea.getBytes());
					// Hora
					sLinea = "	    <fo:table-cell>\n";
					tmpFoFileStream.write(sLinea.getBytes());
					sLinea = "      <fo:block font-weight=\"bold\" font-size=\"10pt\" text-align=\"center\">\n "+res.getString("infGastTarj.texto7")+" </fo:block>\n";
					tmpFoFileStream.write(sLinea.getBytes());
					sLinea = "	    </fo:table-cell>\n";
					tmpFoFileStream.write(sLinea.getBytes());
					// Importe
					sLinea = "	    <fo:table-cell>\n";
					tmpFoFileStream.write(sLinea.getBytes());
					sLinea = "      <fo:block font-weight=\"bold\" font-size=\"10pt\" text-align=\"center\">\n "+res.getString("infGastTarj.texto8")+"  </fo:block>\n";
					tmpFoFileStream.write(sLinea.getBytes());
					sLinea = "	    </fo:table-cell>\n";
					tmpFoFileStream.write(sLinea.getBytes());
					sLinea = "	    </fo:table-row>\n";
					tmpFoFileStream.write(sLinea.getBytes());
					sLinea = "	    <fo:table-row >\n";
					tmpFoFileStream.write(sLinea.getBytes());
				} else if (((!(sTipo.equals(sTipoAnt))))) {
					if (sTipoAnt != "") {
						cont = 0;
						sTipoAnt = sTipo;
						sLinea = "	    <fo:table-row >\n";
						tmpFoFileStream.write(sLinea.getBytes());
						// Tipo
						sLinea = "	    <fo:table-cell>\n";
						tmpFoFileStream.write(sLinea.getBytes());
						sLinea = "      <fo:block  text-align=\"left\">\n "
								+ "</fo:block>";
						tmpFoFileStream.write(sLinea.getBytes());
						sLinea = "	    </fo:table-cell>\n";
						tmpFoFileStream.write(sLinea.getBytes());
						// Fecha
						sLinea = "	    <fo:table-cell>\n";
						tmpFoFileStream.write(sLinea.getBytes());
						sLinea = "      <fo:block font-size=\"10pt\" font-weight=\"bold\"  text-align=\"center\">\n  </fo:block>\n";
						tmpFoFileStream.write(sLinea.getBytes());
						sLinea = "	    </fo:table-cell>\n";
						tmpFoFileStream.write(sLinea.getBytes());
						// Hora
						sLinea = "	    <fo:table-cell>\n";
						tmpFoFileStream.write(sLinea.getBytes());
						sLinea = "      <fo:block font-size=\"10pt\" font-weight=\"bold\"  text-align=\"center\">\n "+res.getString("infGastTarj.texto9")+" </fo:block>\n";
						tmpFoFileStream.write(sLinea.getBytes());
						sLinea = "	    </fo:table-cell>\n";
						tmpFoFileStream.write(sLinea.getBytes());
						// Importe
						sLinea = "	    <fo:table-cell>\n";
						tmpFoFileStream.write(sLinea.getBytes());
						sLinea = "      <fo:block font-size=\"10pt\" font-weight=\"bold\"  text-align=\"center\">\n "
								+ miComun
										.formatearDblMilesDec(BdImporteTotalTipo
												.doubleValue())
								+ "  </fo:block>\n";
						tmpFoFileStream.write(sLinea.getBytes());
						sLinea = "	    </fo:table-cell>\n";
						tmpFoFileStream.write(sLinea.getBytes());
						sLinea = "	    </fo:table-row>\n";
						tmpFoFileStream.write(sLinea.getBytes());
						BdImporteTotalTipo = new BigDecimal(0);
						// sLinea = "	    <fo:table-row>\n";
						// tmpFoFileStream.write(sLinea.getBytes());
						sTipoAnt = sTipo;
						fncImprimirFinPagina();
					}
					fncImprimirComienzoPagina(res,campoTexto3);
					// Primera Linea
					// Tarjeta
					sLinea = "	    <fo:table-row>\n";
					tmpFoFileStream.write(sLinea.getBytes());
					sLinea = "	    <fo:table-cell border-width=\"0.1mm\" >\n";
					tmpFoFileStream.write(sLinea.getBytes());
					sLinea = "      <fo:block  font-size=\"8pt\" text-align=\"left\">\n<![CDATA[ "
							+ res.getString("infGastTarj.texto1")
							+ sTarjeta
							+ res.getString("infGastTarj.texto2")
							+ sNCta
							+ res.getString("infGastTarj.texto3") + sMatricula + "]]></fo:block>";
					tmpFoFileStream.write(sLinea.getBytes());
					sLinea = "	    </fo:table-cell>\n";
					tmpFoFileStream.write(sLinea.getBytes());
					// Dia
					sLinea = "	    <fo:table-cell border-width=\"0.1mm\">\n";
					tmpFoFileStream.write(sLinea.getBytes());
					sLinea = "      <fo:block  text-align=\"center\">\n"
							+ "</fo:block>\n";
					tmpFoFileStream.write(sLinea.getBytes());
					sLinea = "	    </fo:table-cell>\n";
					tmpFoFileStream.write(sLinea.getBytes());
					// Hora
					sLinea = "	    <fo:table-cell border-width=\"0.1mm\">\n";
					tmpFoFileStream.write(sLinea.getBytes());
					sLinea = "      <fo:block  text-align=\"center\">\n"
							+ "</fo:block>\n";
					tmpFoFileStream.write(sLinea.getBytes());
					sLinea = "	    </fo:table-cell>\n";
					tmpFoFileStream.write(sLinea.getBytes());
					// Importe
					sLinea = "	    <fo:table-cell border-width=\"0.1mm\">\n";
					tmpFoFileStream.write(sLinea.getBytes());
					sLinea = "      <fo:block  text-align=\"center\">\n"
							+ "</fo:block>\n";
					tmpFoFileStream.write(sLinea.getBytes());
					sLinea = "	    </fo:table-cell>\n";
					tmpFoFileStream.write(sLinea.getBytes());
					sLinea = "	    </fo:table-row>\n";
					tmpFoFileStream.write(sLinea.getBytes());

					// Segunda Linea
					sLinea = "	    <fo:table-row >\n";
					tmpFoFileStream.write(sLinea.getBytes());
					// Tarjeta
					sLinea = "	    <fo:table-cell border-width=\"0.1mm\" >\n";
					tmpFoFileStream.write(sLinea.getBytes());
					sLinea = "      <fo:block font-size=\"8pt\" text-align=\"left\">\n<![CDATA[ "
							+ res.getString("infGastTarj.texto4") + sDesDpto + "]]></fo:block>";
					tmpFoFileStream.write(sLinea.getBytes());
					sLinea = "	    </fo:table-cell>\n";
					tmpFoFileStream.write(sLinea.getBytes());
					// Dia
					sLinea = "	    <fo:table-cell border-width=\"0.1mm\">\n";
					tmpFoFileStream.write(sLinea.getBytes());
					sLinea = "      <fo:block  text-align=\"center\">\n"
							+ "</fo:block>\n";
					tmpFoFileStream.write(sLinea.getBytes());
					sLinea = "	    </fo:table-cell>\n";
					tmpFoFileStream.write(sLinea.getBytes());
					// Hora
					sLinea = "	    <fo:table-cell border-width=\"0.1mm\">\n";
					tmpFoFileStream.write(sLinea.getBytes());
					sLinea = "      <fo:block  text-align=\"center\">\n"
							+ "</fo:block>\n";
					tmpFoFileStream.write(sLinea.getBytes());
					sLinea = "	    </fo:table-cell>\n";
					tmpFoFileStream.write(sLinea.getBytes());
					// Importe
					sLinea = "	    <fo:table-cell border-width=\"0.1mm\">\n";
					tmpFoFileStream.write(sLinea.getBytes());
					sLinea = "      <fo:block  text-align=\"center\">\n"
							+ "</fo:block>\n";
					tmpFoFileStream.write(sLinea.getBytes());
					sLinea = "	    </fo:table-cell>\n";
					tmpFoFileStream.write(sLinea.getBytes());
					sLinea = "	    </fo:table-row>\n";
					tmpFoFileStream.write(sLinea.getBytes());
					sLinea = "	    <fo:table-row>\n";
					tmpFoFileStream.write(sLinea.getBytes());
					// Tarjeta
					sLinea = "	    <fo:table-cell>\n";
					tmpFoFileStream.write(sLinea.getBytes());
					sLinea = "      <fo:block font-size=\"8pt\" text-align=\"left\">\n <![CDATA["
							+ res.getString("infGastTarj.texto5") + sTipo + "]]></fo:block>";
					tmpFoFileStream.write(sLinea.getBytes());
					sLinea = "	    </fo:table-cell>\n";
					tmpFoFileStream.write(sLinea.getBytes());
					// Fecha
					sLinea = "	    <fo:table-cell>\n";
					tmpFoFileStream.write(sLinea.getBytes());
					sLinea = "      <fo:block font-weight=\"bold\" font-size=\"10pt\" text-align=\"center\">\n "+res.getString("infGastTarj.texto6")+" </fo:block>\n";
					tmpFoFileStream.write(sLinea.getBytes());
					sLinea = "	    </fo:table-cell>\n";
					tmpFoFileStream.write(sLinea.getBytes());
					// Hora
					sLinea = "	    <fo:table-cell>\n";
					tmpFoFileStream.write(sLinea.getBytes());
					sLinea = "      <fo:block font-weight=\"bold\" font-size=\"10pt\" text-align=\"center\">\n "+res.getString("infGastTarj.texto7")+" </fo:block>\n";
					tmpFoFileStream.write(sLinea.getBytes());
					sLinea = "	    </fo:table-cell>\n";
					tmpFoFileStream.write(sLinea.getBytes());
					// Importe
					sLinea = "	    <fo:table-cell>\n";
					tmpFoFileStream.write(sLinea.getBytes());
					sLinea = "      <fo:block font-weight=\"bold\" font-size=\"10pt\" text-align=\"center\">\n "+res.getString("infGastTarj.texto8")+"  </fo:block>\n";
					tmpFoFileStream.write(sLinea.getBytes());
					sLinea = "	    </fo:table-cell>\n";
					tmpFoFileStream.write(sLinea.getBytes());

					sLinea = "	    </fo:table-row>\n";
					tmpFoFileStream.write(sLinea.getBytes());
					sLinea = "	    <fo:table-row >\n";
					tmpFoFileStream.write(sLinea.getBytes());
				} else {

					cont = cont + 1;
					sLinea = "	    <fo:table-row >\n";
					tmpFoFileStream.write(sLinea.getBytes());
				}

				sTarjetaAnt = sTarjeta;
				dImporteTotal = dImporteTotal + dImporte;
				BdImporteTotal = BdImporteTotal.add(BdImporte);

				sTipoAnt = sTipo;
				dImporteTotalTipo = dImporteTotalTipo + dImporte;
				BdImporteTotalTipo = BdImporteTotalTipo.add(BdImporte);

				// Vacio
				sLinea = "	    <fo:table-cell>\n";
				tmpFoFileStream.write(sLinea.getBytes());
				sLinea = "      <fo:block font-size=\"10pt\" padding-top=\"1mm\"  text-align=\"center\">\n </fo:block>\n";
				tmpFoFileStream.write(sLinea.getBytes());
				sLinea = "	    </fo:table-cell>\n";
				tmpFoFileStream.write(sLinea.getBytes());
				// Fecha
				sLinea = "	    <fo:table-cell>\n";
				tmpFoFileStream.write(sLinea.getBytes());
				sLinea = "      <fo:block font-size=\"10pt\" padding-top=\"1mm\"  text-align=\"center\">\n "
						+ sDia + " </fo:block>\n";
				tmpFoFileStream.write(sLinea.getBytes());
				sLinea = "	    </fo:table-cell>\n";
				tmpFoFileStream.write(sLinea.getBytes());
				// Hora
				sLinea = "	    <fo:table-cell>\n";
				tmpFoFileStream.write(sLinea.getBytes());
				sLinea = "      <fo:block font-size=\"10pt\" padding-top=\"1mm\"  text-align=\"center\">\n "
						+ sHora + "</fo:block>\n";
				tmpFoFileStream.write(sLinea.getBytes());
				sLinea = "	    </fo:table-cell>\n";
				tmpFoFileStream.write(sLinea.getBytes());
				// Importe
				sLinea = "	    <fo:table-cell>\n";
				tmpFoFileStream.write(sLinea.getBytes());
				sLinea = "      <fo:block font-size=\"10pt\" padding-top=\"1mm\"  text-align=\"center\">\n "
						+ miComun.formatearDblMilesDec(BdImporte.doubleValue())
						+ "</fo:block>\n";
				tmpFoFileStream.write(sLinea.getBytes());
				sLinea = "	    </fo:table-cell>\n";
				tmpFoFileStream.write(sLinea.getBytes());
				sLinea = "	    </fo:table-row>\n";
				tmpFoFileStream.write(sLinea.getBytes());
			}
			sLinea = "	    <fo:table-row >\n";
			tmpFoFileStream.write(sLinea.getBytes());
			// Tipo
			sLinea = "	    <fo:table-cell>\n";
			tmpFoFileStream.write(sLinea.getBytes());
			sLinea = "      <fo:block font-size=\"10pt\"  text-align=\"left\">\n "
					+ "</fo:block>";
			tmpFoFileStream.write(sLinea.getBytes());
			sLinea = "	    </fo:table-cell>\n";
			tmpFoFileStream.write(sLinea.getBytes());
			// Fecha
			sLinea = "	    <fo:table-cell>\n";
			tmpFoFileStream.write(sLinea.getBytes());
			sLinea = "      <fo:block font-size=\"10pt\" font-weight=\"bold\"  text-align=\"center\">\n  </fo:block>\n";
			tmpFoFileStream.write(sLinea.getBytes());
			sLinea = "	    </fo:table-cell>\n";
			tmpFoFileStream.write(sLinea.getBytes());
			// Hora
			sLinea = "	    <fo:table-cell>\n";
			tmpFoFileStream.write(sLinea.getBytes());
			sLinea = "      <fo:block font-size=\"10pt\" font-weight=\"bold\"  text-align=\"center\">\n "+res.getString("infGastTarj.texto9")+" </fo:block>\n";
			tmpFoFileStream.write(sLinea.getBytes());
			sLinea = "	    </fo:table-cell>\n";
			tmpFoFileStream.write(sLinea.getBytes());
			// Importe
			sLinea = "	    <fo:table-cell>\n";
			tmpFoFileStream.write(sLinea.getBytes());
			sLinea = "      <fo:block font-weight=\"bold\" font-size=\"10pt\" text-align=\"center\">\n "
					+ miComun.formatearDblMilesDec(BdImporteTotalTipo
							.doubleValue()) + "  </fo:block>\n";
			tmpFoFileStream.write(sLinea.getBytes());
			sLinea = "	    </fo:table-cell>\n";
			tmpFoFileStream.write(sLinea.getBytes());
			sLinea = "	    </fo:table-row>\n";
			tmpFoFileStream.write(sLinea.getBytes());
			sLinea = "	    <fo:table-row >\n";
			tmpFoFileStream.write(sLinea.getBytes());
			// vacio
			sLinea = "	    <fo:table-cell>\n";
			tmpFoFileStream.write(sLinea.getBytes());
			sLinea = "      <fo:block font-size=\"10pt\" font-weight=\"bold\"  text-align=\"center\">\n </fo:block>\n";
			tmpFoFileStream.write(sLinea.getBytes());
			sLinea = "	    </fo:table-cell>\n";
			tmpFoFileStream.write(sLinea.getBytes());
			// Fecha
			sLinea = "	    <fo:table-cell>\n";
			tmpFoFileStream.write(sLinea.getBytes());
			sLinea = "      <fo:block font-size=\"10pt\" font-weight=\"bold\"  text-align=\"center\">\n  </fo:block>\n";
			tmpFoFileStream.write(sLinea.getBytes());
			sLinea = "	    </fo:table-cell>\n";
			tmpFoFileStream.write(sLinea.getBytes());
			// Hora
			sLinea = "	    <fo:table-cell>\n";
			tmpFoFileStream.write(sLinea.getBytes());
			sLinea = "      <fo:block font-size=\"10pt\" font-weight=\"bold\"  text-align=\"center\">\n "+res.getString("infGastTarj.texto9")+" </fo:block>\n";
			tmpFoFileStream.write(sLinea.getBytes());
			sLinea = "	    </fo:table-cell>\n";
			tmpFoFileStream.write(sLinea.getBytes());
			// Importe
			sLinea = "	    <fo:table-cell>\n";
			tmpFoFileStream.write(sLinea.getBytes());
			sLinea = "      <fo:block font-size=\"10pt\" font-weight=\"bold\"  text-align=\"center\">\n "
					+ miComun
							.formatearDblMilesDec(BdImporteTotal.doubleValue())
					+ "  </fo:block>\n";
			tmpFoFileStream.write(sLinea.getBytes());
			sLinea = "	    </fo:table-cell>\n";
			tmpFoFileStream.write(sLinea.getBytes());
			sLinea = "	    </fo:table-row>\n";
			tmpFoFileStream.write(sLinea.getBytes());
			fncImprimirFinPagina();
			rs.close();

			sLinea = "</fo:root>\n";
			tmpFoFileStream.write(sLinea.getBytes());

			tmpFoFileStream.close();

			// renderFO(new InputSource(file), response);
			generarPDFdesdeFO(sFoFileDir + tmpFoFile.getName(), sFoFileDir,
					response);

			// tmpFoFile.delete();

			// response.flushBuffer();

		} catch (Exception ex) {
			try {
				response.sendRedirect("m05bError.jsp");
			} catch (IOException e) {
				// TODO Auto-generated catch block
				miLog.addTraza(e);
			}
		} finally {
			try {
				if (rs != null)
					rs.close();
				if (pstmt != null)
					pstmt.close();
				if (conn != null)
					conn.close();
			} catch (SQLException e2) {
				try {
					response.sendRedirect("m05bError.jsp");
				} catch (IOException e) {
					// TODO Auto-generated catch block
					miLog.addTraza(e);
				}
			}
		}
	}

	/**
	 * renders an FO inputsource into a PDF file which is rendered directly to
	 * the response object's OutputStream
	 */
	public void renderFO(InputSource foFile, HttpServletResponse response)
			throws ServletException {
		try {
			ByteArrayOutputStream out = new ByteArrayOutputStream();

			response.reset();
			OutputStream oOut = response.getOutputStream();
			BufferedOutputStream bOut = new BufferedOutputStream(oOut);
			Driver driver = new Driver(foFile, out);
			driver.setRenderer(Driver.RENDER_PDF);
			driver.run();

			response.setContentLength(out.size());
			response.setContentType("application/pdf");

			bOut.write(out.toByteArray());
			out.close();
			bOut.flush();
			bOut.close();
			// response.flushBuffer();
		} catch (Exception ex) {
			System.err.println("Error interrupcion-1" + ex);
			System.err
					.println("Error interrupcion-2" + ex.getClass().getName());
			throw new ServletException(ex);
		}
	}

	public void generarPDFdesdeFO(String ficheroFO, String rutaPDF,
			HttpServletResponse response) throws FOPException {
		try {

			Driver driver = new Driver();

			driver.setRenderer(Driver.RENDER_PDF);

			// Si no existe el directrio lo crea
			File f = new File(rutaPDF);

			if (!f.exists()) {

				f.mkdir();

			}
			// Cargar los datos del .FO
			FileInputStream file = new FileInputStream(ficheroFO);

			BufferedInputStream bfile = new BufferedInputStream(file);

			driver.setInputSource(new InputSource(bfile));

			// Crear un temporal que va a ser el .pdf
			String sPdfFileDir = rutaPDF;
			File pdfFileDir = new File(sPdfFileDir);
			File tmpPdfFile = File.createTempFile("m05b", ".pdf", pdfFileDir);

			FileOutputStream fileout = new FileOutputStream(tmpPdfFile);

			BufferedOutputStream bfileout = new BufferedOutputStream(fileout);

			driver.setOutputStream(bfileout);

			driver.run();

			bfile.close();

			bfileout.close();
			// Longitus del Fichero PDF.
			Long longitud = new Long(tmpPdfFile.length());
			String sLongitud = "" + longitud;
			int iLongitud = Integer.parseInt(sLongitud);

			response.setContentLength((int) iLongitud);
			response.setContentType("application/pdf");

			byte[] fileBytes = new byte[longitud.intValue()];
			FileInputStream fisficheroPdf = new FileInputStream(tmpPdfFile);
			fisficheroPdf.read(fileBytes);
			ServletOutputStream os = response.getOutputStream();
			((OutputStream) os).write(fileBytes);
			((OutputStream) os).flush();
			((OutputStream) os).close();

			// BORRAR EL FICHERO FO

			File fichero = new File(ficheroFO);

			boolean borrado = fichero.delete();
			boolean borrado2 = tmpPdfFile.delete();

		} catch (Exception e) {
			System.err.println("EXCEPCION !!! : Error pasando de FO a PDF: "
					+ e);
		}

	}

}