package festivoServlet;

import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Locale;

import javax.servlet.http.HttpSession;

import m05bBD.m05bFestivo;
import m05bClasses.m05bComun;
import m05bClasses.m05bConexion;
import m05bClasses.m05bConstantes;
import m05bClasses.m05bFileLog;

/**
 * Inserte aqu la descripcin del tipo.
 * Fecha de creacin: (30/11/05)
 */
public class m05bGrabarFestivoServlet extends javax.servlet.http.HttpServlet {m05bFileLog miLog = new m05bFileLog();
	

/**
 * Process incoming HTTP POST requests 
 * 
 * @param request Object that encapsulates the request to the servlet 
 * @param response Object that encapsulates the response from the servlet
 */
public void doPost(javax.servlet.http.HttpServletRequest request, javax.servlet.http.HttpServletResponse response) throws javax.servlet.ServletException, java.io.IOException {

	performTask(request, response);

}
/**
 * Returns the servlet info string.
 */
public String getServletInfo() {

	return super.getServletInfo();

}
/**
 * Initializes the servlet.
 */
public void init() {
	// insert code to initialize the servlet here

}
/**
 * Process incoming requests for information
 * 
 * @param request Object that encapsulates the request to the servlet 
 * @param response Object that encapsulates the response from the servlet
 */
public void performTask(javax.servlet.http.HttpServletRequest request, javax.servlet.http.HttpServletResponse response) {

       String codigo, fecha, descripcion,edescripcion;
       String sql="", sAccion;
       String fecha2="";
       m05bComun miComun = new m05bComun();

       try 	{
			java.sql.Connection conn = null;
			PreparedStatement pstmt = null;
			ResultSet rs = null;

			HttpSession session = request.getSession(true);
			/* Iker. idioma */
			Locale idiomaLocal = (Locale) session.getAttribute("Local");
			String idiomaSes = ((idiomaLocal.getLanguage() == null) ? "es"
					: idiomaLocal.getLanguage());
		
			String formatoFecha="dd/MM/yyyy";
			
			if (!idiomaSes.equals("es")) {
				
				formatoFecha = "yyyy/MM/dd";
			}
			m05bFestivo festivo = (m05bFestivo)session.getAttribute("m05bFestivo");
			codigo = request.getParameter("Codigo");
			festivo.setFes_descrip(codigo);
			fecha=request.getParameter("Fecha");
			fecha2=miComun.FechaObj(fecha,"");
			festivo.setFes_fecha(fecha2);
			descripcion = request.getParameter("Descripcion").toUpperCase();
			festivo.setFes_descrip(descripcion);
			edescripcion = request.getParameter("EDescripcion").toUpperCase();
			festivo.setFes_edescrip(edescripcion);
			try{
				m05bConexion miConex = new m05bConexion();
				conn = miConex.getConnection();	
				sAccion = request.getParameter("Accion");
     			String persona = (String) session.getAttribute("persona");
				miLog.addTraza(persona,"Grabar Festivo","ACCION:"  + sAccion, m05bConstantes.LOG_NIVEL_BAJO);
				if (sAccion.equals(m05bConstantes.ACC_ACTUALIZAR))  {
					sql="update	" 	+  m05bConstantes.TAB_FESTIVOS +
							" set " 	+ 	m05bConstantes.COL_08_FECHA + " = to_date('" + fecha + "','"+formatoFecha+"' )" +
							", " 	+ 	m05bConstantes.COL_08_DESCRIPCION + " = '" + descripcion + "'" +
							", E" 	+ 	m05bConstantes.COL_08_DESCRIPCION + " = '" + edescripcion + "'" +
							" where " + 	m05bConstantes.COL_08_CODIGO + " = " + codigo;
					miLog.addTraza("","","SQL:"  + sql, m05bConstantes.LOG_NIVEL_BAJO);
					pstmt = conn.prepareStatement(sql);
	    			pstmt.executeUpdate();
				} else if (sAccion.equals(m05bConstantes.ACC_ELIMINAR))  {
					sql = "delete from	" +  m05bConstantes.TAB_FESTIVOS +
						" where	" + m05bConstantes.COL_08_CODIGO + " = " + codigo;
					miLog.addTraza("","","SQL:"  + sql, m05bConstantes.LOG_NIVEL_BAJO);
					pstmt = conn.prepareStatement(sql);
	    			pstmt.executeUpdate();
				} else {  
					sql = "insert into	" + m05bConstantes.TAB_FESTIVOS + 
							" (" + m05bConstantes.COL_08_CODIGO + ", " + m05bConstantes.COL_08_FECHA  + ", " + m05bConstantes.COL_08_DESCRIPCION + ",E" + m05bConstantes.COL_08_DESCRIPCION + ")" + 
							" VALUES (" + codigo + ", to_date('" + fecha + "','"+formatoFecha+"'), '" + descripcion + "', '" + edescripcion + "')";
					miLog.addTraza("","","SQL:"  + sql, m05bConstantes.LOG_NIVEL_BAJO);
					pstmt = conn.prepareStatement(sql);
					pstmt.executeUpdate();
				}
				response.sendRedirect("m05bRelFestivosJsp.jsp");
			} catch (SQLException ex) {
				if (ex.getErrorCode() == m05bConstantes.ERR_INTEGRIDAD)
					response.sendRedirect("m05bFestivosJsp.jsp?Codigo=" + codigo + "&Mensaje=" + m05bConstantes.MSG_INTEGRIDAD);
				else if (ex.getErrorCode() == m05bConstantes.ERR_DUPLICADOS)
					response.sendRedirect("m05bFestivosJsp.jsp?Codigo=" + codigo + "&Mensaje=" + m05bConstantes.MSG_EXISTE);
				else
					response.sendRedirect("m05bError.jsp");
				miLog.addTraza(ex);
			}
			finally{
				if (rs != null)
					rs.close();
				if (pstmt != null)
					pstmt.close();
				if (conn != null)
					conn.close();
			}
	} catch(Throwable theException) {
		// uncomment the following line when unexpected exceptions
		// are occuring to aid in debugging the problem.
		miLog.addTraza(theException);
		try {
			response.sendRedirect("m05bError.jsp");
		} catch (IOException e) {
			// TODO Auto-generated catch block
			miLog.addTraza(e);
		}
	} 
}
}