package empleadoServlet;

import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import javax.servlet.http.HttpSession;

import m05bBD.m05bEmpleado;
import m05bClasses.m05bComun;
import m05bClasses.m05bConexion;
import m05bClasses.m05bConstantes;
import m05bClasses.m05bFileLog;

/**
 * Inserte aqu la descripcin del tipo.
 * Fecha de creacin: (07/12/03)
 */
public class m05bGrabarEmpleadoServlet extends javax.servlet.http.HttpServlet {m05bFileLog miLog = new m05bFileLog();
/**
 * Process incoming HTTP POST requests 
 * 
 * @param request Object that encapsulates the request to the servlet 
 * @param response Object that encapsulates the response from the servlet
 */
public void doPost(javax.servlet.http.HttpServletRequest request, javax.servlet.http.HttpServletResponse response) throws javax.servlet.ServletException, java.io.IOException {

	performTask(request, response);

}
/**
 * Returns the servlet info string.
 */
public String getServletInfo() {

	return super.getServletInfo();

}
/**
 * Initializes the servlet.
 */
public void init() {
	// insert code to initialize the servlet here

}
/**
 * Process incoming requests for information
 * 
 * @param request Object that encapsulates the request to the servlet 
 * @param response Object that encapsulates the response from the servlet
 */
public void performTask(javax.servlet.http.HttpServletRequest request, javax.servlet.http.HttpServletResponse response) {

		String sCodigo, sNombre, sPrecHora, sAlta;
		String sql="", accion;
		java.sql.Connection conn=null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
        m05bComun miComun = new m05bComun();
		m05bFileLog miLog = new m05bFileLog();
		boolean finalizado = false;
       try 	{

			HttpSession session = request.getSession(true);

	        m05bEmpleado empleado = (m05bEmpleado)session.getAttribute("m05bEmpleado");
	        String persona = (String) session.getAttribute("persona");
			sCodigo = request.getParameter("Codigo");
			empleado.setEmp_codigo(sCodigo);
			sNombre=request.getParameter("Nombre");
			if (sNombre != null)
				sNombre=sNombre.toUpperCase();
			empleado.setEmp_nombre(sNombre);
			sPrecHora=request.getParameter("Precio");
			if ((sPrecHora==null) || sPrecHora.equals("")){
				sPrecHora="0";
			}
			sPrecHora=miComun.ImportesABasedatos(sPrecHora);

			empleado.setEmp_precio(Double.parseDouble(sPrecHora));
			sAlta=request.getParameter("Alta")==null?"N":"S";
			empleado.setEmp_alta(sAlta);
			accion=request.getParameter("Accion");

			try{
				m05bConexion miConex = new m05bConexion();
				conn = miConex.getConnection();
				if (accion.equals(m05bConstantes.ACC_ACTUALIZAR))  { 
					sql = "update	M0507T00 " + 
						"set	NOMBRE_07 = '" + sNombre + "'" +
						" ,		PRECHORA_07 = " + sPrecHora + 
						" ,		ALTA_07 = '" + sAlta + 
						"' where	COD_EMPL_07 = '" + sCodigo + "'" ;
					pstmt = conn.prepareStatement(sql);
				}
				else if (accion.equals(m05bConstantes.ACC_INSERTAR))  {
				// Chequear si ya existe un empleado con ese codigo
				   sql = "select 1  from M0507T00 where COD_EMPL_07 = '" + sCodigo + "'";
				   pstmt = conn.prepareStatement(sql);
				   rs = pstmt.executeQuery();
				   if (rs.next() == true){ 		
	       	    			response.sendRedirect("m05bEmpleadosJsp.jsp?Codigo=" + sCodigo + "&Mensaje=Existe");
	       	    			finalizado = true;
				   } 
				   else { 
				   	   	sql = "insert into	M0507T00 " + 
							"(COD_EMPL_07, NOMBRE_07, PRECHORA_07, ALTA_07) " + 
							" values " + 
							"('" + sCodigo + "','" + sNombre + "'," + sPrecHora + ",'"+ sAlta +"')";
						pstmt = conn.prepareStatement(sql);
					}
				}
				else   {
					sql = "delete from 	M0507T00 " + 
						" where COD_EMPL_07 =  '" + sCodigo + "'";
					pstmt = conn.prepareStatement(sql);
				}
				if(!finalizado){
					miLog.addTraza(persona, "Grabar Empleados", " SQL: " + sql, m05bConstantes.LOG_NIVEL_BAJO);
					pstmt.executeUpdate();
					response.sendRedirect("m05bRelEmpleadosJsp.jsp");
				}
		    } 	catch (SQLException ex) {
					if (ex.getErrorCode() == m05bConstantes.ERR_INTEGRIDAD)
						response.sendRedirect("m05bEmpleadosJsp.jsp?Codigo=" + sCodigo + "&Mensaje=" + m05bConstantes.MSG_INTEGRIDAD);
					else
						response.sendRedirect("m05bError.jsp");
					miLog.addTraza(ex);
			} finally{
					if (rs != null)
						rs.close();
					if (pstmt != null)
						pstmt.close();
					if (conn != null)
						conn.close();
			}
	} catch(Throwable theException) {
		// uncomment the following line when unexpected exceptions
		// are occuring to aid in debugging the problem.
		miLog.addTraza(theException);
		try {
			response.sendRedirect("m05bError.jsp");
		} catch (IOException e) {
			// TODO Auto-generated catch block
			miLog.addTraza(e);
		}
	}
}

}