package descripcionServlet;

import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

import javax.servlet.http.HttpSession;

import m05bBD.m05bDescripcion;
import m05bClasses.m05bConexion;
import m05bClasses.m05bConstantes;
import m05bClasses.m05bFileLog;


/**
 * Inserte aqu la descripcin del tipo.
 * Fecha de creacin: (19/9/03)
 */
public class m05bGrabarDescripcionServlet extends javax.servlet.http.HttpServlet {m05bFileLog miLog = new m05bFileLog();
	
	   java.sql.Connection conn=null;
	
/**
 * Process incoming HTTP POST requests 
 * 
 * @param request Object that encapsulates the request to the servlet 
 * @param response Object that encapsulates the response from the servlet
 */
public void doPost(javax.servlet.http.HttpServletRequest request, javax.servlet.http.HttpServletResponse response) throws javax.servlet.ServletException, java.io.IOException {

	performTask(request, response);

}
/**
 * Returns the servlet info string.
 */
public String getServletInfo() {

	return super.getServletInfo();

}
/**
 * Initializes the servlet.
 */
public void init() {
	// insert code to initialize the servlet here

}

public boolean fncCheckDelete(String tabla, String campo, String valor) {
	//Comprueba restricciones de integridad referencial para ver si se pueden borrar datos
	String sql;
	boolean bBorrar = true;
    PreparedStatement pstmt = null;
    ResultSet rs = null;
	
	try {
		sql = 	"select 1 from " + tabla + 
					" where " + campo + " = '" + valor + "'";
		pstmt = conn.prepareStatement(sql);
		rs = pstmt.executeQuery();
		if (rs.next() == true){
		   	    bBorrar= false;
		}
	} 	catch (Exception ex1) {
			miLog.addTraza(ex1);
	} 	finally{
			try {
					if (rs != null)
						rs.close();
					if (pstmt != null)
						pstmt.close();
			}	catch (Exception ex2) {
					miLog.addTraza(ex2);
			}
	}
	return bBorrar;
}
/**
 * Process incoming requests for information
 * 
 * @param request Object that encapsulates the request to the servlet 
 * @param response Object that encapsulates the response from the servlet
 */
public void performTask(javax.servlet.http.HttpServletRequest request, javax.servlet.http.HttpServletResponse response) {

       long lTabla;
       //Long lCodigo=0;
       String sql="", sCodigo, sDescripcion, accion, modelo, sTabla,sDescripcionEu;
       boolean bBorrar = true;
	   PreparedStatement pstmt = null;
	   ResultSet rs = null;
	   boolean finalizado = false;
       try  {
			HttpSession session = request.getSession(true);

	        m05bDescripcion descripcion = (m05bDescripcion)session.getAttribute("m05bDescripcion");
			sTabla = request.getParameter("Tabla");
			lTabla = Long.parseLong(sTabla);
			descripcion.setDes_tabla(lTabla);
			sCodigo=request.getParameter("Codigo").toUpperCase();;
			//descripcion.setDes_codigo(Long.parseLong(sCodigo));
			descripcion.setDes_codigo(sCodigo);
			sDescripcion=request.getParameter("Descripcion").toUpperCase();
			sDescripcionEu=request.getParameter("DescripcionEu").toUpperCase();
			descripcion.setDes_descripcion(sDescripcion);
			session.setAttribute("m05bDescripcion",descripcion);
			accion=request.getParameter("Accion");
			modelo = request.getParameter("Modelo")==null?"":request.getParameter("Modelo");
			if (modelo.equals("undefined") ||modelo.equals("null"))
			    modelo="";
			 
			try{
				m05bConexion miConex = new m05bConexion();
				conn = miConex.getConnection();
				if (accion.equals(m05bConstantes.ACC_ACTUALIZAR))  {
					pstmt = conn.prepareStatement(
						"update	" + m05bConstantes.TAB_DESCRIPCIONES + 
						" set	" + m05bConstantes.COL_99_DESCRIPCION + " = ? " + 
						" , E"+ m05bConstantes.COL_99_DESCRIPCION+" =?"+ 
						" where	" + m05bConstantes.COL_99_CODTABLA +  " = ? and " + m05bConstantes.COL_99_CODDESC +  " = ? ");
					pstmt.setString(1, sDescripcion);
					pstmt.setString(2, sDescripcionEu);
					pstmt.setLong(3, lTabla);
					//pstmt.setLong(3, Long.parseLong(sCodigo));
					pstmt.setString(4, sCodigo);
					pstmt.executeUpdate();
				}
				else if (accion.equals(m05bConstantes.ACC_INSERTAR))  {
				// Chequear si ya existe un registro con ese cdigo
				   sql = "select 1  from " + m05bConstantes.TAB_DESCRIPCIONES + 
							" where " + m05bConstantes.COL_99_CODTABLA + " = '" + lTabla + 
							"' and " + m05bConstantes.COL_99_CODDESC + " = '" + sCodigo + "'";
			       pstmt = conn.prepareStatement(sql);
				   rs = pstmt.executeQuery();
				   if (rs.next() == true){ 		
	       	    		response.sendRedirect("m05bDescripcionesJsp.jsp?Tabla=" + lTabla + "&Codigo=" + sCodigo  + "&Mensaje=" + m05bConstantes.MSG_EXISTE);
	       	    		finalizado = true;
				   } 
				   else {
				   	   sql = 	"insert into	" + m05bConstantes.TAB_DESCRIPCIONES + 
							" ("+ m05bConstantes.COL_99_CODTABLA +", "+ m05bConstantes.COL_99_CODDESC +", "+ m05bConstantes.COL_99_DESCRIPCION +",E"+ m05bConstantes.COL_99_DESCRIPCION +")" + 
							" VALUES " +
							" (" + lTabla + ", '" + sCodigo + "', '" + sDescripcion+ "','"+sDescripcionEu+"')";
						pstmt = conn.prepareStatement(sql);
						pstmt.executeUpdate();
					}
				}
				else   {
					if (sTabla.equals(m05bConstantes.DESC_MARCAS)) {
						// No permitir borrar una marca si existe un modelo con esa marca
							bBorrar = fncCheckDelete(m05bConstantes.TAB_MODELOS,m05bConstantes.COL_17_CODMARCA,sCodigo);
					} else if (sTabla.equals(m05bConstantes.DESC_RANGOS)) {
							// No permitir borrar una rango si lo tiene una persona
							bBorrar = fncCheckDelete(m05bConstantes.TAB_PERSONAL,m05bConstantes.COL_21_RANGO,sCodigo);
							if (bBorrar)  {
								// No permitir borrar un rango si est dentro de un grupo
								bBorrar = fncCheckDelete(m05bConstantes.TAB_GRUPOS,m05bConstantes.COL_36_RANGOS,sCodigo);
								sql = 	"select 1 from " + m05bConstantes.TAB_GRUPOS +
											" where " + m05bConstantes.COL_36_RANGOS + " like '%" + sCodigo + "%'";
								pstmt = conn.prepareStatement(sql);
								rs = pstmt.executeQuery();
								if (rs.next() == true){
								   	    bBorrar= false;
								}
							}
					} else if (sTabla.equals(m05bConstantes.DESC_MODALIDADES)) {
						// No permitir borrar una modalidad si est dentro de un seguro
							bBorrar = fncCheckDelete(m05bConstantes.TAB_SEGUROS,m05bConstantes.COL_28_MODAL,sCodigo);
					} else if (sTabla.equals(m05bConstantes.DESC_COLORES)) {
						// No permitir borrar un color si hay un vehculo con ese color
							bBorrar = fncCheckDelete(m05bConstantes.TAB_VEHICULOS,m05bConstantes.COL_34_COLOR,sCodigo);
					}
					if (bBorrar)  {
							pstmt = conn.prepareStatement(
								"delete from 	" + m05bConstantes.TAB_DESCRIPCIONES +
								" where " + m05bConstantes.COL_99_CODTABLA + " = ? AND " + m05bConstantes.COL_99_CODDESC + " = ?  " );
							pstmt.setLong(1, lTabla);
							//pstmt.setLong(2, Long.parseLong(sCodigo));
							pstmt.setString(2, sCodigo);
							pstmt.executeUpdate();
					} else  {
			   				response.sendRedirect("m05bDescripcionesJsp.jsp?Tabla=" + lTabla + "&Codigo=" + sCodigo  + "&Mensaje=" + m05bConstantes.MSG_INTEGRIDAD);
			   				finalizado = true;
					}
				}		
				if(!finalizado){
					if (modelo.equals("")){
					  	response.sendRedirect("m05bRelDescripcionesJsp.jsp?Codigo=" + lTabla );
					}  
					else{
						response.sendRedirect("m05bModelosJsp.jsp?Codigo=&Mensaje=" + m05bConstantes.MSG_FALSE);  
					} 
				}
			} 	catch (Exception SQLException) {
					miLog.addTraza(SQLException);
					response.sendRedirect("m05bError.jsp");
			} 	finally{
					if (rs != null)
						rs.close();
					if (pstmt != null)
						pstmt.close();
					if (conn != null)
						conn.close();
			}
	} catch(Throwable theException) {
		// uncomment the following line when unexpected exceptions
		// are occuring to aid in debugging the problem.
		miLog.addTraza(theException);
		try {
			response.sendRedirect("m05bError.jsp");
		} catch (IOException e) {
			// TODO Auto-generated catch block
			miLog.addTraza(e);
		}
	}
}
}