package departamentoServlet;

import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import javax.servlet.http.HttpSession;

import m05bBD.m05bDepartamento;
import m05bClasses.m05bConexion;
import m05bClasses.m05bConstantes;
import m05bClasses.m05bFileLog;
import m05bClasses.m05bGenerarClave;

/**
 * Inserte aqu la descripcin del tipo. Fecha de creacin: (04/12/03)
 */
public class m05bGrabarDepartamentoServlet extends
		javax.servlet.http.HttpServlet {
	m05bFileLog miLog = new m05bFileLog();
	/**
	 * Process incoming HTTP POST requests
	 * 
	 * @param request
	 *            Object that encapsulates the request to the servlet
	 * @param response
	 *            Object that encapsulates the response from the servlet
	 */
	public void doPost(javax.servlet.http.HttpServletRequest request,
			javax.servlet.http.HttpServletResponse response)
			throws javax.servlet.ServletException, java.io.IOException {

		performTask(request, response);

	}

	/**
	 * Returns the servlet info string.
	 */
	public String getServletInfo() {

		return super.getServletInfo();

	}

	/**
	 * Initializes the servlet.
	 */
	public void init() {
		// insert code to initialize the servlet here

	}

	/**
	 * Process incoming requests for information
	 * 
	 * @param request
	 *            Object that encapsulates the request to the servlet
	 * @param response
	 *            Object that encapsulates the response from the servlet
	 */
	public void performTask(javax.servlet.http.HttpServletRequest request,
			javax.servlet.http.HttpServletResponse response) {

		String sCodigo;
		String sDescripcion, sDescripcionAnt;
		String sEdescripcion, sEdescripcionAnt;
		String sCodXlnet, sCodXlnetAnt;
		String sSit, sSitAnt;
		String accion;
		String sql = "";
		java.sql.Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		boolean finalizado = false;
		try {
			HttpSession session = request.getSession(true);

			m05bDepartamento departamento = (m05bDepartamento) session
					.getAttribute("m05bDepartamento");
			sCodigo = request.getParameter("Codigo").toUpperCase();
			// System.out.println("m05b - Grabar Dptos: CODIGO: " + sCodigo);
			departamento.setDep_codigo(sCodigo);
			sDescripcion = request.getParameter("Descripcion").toUpperCase();
			sDescripcionAnt = request.getParameter("DescripcionAnt")
					.toUpperCase();
			departamento.setDep_descripcion(sDescripcion);
			sEdescripcion = request.getParameter("Edescripcion").toUpperCase();
			sEdescripcionAnt = request.getParameter("EdescripcionAnt")
					.toUpperCase();
			departamento.setDep_edescripcion(sEdescripcion);

			sCodXlnet = request.getParameter("CodXlnet").toUpperCase();
			sCodXlnetAnt = request.getParameter("CodXlnetAnt").toUpperCase();
			departamento.setDep_cod_xlnet(sCodXlnet);

			sSit = request.getParameter("Situacion");
			sSitAnt = request.getParameter("SituacionAnt");
			departamento.setDep_situacion(sSit);

			if (sSit != null && sSit.toUpperCase().equals("ON")) {
				sSit = "A";
			} else {
				sSit = "B";
			}

			if (sSitAnt != null && sSitAnt.toUpperCase().equals("ON")) {
				sSitAnt = "A";
			} else {
				sSitAnt = "B";
			}

			accion = request.getParameter("Accion");

			try {
				m05bConexion miConex = new m05bConexion();
				conn = miConex.getConnection();

				if (accion.equals(m05bConstantes.ACC_ACTUALIZAR)
						|| accion.equals(m05bConstantes.ACC_INSERTAR)) {
					// Chequear si ya existe un departamento asociado a el
					// departamento de xlnet que queremos asociar
					sql = "select 1 from M0506T00 where COD_XLNET_06 = '"
							+ sCodXlnet + "'";
					if (accion.equals(m05bConstantes.ACC_ACTUALIZAR)) {
						sql += " AND COD_DPTO_06<>'" + sCodigo + "'";
					}
					pstmt = conn.prepareStatement(sql);
					rs = pstmt.executeQuery();

					if (rs.next()) {
						String existe = "N";
						if (accion.equals(m05bConstantes.ACC_ACTUALIZAR)) {
							existe = "S";
						}

						response
								.sendRedirect("m05bDepartamentosJsp.jsp?Codigo="
										+ sCodigo
										+ "&Existe="
										+ existe
										+ "&Mensaje="
										+ m05bConstantes.MSG_EXISTEDPTOREL);
						finalizado = true;
					}
				}

				if (!finalizado) {
					if (accion.equals(m05bConstantes.ACC_ACTUALIZAR)) {
						pstmt = conn.prepareStatement("update M0506T00 "
								+ "set DESCRIP_06=? " + ", E_DESCRIP_06=? "
								+ ", COD_XLNET_06=? " + ", SIT_06=? "
								+ "where COD_DPTO_06=?");
						pstmt.setString(1, sDescripcion);
						pstmt.setString(2, sEdescripcion);
						pstmt.setString(3, sCodXlnet);
						pstmt.setString(4, sSit);
						pstmt.setString(5, sCodigo);
						pstmt.executeUpdate();
						// Se mantiene un histrico
						pstmt = conn
								.prepareStatement("insert into	M0511T00 "
										+ "(COD_DPTH_11, CODDPTANT_11, DESDPTANT_11, E_DESDPTANT_11, "
										+ " FCAMBIO_11, CODDPTNUE_11, DESDPTNUE_11, E_DESDPTNUE_11, "
										+ " COD_XLNET_ANT_11, SIT_ANT_11, COD_XLNET_NUE_11, SIT_NUE_11) "
										+ " values "
										+ "(?, ?, ?, ?, sysdate, ?, ?, ?, ?, ?, ?, ?)");

						m05bGenerarClave miId = new m05bGenerarClave();
						pstmt.setInt(1, miId.getNextId(
								m05bConstantes.TAB_HIST_DPTOS,
								m05bConstantes.COL_11_ID));
						pstmt.setString(2, sCodigo);
						pstmt.setString(3, sDescripcionAnt);
						pstmt.setString(4, sEdescripcionAnt);
						pstmt.setString(5, sCodigo);
						pstmt.setString(6, sDescripcion);
						pstmt.setString(7, sEdescripcion);
						pstmt.setString(8, sCodXlnetAnt);
						pstmt.setString(9, sSitAnt);
						pstmt.setString(10, sCodXlnet);
						pstmt.setString(11, sSit);

					} else if (accion.equals(m05bConstantes.ACC_INSERTAR)) {
						// Chequear si ya existe un departamento con ese codigo
						sql = "select 1  from M0506T00 where COD_DPTO_06 = '"
								+ sCodigo + "'";
						pstmt = conn.prepareStatement(sql);
						rs = pstmt.executeQuery();
						if (rs.next() == true) {
							response
									.sendRedirect("m05bDepartamentosJsp.jsp?Codigo="
											+ sCodigo
											+ "&Mensaje="
											+ m05bConstantes.MSG_EXISTE);
							finalizado = true;
						} else {
							pstmt = conn
									.prepareStatement("insert into	M0506T00 "
											+ "(COD_DPTO_06, DESCRIP_06, E_DESCRIP_06, COD_XLNET_06, SIT_06) "
											+ " values " + "(? ,?, ?, ?, ?)");
							pstmt.setString(1, sCodigo);
							pstmt.setString(2, sDescripcion);
							pstmt.setString(3, sEdescripcion);
							pstmt.setString(4, sCodXlnet);
							pstmt.setString(5, sSit);
						}
					} else {
						pstmt = conn.prepareStatement("delete from 	M0506T00 "
								+ " where COD_DPTO_06 =  ? ");
						pstmt.setString(1, sCodigo);
						pstmt.executeUpdate();
						// Se mantiene un histrico
						pstmt = conn
								.prepareStatement("insert into	M0511T00 "
										+ "(COD_DPTH_11, CODDPTANT_11, DESDPTANT_11, E_DESDPTANT_11, "
										+ " FCAMBIO_11, CODDPTNUE_11, DESDPTNUE_11, E_DESDPTNUE_11, "
										+ " COD_XLNET_ANT_11, SIT_ANT_11, COD_XLNET_NUE_11, SIT_NUE_11) "
										+ " values "
										+ "(?, ?, ?, ?, sysdate, ?, ?, ?, ?, ?, ?, ?)");
						m05bGenerarClave miId = new m05bGenerarClave();
						pstmt.setInt(1, miId.getNextId(
								m05bConstantes.TAB_HIST_DPTOS,
								m05bConstantes.COL_11_ID));
						pstmt.setString(2, sCodigo);
						pstmt.setString(3, sDescripcionAnt);
						pstmt.setString(4, sEdescripcionAnt);
						pstmt.setString(5, sCodigo);
						pstmt.setString(6, "");
						pstmt.setString(7, "");
						pstmt.setString(8, sCodXlnetAnt);
						pstmt.setString(9, sSitAnt);
						pstmt.setString(10, "");
						pstmt.setString(11, "");
					}
				}

				if (!finalizado) {
					pstmt.executeUpdate();
					response.sendRedirect("m05bRelDepartamentosJsp.jsp");
				}
			} catch (SQLException ex) {
				if (ex.getErrorCode() == m05bConstantes.ERR_INTEGRIDAD)
					response.sendRedirect("m05bDepartamentosJsp.jsp?Codigo="
							+ sCodigo + "&Mensaje="
							+ m05bConstantes.MSG_INTEGRIDAD);
				else
					response.sendRedirect("m05bError.jsp");
				miLog.addTraza(ex);
			} finally {
				if (rs != null)
					rs.close();
				if (pstmt != null)
					pstmt.close();
				if (conn != null)
					conn.close();
			}

		} catch (Throwable theException) {
			// uncomment the following line when unexpected exceptions
			// are occuring to aid in debugging the problem.
			miLog.addTraza(theException);
			try {
				response.sendRedirect("m05bError.jsp");
			} catch (IOException e) {
				// TODO Auto-generated catch block
				miLog.addTraza(e);
			}
		}
	}
}